@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property delimiter The delimiter used for separating items in the CSV file being imported.
 * @property headerLists List of the headers used to specify a common header for all source CSV files being imported.
 */
public data class TableImportTableInputFormatOptionsCsv(
    public val delimiter: String? = null,
    public val headerLists: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.dynamodb.outputs.TableImportTableInputFormatOptionsCsv):
            TableImportTableInputFormatOptionsCsv = TableImportTableInputFormatOptionsCsv(
            delimiter = javaType.delimiter().map({ args0 -> args0 }).orElse(null),
            headerLists = javaType.headerLists().map({ args0 -> args0 }),
        )
    }
}
