@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket The S3 bucket that is being imported from.
 * @property bucketOwner The account number of the S3 bucket that is being imported from.
 * @property keyPrefix The key prefix shared by all S3 Objects that are being imported.
 */
public data class TableImportTableS3BucketSource(
    public val bucket: String,
    public val bucketOwner: String? = null,
    public val keyPrefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dynamodb.outputs.TableImportTableS3BucketSource):
            TableImportTableS3BucketSource = TableImportTableS3BucketSource(
            bucket = javaType.bucket(),
            bucketOwner = javaType.bucketOwner().map({ args0 -> args0 }).orElse(null),
            keyPrefix = javaType.keyPrefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
