@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn ARN of the table
 * @property kmsKeyArn ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
 * @property pointInTimeRecovery Whether to enable Point In Time Recovery for the replica. Default is `false`.
 * @property propagateTags Whether to propagate the global table's tags to a replica. Default is `false`. Changes to tags only move in one direction: from global (source) to replica. In other words, tag drift on a replica will not trigger an update. Tag or replica changes on the global table, whether from drift or configuration changes, are propagated to replicas. Changing from `true` to `false` on a subsequent `apply` means replica tags are left as they were, unmanaged, not deleted.
 * @property regionName Region name of the replica.
 * @property streamArn ARN of the Table Stream. Only available when `stream_enabled = true`
 * @property streamLabel Timestamp, in ISO 8601 format, for this stream. Note that this timestamp is not a unique identifier for the stream on its own. However, the combination of AWS customer ID, table name and this field is guaranteed to be unique. It can be used for creating CloudWatch Alarms. Only available when `stream_enabled = true`.
 */
public data class TableReplica(
    public val arn: String? = null,
    public val kmsKeyArn: String? = null,
    public val pointInTimeRecovery: Boolean? = null,
    public val propagateTags: Boolean? = null,
    public val regionName: String,
    public val streamArn: String? = null,
    public val streamLabel: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dynamodb.outputs.TableReplica): TableReplica =
            TableReplica(
                arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
                kmsKeyArn = javaType.kmsKeyArn().map({ args0 -> args0 }).orElse(null),
                pointInTimeRecovery = javaType.pointInTimeRecovery().map({ args0 -> args0 }).orElse(null),
                propagateTags = javaType.propagateTags().map({ args0 -> args0 }).orElse(null),
                regionName = javaType.regionName(),
                streamArn = javaType.streamArn().map({ args0 -> args0 }).orElse(null),
                streamLabel = javaType.streamLabel().map({ args0 -> args0 }).orElse(null),
            )
    }
}
