@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Whether or not to enable encryption at rest using an AWS managed KMS customer master key (CMK). If `enabled` is `false` then server-side encryption is set to AWS-_owned_ key (shown as `DEFAULT` in the AWS console). Potentially confusingly, if `enabled` is `true` and no `kms_key_arn` is specified then server-side encryption is set to the _default_ KMS-_managed_ key (shown as `KMS` in the AWS console). The [AWS KMS documentation](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html) explains the difference between AWS-_owned_ and KMS-_managed_ keys.
 * @property kmsKeyArn ARN of the CMK that should be used for the AWS KMS encryption. This argument should only be used if the key is different from the default KMS-managed DynamoDB key, `alias/aws/dynamodb`. **Note:** This attribute will _not_ be populated with the ARN of _default_ keys.
 */
public data class TableServerSideEncryption(
    public val enabled: Boolean,
    public val kmsKeyArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dynamodb.outputs.TableServerSideEncryption):
            TableServerSideEncryption = TableServerSideEncryption(
            enabled = javaType.enabled(),
            kmsKeyArn = javaType.kmsKeyArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
