@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dynamodb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property attributeName Name of the table attribute to store the TTL timestamp in.
 * @property enabled Whether TTL is enabled.
 */
public data class TableTtl(
    public val attributeName: String,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dynamodb.outputs.TableTtl): TableTtl = TableTtl(
            attributeName = javaType.attributeName(),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
