@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DefaultKmsKey].
 */
@PulumiTagMarker
public class DefaultKmsKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefaultKmsKeyArgs = DefaultKmsKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefaultKmsKeyArgsBuilder.() -> Unit) {
        val builder = DefaultKmsKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DefaultKmsKey {
        val builtJavaResource = com.pulumi.aws.ebs.DefaultKmsKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DefaultKmsKey(builtJavaResource)
    }
}

/**
 * Provides a resource to manage the default customer master key (CMK) that your AWS account uses to encrypt EBS volumes.
 * Your AWS account has an AWS-managed default CMK that is used for encrypting an EBS volume when no CMK is specified in the API call that creates the volume.
 * By using the `aws.ebs.DefaultKmsKey` resource, you can specify a customer-managed CMK to use in place of the AWS-managed default CMK.
 * > **NOTE:** Creating an `aws.ebs.DefaultKmsKey` resource does not enable default EBS encryption. Use the `aws.ebs.EncryptionByDefault` to enable default EBS encryption.
 * > **NOTE:** Destroying this resource will reset the default CMK to the account's AWS-managed default CMK for EBS.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.DefaultKmsKey;
 * import com.pulumi.aws.ebs.DefaultKmsKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DefaultKmsKey("example", DefaultKmsKeyArgs.builder()
 *             .keyArn(aws_kms_key.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the EBS default KMS CMK using the KMS key ARN. For example:
 * ```sh
 *  $ pulumi import aws:ebs/defaultKmsKey:DefaultKmsKey example arn:aws:kms:us-east-1:123456789012:key/abcd-1234
 * ```
 *
 */
public class DefaultKmsKey internal constructor(
    override val javaResource: com.pulumi.aws.ebs.DefaultKmsKey,
) : KotlinCustomResource(javaResource, DefaultKmsKeyMapper) {
    /**
     * The ARN of the AWS Key Management Service (AWS KMS) customer master key (CMK) to use to encrypt the EBS volume.
     */
    public val keyArn: Output<String>
        get() = javaResource.keyArn().applyValue({ args0 -> args0 })
}

public object DefaultKmsKeyMapper : ResourceMapper<DefaultKmsKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ebs.DefaultKmsKey::class == javaResource::class

    override fun map(javaResource: Resource): DefaultKmsKey = DefaultKmsKey(
        javaResource as
            com.pulumi.aws.ebs.DefaultKmsKey,
    )
}

/**
 * @see [DefaultKmsKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefaultKmsKey].
 */
public suspend fun defaultKmsKey(
    name: String,
    block: suspend DefaultKmsKeyResourceBuilder.() -> Unit,
): DefaultKmsKey {
    val builder = DefaultKmsKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefaultKmsKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defaultKmsKey(name: String): DefaultKmsKey {
    val builder = DefaultKmsKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
