@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.aws.ebs.EbsFunctions.getDefaultKmsKeyPlain
import com.pulumi.aws.ebs.EbsFunctions.getEbsVolumesPlain
import com.pulumi.aws.ebs.EbsFunctions.getEncryptionByDefaultPlain
import com.pulumi.aws.ebs.EbsFunctions.getSnapshotIdsPlain
import com.pulumi.aws.ebs.EbsFunctions.getSnapshotPlain
import com.pulumi.aws.ebs.EbsFunctions.getVolumePlain
import com.pulumi.aws.ebs.kotlin.inputs.GetEbsVolumesFilter
import com.pulumi.aws.ebs.kotlin.inputs.GetEbsVolumesPlainArgs
import com.pulumi.aws.ebs.kotlin.inputs.GetEbsVolumesPlainArgsBuilder
import com.pulumi.aws.ebs.kotlin.inputs.GetSnapshotFilter
import com.pulumi.aws.ebs.kotlin.inputs.GetSnapshotIdsFilter
import com.pulumi.aws.ebs.kotlin.inputs.GetSnapshotIdsPlainArgs
import com.pulumi.aws.ebs.kotlin.inputs.GetSnapshotIdsPlainArgsBuilder
import com.pulumi.aws.ebs.kotlin.inputs.GetSnapshotPlainArgs
import com.pulumi.aws.ebs.kotlin.inputs.GetSnapshotPlainArgsBuilder
import com.pulumi.aws.ebs.kotlin.inputs.GetVolumeFilter
import com.pulumi.aws.ebs.kotlin.inputs.GetVolumePlainArgs
import com.pulumi.aws.ebs.kotlin.inputs.GetVolumePlainArgsBuilder
import com.pulumi.aws.ebs.kotlin.outputs.GetDefaultKmsKeyResult
import com.pulumi.aws.ebs.kotlin.outputs.GetEbsVolumesResult
import com.pulumi.aws.ebs.kotlin.outputs.GetEncryptionByDefaultResult
import com.pulumi.aws.ebs.kotlin.outputs.GetSnapshotIdsResult
import com.pulumi.aws.ebs.kotlin.outputs.GetSnapshotResult
import com.pulumi.aws.ebs.kotlin.outputs.GetVolumeResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ebs.kotlin.outputs.GetDefaultKmsKeyResult.Companion.toKotlin as getDefaultKmsKeyResultToKotlin
import com.pulumi.aws.ebs.kotlin.outputs.GetEbsVolumesResult.Companion.toKotlin as getEbsVolumesResultToKotlin
import com.pulumi.aws.ebs.kotlin.outputs.GetEncryptionByDefaultResult.Companion.toKotlin as getEncryptionByDefaultResultToKotlin
import com.pulumi.aws.ebs.kotlin.outputs.GetSnapshotIdsResult.Companion.toKotlin as getSnapshotIdsResultToKotlin
import com.pulumi.aws.ebs.kotlin.outputs.GetSnapshotResult.Companion.toKotlin as getSnapshotResultToKotlin
import com.pulumi.aws.ebs.kotlin.outputs.GetVolumeResult.Companion.toKotlin as getVolumeResultToKotlin

public object EbsFunctions {
    /**
     * Use this data source to get the default EBS encryption KMS key in the current region.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import com.pulumi.aws.ebs.Volume;
     * import com.pulumi.aws.ebs.VolumeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = EbsFunctions.getDefaultKmsKey();
     *         var example = new Volume("example", VolumeArgs.builder()
     *             .availabilityZone("us-west-2a")
     *             .encrypted(true)
     *             .kmsKeyId(current.applyValue(getDefaultKmsKeyResult -> getDefaultKmsKeyResult.keyArn()))
     *             .build());
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import com.pulumi.aws.ebs.Volume;
     * import com.pulumi.aws.ebs.VolumeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = EbsFunctions.getDefaultKmsKey();
     *         var example = new Volume("example", VolumeArgs.builder()
     *             .availabilityZone("us-west-2a")
     *             .encrypted(true)
     *             .kmsKeyId(current.applyValue(getDefaultKmsKeyResult -> getDefaultKmsKeyResult.keyArn()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument Use this data source to get the default EBS encryption KMS key in the current region.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import com.pulumi.aws.ebs.Volume;
     * import com.pulumi.aws.ebs.VolumeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = EbsFunctions.getDefaultKmsKey();
     *         var example = new Volume("example", VolumeArgs.builder()
     *             .availabilityZone("us-west-2a")
     *             .encrypted(true)
     *             .kmsKeyId(current.applyValue(getDefaultKmsKeyResult -> getDefaultKmsKeyResult.keyArn()))
     *             .build());
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import com.pulumi.aws.ebs.Volume;
     * import com.pulumi.aws.ebs.VolumeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = EbsFunctions.getDefaultKmsKey();
     *         var example = new Volume("example", VolumeArgs.builder()
     *             .availabilityZone("us-west-2a")
     *             .encrypted(true)
     *             .kmsKeyId(current.applyValue(getDefaultKmsKeyResult -> getDefaultKmsKeyResult.keyArn()))
     *             .build());
     *     }
     * }
     * ```
     * @return A collection of values returned by getDefaultKmsKey.
     */
    public suspend fun getDefaultKmsKey(): GetDefaultKmsKeyResult =
        getDefaultKmsKeyResultToKotlin(getDefaultKmsKeyPlain().await())

    /**
     * `aws.ebs.getEbsVolumes` provides identifying information for EBS volumes matching given criteria.
     * This data source can be useful for getting a list of volume IDs with (for example) matching tags.
     * ## Example Usage
     * The following demonstrates obtaining a map of availability zone to EBS volume ID for volumes with a given tag value.
     * No Java example available.
     * @param argument A collection of arguments for invoking getEbsVolumes.
     * @return A collection of values returned by getEbsVolumes.
     */
    public suspend fun getEbsVolumes(argument: GetEbsVolumesPlainArgs): GetEbsVolumesResult =
        getEbsVolumesResultToKotlin(getEbsVolumesPlain(argument.toJava()).await())

    /**
     * @see [getEbsVolumes].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired volumes.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getEbsVolumes.
     */
    public suspend fun getEbsVolumes(
        filters: List<GetEbsVolumesFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetEbsVolumesResult {
        val argument = GetEbsVolumesPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getEbsVolumesResultToKotlin(getEbsVolumesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEbsVolumes].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ebs&#46;kotlin&#46;inputs&#46;GetEbsVolumesPlainArgs].
     * @return A collection of values returned by getEbsVolumes.
     */
    public suspend fun getEbsVolumes(argument: suspend GetEbsVolumesPlainArgsBuilder.() -> Unit):
        GetEbsVolumesResult {
        val builder = GetEbsVolumesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEbsVolumesResultToKotlin(getEbsVolumesPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides a way to check whether default EBS encryption is enabled for your AWS account in the current AWS region.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = EbsFunctions.getEncryptionByDefault();
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = EbsFunctions.getEncryptionByDefault();
     *     }
     * }
     * ```
     * @param argument Provides a way to check whether default EBS encryption is enabled for your AWS account in the current AWS region.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = EbsFunctions.getEncryptionByDefault();
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = EbsFunctions.getEncryptionByDefault();
     *     }
     * }
     * ```
     * @return A collection of values returned by getEncryptionByDefault.
     */
    public suspend fun getEncryptionByDefault(): GetEncryptionByDefaultResult =
        getEncryptionByDefaultResultToKotlin(getEncryptionByDefaultPlain().await())

    /**
     * Use this data source to get information about an EBS Snapshot for use when provisioning EBS Volumes
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import com.pulumi.aws.ebs.inputs.GetSnapshotArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ebsVolume = EbsFunctions.getSnapshot(GetSnapshotArgs.builder()
     *             .filters(
     *                 GetSnapshotFilterArgs.builder()
     *                     .name("volume-size")
     *                     .values("40")
     *                     .build(),
     *                 GetSnapshotFilterArgs.builder()
     *                     .name("tag:Name")
     *                     .values("Example")
     *                     .build())
     *             .mostRecent(true)
     *             .owners("self")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSnapshot.
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(argument: GetSnapshotPlainArgs): GetSnapshotResult =
        getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())

    /**
     * @see [getSnapshot].
     * @param filters One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-snapshots in the AWS CLI reference][1].
     * @param mostRecent If more than one result is returned, use the most recent snapshot.
     * @param owners Returns the snapshots owned by the specified owner id. Multiple owners can be specified.
     * @param restorableByUserIds One or more AWS accounts IDs that can create volumes from the snapshot.
     * @param snapshotIds Returns information on a specific snapshot_id.
     * @param tags Map of tags for the resource.
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(
        filters: List<GetSnapshotFilter>? = null,
        mostRecent: Boolean? = null,
        owners: List<String>? = null,
        restorableByUserIds: List<String>? = null,
        snapshotIds: List<String>? = null,
        tags: Map<String, String>? = null,
    ): GetSnapshotResult {
        val argument = GetSnapshotPlainArgs(
            filters = filters,
            mostRecent = mostRecent,
            owners = owners,
            restorableByUserIds = restorableByUserIds,
            snapshotIds = snapshotIds,
            tags = tags,
        )
        return getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshot].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ebs&#46;kotlin&#46;inputs&#46;GetSnapshotPlainArgs].
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(argument: suspend GetSnapshotPlainArgsBuilder.() -> Unit):
        GetSnapshotResult {
        val builder = GetSnapshotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotResultToKotlin(getSnapshotPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get a list of EBS Snapshot IDs matching the specified
     * criteria.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import com.pulumi.aws.ebs.inputs.GetSnapshotIdsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ebsVolumes = EbsFunctions.getSnapshotIds(GetSnapshotIdsArgs.builder()
     *             .filters(
     *                 GetSnapshotIdsFilterArgs.builder()
     *                     .name("volume-size")
     *                     .values("40")
     *                     .build(),
     *                 GetSnapshotIdsFilterArgs.builder()
     *                     .name("tag:Name")
     *                     .values("Example")
     *                     .build())
     *             .owners("self")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSnapshotIds.
     * @return A collection of values returned by getSnapshotIds.
     */
    public suspend fun getSnapshotIds(argument: GetSnapshotIdsPlainArgs): GetSnapshotIdsResult =
        getSnapshotIdsResultToKotlin(getSnapshotIdsPlain(argument.toJava()).await())

    /**
     * @see [getSnapshotIds].
     * @param filters One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-volumes in the AWS CLI reference][1].
     * @param owners Returns the snapshots owned by the specified owner id. Multiple owners can be specified.
     * @param restorableByUserIds One or more AWS accounts IDs that can create volumes from the snapshot.
     * @return A collection of values returned by getSnapshotIds.
     */
    public suspend fun getSnapshotIds(
        filters: List<GetSnapshotIdsFilter>? = null,
        owners: List<String>? = null,
        restorableByUserIds: List<String>? = null,
    ): GetSnapshotIdsResult {
        val argument = GetSnapshotIdsPlainArgs(
            filters = filters,
            owners = owners,
            restorableByUserIds = restorableByUserIds,
        )
        return getSnapshotIdsResultToKotlin(getSnapshotIdsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshotIds].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ebs&#46;kotlin&#46;inputs&#46;GetSnapshotIdsPlainArgs].
     * @return A collection of values returned by getSnapshotIds.
     */
    public suspend fun getSnapshotIds(argument: suspend GetSnapshotIdsPlainArgsBuilder.() -> Unit):
        GetSnapshotIdsResult {
        val builder = GetSnapshotIdsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotIdsResultToKotlin(getSnapshotIdsPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about an EBS volume for use in other
     * resources.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ebs.EbsFunctions;
     * import com.pulumi.aws.ebs.inputs.GetVolumeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ebsVolume = EbsFunctions.getVolume(GetVolumeArgs.builder()
     *             .filters(
     *                 GetVolumeFilterArgs.builder()
     *                     .name("volume-type")
     *                     .values("gp2")
     *                     .build(),
     *                 GetVolumeFilterArgs.builder()
     *                     .name("tag:Name")
     *                     .values("Example")
     *                     .build())
     *             .mostRecent(true)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVolume.
     * @return A collection of values returned by getVolume.
     */
    public suspend fun getVolume(argument: GetVolumePlainArgs): GetVolumeResult =
        getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())

    /**
     * @see [getVolume].
     * @param filters One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-volumes in the AWS CLI reference][1].
     * @param mostRecent If more than one result is returned, use the most
     * recent Volume.
     * @param tags Map of tags for the resource.
     * @return A collection of values returned by getVolume.
     */
    public suspend fun getVolume(
        filters: List<GetVolumeFilter>? = null,
        mostRecent: Boolean? = null,
        tags: Map<String, String>? = null,
    ): GetVolumeResult {
        val argument = GetVolumePlainArgs(
            filters = filters,
            mostRecent = mostRecent,
            tags = tags,
        )
        return getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())
    }

    /**
     * @see [getVolume].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ebs&#46;kotlin&#46;inputs&#46;GetVolumePlainArgs].
     * @return A collection of values returned by getVolume.
     */
    public suspend fun getVolume(argument: suspend GetVolumePlainArgsBuilder.() -> Unit):
        GetVolumeResult {
        val builder = GetVolumePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVolumeResultToKotlin(getVolumePlain(builtArgument.toJava()).await())
    }
}
