@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EncryptionByDefault].
 */
@PulumiTagMarker
public class EncryptionByDefaultResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EncryptionByDefaultArgs = EncryptionByDefaultArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EncryptionByDefaultArgsBuilder.() -> Unit) {
        val builder = EncryptionByDefaultArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EncryptionByDefault {
        val builtJavaResource = com.pulumi.aws.ebs.EncryptionByDefault(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EncryptionByDefault(builtJavaResource)
    }
}

/**
 * Provides a resource to manage whether default EBS encryption is enabled for your AWS account in the current AWS region. To manage the default KMS key for the region, see the `aws.ebs.DefaultKmsKey` resource.
 * > **NOTE:** Removing this resource disables default EBS encryption.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.EncryptionByDefault;
 * import com.pulumi.aws.ebs.EncryptionByDefaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EncryptionByDefault("example", EncryptionByDefaultArgs.builder()
 *             .enabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import the default EBS encryption state. For example:
 * ```sh
 *  $ pulumi import aws:ebs/encryptionByDefault:EncryptionByDefault example default
 * ```
 *
 */
public class EncryptionByDefault internal constructor(
    override val javaResource: com.pulumi.aws.ebs.EncryptionByDefault,
) : KotlinCustomResource(javaResource, EncryptionByDefaultMapper) {
    /**
     * Whether or not default EBS encryption is enabled. Valid values are `true` or `false`. Defaults to `true`.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object EncryptionByDefaultMapper : ResourceMapper<EncryptionByDefault> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ebs.EncryptionByDefault::class == javaResource::class

    override fun map(javaResource: Resource): EncryptionByDefault = EncryptionByDefault(
        javaResource
            as com.pulumi.aws.ebs.EncryptionByDefault,
    )
}

/**
 * @see [EncryptionByDefault].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EncryptionByDefault].
 */
public suspend fun encryptionByDefault(
    name: String,
    block: suspend EncryptionByDefaultResourceBuilder.() -> Unit,
): EncryptionByDefault {
    val builder = EncryptionByDefaultResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EncryptionByDefault].
 * @param name The _unique_ name of the resulting resource.
 */
public fun encryptionByDefault(name: String): EncryptionByDefault {
    val builder = EncryptionByDefaultResourceBuilder()
    builder.name(name)
    return builder.build()
}
