@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.aws.ebs.SnapshotCopyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a Snapshot of a snapshot.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.Volume;
 * import com.pulumi.aws.ebs.VolumeArgs;
 * import com.pulumi.aws.ebs.Snapshot;
 * import com.pulumi.aws.ebs.SnapshotArgs;
 * import com.pulumi.aws.ebs.SnapshotCopy;
 * import com.pulumi.aws.ebs.SnapshotCopyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Volume("example", VolumeArgs.builder()
 *             .availabilityZone("us-west-2a")
 *             .size(40)
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *         var exampleSnapshot = new Snapshot("exampleSnapshot", SnapshotArgs.builder()
 *             .volumeId(example.id())
 *             .tags(Map.of("Name", "HelloWorld_snap"))
 *             .build());
 *         var exampleCopy = new SnapshotCopy("exampleCopy", SnapshotCopyArgs.builder()
 *             .sourceSnapshotId(exampleSnapshot.id())
 *             .sourceRegion("us-west-2")
 *             .tags(Map.of("Name", "HelloWorld_copy_snap"))
 *             .build());
 *     }
 * }
 * ```
 * @property description A description of what the snapshot is.
 * @property encrypted Whether the snapshot is encrypted.
 * @property kmsKeyId The ARN for the KMS encryption key.
 * @property permanentRestore Indicates whether to permanently restore an archived snapshot.
 * @property sourceRegion The region of the source snapshot.
 * @property sourceSnapshotId The ARN for the snapshot to be copied.
 * @property storageTier The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
 * @property tags A map of tags for the snapshot.
 * @property temporaryRestoreDays Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
 */
public data class SnapshotCopyArgs(
    public val description: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val permanentRestore: Output<Boolean>? = null,
    public val sourceRegion: Output<String>? = null,
    public val sourceSnapshotId: Output<String>? = null,
    public val storageTier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val temporaryRestoreDays: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.ebs.SnapshotCopyArgs> {
    override fun toJava(): com.pulumi.aws.ebs.SnapshotCopyArgs =
        com.pulumi.aws.ebs.SnapshotCopyArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .permanentRestore(permanentRestore?.applyValue({ args0 -> args0 }))
            .sourceRegion(sourceRegion?.applyValue({ args0 -> args0 }))
            .sourceSnapshotId(sourceSnapshotId?.applyValue({ args0 -> args0 }))
            .storageTier(storageTier?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .temporaryRestoreDays(temporaryRestoreDays?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotCopyArgs].
 */
@PulumiTagMarker
public class SnapshotCopyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var kmsKeyId: Output<String>? = null

    private var permanentRestore: Output<Boolean>? = null

    private var sourceRegion: Output<String>? = null

    private var sourceSnapshotId: Output<String>? = null

    private var storageTier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var temporaryRestoreDays: Output<Int>? = null

    /**
     * @param value A description of what the snapshot is.
     */
    @JvmName("gcderlnuonmniklm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether the snapshot is encrypted.
     */
    @JvmName("ldgmaguevjkjfaym")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value The ARN for the KMS encryption key.
     */
    @JvmName("ciwfblkbdgnpfscm")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Indicates whether to permanently restore an archived snapshot.
     */
    @JvmName("kjecuthmislhnxhi")
    public suspend fun permanentRestore(`value`: Output<Boolean>) {
        this.permanentRestore = value
    }

    /**
     * @param value The region of the source snapshot.
     */
    @JvmName("rbxvojjtfnlxxnsj")
    public suspend fun sourceRegion(`value`: Output<String>) {
        this.sourceRegion = value
    }

    /**
     * @param value The ARN for the snapshot to be copied.
     */
    @JvmName("agwlnktghxnqmbgu")
    public suspend fun sourceSnapshotId(`value`: Output<String>) {
        this.sourceSnapshotId = value
    }

    /**
     * @param value The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
     */
    @JvmName("fdubkpuskfahcwif")
    public suspend fun storageTier(`value`: Output<String>) {
        this.storageTier = value
    }

    /**
     * @param value A map of tags for the snapshot.
     */
    @JvmName("pirbyeifbmlvtnmi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
     */
    @JvmName("odqntvhrwojthkyy")
    public suspend fun temporaryRestoreDays(`value`: Output<Int>) {
        this.temporaryRestoreDays = value
    }

    /**
     * @param value A description of what the snapshot is.
     */
    @JvmName("edyjnwaqcsducgtq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether the snapshot is encrypted.
     */
    @JvmName("ydcvqxjuahcmptoq")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The ARN for the KMS encryption key.
     */
    @JvmName("wxhornefoyjqywgl")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Indicates whether to permanently restore an archived snapshot.
     */
    @JvmName("atacstkccngpigtk")
    public suspend fun permanentRestore(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permanentRestore = mapped
    }

    /**
     * @param value The region of the source snapshot.
     */
    @JvmName("livracklyeofhwan")
    public suspend fun sourceRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRegion = mapped
    }

    /**
     * @param value The ARN for the snapshot to be copied.
     */
    @JvmName("nonttxlstrpfpjde")
    public suspend fun sourceSnapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSnapshotId = mapped
    }

    /**
     * @param value The name of the storage tier. Valid values are `archive` and `standard`. Default value is `standard`.
     */
    @JvmName("keyccthmrtqsrjtr")
    public suspend fun storageTier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageTier = mapped
    }

    /**
     * @param value A map of tags for the snapshot.
     */
    @JvmName("cfflbcsojfbbccwf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags for the snapshot.
     */
    @JvmName("fuvmaxpqyapumlfp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the number of days for which to temporarily restore an archived snapshot. Required for temporary restores only. The snapshot will be automatically re-archived after this period.
     */
    @JvmName("wkvtipmatkwmmjmw")
    public suspend fun temporaryRestoreDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.temporaryRestoreDays = mapped
    }

    internal fun build(): SnapshotCopyArgs = SnapshotCopyArgs(
        description = description,
        encrypted = encrypted,
        kmsKeyId = kmsKeyId,
        permanentRestore = permanentRestore,
        sourceRegion = sourceRegion,
        sourceSnapshotId = sourceSnapshotId,
        storageTier = storageTier,
        tags = tags,
        temporaryRestoreDays = temporaryRestoreDays,
    )
}
