@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin

import com.pulumi.aws.ebs.VolumeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a single EBS volume.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ebs.Volume;
 * import com.pulumi.aws.ebs.VolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Volume("example", VolumeArgs.builder()
 *             .availabilityZone("us-west-2a")
 *             .size(40)
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EBS Volumes using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ebs/volume:Volume id vol-049df61146c4d7901
 * ```
 * @property availabilityZone The AZ where the EBS volume will exist.
 * @property encrypted If true, the disk will be encrypted.
 * @property finalSnapshot If true, snapshot will be created before volume deletion. Any tags on the volume will be migrated to the snapshot. By default set to false
 * @property iops The amount of IOPS to provision for the disk. Only valid for `type` of `io1`, `io2` or `gp3`.
 * @property kmsKeyId The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true. Note: The provider must be running with credentials which have the `GenerateDataKeyWithoutPlaintext` permission on the specified KMS key as required by the [EBS KMS CMK volume provisioning process](https://docs.aws.amazon.com/kms/latest/developerguide/services-ebs.html#ebs-cmk) to prevent a volume from being created and almost immediately deleted.
 * @property multiAttachEnabled Specifies whether to enable Amazon EBS Multi-Attach. Multi-Attach is supported on `io1` and `io2` volumes.
 * @property outpostArn The Amazon Resource Name (ARN) of the Outpost.
 * @property size The size of the drive in GiBs.
 * @property snapshotId A snapshot to base the EBS volume off of.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property throughput The throughput that the volume supports, in MiB/s. Only valid for `type` of `gp3`.
 * > **NOTE:** When changing the `size`, `iops` or `type` of an instance, there are [considerations](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/considerations.html) to be aware of.
 * @property type The type of EBS volume. Can be `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1` or `st1` (Default: `gp2`).
 */
public data class VolumeArgs(
    public val availabilityZone: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val finalSnapshot: Output<Boolean>? = null,
    public val iops: Output<Int>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val multiAttachEnabled: Output<Boolean>? = null,
    public val outpostArn: Output<String>? = null,
    public val size: Output<Int>? = null,
    public val snapshotId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val throughput: Output<Int>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ebs.VolumeArgs> {
    override fun toJava(): com.pulumi.aws.ebs.VolumeArgs = com.pulumi.aws.ebs.VolumeArgs.builder()
        .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
        .encrypted(encrypted?.applyValue({ args0 -> args0 }))
        .finalSnapshot(finalSnapshot?.applyValue({ args0 -> args0 }))
        .iops(iops?.applyValue({ args0 -> args0 }))
        .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
        .multiAttachEnabled(multiAttachEnabled?.applyValue({ args0 -> args0 }))
        .outpostArn(outpostArn?.applyValue({ args0 -> args0 }))
        .size(size?.applyValue({ args0 -> args0 }))
        .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .throughput(throughput?.applyValue({ args0 -> args0 }))
        .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeArgs].
 */
@PulumiTagMarker
public class VolumeArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var finalSnapshot: Output<Boolean>? = null

    private var iops: Output<Int>? = null

    private var kmsKeyId: Output<String>? = null

    private var multiAttachEnabled: Output<Boolean>? = null

    private var outpostArn: Output<String>? = null

    private var size: Output<Int>? = null

    private var snapshotId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var throughput: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value The AZ where the EBS volume will exist.
     */
    @JvmName("sehhajqepitkcrej")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value If true, the disk will be encrypted.
     */
    @JvmName("sqqtpflpfseejgwp")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value If true, snapshot will be created before volume deletion. Any tags on the volume will be migrated to the snapshot. By default set to false
     */
    @JvmName("sfwuughplmsjgunw")
    public suspend fun finalSnapshot(`value`: Output<Boolean>) {
        this.finalSnapshot = value
    }

    /**
     * @param value The amount of IOPS to provision for the disk. Only valid for `type` of `io1`, `io2` or `gp3`.
     */
    @JvmName("vdmpuiqnvhsiudxg")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true. Note: The provider must be running with credentials which have the `GenerateDataKeyWithoutPlaintext` permission on the specified KMS key as required by the [EBS KMS CMK volume provisioning process](https://docs.aws.amazon.com/kms/latest/developerguide/services-ebs.html#ebs-cmk) to prevent a volume from being created and almost immediately deleted.
     */
    @JvmName("obbnhbrmmpidrmmw")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Specifies whether to enable Amazon EBS Multi-Attach. Multi-Attach is supported on `io1` and `io2` volumes.
     */
    @JvmName("bfqybusoqhpfelfg")
    public suspend fun multiAttachEnabled(`value`: Output<Boolean>) {
        this.multiAttachEnabled = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Outpost.
     */
    @JvmName("cyrolhqkhrexyeoc")
    public suspend fun outpostArn(`value`: Output<String>) {
        this.outpostArn = value
    }

    /**
     * @param value The size of the drive in GiBs.
     */
    @JvmName("bluloywchoyyvsge")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value A snapshot to base the EBS volume off of.
     */
    @JvmName("sxdcmnkwtsrivtyr")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wjjefuqsdtbqsohj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The throughput that the volume supports, in MiB/s. Only valid for `type` of `gp3`.
     * > **NOTE:** When changing the `size`, `iops` or `type` of an instance, there are [considerations](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/considerations.html) to be aware of.
     */
    @JvmName("hibwrwuexiojrdxw")
    public suspend fun throughput(`value`: Output<Int>) {
        this.throughput = value
    }

    /**
     * @param value The type of EBS volume. Can be `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1` or `st1` (Default: `gp2`).
     */
    @JvmName("idwrserohwdevfbo")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The AZ where the EBS volume will exist.
     */
    @JvmName("xngnbtkwlxbcdwjw")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value If true, the disk will be encrypted.
     */
    @JvmName("oymudiyfmuwubovn")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value If true, snapshot will be created before volume deletion. Any tags on the volume will be migrated to the snapshot. By default set to false
     */
    @JvmName("algynqowcuiheccn")
    public suspend fun finalSnapshot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.finalSnapshot = mapped
    }

    /**
     * @param value The amount of IOPS to provision for the disk. Only valid for `type` of `io1`, `io2` or `gp3`.
     */
    @JvmName("yqejsilibqyplhqa")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value The ARN for the KMS encryption key. When specifying `kms_key_id`, `encrypted` needs to be set to true. Note: The provider must be running with credentials which have the `GenerateDataKeyWithoutPlaintext` permission on the specified KMS key as required by the [EBS KMS CMK volume provisioning process](https://docs.aws.amazon.com/kms/latest/developerguide/services-ebs.html#ebs-cmk) to prevent a volume from being created and almost immediately deleted.
     */
    @JvmName("ixcbybkvenbdwpxs")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Specifies whether to enable Amazon EBS Multi-Attach. Multi-Attach is supported on `io1` and `io2` volumes.
     */
    @JvmName("vhxeunqgqdyjxlix")
    public suspend fun multiAttachEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiAttachEnabled = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Outpost.
     */
    @JvmName("ujiowgrlehrfirle")
    public suspend fun outpostArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outpostArn = mapped
    }

    /**
     * @param value The size of the drive in GiBs.
     */
    @JvmName("yfjxlerlppnblqwa")
    public suspend fun size(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value A snapshot to base the EBS volume off of.
     */
    @JvmName("mlbwmnjocarmhrwn")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("btcwdnbwkunmardt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ascpjeyekivlmpbb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The throughput that the volume supports, in MiB/s. Only valid for `type` of `gp3`.
     * > **NOTE:** When changing the `size`, `iops` or `type` of an instance, there are [considerations](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/considerations.html) to be aware of.
     */
    @JvmName("oqxuciflhiedhsfy")
    public suspend fun throughput(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughput = mapped
    }

    /**
     * @param value The type of EBS volume. Can be `standard`, `gp2`, `gp3`, `io1`, `io2`, `sc1` or `st1` (Default: `gp2`).
     */
    @JvmName("lpdeligjbdqtlmre")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): VolumeArgs = VolumeArgs(
        availabilityZone = availabilityZone,
        encrypted = encrypted,
        finalSnapshot = finalSnapshot,
        iops = iops,
        kmsKeyId = kmsKeyId,
        multiAttachEnabled = multiAttachEnabled,
        outpostArn = outpostArn,
        size = size,
        snapshotId = snapshotId,
        tags = tags,
        throughput = throughput,
        type = type,
    )
}
