@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.inputs

import com.pulumi.aws.ebs.inputs.GetEbsVolumesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEbsVolumes.
 * @property filters Custom filter block as described below.
 * @property tags Map of tags, each pair of which must exactly match
 * a pair on the desired volumes.
 * More complex filters can be expressed using one or more `filter` sub-blocks,
 * which take the following arguments:
 */
public data class GetEbsVolumesPlainArgs(
    public val filters: List<GetEbsVolumesFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ebs.inputs.GetEbsVolumesPlainArgs> {
    override fun toJava(): com.pulumi.aws.ebs.inputs.GetEbsVolumesPlainArgs =
        com.pulumi.aws.ebs.inputs.GetEbsVolumesPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetEbsVolumesPlainArgs].
 */
@PulumiTagMarker
public class GetEbsVolumesPlainArgsBuilder internal constructor() {
    private var filters: List<GetEbsVolumesFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Custom filter block as described below.
     */
    @JvmName("faosludyytcaosme")
    public suspend fun filters(`value`: List<GetEbsVolumesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("rwxflkrqkpakyaxt")
    public suspend fun filters(argument: List<suspend GetEbsVolumesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetEbsVolumesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("pdpkjwvkwjnivrxn")
    public suspend fun filters(vararg argument: suspend GetEbsVolumesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetEbsVolumesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Custom filter block as described below.
     */
    @JvmName("rbspgucihwbakbpy")
    public suspend fun filters(argument: suspend GetEbsVolumesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetEbsVolumesFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Custom filter block as described below.
     */
    @JvmName("mfvavsjcyfgpbxgk")
    public suspend fun filters(vararg values: GetEbsVolumesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match
     * a pair on the desired volumes.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("wgsptyewesmnojlf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match
     * a pair on the desired volumes.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     */
    @JvmName("fhekqrwlxfdssyja")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetEbsVolumesPlainArgs = GetEbsVolumesPlainArgs(
        filters = filters,
        tags = tags,
    )
}
