@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.inputs

import com.pulumi.aws.ebs.inputs.GetSnapshotIdsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSnapshotIds.
 * @property filters One or more name/value pairs to filter off of. There are
 * several valid keys, for a full reference, check out
 * [describe-volumes in the AWS CLI reference][1].
 * @property owners Returns the snapshots owned by the specified owner id. Multiple owners can be specified.
 * @property restorableByUserIds One or more AWS accounts IDs that can create volumes from the snapshot.
 */
public data class GetSnapshotIdsPlainArgs(
    public val filters: List<GetSnapshotIdsFilter>? = null,
    public val owners: List<String>? = null,
    public val restorableByUserIds: List<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ebs.inputs.GetSnapshotIdsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ebs.inputs.GetSnapshotIdsPlainArgs =
        com.pulumi.aws.ebs.inputs.GetSnapshotIdsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .owners(owners?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .restorableByUserIds(restorableByUserIds?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetSnapshotIdsPlainArgs].
 */
@PulumiTagMarker
public class GetSnapshotIdsPlainArgsBuilder internal constructor() {
    private var filters: List<GetSnapshotIdsFilter>? = null

    private var owners: List<String>? = null

    private var restorableByUserIds: List<String>? = null

    /**
     * @param value One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-volumes in the AWS CLI reference][1].
     */
    @JvmName("slxkbbjcseajqsox")
    public suspend fun filters(`value`: List<GetSnapshotIdsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-volumes in the AWS CLI reference][1].
     */
    @JvmName("ladwgnvvkmcgixsm")
    public suspend fun filters(argument: List<suspend GetSnapshotIdsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetSnapshotIdsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-volumes in the AWS CLI reference][1].
     */
    @JvmName("hdvkfwqqbrmyotic")
    public suspend fun filters(vararg argument: suspend GetSnapshotIdsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetSnapshotIdsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-volumes in the AWS CLI reference][1].
     */
    @JvmName("rvuodeaugwyueuoy")
    public suspend fun filters(argument: suspend GetSnapshotIdsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetSnapshotIdsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-volumes in the AWS CLI reference][1].
     */
    @JvmName("gbwnntmuxkdwxgom")
    public suspend fun filters(vararg values: GetSnapshotIdsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Returns the snapshots owned by the specified owner id. Multiple owners can be specified.
     */
    @JvmName("orsqgxsldansiwxi")
    public suspend fun owners(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.owners = mapped
    }

    /**
     * @param values Returns the snapshots owned by the specified owner id. Multiple owners can be specified.
     */
    @JvmName("atdqwitghnceacwp")
    public suspend fun owners(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.owners = mapped
    }

    /**
     * @param value One or more AWS accounts IDs that can create volumes from the snapshot.
     */
    @JvmName("safhmlsgqvgwissw")
    public suspend fun restorableByUserIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.restorableByUserIds = mapped
    }

    /**
     * @param values One or more AWS accounts IDs that can create volumes from the snapshot.
     */
    @JvmName("guyijyfommxblylu")
    public suspend fun restorableByUserIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.restorableByUserIds = mapped
    }

    internal fun build(): GetSnapshotIdsPlainArgs = GetSnapshotIdsPlainArgs(
        filters = filters,
        owners = owners,
        restorableByUserIds = restorableByUserIds,
    )
}
