@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.inputs

import com.pulumi.aws.ebs.inputs.GetVolumePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVolume.
 * @property filters One or more name/value pairs to filter off of. There are
 * several valid keys, for a full reference, check out
 * [describe-volumes in the AWS CLI reference][1].
 * @property mostRecent If more than one result is returned, use the most
 * recent Volume.
 * @property tags Map of tags for the resource.
 */
public data class GetVolumePlainArgs(
    public val filters: List<GetVolumeFilter>? = null,
    public val mostRecent: Boolean? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ebs.inputs.GetVolumePlainArgs> {
    override fun toJava(): com.pulumi.aws.ebs.inputs.GetVolumePlainArgs =
        com.pulumi.aws.ebs.inputs.GetVolumePlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .mostRecent(mostRecent?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetVolumePlainArgs].
 */
@PulumiTagMarker
public class GetVolumePlainArgsBuilder internal constructor() {
    private var filters: List<GetVolumeFilter>? = null

    private var mostRecent: Boolean? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-volumes in the AWS CLI reference][1].
     */
    @JvmName("iiokorjdrnvrbpbt")
    public suspend fun filters(`value`: List<GetVolumeFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-volumes in the AWS CLI reference][1].
     */
    @JvmName("gjicckodytrbxsqq")
    public suspend fun filters(argument: List<suspend GetVolumeFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GetVolumeFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-volumes in the AWS CLI reference][1].
     */
    @JvmName("xkqytshliwuwqlhf")
    public suspend fun filters(vararg argument: suspend GetVolumeFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GetVolumeFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-volumes in the AWS CLI reference][1].
     */
    @JvmName("gmarixoadinsxoln")
    public suspend fun filters(argument: suspend GetVolumeFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVolumeFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-volumes in the AWS CLI reference][1].
     */
    @JvmName("dxutvwngcdbqmjuj")
    public suspend fun filters(vararg values: GetVolumeFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value If more than one result is returned, use the most
     * recent Volume.
     */
    @JvmName("tlpwojiekklwnrlf")
    public suspend fun mostRecent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mostRecent = mapped
    }

    /**
     * @param value Map of tags for the resource.
     */
    @JvmName("fvjyaotdgcmdbmer")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags for the resource.
     */
    @JvmName("rabarfnbskhpxehl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetVolumePlainArgs = GetVolumePlainArgs(
        filters = filters,
        mostRecent = mostRecent,
        tags = tags,
    )
}
