@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.inputs

import com.pulumi.aws.ebs.inputs.SnapshotImportDiskContainerUserBucketArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3Bucket The name of the Amazon S3 bucket where the disk image is located.
 * @property s3Key The file name of the disk image.
 */
public data class SnapshotImportDiskContainerUserBucketArgs(
    public val s3Bucket: Output<String>,
    public val s3Key: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ebs.inputs.SnapshotImportDiskContainerUserBucketArgs> {
    override fun toJava(): com.pulumi.aws.ebs.inputs.SnapshotImportDiskContainerUserBucketArgs =
        com.pulumi.aws.ebs.inputs.SnapshotImportDiskContainerUserBucketArgs.builder()
            .s3Bucket(s3Bucket.applyValue({ args0 -> args0 }))
            .s3Key(s3Key.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotImportDiskContainerUserBucketArgs].
 */
@PulumiTagMarker
public class SnapshotImportDiskContainerUserBucketArgsBuilder internal constructor() {
    private var s3Bucket: Output<String>? = null

    private var s3Key: Output<String>? = null

    /**
     * @param value The name of the Amazon S3 bucket where the disk image is located.
     */
    @JvmName("bmvcacsijluokafp")
    public suspend fun s3Bucket(`value`: Output<String>) {
        this.s3Bucket = value
    }

    /**
     * @param value The file name of the disk image.
     */
    @JvmName("yqfgccobhxfoxnsp")
    public suspend fun s3Key(`value`: Output<String>) {
        this.s3Key = value
    }

    /**
     * @param value The name of the Amazon S3 bucket where the disk image is located.
     */
    @JvmName("igkaoexaygjmcroe")
    public suspend fun s3Bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Bucket = mapped
    }

    /**
     * @param value The file name of the disk image.
     */
    @JvmName("mdgcyedradghaahl")
    public suspend fun s3Key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Key = mapped
    }

    internal fun build(): SnapshotImportDiskContainerUserBucketArgs =
        SnapshotImportDiskContainerUserBucketArgs(
            s3Bucket = s3Bucket ?: throw PulumiNullFieldException("s3Bucket"),
            s3Key = s3Key ?: throw PulumiNullFieldException("s3Key"),
        )
}
