@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getDefaultKmsKey.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property keyArn ARN of the default KMS key uses to encrypt an EBS volume in this region when no key is specified in an API call that creates the volume and encryption by default is enabled.
 */
public data class GetDefaultKmsKeyResult(
    public val id: String,
    public val keyArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ebs.outputs.GetDefaultKmsKeyResult):
            GetDefaultKmsKeyResult = GetDefaultKmsKeyResult(
            id = javaType.id(),
            keyArn = javaType.keyArn(),
        )
    }
}
