@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getEbsVolumes.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids Set of all the EBS Volume IDs found. This data source will fail if
 * no volumes match the provided criteria.
 * @property tags
 */
public data class GetEbsVolumesResult(
    public val filters: List<GetEbsVolumesFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ebs.outputs.GetEbsVolumesResult):
            GetEbsVolumesResult = GetEbsVolumesResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ebs.kotlin.outputs.GetEbsVolumesFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
