@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSnapshotIds.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids Set of EBS snapshot IDs, sorted by creation time in descending order.
 * @property owners
 * @property restorableByUserIds
 */
public data class GetSnapshotIdsResult(
    public val filters: List<GetSnapshotIdsFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val owners: List<String>? = null,
    public val restorableByUserIds: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ebs.outputs.GetSnapshotIdsResult):
            GetSnapshotIdsResult = GetSnapshotIdsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ebs.kotlin.outputs.GetSnapshotIdsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            owners = javaType.owners().map({ args0 -> args0 }),
            restorableByUserIds = javaType.restorableByUserIds().map({ args0 -> args0 }),
        )
    }
}
