@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getVolume.
 * @property arn Volume ARN (e.g., arn:aws:ec2:us-east-1:0123456789012:volume/vol-59fcb34e).
 * @property availabilityZone AZ where the EBS volume exists.
 * @property encrypted Whether the disk is encrypted.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property iops Amount of IOPS for the disk.
 * @property kmsKeyId ARN for the KMS encryption key.
 * @property mostRecent
 * @property multiAttachEnabled (Optional) Specifies whether Amazon EBS Multi-Attach is enabled.
 * @property outpostArn ARN of the Outpost.
 * @property size Size of the drive in GiBs.
 * @property snapshotId Snapshot_id the EBS volume is based off.
 * @property tags Map of tags for the resource.
 * @property throughput Throughput that the volume supports, in MiB/s.
 * @property volumeId Volume ID (e.g., vol-59fcb34e).
 * @property volumeType Type of EBS volume.
 */
public data class GetVolumeResult(
    public val arn: String,
    public val availabilityZone: String,
    public val encrypted: Boolean,
    public val filters: List<GetVolumeFilter>? = null,
    public val id: String,
    public val iops: Int,
    public val kmsKeyId: String,
    public val mostRecent: Boolean? = null,
    public val multiAttachEnabled: Boolean,
    public val outpostArn: String,
    public val size: Int,
    public val snapshotId: String,
    public val tags: Map<String, String>,
    public val throughput: Int,
    public val volumeId: String,
    public val volumeType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ebs.outputs.GetVolumeResult): GetVolumeResult =
            GetVolumeResult(
                arn = javaType.arn(),
                availabilityZone = javaType.availabilityZone(),
                encrypted = javaType.encrypted(),
                filters = javaType.filters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.ebs.kotlin.outputs.GetVolumeFilter.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                iops = javaType.iops(),
                kmsKeyId = javaType.kmsKeyId(),
                mostRecent = javaType.mostRecent().map({ args0 -> args0 }).orElse(null),
                multiAttachEnabled = javaType.multiAttachEnabled(),
                outpostArn = javaType.outpostArn(),
                size = javaType.size(),
                snapshotId = javaType.snapshotId(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                throughput = javaType.throughput(),
                volumeId = javaType.volumeId(),
                volumeType = javaType.volumeType(),
            )
    }
}
