@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ebs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property s3Bucket The name of the Amazon S3 bucket where the disk image is located.
 * @property s3Key The file name of the disk image.
 */
public data class SnapshotImportDiskContainerUserBucket(
    public val s3Bucket: String,
    public val s3Key: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ebs.outputs.SnapshotImportDiskContainerUserBucket):
            SnapshotImportDiskContainerUserBucket = SnapshotImportDiskContainerUserBucket(
            s3Bucket = javaType.s3Bucket(),
            s3Key = javaType.s3Key(),
        )
    }
}
