@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.AmiArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.AmiEbsBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.AmiEbsBlockDeviceArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.AmiEphemeralBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.AmiEphemeralBlockDeviceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The AMI resource allows the creation and management of a completely-custom
 * *Amazon Machine Image* (AMI).
 * If you just want to duplicate an existing AMI, possibly copying it to another
 * region, it's better to use `aws.ec2.AmiCopy` instead.
 * If you just want to share an existing AMI with another AWS account,
 * it's better to use `aws.ec2.AmiLaunchPermission` instead.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ami;
 * import com.pulumi.aws.ec2.AmiArgs;
 * import com.pulumi.aws.ec2.inputs.AmiEbsBlockDeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Ami("example", AmiArgs.builder()
 *             .ebsBlockDevices(AmiEbsBlockDeviceArgs.builder()
 *                 .deviceName("/dev/xvda")
 *                 .snapshotId("snap-xxxxxxxx")
 *                 .volumeSize(8)
 *                 .build())
 *             .imdsSupport("v2.0")
 *             .rootDeviceName("/dev/xvda")
 *             .virtualizationType("hvm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ami` using the ID of the AMI. For example:
 * ```sh
 *  $ pulumi import aws:ec2/ami:Ami example ami-12345678
 * ```
 * @property architecture Machine architecture for created instances. Defaults to "x86_64".
 * @property bootMode Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
 * @property deprecationTime Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
 * @property description Longer, human-readable description for the AMI.
 * @property ebsBlockDevices Nested block describing an EBS block device that should be
 * attached to created instances. The structure of this block is described below.
 * @property enaSupport Whether enhanced networking with ENA is enabled. Defaults to `false`.
 * @property ephemeralBlockDevices Nested block describing an ephemeral block device that
 * should be attached to created instances. The structure of this block is described below.
 * @property imageLocation Path to an S3 object containing an image manifest, e.g., created
 * by the `ec2-upload-bundle` command in the EC2 command line tools.
 * @property imdsSupport If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
 * @property kernelId ID of the kernel image (AKI) that will be used as the paravirtual
 * kernel in created instances.
 * @property name Region-unique name for the AMI.
 * @property ramdiskId ID of an initrd image (ARI) that will be used when booting the
 * created instances.
 * @property rootDeviceName Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
 * @property sriovNetSupport When set to "simple" (the default), enables enhanced networking
 * for created instances. No other value is supported at this time.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tpmSupport If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
 * @property virtualizationType Keyword to choose what virtualization mode created instances
 * will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
 * changes the set of further arguments that are required, as described below.
 */
public data class AmiArgs(
    public val architecture: Output<String>? = null,
    public val bootMode: Output<String>? = null,
    public val deprecationTime: Output<String>? = null,
    public val description: Output<String>? = null,
    public val ebsBlockDevices: Output<List<AmiEbsBlockDeviceArgs>>? = null,
    public val enaSupport: Output<Boolean>? = null,
    public val ephemeralBlockDevices: Output<List<AmiEphemeralBlockDeviceArgs>>? = null,
    public val imageLocation: Output<String>? = null,
    public val imdsSupport: Output<String>? = null,
    public val kernelId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val ramdiskId: Output<String>? = null,
    public val rootDeviceName: Output<String>? = null,
    public val sriovNetSupport: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tpmSupport: Output<String>? = null,
    public val virtualizationType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.AmiArgs> {
    override fun toJava(): com.pulumi.aws.ec2.AmiArgs = com.pulumi.aws.ec2.AmiArgs.builder()
        .architecture(architecture?.applyValue({ args0 -> args0 }))
        .bootMode(bootMode?.applyValue({ args0 -> args0 }))
        .deprecationTime(deprecationTime?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .ebsBlockDevices(
            ebsBlockDevices?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .enaSupport(enaSupport?.applyValue({ args0 -> args0 }))
        .ephemeralBlockDevices(
            ephemeralBlockDevices?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .imageLocation(imageLocation?.applyValue({ args0 -> args0 }))
        .imdsSupport(imdsSupport?.applyValue({ args0 -> args0 }))
        .kernelId(kernelId?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .ramdiskId(ramdiskId?.applyValue({ args0 -> args0 }))
        .rootDeviceName(rootDeviceName?.applyValue({ args0 -> args0 }))
        .sriovNetSupport(sriovNetSupport?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .tpmSupport(tpmSupport?.applyValue({ args0 -> args0 }))
        .virtualizationType(virtualizationType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmiArgs].
 */
@PulumiTagMarker
public class AmiArgsBuilder internal constructor() {
    private var architecture: Output<String>? = null

    private var bootMode: Output<String>? = null

    private var deprecationTime: Output<String>? = null

    private var description: Output<String>? = null

    private var ebsBlockDevices: Output<List<AmiEbsBlockDeviceArgs>>? = null

    private var enaSupport: Output<Boolean>? = null

    private var ephemeralBlockDevices: Output<List<AmiEphemeralBlockDeviceArgs>>? = null

    private var imageLocation: Output<String>? = null

    private var imdsSupport: Output<String>? = null

    private var kernelId: Output<String>? = null

    private var name: Output<String>? = null

    private var ramdiskId: Output<String>? = null

    private var rootDeviceName: Output<String>? = null

    private var sriovNetSupport: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tpmSupport: Output<String>? = null

    private var virtualizationType: Output<String>? = null

    /**
     * @param value Machine architecture for created instances. Defaults to "x86_64".
     */
    @JvmName("ayxejvdaqhuxludb")
    public suspend fun architecture(`value`: Output<String>) {
        this.architecture = value
    }

    /**
     * @param value Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
     */
    @JvmName("hkgsmbuhiwvagxfn")
    public suspend fun bootMode(`value`: Output<String>) {
        this.bootMode = value
    }

    /**
     * @param value Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    @JvmName("dxcneftihoicjbfg")
    public suspend fun deprecationTime(`value`: Output<String>) {
        this.deprecationTime = value
    }

    /**
     * @param value Longer, human-readable description for the AMI.
     */
    @JvmName("kemtegistwkysiwa")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("ggjatryilftihutk")
    public suspend fun ebsBlockDevices(`value`: Output<List<AmiEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = value
    }

    @JvmName("olpslbuhkbfmwvpk")
    public suspend fun ebsBlockDevices(vararg values: Output<AmiEbsBlockDeviceArgs>) {
        this.ebsBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("fpugsdmwvakooavt")
    public suspend fun ebsBlockDevices(values: List<Output<AmiEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = Output.all(values)
    }

    /**
     * @param value Whether enhanced networking with ENA is enabled. Defaults to `false`.
     */
    @JvmName("apgrasgayberbhrg")
    public suspend fun enaSupport(`value`: Output<Boolean>) {
        this.enaSupport = value
    }

    /**
     * @param value Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("fvlewyptdydtrohj")
    public suspend fun ephemeralBlockDevices(`value`: Output<List<AmiEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = value
    }

    @JvmName("lvpqkgouadjgaeuf")
    public suspend fun ephemeralBlockDevices(vararg values: Output<AmiEphemeralBlockDeviceArgs>) {
        this.ephemeralBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("fucgjievasflvxtc")
    public suspend fun ephemeralBlockDevices(values: List<Output<AmiEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = Output.all(values)
    }

    /**
     * @param value Path to an S3 object containing an image manifest, e.g., created
     * by the `ec2-upload-bundle` command in the EC2 command line tools.
     */
    @JvmName("ebkjfoxvnyeijqql")
    public suspend fun imageLocation(`value`: Output<String>) {
        this.imageLocation = value
    }

    /**
     * @param value If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
     */
    @JvmName("sumukyatbledpcvt")
    public suspend fun imdsSupport(`value`: Output<String>) {
        this.imdsSupport = value
    }

    /**
     * @param value ID of the kernel image (AKI) that will be used as the paravirtual
     * kernel in created instances.
     */
    @JvmName("axhshjbtimsxepbl")
    public suspend fun kernelId(`value`: Output<String>) {
        this.kernelId = value
    }

    /**
     * @param value Region-unique name for the AMI.
     */
    @JvmName("xdhbaprpkmnyidnc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value ID of an initrd image (ARI) that will be used when booting the
     * created instances.
     */
    @JvmName("avmktombfuvdlmvu")
    public suspend fun ramdiskId(`value`: Output<String>) {
        this.ramdiskId = value
    }

    /**
     * @param value Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
     */
    @JvmName("qaufkvitrmfxfbex")
    public suspend fun rootDeviceName(`value`: Output<String>) {
        this.rootDeviceName = value
    }

    /**
     * @param value When set to "simple" (the default), enables enhanced networking
     * for created instances. No other value is supported at this time.
     */
    @JvmName("bctfblqayugvnuac")
    public suspend fun sriovNetSupport(`value`: Output<String>) {
        this.sriovNetSupport = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("afcvyqxqjthaaqti")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
     */
    @JvmName("jjkyetgqrmddnsxu")
    public suspend fun tpmSupport(`value`: Output<String>) {
        this.tpmSupport = value
    }

    /**
     * @param value Keyword to choose what virtualization mode created instances
     * will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
     * changes the set of further arguments that are required, as described below.
     */
    @JvmName("bsuspjvdjwnajufo")
    public suspend fun virtualizationType(`value`: Output<String>) {
        this.virtualizationType = value
    }

    /**
     * @param value Machine architecture for created instances. Defaults to "x86_64".
     */
    @JvmName("kjtqoowmfgfmqphw")
    public suspend fun architecture(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.architecture = mapped
    }

    /**
     * @param value Boot mode of the AMI. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the Amazon Elastic Compute Cloud User Guide.
     */
    @JvmName("eyotbtsqbcwhdxyf")
    public suspend fun bootMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bootMode = mapped
    }

    /**
     * @param value Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    @JvmName("fdwyydmytkakhquh")
    public suspend fun deprecationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deprecationTime = mapped
    }

    /**
     * @param value Longer, human-readable description for the AMI.
     */
    @JvmName("almmutpfgcqlymym")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("pdqflkvbcjxxhvgs")
    public suspend fun ebsBlockDevices(`value`: List<AmiEbsBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("kxidrxfwvcflnfws")
    public suspend
    fun ebsBlockDevices(argument: List<suspend AmiEbsBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AmiEbsBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("wsrfasjshyugksmw")
    public suspend fun ebsBlockDevices(
        vararg
        argument: suspend AmiEbsBlockDeviceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AmiEbsBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("wsvlqbhphhcmrruc")
    public suspend fun ebsBlockDevices(argument: suspend AmiEbsBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AmiEbsBlockDeviceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param values Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("groisvugxmjdwfxi")
    public suspend fun ebsBlockDevices(vararg values: AmiEbsBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param value Whether enhanced networking with ENA is enabled. Defaults to `false`.
     */
    @JvmName("bwkgstjelnwmfkdk")
    public suspend fun enaSupport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enaSupport = mapped
    }

    /**
     * @param value Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("mlyooyamcgubqcqn")
    public suspend fun ephemeralBlockDevices(`value`: List<AmiEphemeralBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("gkpxnkuseonhyohr")
    public suspend
    fun ephemeralBlockDevices(argument: List<suspend AmiEphemeralBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AmiEphemeralBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("kjuiiluwdywlmiyc")
    public suspend fun ephemeralBlockDevices(
        vararg
        argument: suspend AmiEphemeralBlockDeviceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AmiEphemeralBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("ltmiwrfyapypmedr")
    public suspend
    fun ephemeralBlockDevices(argument: suspend AmiEphemeralBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AmiEphemeralBlockDeviceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param values Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("rruduiwkllcmkxgs")
    public suspend fun ephemeralBlockDevices(vararg values: AmiEphemeralBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param value Path to an S3 object containing an image manifest, e.g., created
     * by the `ec2-upload-bundle` command in the EC2 command line tools.
     */
    @JvmName("nishoxvscwijghog")
    public suspend fun imageLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageLocation = mapped
    }

    /**
     * @param value If EC2 instances started from this image should require the use of the Instance Metadata Service V2 (IMDSv2), set this argument to `v2.0`. For more information, see [Configure instance metadata options for new instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-IMDS-new-instances.html#configure-IMDS-new-instances-ami-configuration).
     */
    @JvmName("cfqatiixlupufhpc")
    public suspend fun imdsSupport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imdsSupport = mapped
    }

    /**
     * @param value ID of the kernel image (AKI) that will be used as the paravirtual
     * kernel in created instances.
     */
    @JvmName("jmwtwfhvgsljrjeh")
    public suspend fun kernelId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kernelId = mapped
    }

    /**
     * @param value Region-unique name for the AMI.
     */
    @JvmName("wesblxiblsorvksa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value ID of an initrd image (ARI) that will be used when booting the
     * created instances.
     */
    @JvmName("tpcygulyitwxmytk")
    public suspend fun ramdiskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ramdiskId = mapped
    }

    /**
     * @param value Name of the root device (for example, `/dev/sda1`, or `/dev/xvda`).
     */
    @JvmName("ilbvlvskqeflmvap")
    public suspend fun rootDeviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootDeviceName = mapped
    }

    /**
     * @param value When set to "simple" (the default), enables enhanced networking
     * for created instances. No other value is supported at this time.
     */
    @JvmName("ltncgshxiwsljdky")
    public suspend fun sriovNetSupport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sriovNetSupport = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jdfbmaewqqatldho")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("igqufdvgjeuaqitb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value If the image is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the Amazon Elastic Compute Cloud User Guide.
     */
    @JvmName("lspbbdegjhgyjqbf")
    public suspend fun tpmSupport(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tpmSupport = mapped
    }

    /**
     * @param value Keyword to choose what virtualization mode created instances
     * will use. Can be either "paravirtual" (the default) or "hvm". The choice of virtualization type
     * changes the set of further arguments that are required, as described below.
     */
    @JvmName("sgixcplksnmamcih")
    public suspend fun virtualizationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualizationType = mapped
    }

    internal fun build(): AmiArgs = AmiArgs(
        architecture = architecture,
        bootMode = bootMode,
        deprecationTime = deprecationTime,
        description = description,
        ebsBlockDevices = ebsBlockDevices,
        enaSupport = enaSupport,
        ephemeralBlockDevices = ephemeralBlockDevices,
        imageLocation = imageLocation,
        imdsSupport = imdsSupport,
        kernelId = kernelId,
        name = name,
        ramdiskId = ramdiskId,
        rootDeviceName = rootDeviceName,
        sriovNetSupport = sriovNetSupport,
        tags = tags,
        tpmSupport = tpmSupport,
        virtualizationType = virtualizationType,
    )
}
