@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.AmiCopyArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.AmiCopyEbsBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.AmiCopyEbsBlockDeviceArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.AmiCopyEphemeralBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.AmiCopyEphemeralBlockDeviceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The "AMI copy" resource allows duplication of an Amazon Machine Image (AMI),
 * including cross-region copies.
 * If the source AMI has associated EBS snapshots, those will also be duplicated
 * along with the AMI.
 * This is useful for taking a single AMI provisioned in one region and making
 * it available in another for a multi-region deployment.
 * Copying an AMI can take several minutes. The creation of this resource will
 * block until the new AMI is available for use on new instances.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AmiCopy;
 * import com.pulumi.aws.ec2.AmiCopyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AmiCopy("example", AmiCopyArgs.builder()
 *             .description("A copy of ami-xxxxxxxx")
 *             .sourceAmiId("ami-xxxxxxxx")
 *             .sourceAmiRegion("us-west-1")
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *     }
 * }
 * ```
 * @property deprecationTime Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
 * @property description Longer, human-readable description for the AMI.
 * @property destinationOutpostArn ARN of the Outpost to which to copy the AMI.
 * Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
 * @property ebsBlockDevices Nested block describing an EBS block device that should be
 * attached to created instances. The structure of this block is described below.
 * @property encrypted Whether the destination snapshots of the copied image should be encrypted. Defaults to `false`
 * @property ephemeralBlockDevices Nested block describing an ephemeral block device that
 * should be attached to created instances. The structure of this block is described below.
 * @property kmsKeyId Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
 * @property name Region-unique name for the AMI.
 * @property sourceAmiId Id of the AMI to copy. This id must be valid in the region
 * given by `source_ami_region`.
 * @property sourceAmiRegion Region from which the AMI will be copied. This may be the
 * same as the AWS provider region in order to create a copy within the same region.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AmiCopyArgs(
    public val deprecationTime: Output<String>? = null,
    public val description: Output<String>? = null,
    public val destinationOutpostArn: Output<String>? = null,
    public val ebsBlockDevices: Output<List<AmiCopyEbsBlockDeviceArgs>>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val ephemeralBlockDevices: Output<List<AmiCopyEphemeralBlockDeviceArgs>>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val sourceAmiId: Output<String>? = null,
    public val sourceAmiRegion: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.AmiCopyArgs> {
    override fun toJava(): com.pulumi.aws.ec2.AmiCopyArgs = com.pulumi.aws.ec2.AmiCopyArgs.builder()
        .deprecationTime(deprecationTime?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .destinationOutpostArn(destinationOutpostArn?.applyValue({ args0 -> args0 }))
        .ebsBlockDevices(
            ebsBlockDevices?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .encrypted(encrypted?.applyValue({ args0 -> args0 }))
        .ephemeralBlockDevices(
            ephemeralBlockDevices?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .sourceAmiId(sourceAmiId?.applyValue({ args0 -> args0 }))
        .sourceAmiRegion(sourceAmiRegion?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [AmiCopyArgs].
 */
@PulumiTagMarker
public class AmiCopyArgsBuilder internal constructor() {
    private var deprecationTime: Output<String>? = null

    private var description: Output<String>? = null

    private var destinationOutpostArn: Output<String>? = null

    private var ebsBlockDevices: Output<List<AmiCopyEbsBlockDeviceArgs>>? = null

    private var encrypted: Output<Boolean>? = null

    private var ephemeralBlockDevices: Output<List<AmiCopyEphemeralBlockDeviceArgs>>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var sourceAmiId: Output<String>? = null

    private var sourceAmiRegion: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    @JvmName("fgkggucqadtprjvf")
    public suspend fun deprecationTime(`value`: Output<String>) {
        this.deprecationTime = value
    }

    /**
     * @param value Longer, human-readable description for the AMI.
     */
    @JvmName("ltxnpvxxygigcgdw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value ARN of the Outpost to which to copy the AMI.
     * Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
     */
    @JvmName("uqpeafawweteewrh")
    public suspend fun destinationOutpostArn(`value`: Output<String>) {
        this.destinationOutpostArn = value
    }

    /**
     * @param value Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("ubtdfbsruvqbkajp")
    public suspend fun ebsBlockDevices(`value`: Output<List<AmiCopyEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = value
    }

    @JvmName("obtftnhslouifimb")
    public suspend fun ebsBlockDevices(vararg values: Output<AmiCopyEbsBlockDeviceArgs>) {
        this.ebsBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("qyrtwbtuslhhiktv")
    public suspend fun ebsBlockDevices(values: List<Output<AmiCopyEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = Output.all(values)
    }

    /**
     * @param value Whether the destination snapshots of the copied image should be encrypted. Defaults to `false`
     */
    @JvmName("qokvntjoanmnmqgj")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("kxhelwggqdloghum")
    public suspend fun ephemeralBlockDevices(`value`: Output<List<AmiCopyEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = value
    }

    @JvmName("dvqcvectpfmiscbo")
    public suspend fun ephemeralBlockDevices(vararg values: Output<AmiCopyEphemeralBlockDeviceArgs>) {
        this.ephemeralBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("oumohixpaqsehphd")
    public suspend fun ephemeralBlockDevices(values: List<Output<AmiCopyEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = Output.all(values)
    }

    /**
     * @param value Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
     */
    @JvmName("tbvumkxeaeltrfnk")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Region-unique name for the AMI.
     */
    @JvmName("ostrstfmojugrfws")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Id of the AMI to copy. This id must be valid in the region
     * given by `source_ami_region`.
     */
    @JvmName("cmxeyyyvnbisnohg")
    public suspend fun sourceAmiId(`value`: Output<String>) {
        this.sourceAmiId = value
    }

    /**
     * @param value Region from which the AMI will be copied. This may be the
     * same as the AWS provider region in order to create a copy within the same region.
     */
    @JvmName("ivdlrctmpfpsehal")
    public suspend fun sourceAmiRegion(`value`: Output<String>) {
        this.sourceAmiRegion = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nxoeubhjmtkvhxti")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    @JvmName("orwwiimxxaquvaih")
    public suspend fun deprecationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deprecationTime = mapped
    }

    /**
     * @param value Longer, human-readable description for the AMI.
     */
    @JvmName("romrwchjimkqdowg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value ARN of the Outpost to which to copy the AMI.
     * Only specify this parameter when copying an AMI from an AWS Region to an Outpost. The AMI must be in the Region of the destination Outpost.
     */
    @JvmName("hwynqwtucolpljyu")
    public suspend fun destinationOutpostArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationOutpostArn = mapped
    }

    /**
     * @param value Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("fhsndrqplhwxeilb")
    public suspend fun ebsBlockDevices(`value`: List<AmiCopyEbsBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("gkbfryodkyaanvkk")
    public suspend
    fun ebsBlockDevices(argument: List<suspend AmiCopyEbsBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AmiCopyEbsBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("lkaregulsbvniexe")
    public suspend fun ebsBlockDevices(
        vararg
        argument: suspend AmiCopyEbsBlockDeviceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AmiCopyEbsBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("muypwyxupojkugnt")
    public suspend
    fun ebsBlockDevices(argument: suspend AmiCopyEbsBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AmiCopyEbsBlockDeviceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param values Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("qiolwugrnkfccuaw")
    public suspend fun ebsBlockDevices(vararg values: AmiCopyEbsBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param value Whether the destination snapshots of the copied image should be encrypted. Defaults to `false`
     */
    @JvmName("bcfxufkrmcqmlgfo")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("vgwvvehlxpyqvsjn")
    public suspend fun ephemeralBlockDevices(`value`: List<AmiCopyEphemeralBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("yacxoowuwjbvhknp")
    public suspend
    fun ephemeralBlockDevices(argument: List<suspend AmiCopyEphemeralBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AmiCopyEphemeralBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("ytnxafkkjsdtxshq")
    public suspend fun ephemeralBlockDevices(
        vararg
        argument: suspend AmiCopyEphemeralBlockDeviceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AmiCopyEphemeralBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("uebmkhlupnxkomso")
    public suspend
    fun ephemeralBlockDevices(argument: suspend AmiCopyEphemeralBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AmiCopyEphemeralBlockDeviceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param values Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("wqnwmyoafmeqdclg")
    public suspend fun ephemeralBlockDevices(vararg values: AmiCopyEphemeralBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param value Full ARN of the KMS Key to use when encrypting the snapshots of an image during a copy operation. If not specified, then the default AWS KMS Key will be used
     */
    @JvmName("eiowwsjrvagkwatj")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Region-unique name for the AMI.
     */
    @JvmName("jlndhnkxknivkbbe")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Id of the AMI to copy. This id must be valid in the region
     * given by `source_ami_region`.
     */
    @JvmName("pavnjnsykluegyrs")
    public suspend fun sourceAmiId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAmiId = mapped
    }

    /**
     * @param value Region from which the AMI will be copied. This may be the
     * same as the AWS provider region in order to create a copy within the same region.
     */
    @JvmName("majuyoyhyfuujhwl")
    public suspend fun sourceAmiRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAmiRegion = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ymmdqqguwthwuhwb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kflwmjtcsysdoqyw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AmiCopyArgs = AmiCopyArgs(
        deprecationTime = deprecationTime,
        description = description,
        destinationOutpostArn = destinationOutpostArn,
        ebsBlockDevices = ebsBlockDevices,
        encrypted = encrypted,
        ephemeralBlockDevices = ephemeralBlockDevices,
        kmsKeyId = kmsKeyId,
        name = name,
        sourceAmiId = sourceAmiId,
        sourceAmiRegion = sourceAmiRegion,
        tags = tags,
    )
}
