@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.AmiFromInstanceArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.AmiFromInstanceEbsBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.AmiFromInstanceEbsBlockDeviceArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.AmiFromInstanceEphemeralBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.AmiFromInstanceEphemeralBlockDeviceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The "AMI from instance" resource allows the creation of an Amazon Machine
 * Image (AMI) modelled after an existing EBS-backed EC2 instance.
 * The created AMI will refer to implicitly-created snapshots of the instance's
 * EBS volumes and mimick its assigned block device configuration at the time
 * the resource is created.
 * This resource is best applied to an instance that is stopped when this instance
 * is created, so that the contents of the created image are predictable. When
 * applied to an instance that is running, *the instance will be stopped before taking
 * the snapshots and then started back up again*, resulting in a period of
 * downtime.
 * Note that the source instance is inspected only at the initial creation of this
 * resource. Ongoing updates to the referenced instance will not be propagated into
 * the generated AMI. Users may taint or otherwise recreate the resource in order
 * to produce a fresh snapshot.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AmiFromInstance;
 * import com.pulumi.aws.ec2.AmiFromInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AmiFromInstance("example", AmiFromInstanceArgs.builder()
 *             .sourceInstanceId("i-xxxxxxxx")
 *             .build());
 *     }
 * }
 * ```
 * @property deprecationTime Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
 * @property description Longer, human-readable description for the AMI.
 * @property ebsBlockDevices Nested block describing an EBS block device that should be
 * attached to created instances. The structure of this block is described below.
 * @property ephemeralBlockDevices Nested block describing an ephemeral block device that
 * should be attached to created instances. The structure of this block is described below.
 * @property name Region-unique name for the AMI.
 * @property snapshotWithoutReboot Boolean that overrides the behavior of stopping
 * the instance before snapshotting. This is risky since it may cause a snapshot of an
 * inconsistent filesystem state, but can be used to avoid downtime if the user otherwise
 * guarantees that no filesystem writes will be underway at the time of snapshot.
 * @property sourceInstanceId ID of the instance to use as the basis of the AMI.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AmiFromInstanceArgs(
    public val deprecationTime: Output<String>? = null,
    public val description: Output<String>? = null,
    public val ebsBlockDevices: Output<List<AmiFromInstanceEbsBlockDeviceArgs>>? = null,
    public val ephemeralBlockDevices: Output<List<AmiFromInstanceEphemeralBlockDeviceArgs>>? = null,
    public val name: Output<String>? = null,
    public val snapshotWithoutReboot: Output<Boolean>? = null,
    public val sourceInstanceId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.AmiFromInstanceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.AmiFromInstanceArgs =
        com.pulumi.aws.ec2.AmiFromInstanceArgs.builder()
            .deprecationTime(deprecationTime?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .ebsBlockDevices(
                ebsBlockDevices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ephemeralBlockDevices(
                ephemeralBlockDevices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .snapshotWithoutReboot(snapshotWithoutReboot?.applyValue({ args0 -> args0 }))
            .sourceInstanceId(sourceInstanceId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AmiFromInstanceArgs].
 */
@PulumiTagMarker
public class AmiFromInstanceArgsBuilder internal constructor() {
    private var deprecationTime: Output<String>? = null

    private var description: Output<String>? = null

    private var ebsBlockDevices: Output<List<AmiFromInstanceEbsBlockDeviceArgs>>? = null

    private var ephemeralBlockDevices: Output<List<AmiFromInstanceEphemeralBlockDeviceArgs>>? = null

    private var name: Output<String>? = null

    private var snapshotWithoutReboot: Output<Boolean>? = null

    private var sourceInstanceId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    @JvmName("hyjeyehvwwxcphby")
    public suspend fun deprecationTime(`value`: Output<String>) {
        this.deprecationTime = value
    }

    /**
     * @param value Longer, human-readable description for the AMI.
     */
    @JvmName("xjbbopwnxmnajmxh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("qpqbdaigtbriwxwh")
    public suspend fun ebsBlockDevices(`value`: Output<List<AmiFromInstanceEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = value
    }

    @JvmName("xdpawaecccgnksmm")
    public suspend fun ebsBlockDevices(vararg values: Output<AmiFromInstanceEbsBlockDeviceArgs>) {
        this.ebsBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("uqkgatdmyidoomtr")
    public suspend fun ebsBlockDevices(values: List<Output<AmiFromInstanceEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = Output.all(values)
    }

    /**
     * @param value Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("jghfwslbbpfatuxc")
    public suspend
    fun ephemeralBlockDevices(`value`: Output<List<AmiFromInstanceEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = value
    }

    @JvmName("jloljwwxqfofmaap")
    public suspend fun ephemeralBlockDevices(
        vararg
        values: Output<AmiFromInstanceEphemeralBlockDeviceArgs>,
    ) {
        this.ephemeralBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("djsfclttabcegcei")
    public suspend
    fun ephemeralBlockDevices(values: List<Output<AmiFromInstanceEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = Output.all(values)
    }

    /**
     * @param value Region-unique name for the AMI.
     */
    @JvmName("afphxcqkogsunknk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Boolean that overrides the behavior of stopping
     * the instance before snapshotting. This is risky since it may cause a snapshot of an
     * inconsistent filesystem state, but can be used to avoid downtime if the user otherwise
     * guarantees that no filesystem writes will be underway at the time of snapshot.
     */
    @JvmName("fvxnvjirtlqinqex")
    public suspend fun snapshotWithoutReboot(`value`: Output<Boolean>) {
        this.snapshotWithoutReboot = value
    }

    /**
     * @param value ID of the instance to use as the basis of the AMI.
     */
    @JvmName("osgkhiryrnutetdq")
    public suspend fun sourceInstanceId(`value`: Output<String>) {
        this.sourceInstanceId = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("otvmguqoaboiayde")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Date and time to deprecate the AMI. If you specified a value for seconds, Amazon EC2 rounds the seconds to the nearest minute. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    @JvmName("alqfgglhgqufvwin")
    public suspend fun deprecationTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deprecationTime = mapped
    }

    /**
     * @param value Longer, human-readable description for the AMI.
     */
    @JvmName("tthmldfflrkeigyq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("pxtbfbsthcmppnfy")
    public suspend fun ebsBlockDevices(`value`: List<AmiFromInstanceEbsBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("bbhkwqvlxmkkotmi")
    public suspend
    fun ebsBlockDevices(argument: List<suspend AmiFromInstanceEbsBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AmiFromInstanceEbsBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("isulqitcetcxbgjv")
    public suspend fun ebsBlockDevices(
        vararg
        argument: suspend AmiFromInstanceEbsBlockDeviceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AmiFromInstanceEbsBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("kfjxtyllskokvrum")
    public suspend
    fun ebsBlockDevices(argument: suspend AmiFromInstanceEbsBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AmiFromInstanceEbsBlockDeviceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param values Nested block describing an EBS block device that should be
     * attached to created instances. The structure of this block is described below.
     */
    @JvmName("eapvogxxrnttgrcx")
    public suspend fun ebsBlockDevices(vararg values: AmiFromInstanceEbsBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param value Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("iturypodtipymkwf")
    public suspend
    fun ephemeralBlockDevices(`value`: List<AmiFromInstanceEphemeralBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("vlhwilrjthgvpcqj")
    public suspend
    fun ephemeralBlockDevices(argument: List<suspend AmiFromInstanceEphemeralBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AmiFromInstanceEphemeralBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("nkhjobfvidfwjubu")
    public suspend fun ephemeralBlockDevices(
        vararg
        argument: suspend AmiFromInstanceEphemeralBlockDeviceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AmiFromInstanceEphemeralBlockDeviceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("xcbprsjmkvijlvnr")
    public suspend
    fun ephemeralBlockDevices(argument: suspend AmiFromInstanceEphemeralBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AmiFromInstanceEphemeralBlockDeviceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param values Nested block describing an ephemeral block device that
     * should be attached to created instances. The structure of this block is described below.
     */
    @JvmName("bwhtlghdgnbxmwqa")
    public suspend fun ephemeralBlockDevices(vararg values: AmiFromInstanceEphemeralBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param value Region-unique name for the AMI.
     */
    @JvmName("devfvvxqdyyahucs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Boolean that overrides the behavior of stopping
     * the instance before snapshotting. This is risky since it may cause a snapshot of an
     * inconsistent filesystem state, but can be used to avoid downtime if the user otherwise
     * guarantees that no filesystem writes will be underway at the time of snapshot.
     */
    @JvmName("mnltdgshacbvaltt")
    public suspend fun snapshotWithoutReboot(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotWithoutReboot = mapped
    }

    /**
     * @param value ID of the instance to use as the basis of the AMI.
     */
    @JvmName("iwblefkflcqjujlf")
    public suspend fun sourceInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceInstanceId = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gqhpjdntgteykkui")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("brtgvbbftvrvhena")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AmiFromInstanceArgs = AmiFromInstanceArgs(
        deprecationTime = deprecationTime,
        description = description,
        ebsBlockDevices = ebsBlockDevices,
        ephemeralBlockDevices = ephemeralBlockDevices,
        name = name,
        snapshotWithoutReboot = snapshotWithoutReboot,
        sourceInstanceId = sourceInstanceId,
        tags = tags,
    )
}
