@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AmiLaunchPermission].
 */
@PulumiTagMarker
public class AmiLaunchPermissionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AmiLaunchPermissionArgs = AmiLaunchPermissionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AmiLaunchPermissionArgsBuilder.() -> Unit) {
        val builder = AmiLaunchPermissionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AmiLaunchPermission {
        val builtJavaResource = com.pulumi.aws.ec2.AmiLaunchPermission(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AmiLaunchPermission(builtJavaResource)
    }
}

/**
 * Adds a launch permission to an Amazon Machine Image (AMI).
 * ## Example Usage
 * ### AWS Account ID
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AmiLaunchPermission;
 * import com.pulumi.aws.ec2.AmiLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AmiLaunchPermission("example", AmiLaunchPermissionArgs.builder()
 *             .accountId("123456789012")
 *             .imageId("ami-12345678")
 *             .build());
 *     }
 * }
 * ```
 * ### Public Access
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AmiLaunchPermission;
 * import com.pulumi.aws.ec2.AmiLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AmiLaunchPermission("example", AmiLaunchPermissionArgs.builder()
 *             .group("all")
 *             .imageId("ami-12345678")
 *             .build());
 *     }
 * }
 * ```
 * ### Organization Access
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.OrganizationsFunctions;
 * import com.pulumi.aws.ec2.AmiLaunchPermission;
 * import com.pulumi.aws.ec2.AmiLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = OrganizationsFunctions.getOrganization();
 *         var example = new AmiLaunchPermission("example", AmiLaunchPermissionArgs.builder()
 *             .imageId("ami-12345678")
 *             .organizationArn(current.applyValue(getOrganizationResult -> getOrganizationResult.arn()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AMI Launch Permissions using `[ACCOUNT-ID|GROUP-NAME|ORGANIZATION-ARN|ORGANIZATIONAL-UNIT-ARN]/IMAGE-ID`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/amiLaunchPermission:AmiLaunchPermission example 123456789012/ami-12345678
 * ```
 *
 */
public class AmiLaunchPermission internal constructor(
    override val javaResource: com.pulumi.aws.ec2.AmiLaunchPermission,
) : KotlinCustomResource(javaResource, AmiLaunchPermissionMapper) {
    /**
     * AWS account ID for the launch permission.
     */
    public val accountId: Output<String>?
        get() = javaResource.accountId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the group for the launch permission. Valid values: `"all"`.
     */
    public val group: Output<String>?
        get() = javaResource.group().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ID of the AMI.
     */
    public val imageId: Output<String>
        get() = javaResource.imageId().applyValue({ args0 -> args0 })

    /**
     * ARN of an organization for the launch permission.
     */
    public val organizationArn: Output<String>?
        get() = javaResource.organizationArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of an organizational unit for the launch permission.
     */
    public val organizationalUnitArn: Output<String>?
        get() = javaResource.organizationalUnitArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AmiLaunchPermissionMapper : ResourceMapper<AmiLaunchPermission> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.AmiLaunchPermission::class == javaResource::class

    override fun map(javaResource: Resource): AmiLaunchPermission = AmiLaunchPermission(
        javaResource
            as com.pulumi.aws.ec2.AmiLaunchPermission,
    )
}

/**
 * @see [AmiLaunchPermission].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AmiLaunchPermission].
 */
public suspend fun amiLaunchPermission(
    name: String,
    block: suspend AmiLaunchPermissionResourceBuilder.() -> Unit,
): AmiLaunchPermission {
    val builder = AmiLaunchPermissionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AmiLaunchPermission].
 * @param name The _unique_ name of the resulting resource.
 */
public fun amiLaunchPermission(name: String): AmiLaunchPermission {
    val builder = AmiLaunchPermissionResourceBuilder()
    builder.name(name)
    return builder.build()
}
