@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.AmiLaunchPermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Adds a launch permission to an Amazon Machine Image (AMI).
 * ## Example Usage
 * ### AWS Account ID
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AmiLaunchPermission;
 * import com.pulumi.aws.ec2.AmiLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AmiLaunchPermission("example", AmiLaunchPermissionArgs.builder()
 *             .accountId("123456789012")
 *             .imageId("ami-12345678")
 *             .build());
 *     }
 * }
 * ```
 * ### Public Access
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AmiLaunchPermission;
 * import com.pulumi.aws.ec2.AmiLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AmiLaunchPermission("example", AmiLaunchPermissionArgs.builder()
 *             .group("all")
 *             .imageId("ami-12345678")
 *             .build());
 *     }
 * }
 * ```
 * ### Organization Access
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.OrganizationsFunctions;
 * import com.pulumi.aws.ec2.AmiLaunchPermission;
 * import com.pulumi.aws.ec2.AmiLaunchPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = OrganizationsFunctions.getOrganization();
 *         var example = new AmiLaunchPermission("example", AmiLaunchPermissionArgs.builder()
 *             .imageId("ami-12345678")
 *             .organizationArn(current.applyValue(getOrganizationResult -> getOrganizationResult.arn()))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import AMI Launch Permissions using `[ACCOUNT-ID|GROUP-NAME|ORGANIZATION-ARN|ORGANIZATIONAL-UNIT-ARN]/IMAGE-ID`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/amiLaunchPermission:AmiLaunchPermission example 123456789012/ami-12345678
 * ```
 * @property accountId AWS account ID for the launch permission.
 * @property group Name of the group for the launch permission. Valid values: `"all"`.
 * @property imageId ID of the AMI.
 * @property organizationArn ARN of an organization for the launch permission.
 * @property organizationalUnitArn ARN of an organizational unit for the launch permission.
 */
public data class AmiLaunchPermissionArgs(
    public val accountId: Output<String>? = null,
    public val group: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val organizationArn: Output<String>? = null,
    public val organizationalUnitArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.AmiLaunchPermissionArgs> {
    override fun toJava(): com.pulumi.aws.ec2.AmiLaunchPermissionArgs =
        com.pulumi.aws.ec2.AmiLaunchPermissionArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .group(group?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .organizationArn(organizationArn?.applyValue({ args0 -> args0 }))
            .organizationalUnitArn(organizationalUnitArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmiLaunchPermissionArgs].
 */
@PulumiTagMarker
public class AmiLaunchPermissionArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var group: Output<String>? = null

    private var imageId: Output<String>? = null

    private var organizationArn: Output<String>? = null

    private var organizationalUnitArn: Output<String>? = null

    /**
     * @param value AWS account ID for the launch permission.
     */
    @JvmName("rpumkrktsmefxmhx")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value Name of the group for the launch permission. Valid values: `"all"`.
     */
    @JvmName("mptouaktsxqjoxvm")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value ID of the AMI.
     */
    @JvmName("nqqthxxulrvbfjix")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value ARN of an organization for the launch permission.
     */
    @JvmName("sytiahehckjiixpr")
    public suspend fun organizationArn(`value`: Output<String>) {
        this.organizationArn = value
    }

    /**
     * @param value ARN of an organizational unit for the launch permission.
     */
    @JvmName("qbugmhmfrxduabac")
    public suspend fun organizationalUnitArn(`value`: Output<String>) {
        this.organizationalUnitArn = value
    }

    /**
     * @param value AWS account ID for the launch permission.
     */
    @JvmName("yerrhbvreitltikh")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value Name of the group for the launch permission. Valid values: `"all"`.
     */
    @JvmName("lrbwhaulrlwpvcfe")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value ID of the AMI.
     */
    @JvmName("wcxvlvkvdtijxvgo")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value ARN of an organization for the launch permission.
     */
    @JvmName("laggnvehubobfxry")
    public suspend fun organizationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationArn = mapped
    }

    /**
     * @param value ARN of an organizational unit for the launch permission.
     */
    @JvmName("mcjfewfecsqmskie")
    public suspend fun organizationalUnitArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalUnitArn = mapped
    }

    internal fun build(): AmiLaunchPermissionArgs = AmiLaunchPermissionArgs(
        accountId = accountId,
        group = group,
        imageId = imageId,
        organizationArn = organizationArn,
        organizationalUnitArn = organizationalUnitArn,
    )
}
