@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AvailabilityZoneGroup].
 */
@PulumiTagMarker
public class AvailabilityZoneGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AvailabilityZoneGroupArgs = AvailabilityZoneGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AvailabilityZoneGroupArgsBuilder.() -> Unit) {
        val builder = AvailabilityZoneGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AvailabilityZoneGroup {
        val builtJavaResource = com.pulumi.aws.ec2.AvailabilityZoneGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AvailabilityZoneGroup(builtJavaResource)
    }
}

/**
 * Manages an EC2 Availability Zone Group, such as updating its opt-in status.
 * > **NOTE:** This is an advanced resource. The provider will automatically assume management of the EC2 Availability Zone Group without import and perform no actions on removal from configuration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.AvailabilityZoneGroup;
 * import com.pulumi.aws.ec2.AvailabilityZoneGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AvailabilityZoneGroup("example", AvailabilityZoneGroupArgs.builder()
 *             .groupName("us-west-2-lax-1")
 *             .optInStatus("opted-in")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EC2 Availability Zone Groups using the group name. For example:
 * ```sh
 *  $ pulumi import aws:ec2/availabilityZoneGroup:AvailabilityZoneGroup example us-west-2-lax-1
 * ```
 *
 */
public class AvailabilityZoneGroup internal constructor(
    override val javaResource: com.pulumi.aws.ec2.AvailabilityZoneGroup,
) : KotlinCustomResource(javaResource, AvailabilityZoneGroupMapper) {
    /**
     * Name of the Availability Zone Group.
     */
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })

    /**
     * Indicates whether to enable or disable Availability Zone Group. Valid values: `opted-in` or `not-opted-in`.
     */
    public val optInStatus: Output<String>
        get() = javaResource.optInStatus().applyValue({ args0 -> args0 })
}

public object AvailabilityZoneGroupMapper : ResourceMapper<AvailabilityZoneGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.AvailabilityZoneGroup::class == javaResource::class

    override fun map(javaResource: Resource): AvailabilityZoneGroup =
        AvailabilityZoneGroup(javaResource as com.pulumi.aws.ec2.AvailabilityZoneGroup)
}

/**
 * @see [AvailabilityZoneGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AvailabilityZoneGroup].
 */
public suspend fun availabilityZoneGroup(
    name: String,
    block: suspend AvailabilityZoneGroupResourceBuilder.() -> Unit,
): AvailabilityZoneGroup {
    val builder = AvailabilityZoneGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AvailabilityZoneGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun availabilityZoneGroup(name: String): AvailabilityZoneGroup {
    val builder = AvailabilityZoneGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
