@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [CapacityReservation].
 */
@PulumiTagMarker
public class CapacityReservationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CapacityReservationArgs = CapacityReservationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CapacityReservationArgsBuilder.() -> Unit) {
        val builder = CapacityReservationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CapacityReservation {
        val builtJavaResource = com.pulumi.aws.ec2.CapacityReservation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CapacityReservation(builtJavaResource)
    }
}

/**
 * Provides an EC2 Capacity Reservation. This allows you to reserve capacity for your Amazon EC2 instances in a specific Availability Zone for any duration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.CapacityReservation;
 * import com.pulumi.aws.ec2.CapacityReservationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new CapacityReservation("default", CapacityReservationArgs.builder()
 *             .availabilityZone("eu-west-1a")
 *             .instanceCount(1)
 *             .instancePlatform("Linux/UNIX")
 *             .instanceType("t2.micro")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Capacity Reservations using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/capacityReservation:CapacityReservation web cr-0123456789abcdef0
 * ```
 *
 */
public class CapacityReservation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.CapacityReservation,
) : KotlinCustomResource(javaResource, CapacityReservationMapper) {
    /**
     * The ARN of the Capacity Reservation.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Availability Zone in which to create the Capacity Reservation.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the Capacity Reservation supports EBS-optimized instances.
     */
    public val ebsOptimized: Output<Boolean>?
        get() = javaResource.ebsOptimized().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    public val endDate: Output<String>?
        get() = javaResource.endDate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates the way in which the Capacity Reservation ends. Specify either `unlimited` or `limited`.
     */
    public val endDateType: Output<String>?
        get() = javaResource.endDateType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
     */
    public val ephemeralStorage: Output<Boolean>?
        get() = javaResource.ephemeralStorage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of instances for which to reserve capacity.
     */
    public val instanceCount: Output<Int>
        get() = javaResource.instanceCount().applyValue({ args0 -> args0 })

    /**
     * Indicates the type of instance launches that the Capacity Reservation accepts. Specify either `open` or `targeted`.
     */
    public val instanceMatchCriteria: Output<String>?
        get() = javaResource.instanceMatchCriteria().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of operating system for which to reserve capacity. Valid options are `Linux/UNIX`, `Red Hat Enterprise Linux`, `SUSE Linux`, `Windows`, `Windows with SQL Server`, `Windows with SQL Server Enterprise`, `Windows with SQL Server Standard` or `Windows with SQL Server Web`.
     */
    public val instancePlatform: Output<String>
        get() = javaResource.instancePlatform().applyValue({ args0 -> args0 })

    /**
     * The instance type for which to reserve capacity.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
     */
    public val outpostArn: Output<String>?
        get() = javaResource.outpostArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the AWS account that owns the Capacity Reservation.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation.
     */
    public val placementGroupArn: Output<String>?
        get() = javaResource.placementGroupArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Indicates the tenancy of the Capacity Reservation. Specify either `default` or `dedicated`.
     */
    public val tenancy: Output<String>?
        get() = javaResource.tenancy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object CapacityReservationMapper : ResourceMapper<CapacityReservation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.CapacityReservation::class == javaResource::class

    override fun map(javaResource: Resource): CapacityReservation = CapacityReservation(
        javaResource
            as com.pulumi.aws.ec2.CapacityReservation,
    )
}

/**
 * @see [CapacityReservation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CapacityReservation].
 */
public suspend fun capacityReservation(
    name: String,
    block: suspend CapacityReservationResourceBuilder.() -> Unit,
): CapacityReservation {
    val builder = CapacityReservationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CapacityReservation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun capacityReservation(name: String): CapacityReservation {
    val builder = CapacityReservationResourceBuilder()
    builder.name(name)
    return builder.build()
}
