@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.CapacityReservationArgs.builder
import com.pulumi.aws.ec2.kotlin.enums.InstancePlatform
import com.pulumi.aws.ec2.kotlin.enums.InstanceType
import com.pulumi.aws.ec2.kotlin.enums.Tenancy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EC2 Capacity Reservation. This allows you to reserve capacity for your Amazon EC2 instances in a specific Availability Zone for any duration.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.CapacityReservation;
 * import com.pulumi.aws.ec2.CapacityReservationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new CapacityReservation("default", CapacityReservationArgs.builder()
 *             .availabilityZone("eu-west-1a")
 *             .instanceCount(1)
 *             .instancePlatform("Linux/UNIX")
 *             .instanceType("t2.micro")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Capacity Reservations using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/capacityReservation:CapacityReservation web cr-0123456789abcdef0
 * ```
 * @property availabilityZone The Availability Zone in which to create the Capacity Reservation.
 * @property ebsOptimized Indicates whether the Capacity Reservation supports EBS-optimized instances.
 * @property endDate The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
 * @property endDateType Indicates the way in which the Capacity Reservation ends. Specify either `unlimited` or `limited`.
 * @property ephemeralStorage Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
 * @property instanceCount The number of instances for which to reserve capacity.
 * @property instanceMatchCriteria Indicates the type of instance launches that the Capacity Reservation accepts. Specify either `open` or `targeted`.
 * @property instancePlatform The type of operating system for which to reserve capacity. Valid options are `Linux/UNIX`, `Red Hat Enterprise Linux`, `SUSE Linux`, `Windows`, `Windows with SQL Server`, `Windows with SQL Server Enterprise`, `Windows with SQL Server Standard` or `Windows with SQL Server Web`.
 * @property instanceType The instance type for which to reserve capacity.
 * @property outpostArn The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
 * @property placementGroupArn The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tenancy Indicates the tenancy of the Capacity Reservation. Specify either `default` or `dedicated`.
 */
public data class CapacityReservationArgs(
    public val availabilityZone: Output<String>? = null,
    public val ebsOptimized: Output<Boolean>? = null,
    public val endDate: Output<String>? = null,
    public val endDateType: Output<String>? = null,
    public val ephemeralStorage: Output<Boolean>? = null,
    public val instanceCount: Output<Int>? = null,
    public val instanceMatchCriteria: Output<String>? = null,
    public val instancePlatform: Output<Either<String, InstancePlatform>>? = null,
    public val instanceType: Output<Either<String, InstanceType>>? = null,
    public val outpostArn: Output<String>? = null,
    public val placementGroupArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tenancy: Output<Either<String, Tenancy>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.CapacityReservationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.CapacityReservationArgs =
        com.pulumi.aws.ec2.CapacityReservationArgs.builder()
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .ebsOptimized(ebsOptimized?.applyValue({ args0 -> args0 }))
            .endDate(endDate?.applyValue({ args0 -> args0 }))
            .endDateType(endDateType?.applyValue({ args0 -> args0 }))
            .ephemeralStorage(ephemeralStorage?.applyValue({ args0 -> args0 }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .instanceMatchCriteria(instanceMatchCriteria?.applyValue({ args0 -> args0 }))
            .instancePlatform(
                instancePlatform?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .instanceType(
                instanceType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .outpostArn(outpostArn?.applyValue({ args0 -> args0 }))
            .placementGroupArn(placementGroupArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tenancy(
                tenancy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [CapacityReservationArgs].
 */
@PulumiTagMarker
public class CapacityReservationArgsBuilder internal constructor() {
    private var availabilityZone: Output<String>? = null

    private var ebsOptimized: Output<Boolean>? = null

    private var endDate: Output<String>? = null

    private var endDateType: Output<String>? = null

    private var ephemeralStorage: Output<Boolean>? = null

    private var instanceCount: Output<Int>? = null

    private var instanceMatchCriteria: Output<String>? = null

    private var instancePlatform: Output<Either<String, InstancePlatform>>? = null

    private var instanceType: Output<Either<String, InstanceType>>? = null

    private var outpostArn: Output<String>? = null

    private var placementGroupArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tenancy: Output<Either<String, Tenancy>>? = null

    /**
     * @param value The Availability Zone in which to create the Capacity Reservation.
     */
    @JvmName("hmngrcpdjawsgmgn")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value Indicates whether the Capacity Reservation supports EBS-optimized instances.
     */
    @JvmName("rkiyjcllkunifqoi")
    public suspend fun ebsOptimized(`value`: Output<Boolean>) {
        this.ebsOptimized = value
    }

    /**
     * @param value The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    @JvmName("ybegndjkxumcttcj")
    public suspend fun endDate(`value`: Output<String>) {
        this.endDate = value
    }

    /**
     * @param value Indicates the way in which the Capacity Reservation ends. Specify either `unlimited` or `limited`.
     */
    @JvmName("rshltxacppodvreu")
    public suspend fun endDateType(`value`: Output<String>) {
        this.endDateType = value
    }

    /**
     * @param value Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
     */
    @JvmName("maqdckwndwamkpir")
    public suspend fun ephemeralStorage(`value`: Output<Boolean>) {
        this.ephemeralStorage = value
    }

    /**
     * @param value The number of instances for which to reserve capacity.
     */
    @JvmName("awasdadnplxwuruu")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value Indicates the type of instance launches that the Capacity Reservation accepts. Specify either `open` or `targeted`.
     */
    @JvmName("unpolhawjqsreyyp")
    public suspend fun instanceMatchCriteria(`value`: Output<String>) {
        this.instanceMatchCriteria = value
    }

    /**
     * @param value The type of operating system for which to reserve capacity. Valid options are `Linux/UNIX`, `Red Hat Enterprise Linux`, `SUSE Linux`, `Windows`, `Windows with SQL Server`, `Windows with SQL Server Enterprise`, `Windows with SQL Server Standard` or `Windows with SQL Server Web`.
     */
    @JvmName("pgxbcwgddudjtvoo")
    public suspend fun instancePlatform(`value`: Output<Either<String, InstancePlatform>>) {
        this.instancePlatform = value
    }

    /**
     * @param value The instance type for which to reserve capacity.
     */
    @JvmName("vgeowpkkmbkhbovh")
    public suspend fun instanceType(`value`: Output<Either<String, InstanceType>>) {
        this.instanceType = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
     */
    @JvmName("llhcyuxvwcvrpcgi")
    public suspend fun outpostArn(`value`: Output<String>) {
        this.outpostArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation.
     */
    @JvmName("ywfxmugcrgaymlnk")
    public suspend fun placementGroupArn(`value`: Output<String>) {
        this.placementGroupArn = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rsgvkehmpeovyjwr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Indicates the tenancy of the Capacity Reservation. Specify either `default` or `dedicated`.
     */
    @JvmName("ydwqktreochbsape")
    public suspend fun tenancy(`value`: Output<Either<String, Tenancy>>) {
        this.tenancy = value
    }

    /**
     * @param value The Availability Zone in which to create the Capacity Reservation.
     */
    @JvmName("kwwpkdwehoihibqe")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value Indicates whether the Capacity Reservation supports EBS-optimized instances.
     */
    @JvmName("uwpyyygvbksnkvsr")
    public suspend fun ebsOptimized(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsOptimized = mapped
    }

    /**
     * @param value The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. Valid values: [RFC3339 time string](https://tools.ietf.org/html/rfc3339#section-5.8) (`YYYY-MM-DDTHH:MM:SSZ`)
     */
    @JvmName("hvmelwtxeugpdqas")
    public suspend fun endDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDate = mapped
    }

    /**
     * @param value Indicates the way in which the Capacity Reservation ends. Specify either `unlimited` or `limited`.
     */
    @JvmName("tfslqjfdllvmepdo")
    public suspend fun endDateType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDateType = mapped
    }

    /**
     * @param value Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
     */
    @JvmName("kkjfpcyeyeytgbhc")
    public suspend fun ephemeralStorage(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralStorage = mapped
    }

    /**
     * @param value The number of instances for which to reserve capacity.
     */
    @JvmName("duivksqnymotqqrm")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value Indicates the type of instance launches that the Capacity Reservation accepts. Specify either `open` or `targeted`.
     */
    @JvmName("dmxbphcbqnsxthms")
    public suspend fun instanceMatchCriteria(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceMatchCriteria = mapped
    }

    /**
     * @param value The type of operating system for which to reserve capacity. Valid options are `Linux/UNIX`, `Red Hat Enterprise Linux`, `SUSE Linux`, `Windows`, `Windows with SQL Server`, `Windows with SQL Server Enterprise`, `Windows with SQL Server Standard` or `Windows with SQL Server Web`.
     */
    @JvmName("nnhdscmqqqahphwo")
    public suspend fun instancePlatform(`value`: Either<String, InstancePlatform>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instancePlatform = mapped
    }

    /**
     * @param value The type of operating system for which to reserve capacity. Valid options are `Linux/UNIX`, `Red Hat Enterprise Linux`, `SUSE Linux`, `Windows`, `Windows with SQL Server`, `Windows with SQL Server Enterprise`, `Windows with SQL Server Standard` or `Windows with SQL Server Web`.
     */
    @JvmName("sqqyxpfwnxuupolw")
    public fun instancePlatform(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InstancePlatform>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instancePlatform = mapped
    }

    /**
     * @param value The type of operating system for which to reserve capacity. Valid options are `Linux/UNIX`, `Red Hat Enterprise Linux`, `SUSE Linux`, `Windows`, `Windows with SQL Server`, `Windows with SQL Server Enterprise`, `Windows with SQL Server Standard` or `Windows with SQL Server Web`.
     */
    @JvmName("yymmigwqhoioxend")
    public fun instancePlatform(`value`: InstancePlatform) {
        val toBeMapped = Either.ofRight<String, InstancePlatform>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instancePlatform = mapped
    }

    /**
     * @param value The instance type for which to reserve capacity.
     */
    @JvmName("qfaaafjpfrjfwadp")
    public suspend fun instanceType(`value`: Either<String, InstanceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The instance type for which to reserve capacity.
     */
    @JvmName("gyvsvvrqwejjtiht")
    public fun instanceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InstanceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The instance type for which to reserve capacity.
     */
    @JvmName("foueyibyqjpjavtm")
    public fun instanceType(`value`: InstanceType) {
        val toBeMapped = Either.ofRight<String, InstanceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
     */
    @JvmName("wctrehoqrxbcadyt")
    public suspend fun outpostArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outpostArn = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation.
     */
    @JvmName("ubwkavamndsnprlr")
    public suspend fun placementGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementGroupArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("akouyibheehffwpo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mljgdjnagmlgounc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Indicates the tenancy of the Capacity Reservation. Specify either `default` or `dedicated`.
     */
    @JvmName("bsecrkthsyurhoio")
    public suspend fun tenancy(`value`: Either<String, Tenancy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenancy = mapped
    }

    /**
     * @param value Indicates the tenancy of the Capacity Reservation. Specify either `default` or `dedicated`.
     */
    @JvmName("ompqlacdrkofidww")
    public fun tenancy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Tenancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenancy = mapped
    }

    /**
     * @param value Indicates the tenancy of the Capacity Reservation. Specify either `default` or `dedicated`.
     */
    @JvmName("kgdrbmfacwhygngy")
    public fun tenancy(`value`: Tenancy) {
        val toBeMapped = Either.ofRight<String, Tenancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenancy = mapped
    }

    internal fun build(): CapacityReservationArgs = CapacityReservationArgs(
        availabilityZone = availabilityZone,
        ebsOptimized = ebsOptimized,
        endDate = endDate,
        endDateType = endDateType,
        ephemeralStorage = ephemeralStorage,
        instanceCount = instanceCount,
        instanceMatchCriteria = instanceMatchCriteria,
        instancePlatform = instancePlatform,
        instanceType = instanceType,
        outpostArn = outpostArn,
        placementGroupArn = placementGroupArn,
        tags = tags,
        tenancy = tenancy,
    )
}
