@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [CustomerGateway].
 */
@PulumiTagMarker
public class CustomerGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomerGatewayArgs = CustomerGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomerGatewayArgsBuilder.() -> Unit) {
        val builder = CustomerGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomerGateway {
        val builtJavaResource = com.pulumi.aws.ec2.CustomerGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CustomerGateway(builtJavaResource)
    }
}

/**
 * Provides a customer gateway inside a VPC. These objects can be connected to VPN gateways via VPN connections, and allow you to establish tunnels between your network and the VPC.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.CustomerGateway;
 * import com.pulumi.aws.ec2.CustomerGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var main = new CustomerGateway("main", CustomerGatewayArgs.builder()
 *             .bgpAsn(65000)
 *             .ipAddress("172.83.124.10")
 *             .tags(Map.of("Name", "main-customer-gateway"))
 *             .type("ipsec.1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Customer Gateways using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/customerGateway:CustomerGateway main cgw-b4dc3961
 * ```
 *
 */
public class CustomerGateway internal constructor(
    override val javaResource: com.pulumi.aws.ec2.CustomerGateway,
) : KotlinCustomResource(javaResource, CustomerGatewayMapper) {
    /**
     * The ARN of the customer gateway.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
     */
    public val bgpAsn: Output<String>
        get() = javaResource.bgpAsn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for the customer gateway certificate.
     */
    public val certificateArn: Output<String>?
        get() = javaResource.certificateArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A name for the customer gateway device.
     */
    public val deviceName: Output<String>?
        get() = javaResource.deviceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IPv4 address for the customer gateway device's outside interface.
     */
    public val ipAddress: Output<String>?
        get() = javaResource.ipAddress().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Tags to apply to the gateway. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of customer gateway. The only type AWS
     * supports at this time is "ipsec.1".
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CustomerGatewayMapper : ResourceMapper<CustomerGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.CustomerGateway::class == javaResource::class

    override fun map(javaResource: Resource): CustomerGateway = CustomerGateway(
        javaResource as
            com.pulumi.aws.ec2.CustomerGateway,
    )
}

/**
 * @see [CustomerGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomerGateway].
 */
public suspend fun customerGateway(
    name: String,
    block: suspend CustomerGatewayResourceBuilder.() -> Unit,
): CustomerGateway {
    val builder = CustomerGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomerGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customerGateway(name: String): CustomerGateway {
    val builder = CustomerGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
