@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DedicatedHost].
 */
@PulumiTagMarker
public class DedicatedHostResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DedicatedHostArgs = DedicatedHostArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DedicatedHostArgsBuilder.() -> Unit) {
        val builder = DedicatedHostArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DedicatedHost {
        val builtJavaResource = com.pulumi.aws.ec2.DedicatedHost(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DedicatedHost(builtJavaResource)
    }
}

/**
 * Provides an EC2 Host resource. This allows Dedicated Hosts to be allocated, modified, and released.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DedicatedHost;
 * import com.pulumi.aws.ec2.DedicatedHostArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new DedicatedHost("test", DedicatedHostArgs.builder()
 *             .autoPlacement("on")
 *             .availabilityZone("us-west-2a")
 *             .hostRecovery("on")
 *             .instanceType("c5.18xlarge")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import hosts using the host `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/dedicatedHost:DedicatedHost example h-0385a99d0e4b20cbb
 * ```
 *
 */
public class DedicatedHost internal constructor(
    override val javaResource: com.pulumi.aws.ec2.DedicatedHost,
) : KotlinCustomResource(javaResource, DedicatedHostMapper) {
    /**
     * The ARN of the Dedicated Host.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID of the Outpost hardware asset on which to allocate the Dedicated Hosts. This parameter is supported only if you specify OutpostArn. If you are allocating the Dedicated Hosts in a Region, omit this parameter.
     */
    public val assetId: Output<String>
        get() = javaResource.assetId().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the host accepts any untargeted instance launches that match its instance type configuration, or if it only accepts Host tenancy instance launches that specify its unique host ID. Valid values: `on`, `off`. Default: `on`.
     */
    public val autoPlacement: Output<String>?
        get() = javaResource.autoPlacement().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Availability Zone in which to allocate the Dedicated Host.
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * Indicates whether to enable or disable host recovery for the Dedicated Host. Valid values: `on`, `off`. Default: `off`.
     */
    public val hostRecovery: Output<String>?
        get() = javaResource.hostRecovery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the instance family to be supported by the Dedicated Hosts. If you specify an instance family, the Dedicated Hosts support multiple instance types within that instance family. Exactly one of `instance_family` or `instance_type` must be specified.
     */
    public val instanceFamily: Output<String>?
        get() = javaResource.instanceFamily().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the instance type to be supported by the Dedicated Hosts. If you specify an instance type, the Dedicated Hosts support instances of the specified instance type only. Exactly one of `instance_family` or `instance_type` must be specified.
     */
    public val instanceType: Output<String>?
        get() = javaResource.instanceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the AWS Outpost on which to allocate the Dedicated Host.
     */
    public val outpostArn: Output<String>?
        get() = javaResource.outpostArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the AWS account that owns the Dedicated Host.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DedicatedHostMapper : ResourceMapper<DedicatedHost> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.DedicatedHost::class == javaResource::class

    override fun map(javaResource: Resource): DedicatedHost = DedicatedHost(
        javaResource as
            com.pulumi.aws.ec2.DedicatedHost,
    )
}

/**
 * @see [DedicatedHost].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DedicatedHost].
 */
public suspend fun dedicatedHost(
    name: String,
    block: suspend DedicatedHostResourceBuilder.() -> Unit,
): DedicatedHost {
    val builder = DedicatedHostResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DedicatedHost].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dedicatedHost(name: String): DedicatedHost {
    val builder = DedicatedHostResourceBuilder()
    builder.name(name)
    return builder.build()
}
