@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.DefaultNetworkAclEgress
import com.pulumi.aws.ec2.kotlin.outputs.DefaultNetworkAclIngress
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.DefaultNetworkAclEgress.Companion.toKotlin as defaultNetworkAclEgressToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.DefaultNetworkAclIngress.Companion.toKotlin as defaultNetworkAclIngressToKotlin

/**
 * Builder for [DefaultNetworkAcl].
 */
@PulumiTagMarker
public class DefaultNetworkAclResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefaultNetworkAclArgs = DefaultNetworkAclArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefaultNetworkAclArgsBuilder.() -> Unit) {
        val builder = DefaultNetworkAclArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DefaultNetworkAcl {
        val builtJavaResource = com.pulumi.aws.ec2.DefaultNetworkAcl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DefaultNetworkAcl(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a VPC's default network ACL. This resource can manage the default network ACL of the default or a non-default VPC.
 * > **NOTE:** This is an advanced resource with special caveats. Please read this document in its entirety before using this resource. The `aws.ec2.DefaultNetworkAcl` behaves differently from normal resources. This provider does not _create_ this resource but instead attempts to "adopt" it into management.
 * Every VPC has a default network ACL that can be managed but not destroyed. When the provider first adopts the Default Network ACL, it **immediately removes all rules in the ACL**. It then proceeds to create any rules specified in the configuration. This step is required so that only the rules specified in the configuration are created.
 * This resource treats its inline rules as absolute; only the rules defined inline are created, and any additions/removals external to this resource will result in diffs being shown. For these reasons, this resource is incompatible with the `aws.ec2.NetworkAclRule` resource.
 * For more information about Network ACLs, see the AWS Documentation on [Network ACLs][aws-network-acls].
 * ## Example Usage
 * ### Basic Example
 * The following config gives the Default Network ACL the same rules that AWS includes but pulls the resource under management by this provider. This means that any ACL rules added or changed will be detected as drift.
 * No Java example available.
 * ### Example: Deny All Egress Traffic, Allow Ingress
 * The following denies all Egress traffic by omitting any `egress` rules, while including the default `ingress` rule to allow all traffic.
 * No Java example available.
 * ### Example: Deny All Traffic To Any Subnet In The Default Network ACL
 * This config denies all traffic in the Default ACL. This can be useful if you want to lock down the VPC to force all resources to assign a non-default ACL.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.DefaultNetworkAcl;
 * import com.pulumi.aws.ec2.DefaultNetworkAclArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mainvpc = new Vpc("mainvpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .build());
 *         var default_ = new DefaultNetworkAcl("default", DefaultNetworkAclArgs.builder()
 *             .defaultNetworkAclId(mainvpc.defaultNetworkAclId())
 *             .build());
 *     }
 * }
 * ```
 * ### Managing Subnets In A Default Network ACL
 * Within a VPC, all Subnets must be associated with a Network ACL. In order to "delete" the association between a Subnet and a non-default Network ACL, the association is destroyed by replacing it with an association between the Subnet and the Default ACL instead.
 * When managing the Default Network ACL, you cannot "remove" Subnets. Instead, they must be reassigned to another Network ACL, or the Subnet itself must be destroyed. Because of these requirements, removing the `subnet_ids` attribute from the configuration of a `aws.ec2.DefaultNetworkAcl` resource may result in a reoccurring plan, until the Subnets are reassigned to another Network ACL or are destroyed.
 * Because Subnets are by default associated with the Default Network ACL, any non-explicit association will show up as a plan to remove the Subnet. For example: if you have a custom `aws.ec2.NetworkAcl` with two subnets attached, and you remove the `aws.ec2.NetworkAcl` resource, after successfully destroying this resource future plans will show a diff on the managed `aws.ec2.DefaultNetworkAcl`, as those two Subnets have been orphaned by the now destroyed network acl and thus adopted by the Default Network ACL. In order to avoid a reoccurring plan, they will need to be reassigned, destroyed, or added to the `subnet_ids` attribute of the `aws.ec2.DefaultNetworkAcl` entry.
 * As an alternative to the above, you can also specify the following lifecycle configuration in your `aws.ec2.DefaultNetworkAcl` resource:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultNetworkAcl;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new DefaultNetworkAcl("default");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Default Network ACLs using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/defaultNetworkAcl:DefaultNetworkAcl sample acl-7aaabd18
 * ```
 *
 */
public class DefaultNetworkAcl internal constructor(
    override val javaResource: com.pulumi.aws.ec2.DefaultNetworkAcl,
) : KotlinCustomResource(javaResource, DefaultNetworkAclMapper) {
    /**
     * ARN of the Default Network ACL
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Network ACL ID to manage. This attribute is exported from `aws.ec2.Vpc`, or manually found via the AWS Console.
     * The following arguments are optional:
     */
    public val defaultNetworkAclId: Output<String>
        get() = javaResource.defaultNetworkAclId().applyValue({ args0 -> args0 })

    /**
     * Configuration block for an egress rule. Detailed below.
     */
    public val egress: Output<List<DefaultNetworkAclEgress>>?
        get() = javaResource.egress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> defaultNetworkAclEgressToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Configuration block for an ingress rule. Detailed below.
     */
    public val ingress: Output<List<DefaultNetworkAclIngress>>?
        get() = javaResource.ingress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> defaultNetworkAclIngressToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * ID of the AWS account that owns the Default Network ACL
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * List of Subnet IDs to apply the ACL to. See the notes above on Managing Subnets in the Default Network ACL
     */
    public val subnetIds: Output<List<String>>?
        get() = javaResource.subnetIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * ID of the associated VPC
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object DefaultNetworkAclMapper : ResourceMapper<DefaultNetworkAcl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.DefaultNetworkAcl::class == javaResource::class

    override fun map(javaResource: Resource): DefaultNetworkAcl = DefaultNetworkAcl(
        javaResource as
            com.pulumi.aws.ec2.DefaultNetworkAcl,
    )
}

/**
 * @see [DefaultNetworkAcl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefaultNetworkAcl].
 */
public suspend fun defaultNetworkAcl(
    name: String,
    block: suspend DefaultNetworkAclResourceBuilder.() -> Unit,
): DefaultNetworkAcl {
    val builder = DefaultNetworkAclResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefaultNetworkAcl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defaultNetworkAcl(name: String): DefaultNetworkAcl {
    val builder = DefaultNetworkAclResourceBuilder()
    builder.name(name)
    return builder.build()
}
