@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.DefaultSecurityGroupEgress
import com.pulumi.aws.ec2.kotlin.outputs.DefaultSecurityGroupIngress
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.DefaultSecurityGroupEgress.Companion.toKotlin as defaultSecurityGroupEgressToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.DefaultSecurityGroupIngress.Companion.toKotlin as defaultSecurityGroupIngressToKotlin

/**
 * Builder for [DefaultSecurityGroup].
 */
@PulumiTagMarker
public class DefaultSecurityGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefaultSecurityGroupArgs = DefaultSecurityGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefaultSecurityGroupArgsBuilder.() -> Unit) {
        val builder = DefaultSecurityGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DefaultSecurityGroup {
        val builtJavaResource = com.pulumi.aws.ec2.DefaultSecurityGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DefaultSecurityGroup(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a default security group. This resource can manage the default security group of the default or a non-default VPC.
 * > **NOTE:** This is an advanced resource with special caveats. Please read this document in its entirety before using this resource. The `aws.ec2.DefaultSecurityGroup` resource behaves differently from normal resources. This provider does not _create_ this resource but instead attempts to "adopt" it into management.
 * When the provider first begins managing the default security group, it **immediately removes all ingress and egress rules in the Security Group**. It then creates any rules specified in the configuration. This way only the rules specified in the configuration are created.
 * This resource treats its inline rules as absolute; only the rules defined inline are created, and any additions/removals external to this resource will result in diff shown. For these reasons, this resource is incompatible with the `aws.ec2.SecurityGroupRule` resource.
 * For more information about default security groups, see the AWS documentation on [Default Security Groups][aws-default-security-groups]. To manage normal security groups, see the `aws.ec2.SecurityGroup` resource.
 * ## Example Usage
 * The following config gives the default security group the same rules that AWS provides by default but under management by this provider. This means that any ingress or egress rules added or changed will be detected as drift.
 * No Java example available.
 * ### Example Config To Deny All Egress Traffic, Allowing Ingress
 * The following denies all Egress traffic by omitting any `egress` rules, while including the default `ingress` rule to allow all traffic.
 * No Java example available.
 * ## Import
 * Using `pulumi import`, import Security Groups using the security group `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/defaultSecurityGroup:DefaultSecurityGroup default_sg sg-903004f8
 * ```
 *
 */
public class DefaultSecurityGroup internal constructor(
    override val javaResource: com.pulumi.aws.ec2.DefaultSecurityGroup,
) : KotlinCustomResource(javaResource, DefaultSecurityGroupMapper) {
    /**
     * ARN of the security group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of this rule.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Configuration block. Detailed below.
     */
    public val egress: Output<List<DefaultSecurityGroupEgress>>
        get() = javaResource.egress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    defaultSecurityGroupEgressToKotlin(args0)
                })
            })
        })

    /**
     * Configuration block. Detailed below.
     */
    public val ingress: Output<List<DefaultSecurityGroupIngress>>
        get() = javaResource.ingress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    defaultSecurityGroupIngressToKotlin(args0)
                })
            })
        })

    /**
     * Name of the security group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Owner ID.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    public val revokeRulesOnDelete: Output<Boolean>?
        get() = javaResource.revokeRulesOnDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * VPC ID. **Note that changing the `vpc_id` will _not_ restore any default security group rules that were modified, added, or removed.** It will be left in its current state.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object DefaultSecurityGroupMapper : ResourceMapper<DefaultSecurityGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.DefaultSecurityGroup::class == javaResource::class

    override fun map(javaResource: Resource): DefaultSecurityGroup = DefaultSecurityGroup(
        javaResource
            as com.pulumi.aws.ec2.DefaultSecurityGroup,
    )
}

/**
 * @see [DefaultSecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefaultSecurityGroup].
 */
public suspend fun defaultSecurityGroup(
    name: String,
    block: suspend DefaultSecurityGroupResourceBuilder.() -> Unit,
): DefaultSecurityGroup {
    val builder = DefaultSecurityGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefaultSecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defaultSecurityGroup(name: String): DefaultSecurityGroup {
    val builder = DefaultSecurityGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
