@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.DefaultSecurityGroupArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.DefaultSecurityGroupEgressArgs
import com.pulumi.aws.ec2.kotlin.inputs.DefaultSecurityGroupEgressArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.DefaultSecurityGroupIngressArgs
import com.pulumi.aws.ec2.kotlin.inputs.DefaultSecurityGroupIngressArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a default security group. This resource can manage the default security group of the default or a non-default VPC.
 * > **NOTE:** This is an advanced resource with special caveats. Please read this document in its entirety before using this resource. The `aws.ec2.DefaultSecurityGroup` resource behaves differently from normal resources. This provider does not _create_ this resource but instead attempts to "adopt" it into management.
 * When the provider first begins managing the default security group, it **immediately removes all ingress and egress rules in the Security Group**. It then creates any rules specified in the configuration. This way only the rules specified in the configuration are created.
 * This resource treats its inline rules as absolute; only the rules defined inline are created, and any additions/removals external to this resource will result in diff shown. For these reasons, this resource is incompatible with the `aws.ec2.SecurityGroupRule` resource.
 * For more information about default security groups, see the AWS documentation on [Default Security Groups][aws-default-security-groups]. To manage normal security groups, see the `aws.ec2.SecurityGroup` resource.
 * ## Example Usage
 * The following config gives the default security group the same rules that AWS provides by default but under management by this provider. This means that any ingress or egress rules added or changed will be detected as drift.
 * No Java example available.
 * ### Example Config To Deny All Egress Traffic, Allowing Ingress
 * The following denies all Egress traffic by omitting any `egress` rules, while including the default `ingress` rule to allow all traffic.
 * No Java example available.
 * ## Import
 * Using `pulumi import`, import Security Groups using the security group `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/defaultSecurityGroup:DefaultSecurityGroup default_sg sg-903004f8
 * ```
 * @property egress Configuration block. Detailed below.
 * @property ingress Configuration block. Detailed below.
 * @property revokeRulesOnDelete
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcId VPC ID. **Note that changing the `vpc_id` will _not_ restore any default security group rules that were modified, added, or removed.** It will be left in its current state.
 */
public data class DefaultSecurityGroupArgs(
    public val egress: Output<List<DefaultSecurityGroupEgressArgs>>? = null,
    public val ingress: Output<List<DefaultSecurityGroupIngressArgs>>? = null,
    public val revokeRulesOnDelete: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.DefaultSecurityGroupArgs> {
    override fun toJava(): com.pulumi.aws.ec2.DefaultSecurityGroupArgs =
        com.pulumi.aws.ec2.DefaultSecurityGroupArgs.builder()
            .egress(egress?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .ingress(
                ingress?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .revokeRulesOnDelete(revokeRulesOnDelete?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefaultSecurityGroupArgs].
 */
@PulumiTagMarker
public class DefaultSecurityGroupArgsBuilder internal constructor() {
    private var egress: Output<List<DefaultSecurityGroupEgressArgs>>? = null

    private var ingress: Output<List<DefaultSecurityGroupIngressArgs>>? = null

    private var revokeRulesOnDelete: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("wcvjjkqmpidrvyxn")
    public suspend fun egress(`value`: Output<List<DefaultSecurityGroupEgressArgs>>) {
        this.egress = value
    }

    @JvmName("fuwonwixaukhbyyi")
    public suspend fun egress(vararg values: Output<DefaultSecurityGroupEgressArgs>) {
        this.egress = Output.all(values.asList())
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("djkohsevfqpnomds")
    public suspend fun egress(values: List<Output<DefaultSecurityGroupEgressArgs>>) {
        this.egress = Output.all(values)
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("xgrdgraxrsyehuai")
    public suspend fun ingress(`value`: Output<List<DefaultSecurityGroupIngressArgs>>) {
        this.ingress = value
    }

    @JvmName("tarbiscqxbuwywio")
    public suspend fun ingress(vararg values: Output<DefaultSecurityGroupIngressArgs>) {
        this.ingress = Output.all(values.asList())
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("xocamibiseveoopw")
    public suspend fun ingress(values: List<Output<DefaultSecurityGroupIngressArgs>>) {
        this.ingress = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("idwmfvkoitvgvqwk")
    public suspend fun revokeRulesOnDelete(`value`: Output<Boolean>) {
        this.revokeRulesOnDelete = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xgpcmkpmivlqoade")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value VPC ID. **Note that changing the `vpc_id` will _not_ restore any default security group rules that were modified, added, or removed.** It will be left in its current state.
     */
    @JvmName("mbucrexymgnhirxq")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("eqfjajdkdyotntxn")
    public suspend fun egress(`value`: List<DefaultSecurityGroupEgressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.egress = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("xkiirhlbtqpqcoxi")
    public suspend
    fun egress(argument: List<suspend DefaultSecurityGroupEgressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DefaultSecurityGroupEgressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.egress = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("giaqrpfqirixusfj")
    public suspend fun egress(
        vararg
        argument: suspend DefaultSecurityGroupEgressArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DefaultSecurityGroupEgressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.egress = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("poyspruukqmcjehd")
    public suspend fun egress(argument: suspend DefaultSecurityGroupEgressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DefaultSecurityGroupEgressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.egress = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("wpivqmfodmfutjio")
    public suspend fun egress(vararg values: DefaultSecurityGroupEgressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.egress = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("njfuiymlnwagerse")
    public suspend fun ingress(`value`: List<DefaultSecurityGroupIngressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingress = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("krubbqauevuibakw")
    public suspend
    fun ingress(argument: List<suspend DefaultSecurityGroupIngressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DefaultSecurityGroupIngressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ingress = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("pluasnhbetwjxeyg")
    public suspend fun ingress(
        vararg
        argument: suspend DefaultSecurityGroupIngressArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DefaultSecurityGroupIngressArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ingress = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("yypypsmikxwxptew")
    public suspend fun ingress(argument: suspend DefaultSecurityGroupIngressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DefaultSecurityGroupIngressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ingress = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("tsgbqcyfcopnlkke")
    public suspend fun ingress(vararg values: DefaultSecurityGroupIngressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingress = mapped
    }

    /**
     * @param value
     */
    @JvmName("iwbbicwvvhbgxnqh")
    public suspend fun revokeRulesOnDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.revokeRulesOnDelete = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lbcqsdctiplkfikv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jktfnayaatpebmoy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value VPC ID. **Note that changing the `vpc_id` will _not_ restore any default security group rules that were modified, added, or removed.** It will be left in its current state.
     */
    @JvmName("lqdtdyvswsbcjtou")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): DefaultSecurityGroupArgs = DefaultSecurityGroupArgs(
        egress = egress,
        ingress = ingress,
        revokeRulesOnDelete = revokeRulesOnDelete,
        tags = tags,
        vpcId = vpcId,
    )
}
