@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DefaultSubnet].
 */
@PulumiTagMarker
public class DefaultSubnetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefaultSubnetArgs = DefaultSubnetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefaultSubnetArgsBuilder.() -> Unit) {
        val builder = DefaultSubnetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DefaultSubnet {
        val builtJavaResource = com.pulumi.aws.ec2.DefaultSubnet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DefaultSubnet(builtJavaResource)
    }
}

/**
 * Provides a resource to manage a [default subnet](http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/default-vpc.html#default-vpc-basics) in the current region.
 * **This is an advanced resource** and has special caveats to be aware of when using it. Please read this document in its entirety before using this resource.
 * The `aws.ec2.DefaultSubnet` resource behaves differently from normal resources in that if a default subnet exists in the specified Availability Zone, this provider does not _create_ this resource, but instead "adopts" it into management.
 * If no default subnet exists, this provider creates a new default subnet.
 * By default, `pulumi destroy` does not delete the default subnet but does remove the resource from the state.
 * Set the `force_destroy` argument to `true` to delete the default subnet.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultSubnet;
 * import com.pulumi.aws.ec2.DefaultSubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultAz1 = new DefaultSubnet("defaultAz1", DefaultSubnetArgs.builder()
 *             .availabilityZone("us-west-2a")
 *             .tags(Map.of("Name", "Default subnet for us-west-2a"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import subnets using the subnet `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/defaultSubnet:DefaultSubnet public_subnet subnet-9d4a7b6c
 * ```
 *
 */
public class DefaultSubnet internal constructor(
    override val javaResource: com.pulumi.aws.ec2.DefaultSubnet,
) : KotlinCustomResource(javaResource, DefaultSubnetMapper) {
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val assignIpv6AddressOnCreation: Output<Boolean>?
        get() = javaResource.assignIpv6AddressOnCreation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * is required
     * * The `availability_zone_id`, `cidr_block` and `vpc_id` arguments become computed attributes
     * * The default value for `map_public_ip_on_launch` is `true`
     * This resource supports the following additional arguments:
     */
    public val availabilityZone: Output<String>
        get() = javaResource.availabilityZone().applyValue({ args0 -> args0 })

    /**
     * The AZ ID of the subnet
     */
    public val availabilityZoneId: Output<String>
        get() = javaResource.availabilityZoneId().applyValue({ args0 -> args0 })

    /**
     * The IPv4 CIDR block assigned to the subnet
     */
    public val cidrBlock: Output<String>
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0 })

    public val customerOwnedIpv4Pool: Output<String>?
        get() = javaResource.customerOwnedIpv4Pool().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val enableDns64: Output<Boolean>?
        get() = javaResource.enableDns64().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val enableLniAtDeviceIndex: Output<Int>
        get() = javaResource.enableLniAtDeviceIndex().applyValue({ args0 -> args0 })

    public val enableResourceNameDnsARecordOnLaunch: Output<Boolean>?
        get() = javaResource.enableResourceNameDnsARecordOnLaunch().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    public val enableResourceNameDnsAaaaRecordOnLaunch: Output<Boolean>?
        get() = javaResource.enableResourceNameDnsAaaaRecordOnLaunch().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    public val existingDefaultSubnet: Output<Boolean>
        get() = javaResource.existingDefaultSubnet().applyValue({ args0 -> args0 })

    /**
     * Whether destroying the resource deletes the default subnet. Default: `false`
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val ipv6CidrBlock: Output<String>
        get() = javaResource.ipv6CidrBlock().applyValue({ args0 -> args0 })

    public val ipv6CidrBlockAssociationId: Output<String>
        get() = javaResource.ipv6CidrBlockAssociationId().applyValue({ args0 -> args0 })

    public val ipv6Native: Output<Boolean>?
        get() = javaResource.ipv6Native().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val mapCustomerOwnedIpOnLaunch: Output<Boolean>?
        get() = javaResource.mapCustomerOwnedIpOnLaunch().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val mapPublicIpOnLaunch: Output<Boolean>?
        get() = javaResource.mapPublicIpOnLaunch().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val outpostArn: Output<String>
        get() = javaResource.outpostArn().applyValue({ args0 -> args0 })

    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    public val privateDnsHostnameTypeOnLaunch: Output<String>
        get() = javaResource.privateDnsHostnameTypeOnLaunch().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the VPC the subnet is in
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object DefaultSubnetMapper : ResourceMapper<DefaultSubnet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.DefaultSubnet::class == javaResource::class

    override fun map(javaResource: Resource): DefaultSubnet = DefaultSubnet(
        javaResource as
            com.pulumi.aws.ec2.DefaultSubnet,
    )
}

/**
 * @see [DefaultSubnet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefaultSubnet].
 */
public suspend fun defaultSubnet(
    name: String,
    block: suspend DefaultSubnetResourceBuilder.() -> Unit,
): DefaultSubnet {
    val builder = DefaultSubnetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefaultSubnet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defaultSubnet(name: String): DefaultSubnet {
    val builder = DefaultSubnetResourceBuilder()
    builder.name(name)
    return builder.build()
}
