@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.DefaultSubnetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage a [default subnet](http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/default-vpc.html#default-vpc-basics) in the current region.
 * **This is an advanced resource** and has special caveats to be aware of when using it. Please read this document in its entirety before using this resource.
 * The `aws.ec2.DefaultSubnet` resource behaves differently from normal resources in that if a default subnet exists in the specified Availability Zone, this provider does not _create_ this resource, but instead "adopts" it into management.
 * If no default subnet exists, this provider creates a new default subnet.
 * By default, `pulumi destroy` does not delete the default subnet but does remove the resource from the state.
 * Set the `force_destroy` argument to `true` to delete the default subnet.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultSubnet;
 * import com.pulumi.aws.ec2.DefaultSubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultAz1 = new DefaultSubnet("defaultAz1", DefaultSubnetArgs.builder()
 *             .availabilityZone("us-west-2a")
 *             .tags(Map.of("Name", "Default subnet for us-west-2a"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import subnets using the subnet `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/defaultSubnet:DefaultSubnet public_subnet subnet-9d4a7b6c
 * ```
 * @property assignIpv6AddressOnCreation
 * @property availabilityZone is required
 * * The `availability_zone_id`, `cidr_block` and `vpc_id` arguments become computed attributes
 * * The default value for `map_public_ip_on_launch` is `true`
 * This resource supports the following additional arguments:
 * @property customerOwnedIpv4Pool
 * @property enableDns64
 * @property enableResourceNameDnsARecordOnLaunch
 * @property enableResourceNameDnsAaaaRecordOnLaunch
 * @property forceDestroy Whether destroying the resource deletes the default subnet. Default: `false`
 * @property ipv6CidrBlock
 * @property ipv6Native
 * @property mapCustomerOwnedIpOnLaunch
 * @property mapPublicIpOnLaunch
 * @property privateDnsHostnameTypeOnLaunch
 * @property tags
 */
public data class DefaultSubnetArgs(
    public val assignIpv6AddressOnCreation: Output<Boolean>? = null,
    public val availabilityZone: Output<String>? = null,
    public val customerOwnedIpv4Pool: Output<String>? = null,
    public val enableDns64: Output<Boolean>? = null,
    public val enableResourceNameDnsARecordOnLaunch: Output<Boolean>? = null,
    public val enableResourceNameDnsAaaaRecordOnLaunch: Output<Boolean>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val ipv6CidrBlock: Output<String>? = null,
    public val ipv6Native: Output<Boolean>? = null,
    public val mapCustomerOwnedIpOnLaunch: Output<Boolean>? = null,
    public val mapPublicIpOnLaunch: Output<Boolean>? = null,
    public val privateDnsHostnameTypeOnLaunch: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.DefaultSubnetArgs> {
    override fun toJava(): com.pulumi.aws.ec2.DefaultSubnetArgs =
        com.pulumi.aws.ec2.DefaultSubnetArgs.builder()
            .assignIpv6AddressOnCreation(assignIpv6AddressOnCreation?.applyValue({ args0 -> args0 }))
            .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
            .customerOwnedIpv4Pool(customerOwnedIpv4Pool?.applyValue({ args0 -> args0 }))
            .enableDns64(enableDns64?.applyValue({ args0 -> args0 }))
            .enableResourceNameDnsARecordOnLaunch(
                enableResourceNameDnsARecordOnLaunch?.applyValue({ args0 ->
                    args0
                }),
            )
            .enableResourceNameDnsAaaaRecordOnLaunch(
                enableResourceNameDnsAaaaRecordOnLaunch?.applyValue({ args0 ->
                    args0
                }),
            )
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .ipv6CidrBlock(ipv6CidrBlock?.applyValue({ args0 -> args0 }))
            .ipv6Native(ipv6Native?.applyValue({ args0 -> args0 }))
            .mapCustomerOwnedIpOnLaunch(mapCustomerOwnedIpOnLaunch?.applyValue({ args0 -> args0 }))
            .mapPublicIpOnLaunch(mapPublicIpOnLaunch?.applyValue({ args0 -> args0 }))
            .privateDnsHostnameTypeOnLaunch(privateDnsHostnameTypeOnLaunch?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DefaultSubnetArgs].
 */
@PulumiTagMarker
public class DefaultSubnetArgsBuilder internal constructor() {
    private var assignIpv6AddressOnCreation: Output<Boolean>? = null

    private var availabilityZone: Output<String>? = null

    private var customerOwnedIpv4Pool: Output<String>? = null

    private var enableDns64: Output<Boolean>? = null

    private var enableResourceNameDnsARecordOnLaunch: Output<Boolean>? = null

    private var enableResourceNameDnsAaaaRecordOnLaunch: Output<Boolean>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var ipv6CidrBlock: Output<String>? = null

    private var ipv6Native: Output<Boolean>? = null

    private var mapCustomerOwnedIpOnLaunch: Output<Boolean>? = null

    private var mapPublicIpOnLaunch: Output<Boolean>? = null

    private var privateDnsHostnameTypeOnLaunch: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value
     */
    @JvmName("bitoxxylykmfbwal")
    public suspend fun assignIpv6AddressOnCreation(`value`: Output<Boolean>) {
        this.assignIpv6AddressOnCreation = value
    }

    /**
     * @param value is required
     * * The `availability_zone_id`, `cidr_block` and `vpc_id` arguments become computed attributes
     * * The default value for `map_public_ip_on_launch` is `true`
     * This resource supports the following additional arguments:
     */
    @JvmName("umsvydkhgqqlbbyd")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value
     */
    @JvmName("gwhygkrblibbdfap")
    public suspend fun customerOwnedIpv4Pool(`value`: Output<String>) {
        this.customerOwnedIpv4Pool = value
    }

    /**
     * @param value
     */
    @JvmName("axsyyliakqxkiorx")
    public suspend fun enableDns64(`value`: Output<Boolean>) {
        this.enableDns64 = value
    }

    /**
     * @param value
     */
    @JvmName("dijqcjwigpuroatb")
    public suspend fun enableResourceNameDnsARecordOnLaunch(`value`: Output<Boolean>) {
        this.enableResourceNameDnsARecordOnLaunch = value
    }

    /**
     * @param value
     */
    @JvmName("ssyrllwootajarqv")
    public suspend fun enableResourceNameDnsAaaaRecordOnLaunch(`value`: Output<Boolean>) {
        this.enableResourceNameDnsAaaaRecordOnLaunch = value
    }

    /**
     * @param value Whether destroying the resource deletes the default subnet. Default: `false`
     */
    @JvmName("jmyqsuquswooncqw")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value
     */
    @JvmName("orvwmuojsbhuqdag")
    public suspend fun ipv6CidrBlock(`value`: Output<String>) {
        this.ipv6CidrBlock = value
    }

    /**
     * @param value
     */
    @JvmName("flrdeofjavfjfjqv")
    public suspend fun ipv6Native(`value`: Output<Boolean>) {
        this.ipv6Native = value
    }

    /**
     * @param value
     */
    @JvmName("qbegpqksysjauwgv")
    public suspend fun mapCustomerOwnedIpOnLaunch(`value`: Output<Boolean>) {
        this.mapCustomerOwnedIpOnLaunch = value
    }

    /**
     * @param value
     */
    @JvmName("xagtsaxvgjycscro")
    public suspend fun mapPublicIpOnLaunch(`value`: Output<Boolean>) {
        this.mapPublicIpOnLaunch = value
    }

    /**
     * @param value
     */
    @JvmName("rwbonxjwerjxpcvy")
    public suspend fun privateDnsHostnameTypeOnLaunch(`value`: Output<String>) {
        this.privateDnsHostnameTypeOnLaunch = value
    }

    /**
     * @param value
     */
    @JvmName("ugcynqardhdsilff")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("vugolhixjceihpcm")
    public suspend fun assignIpv6AddressOnCreation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignIpv6AddressOnCreation = mapped
    }

    /**
     * @param value is required
     * * The `availability_zone_id`, `cidr_block` and `vpc_id` arguments become computed attributes
     * * The default value for `map_public_ip_on_launch` is `true`
     * This resource supports the following additional arguments:
     */
    @JvmName("cxwnsabfoskfdwmq")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value
     */
    @JvmName("oqnqdympnlotvosv")
    public suspend fun customerOwnedIpv4Pool(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerOwnedIpv4Pool = mapped
    }

    /**
     * @param value
     */
    @JvmName("pyjvcfqmtawbxqrh")
    public suspend fun enableDns64(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDns64 = mapped
    }

    /**
     * @param value
     */
    @JvmName("dcxljtllnnbruwhd")
    public suspend fun enableResourceNameDnsARecordOnLaunch(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableResourceNameDnsARecordOnLaunch = mapped
    }

    /**
     * @param value
     */
    @JvmName("tiatetvigotlcfyr")
    public suspend fun enableResourceNameDnsAaaaRecordOnLaunch(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableResourceNameDnsAaaaRecordOnLaunch = mapped
    }

    /**
     * @param value Whether destroying the resource deletes the default subnet. Default: `false`
     */
    @JvmName("omaasdrnjusefhpb")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value
     */
    @JvmName("xqohulerfvsjvfho")
    public suspend fun ipv6CidrBlock(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6CidrBlock = mapped
    }

    /**
     * @param value
     */
    @JvmName("bckdkkixlthevhnq")
    public suspend fun ipv6Native(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Native = mapped
    }

    /**
     * @param value
     */
    @JvmName("qpyiiayggdrfcexi")
    public suspend fun mapCustomerOwnedIpOnLaunch(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mapCustomerOwnedIpOnLaunch = mapped
    }

    /**
     * @param value
     */
    @JvmName("cmikuhhqmldbphhm")
    public suspend fun mapPublicIpOnLaunch(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mapPublicIpOnLaunch = mapped
    }

    /**
     * @param value
     */
    @JvmName("jjifkaryyeqjlmqg")
    public suspend fun privateDnsHostnameTypeOnLaunch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateDnsHostnameTypeOnLaunch = mapped
    }

    /**
     * @param value
     */
    @JvmName("dqprwyeipnchkiaq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("tpwdhwwkylfonnxk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DefaultSubnetArgs = DefaultSubnetArgs(
        assignIpv6AddressOnCreation = assignIpv6AddressOnCreation,
        availabilityZone = availabilityZone,
        customerOwnedIpv4Pool = customerOwnedIpv4Pool,
        enableDns64 = enableDns64,
        enableResourceNameDnsARecordOnLaunch = enableResourceNameDnsARecordOnLaunch,
        enableResourceNameDnsAaaaRecordOnLaunch = enableResourceNameDnsAaaaRecordOnLaunch,
        forceDestroy = forceDestroy,
        ipv6CidrBlock = ipv6CidrBlock,
        ipv6Native = ipv6Native,
        mapCustomerOwnedIpOnLaunch = mapCustomerOwnedIpOnLaunch,
        mapPublicIpOnLaunch = mapPublicIpOnLaunch,
        privateDnsHostnameTypeOnLaunch = privateDnsHostnameTypeOnLaunch,
        tags = tags,
    )
}
