@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DefaultVpc].
 */
@PulumiTagMarker
public class DefaultVpcResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefaultVpcArgs = DefaultVpcArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefaultVpcArgsBuilder.() -> Unit) {
        val builder = DefaultVpcArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DefaultVpc {
        val builtJavaResource = com.pulumi.aws.ec2.DefaultVpc(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DefaultVpc(builtJavaResource)
    }
}

/**
 * Provides a resource to manage the [default AWS VPC](http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/default-vpc.html)
 * in the current AWS Region.
 * If you created your AWS account after 2013-12-04 you have a default VPC in each AWS Region.
 * **This is an advanced resource** and has special caveats to be aware of when using it. Please read this document in its entirety before using this resource.
 * The `aws.ec2.DefaultVpc` resource behaves differently from normal resources in that if a default VPC exists, this provider does not _create_ this resource, but instead "adopts" it into management.
 * If no default VPC exists, the provider creates a new default VPC, which leads to the implicit creation of [other resources](https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#default-vpc-components).
 * By default, `pulumi destroy` does not delete the default VPC but does remove the resource from the state.
 * Set the `force_destroy` argument to `true` to delete the default VPC.
 * ## Example Usage
 * Basic usage with tags:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultVpc;
 * import com.pulumi.aws.ec2.DefaultVpcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new DefaultVpc("default", DefaultVpcArgs.builder()
 *             .tags(Map.of("Name", "Default VPC"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Default VPCs using the VPC `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/defaultVpc:DefaultVpc default vpc-a01106c2
 * ```
 *
 */
public class DefaultVpc internal constructor(
    override val javaResource: com.pulumi.aws.ec2.DefaultVpc,
) : KotlinCustomResource(javaResource, DefaultVpcMapper) {
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val assignGeneratedIpv6CidrBlock: Output<Boolean>?
        get() = javaResource.assignGeneratedIpv6CidrBlock().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The primary IPv4 CIDR block for the VPC
     */
    public val cidrBlock: Output<String>
        get() = javaResource.cidrBlock().applyValue({ args0 -> args0 })

    public val defaultNetworkAclId: Output<String>
        get() = javaResource.defaultNetworkAclId().applyValue({ args0 -> args0 })

    public val defaultRouteTableId: Output<String>
        get() = javaResource.defaultRouteTableId().applyValue({ args0 -> args0 })

    public val defaultSecurityGroupId: Output<String>
        get() = javaResource.defaultSecurityGroupId().applyValue({ args0 -> args0 })

    public val dhcpOptionsId: Output<String>
        get() = javaResource.dhcpOptionsId().applyValue({ args0 -> args0 })

    public val enableDnsHostnames: Output<Boolean>?
        get() = javaResource.enableDnsHostnames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val enableDnsSupport: Output<Boolean>?
        get() = javaResource.enableDnsSupport().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val enableNetworkAddressUsageMetrics: Output<Boolean>
        get() = javaResource.enableNetworkAddressUsageMetrics().applyValue({ args0 -> args0 })

    public val existingDefaultVpc: Output<Boolean>
        get() = javaResource.existingDefaultVpc().applyValue({ args0 -> args0 })

    /**
     * Whether destroying the resource deletes the default VPC. Default: `false`
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The allowed tenancy of instances launched into the VPC
     */
    public val instanceTenancy: Output<String>
        get() = javaResource.instanceTenancy().applyValue({ args0 -> args0 })

    public val ipv6AssociationId: Output<String>
        get() = javaResource.ipv6AssociationId().applyValue({ args0 -> args0 })

    public val ipv6CidrBlock: Output<String>
        get() = javaResource.ipv6CidrBlock().applyValue({ args0 -> args0 })

    public val ipv6CidrBlockNetworkBorderGroup: Output<String>
        get() = javaResource.ipv6CidrBlockNetworkBorderGroup().applyValue({ args0 -> args0 })

    public val ipv6IpamPoolId: Output<String>?
        get() = javaResource.ipv6IpamPoolId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val ipv6NetmaskLength: Output<Int>?
        get() = javaResource.ipv6NetmaskLength().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val mainRouteTableId: Output<String>
        get() = javaResource.mainRouteTableId().applyValue({ args0 -> args0 })

    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DefaultVpcMapper : ResourceMapper<DefaultVpc> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.DefaultVpc::class == javaResource::class

    override fun map(javaResource: Resource): DefaultVpc = DefaultVpc(
        javaResource as
            com.pulumi.aws.ec2.DefaultVpc,
    )
}

/**
 * @see [DefaultVpc].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefaultVpc].
 */
public suspend fun defaultVpc(name: String, block: suspend DefaultVpcResourceBuilder.() -> Unit):
    DefaultVpc {
    val builder = DefaultVpcResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefaultVpc].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defaultVpc(name: String): DefaultVpc {
    val builder = DefaultVpcResourceBuilder()
    builder.name(name)
    return builder.build()
}
