@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DefaultVpcDhcpOptions].
 */
@PulumiTagMarker
public class DefaultVpcDhcpOptionsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefaultVpcDhcpOptionsArgs = DefaultVpcDhcpOptionsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefaultVpcDhcpOptionsArgsBuilder.() -> Unit) {
        val builder = DefaultVpcDhcpOptionsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DefaultVpcDhcpOptions {
        val builtJavaResource = com.pulumi.aws.ec2.DefaultVpcDhcpOptions(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DefaultVpcDhcpOptions(builtJavaResource)
    }
}

/**
 * Provides a resource to manage the [default AWS DHCP Options Set](http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html#AmazonDNS)
 * in the current region.
 * Each AWS region comes with a default set of DHCP options.
 * **This is an advanced resource**, and has special caveats to be aware of when
 * using it. Please read this document in its entirety before using this resource.
 * The `aws.ec2.DefaultVpcDhcpOptions` behaves differently from normal resources, in that
 * this provider does not _create_ this resource, but instead "adopts" it
 * into management.
 * ## Example Usage
 * Basic usage with tags:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultVpcDhcpOptions;
 * import com.pulumi.aws.ec2.DefaultVpcDhcpOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new DefaultVpcDhcpOptions("default", DefaultVpcDhcpOptionsArgs.builder()
 *             .tags(Map.of("Name", "Default DHCP Option Set"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC DHCP Options using the DHCP Options `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/defaultVpcDhcpOptions:DefaultVpcDhcpOptions default_options dopt-d9070ebb
 * ```
 *
 */
public class DefaultVpcDhcpOptions internal constructor(
    override val javaResource: com.pulumi.aws.ec2.DefaultVpcDhcpOptions,
) : KotlinCustomResource(javaResource, DefaultVpcDhcpOptionsMapper) {
    /**
     * The ARN of the DHCP Options Set.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    public val domainNameServers: Output<String>
        get() = javaResource.domainNameServers().applyValue({ args0 -> args0 })

    /**
     * List of NETBIOS name servers.
     */
    public val netbiosNameServers: Output<String>
        get() = javaResource.netbiosNameServers().applyValue({ args0 -> args0 })

    /**
     * The NetBIOS node type (1, 2, 4, or 8). AWS recommends to specify 2 since broadcast and multicast are not supported in their network. For more information about these node types, see [RFC 2132](http://www.ietf.org/rfc/rfc2132.txt).
     */
    public val netbiosNodeType: Output<String>
        get() = javaResource.netbiosNodeType().applyValue({ args0 -> args0 })

    public val ntpServers: Output<String>
        get() = javaResource.ntpServers().applyValue({ args0 -> args0 })

    /**
     * The ID of the AWS account that owns the DHCP options set.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DefaultVpcDhcpOptionsMapper : ResourceMapper<DefaultVpcDhcpOptions> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.DefaultVpcDhcpOptions::class == javaResource::class

    override fun map(javaResource: Resource): DefaultVpcDhcpOptions =
        DefaultVpcDhcpOptions(javaResource as com.pulumi.aws.ec2.DefaultVpcDhcpOptions)
}

/**
 * @see [DefaultVpcDhcpOptions].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefaultVpcDhcpOptions].
 */
public suspend fun defaultVpcDhcpOptions(
    name: String,
    block: suspend DefaultVpcDhcpOptionsResourceBuilder.() -> Unit,
): DefaultVpcDhcpOptions {
    val builder = DefaultVpcDhcpOptionsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefaultVpcDhcpOptions].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defaultVpcDhcpOptions(name: String): DefaultVpcDhcpOptions {
    val builder = DefaultVpcDhcpOptionsResourceBuilder()
    builder.name(name)
    return builder.build()
}
