@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.DefaultVpcDhcpOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage the [default AWS DHCP Options Set](http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_DHCP_Options.html#AmazonDNS)
 * in the current region.
 * Each AWS region comes with a default set of DHCP options.
 * **This is an advanced resource**, and has special caveats to be aware of when
 * using it. Please read this document in its entirety before using this resource.
 * The `aws.ec2.DefaultVpcDhcpOptions` behaves differently from normal resources, in that
 * this provider does not _create_ this resource, but instead "adopts" it
 * into management.
 * ## Example Usage
 * Basic usage with tags:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.DefaultVpcDhcpOptions;
 * import com.pulumi.aws.ec2.DefaultVpcDhcpOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new DefaultVpcDhcpOptions("default", DefaultVpcDhcpOptionsArgs.builder()
 *             .tags(Map.of("Name", "Default DHCP Option Set"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import VPC DHCP Options using the DHCP Options `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/defaultVpcDhcpOptions:DefaultVpcDhcpOptions default_options dopt-d9070ebb
 * ```
 * @property ownerId The ID of the AWS account that owns the DHCP options set.
 * @property tags A map of tags to assign to the resource.
 */
public data class DefaultVpcDhcpOptionsArgs(
    public val ownerId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.DefaultVpcDhcpOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ec2.DefaultVpcDhcpOptionsArgs =
        com.pulumi.aws.ec2.DefaultVpcDhcpOptionsArgs.builder()
            .ownerId(ownerId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DefaultVpcDhcpOptionsArgs].
 */
@PulumiTagMarker
public class DefaultVpcDhcpOptionsArgsBuilder internal constructor() {
    private var ownerId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The ID of the AWS account that owns the DHCP options set.
     */
    @JvmName("isdkbsbuitjndmxu")
    public suspend fun ownerId(`value`: Output<String>) {
        this.ownerId = value
    }

    /**
     * @param value A map of tags to assign to the resource.
     */
    @JvmName("xoejolgaboxsrsqo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the AWS account that owns the DHCP options set.
     */
    @JvmName("thpuextemwujayia")
    public suspend fun ownerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource.
     */
    @JvmName("ajcxoukjxhwwvyyb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource.
     */
    @JvmName("humragktuinhgsnn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DefaultVpcDhcpOptionsArgs = DefaultVpcDhcpOptionsArgs(
        ownerId = ownerId,
        tags = tags,
    )
}
