@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.Ec2Functions.getAmiIdsPlain
import com.pulumi.aws.ec2.Ec2Functions.getAmiPlain
import com.pulumi.aws.ec2.Ec2Functions.getCoipPoolPlain
import com.pulumi.aws.ec2.Ec2Functions.getCoipPoolsPlain
import com.pulumi.aws.ec2.Ec2Functions.getCustomerGatewayPlain
import com.pulumi.aws.ec2.Ec2Functions.getDedicatedHostPlain
import com.pulumi.aws.ec2.Ec2Functions.getEipsPlain
import com.pulumi.aws.ec2.Ec2Functions.getElasticIpPlain
import com.pulumi.aws.ec2.Ec2Functions.getInstancePlain
import com.pulumi.aws.ec2.Ec2Functions.getInstanceTypeOfferingPlain
import com.pulumi.aws.ec2.Ec2Functions.getInstanceTypeOfferingsPlain
import com.pulumi.aws.ec2.Ec2Functions.getInstanceTypePlain
import com.pulumi.aws.ec2.Ec2Functions.getInstanceTypesPlain
import com.pulumi.aws.ec2.Ec2Functions.getInstancesPlain
import com.pulumi.aws.ec2.Ec2Functions.getInternetGatewayPlain
import com.pulumi.aws.ec2.Ec2Functions.getIpamPreviewNextCidrPlain
import com.pulumi.aws.ec2.Ec2Functions.getKeyPairPlain
import com.pulumi.aws.ec2.Ec2Functions.getLaunchConfigurationPlain
import com.pulumi.aws.ec2.Ec2Functions.getLaunchTemplatePlain
import com.pulumi.aws.ec2.Ec2Functions.getLocalGatewayPlain
import com.pulumi.aws.ec2.Ec2Functions.getLocalGatewayRouteTablePlain
import com.pulumi.aws.ec2.Ec2Functions.getLocalGatewayRouteTablesPlain
import com.pulumi.aws.ec2.Ec2Functions.getLocalGatewayVirtualInterfaceGroupPlain
import com.pulumi.aws.ec2.Ec2Functions.getLocalGatewayVirtualInterfaceGroupsPlain
import com.pulumi.aws.ec2.Ec2Functions.getLocalGatewayVirtualInterfacePlain
import com.pulumi.aws.ec2.Ec2Functions.getLocalGatewaysPlain
import com.pulumi.aws.ec2.Ec2Functions.getManagedPrefixListPlain
import com.pulumi.aws.ec2.Ec2Functions.getManagedPrefixListsPlain
import com.pulumi.aws.ec2.Ec2Functions.getNatGatewayPlain
import com.pulumi.aws.ec2.Ec2Functions.getNatGatewaysPlain
import com.pulumi.aws.ec2.Ec2Functions.getNetworkAclsPlain
import com.pulumi.aws.ec2.Ec2Functions.getNetworkInsightsAnalysisPlain
import com.pulumi.aws.ec2.Ec2Functions.getNetworkInsightsPathPlain
import com.pulumi.aws.ec2.Ec2Functions.getNetworkInterfacePlain
import com.pulumi.aws.ec2.Ec2Functions.getNetworkInterfacesPlain
import com.pulumi.aws.ec2.Ec2Functions.getPrefixListPlain
import com.pulumi.aws.ec2.Ec2Functions.getPublicIpv4PoolPlain
import com.pulumi.aws.ec2.Ec2Functions.getPublicIpv4PoolsPlain
import com.pulumi.aws.ec2.Ec2Functions.getRoutePlain
import com.pulumi.aws.ec2.Ec2Functions.getRouteTablePlain
import com.pulumi.aws.ec2.Ec2Functions.getRouteTablesPlain
import com.pulumi.aws.ec2.Ec2Functions.getSecurityGroupPlain
import com.pulumi.aws.ec2.Ec2Functions.getSecurityGroupsPlain
import com.pulumi.aws.ec2.Ec2Functions.getSerialConsoleAccessPlain
import com.pulumi.aws.ec2.Ec2Functions.getSpotPricePlain
import com.pulumi.aws.ec2.Ec2Functions.getSubnetPlain
import com.pulumi.aws.ec2.Ec2Functions.getSubnetsPlain
import com.pulumi.aws.ec2.Ec2Functions.getTransitGatewayRouteTablesPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcDhcpOptionsPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcEndpointPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcEndpointServicePlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcIamPoolCidrsPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcIamPoolPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcIamPoolsPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcIpamPoolCidrsPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcIpamPoolPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcIpamPoolsPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcPeeringConnectionPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcPeeringConnectionsPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpcsPlain
import com.pulumi.aws.ec2.Ec2Functions.getVpnGatewayPlain
import com.pulumi.aws.ec2.kotlin.inputs.GetAmiFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetAmiIdsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetAmiIdsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetAmiIdsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetAmiPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetAmiPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetCoipPoolFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetCoipPoolPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetCoipPoolPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetCoipPoolsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetCoipPoolsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetCoipPoolsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetCustomerGatewayFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetCustomerGatewayPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetCustomerGatewayPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetDedicatedHostFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetDedicatedHostPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetDedicatedHostPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetEipsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetEipsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetEipsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetElasticIpFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetElasticIpPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetElasticIpPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetInstancePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetInstancePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypeOfferingFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypeOfferingPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypeOfferingPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypeOfferingsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypeOfferingsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypeOfferingsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypesFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypesPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetInstanceTypesPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetInstancesFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetInternetGatewayFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetInternetGatewayPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetInternetGatewayPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetIpamPreviewNextCidrPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetIpamPreviewNextCidrPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetKeyPairFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetKeyPairPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetKeyPairPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLaunchConfigurationPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLaunchConfigurationPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLaunchTemplateFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLaunchTemplatePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLaunchTemplatePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayRouteTableFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayRouteTablePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayRouteTablePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayRouteTablesFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayRouteTablesPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayRouteTablesPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfaceFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfaceGroupFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfaceGroupPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfaceGroupPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfaceGroupsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfaceGroupsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfaceGroupsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfacePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewayVirtualInterfacePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewaysFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewaysPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetLocalGatewaysPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetManagedPrefixListFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetManagedPrefixListPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetManagedPrefixListPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetManagedPrefixListsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetManagedPrefixListsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetManagedPrefixListsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetNatGatewayFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetNatGatewayPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetNatGatewayPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetNatGatewaysFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetNatGatewaysPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetNatGatewaysPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkAclsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkAclsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkAclsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInsightsAnalysisFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInsightsAnalysisPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInsightsAnalysisPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInsightsPathFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInsightsPathPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInsightsPathPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInterfaceFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInterfacePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInterfacePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInterfacesFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInterfacesPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetNetworkInterfacesPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetPrefixListFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetPrefixListPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetPrefixListPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetPublicIpv4PoolPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetPublicIpv4PoolPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetPublicIpv4PoolsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetPublicIpv4PoolsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetPublicIpv4PoolsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetRoutePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetRoutePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetRouteTableFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetRouteTablePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetRouteTablePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetRouteTablesFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetRouteTablesPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetRouteTablesPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetSecurityGroupFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetSecurityGroupPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetSecurityGroupPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetSecurityGroupsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetSecurityGroupsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetSecurityGroupsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetSpotPriceFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetSpotPricePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetSpotPricePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetSubnetFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetSubnetPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetSubnetPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetSubnetsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetSubnetsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetSubnetsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetTransitGatewayRouteTablesFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetTransitGatewayRouteTablesPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetTransitGatewayRouteTablesPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcDhcpOptionsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcDhcpOptionsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcDhcpOptionsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcEndpointFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcEndpointPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcEndpointPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcEndpointServiceFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcEndpointServicePlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcEndpointServicePlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolCidrsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolCidrsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolCidrsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIamPoolsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolCidrsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolCidrsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolCidrsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcIpamPoolsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPeeringConnectionFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPeeringConnectionPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPeeringConnectionPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPeeringConnectionsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPeeringConnectionsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPeeringConnectionsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcsFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcsPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpcsPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.GetVpnGatewayFilter
import com.pulumi.aws.ec2.kotlin.inputs.GetVpnGatewayPlainArgs
import com.pulumi.aws.ec2.kotlin.inputs.GetVpnGatewayPlainArgsBuilder
import com.pulumi.aws.ec2.kotlin.outputs.GetAmiIdsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetAmiResult
import com.pulumi.aws.ec2.kotlin.outputs.GetCoipPoolResult
import com.pulumi.aws.ec2.kotlin.outputs.GetCoipPoolsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetCustomerGatewayResult
import com.pulumi.aws.ec2.kotlin.outputs.GetDedicatedHostResult
import com.pulumi.aws.ec2.kotlin.outputs.GetEipsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetElasticIpResult
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceResult
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeOfferingResult
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeOfferingsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeResult
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypesResult
import com.pulumi.aws.ec2.kotlin.outputs.GetInstancesResult
import com.pulumi.aws.ec2.kotlin.outputs.GetInternetGatewayResult
import com.pulumi.aws.ec2.kotlin.outputs.GetIpamPreviewNextCidrResult
import com.pulumi.aws.ec2.kotlin.outputs.GetKeyPairResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLaunchConfigurationResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayRouteTableResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayRouteTablesResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceGroupResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceGroupsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceResult
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewaysResult
import com.pulumi.aws.ec2.kotlin.outputs.GetManagedPrefixListResult
import com.pulumi.aws.ec2.kotlin.outputs.GetManagedPrefixListsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetNatGatewayResult
import com.pulumi.aws.ec2.kotlin.outputs.GetNatGatewaysResult
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkAclsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisResult
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsPathResult
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInterfaceResult
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInterfacesResult
import com.pulumi.aws.ec2.kotlin.outputs.GetPrefixListResult
import com.pulumi.aws.ec2.kotlin.outputs.GetPublicIpv4PoolResult
import com.pulumi.aws.ec2.kotlin.outputs.GetPublicIpv4PoolsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetRouteResult
import com.pulumi.aws.ec2.kotlin.outputs.GetRouteTableResult
import com.pulumi.aws.ec2.kotlin.outputs.GetRouteTablesResult
import com.pulumi.aws.ec2.kotlin.outputs.GetSecurityGroupResult
import com.pulumi.aws.ec2.kotlin.outputs.GetSecurityGroupsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetSerialConsoleAccessResult
import com.pulumi.aws.ec2.kotlin.outputs.GetSpotPriceResult
import com.pulumi.aws.ec2.kotlin.outputs.GetSubnetResult
import com.pulumi.aws.ec2.kotlin.outputs.GetSubnetsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetTransitGatewayRouteTablesResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcDhcpOptionsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcEndpointResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcEndpointServiceResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolCidrsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolCidrsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcPeeringConnectionResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcPeeringConnectionsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcsResult
import com.pulumi.aws.ec2.kotlin.outputs.GetVpnGatewayResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.GetAmiIdsResult.Companion.toKotlin as getAmiIdsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetAmiResult.Companion.toKotlin as getAmiResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetCoipPoolResult.Companion.toKotlin as getCoipPoolResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetCoipPoolsResult.Companion.toKotlin as getCoipPoolsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetCustomerGatewayResult.Companion.toKotlin as getCustomerGatewayResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetDedicatedHostResult.Companion.toKotlin as getDedicatedHostResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetEipsResult.Companion.toKotlin as getEipsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetElasticIpResult.Companion.toKotlin as getElasticIpResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceResult.Companion.toKotlin as getInstanceResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeOfferingResult.Companion.toKotlin as getInstanceTypeOfferingResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeOfferingsResult.Companion.toKotlin as getInstanceTypeOfferingsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypeResult.Companion.toKotlin as getInstanceTypeResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetInstanceTypesResult.Companion.toKotlin as getInstanceTypesResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetInternetGatewayResult.Companion.toKotlin as getInternetGatewayResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetIpamPreviewNextCidrResult.Companion.toKotlin as getIpamPreviewNextCidrResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetKeyPairResult.Companion.toKotlin as getKeyPairResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLaunchConfigurationResult.Companion.toKotlin as getLaunchConfigurationResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLaunchTemplateResult.Companion.toKotlin as getLaunchTemplateResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayResult.Companion.toKotlin as getLocalGatewayResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayRouteTableResult.Companion.toKotlin as getLocalGatewayRouteTableResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayRouteTablesResult.Companion.toKotlin as getLocalGatewayRouteTablesResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceGroupResult.Companion.toKotlin as getLocalGatewayVirtualInterfaceGroupResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceGroupsResult.Companion.toKotlin as getLocalGatewayVirtualInterfaceGroupsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewayVirtualInterfaceResult.Companion.toKotlin as getLocalGatewayVirtualInterfaceResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetLocalGatewaysResult.Companion.toKotlin as getLocalGatewaysResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetManagedPrefixListResult.Companion.toKotlin as getManagedPrefixListResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetManagedPrefixListsResult.Companion.toKotlin as getManagedPrefixListsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetNatGatewayResult.Companion.toKotlin as getNatGatewayResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetNatGatewaysResult.Companion.toKotlin as getNatGatewaysResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkAclsResult.Companion.toKotlin as getNetworkAclsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsAnalysisResult.Companion.toKotlin as getNetworkInsightsAnalysisResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInsightsPathResult.Companion.toKotlin as getNetworkInsightsPathResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInterfaceResult.Companion.toKotlin as getNetworkInterfaceResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetNetworkInterfacesResult.Companion.toKotlin as getNetworkInterfacesResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetPrefixListResult.Companion.toKotlin as getPrefixListResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetPublicIpv4PoolResult.Companion.toKotlin as getPublicIpv4PoolResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetPublicIpv4PoolsResult.Companion.toKotlin as getPublicIpv4PoolsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetRouteResult.Companion.toKotlin as getRouteResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetRouteTableResult.Companion.toKotlin as getRouteTableResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetRouteTablesResult.Companion.toKotlin as getRouteTablesResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetSecurityGroupResult.Companion.toKotlin as getSecurityGroupResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetSecurityGroupsResult.Companion.toKotlin as getSecurityGroupsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetSerialConsoleAccessResult.Companion.toKotlin as getSerialConsoleAccessResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetSpotPriceResult.Companion.toKotlin as getSpotPriceResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetSubnetResult.Companion.toKotlin as getSubnetResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetSubnetsResult.Companion.toKotlin as getSubnetsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetTransitGatewayRouteTablesResult.Companion.toKotlin as getTransitGatewayRouteTablesResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcDhcpOptionsResult.Companion.toKotlin as getVpcDhcpOptionsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcEndpointResult.Companion.toKotlin as getVpcEndpointResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcEndpointServiceResult.Companion.toKotlin as getVpcEndpointServiceResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolCidrsResult.Companion.toKotlin as getVpcIamPoolCidrsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolResult.Companion.toKotlin as getVpcIamPoolResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIamPoolsResult.Companion.toKotlin as getVpcIamPoolsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolCidrsResult.Companion.toKotlin as getVpcIpamPoolCidrsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolResult.Companion.toKotlin as getVpcIpamPoolResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcIpamPoolsResult.Companion.toKotlin as getVpcIpamPoolsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcPeeringConnectionResult.Companion.toKotlin as getVpcPeeringConnectionResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcPeeringConnectionsResult.Companion.toKotlin as getVpcPeeringConnectionsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcResult.Companion.toKotlin as getVpcResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpcsResult.Companion.toKotlin as getVpcsResultToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.GetVpnGatewayResult.Companion.toKotlin as getVpnGatewayResultToKotlin

public object Ec2Functions {
    /**
     * Use this data source to get the ID of a registered AMI for use in other
     * resources.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getAmi(GetAmiArgs.builder()
     *             .executableUsers("self")
     *             .filters(
     *                 GetAmiFilterArgs.builder()
     *                     .name("name")
     *                     .values("myami-*")
     *                     .build(),
     *                 GetAmiFilterArgs.builder()
     *                     .name("root-device-type")
     *                     .values("ebs")
     *                     .build(),
     *                 GetAmiFilterArgs.builder()
     *                     .name("virtualization-type")
     *                     .values("hvm")
     *                     .build())
     *             .mostRecent(true)
     *             .nameRegex("^myami-\\d{3}")
     *             .owners("self")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAmi.
     * @return A collection of values returned by getAmi.
     */
    public suspend fun getAmi(argument: GetAmiPlainArgs): GetAmiResult =
        getAmiResultToKotlin(getAmiPlain(argument.toJava()).await())

    /**
     * @see [getAmi].
     * @param executableUsers Limit search to users with *explicit* launch permission on
     * the image. Valid items are the numeric account ID or `self`.
     * @param filters One or more name/value pairs to filter off of. There are
     * several valid keys, for a full reference, check out
     * [describe-images in the AWS CLI reference][1].
     * @param includeDeprecated If true, all deprecated AMIs are included in the response. If false, no deprecated AMIs are included in the response. If no value is specified, the default value is false.
     * @param mostRecent If more than one result is returned, use the most
     * recent AMI.
     * @param nameRegex Regex string to apply to the AMI list returned
     * by AWS. This allows more advanced filtering not supported from the AWS API. This
     * filtering is done locally on what AWS returns, and could have a performance
     * impact if the result is large. Combine this with other
     * options to narrow down the list AWS returns.
     * > **NOTE:** If more or less than a single match is returned by the search,
     * this call will fail. Ensure that your search is specific enough to return
     * a single AMI ID only, or use `most_recent` to choose the most recent one. If
     * you want to match multiple AMIs, use the `aws.ec2.getAmiIds` data source instead.
     * @param owners List of AMI owners to limit search. Valid values: an AWS account ID, `self` (the current account), or an AWS owner alias (e.g., `amazon`, `aws-marketplace`, `microsoft`).
     * @param tags Any tags assigned to the image.
     * * `tags.#.key` - Key name of the tag.
     * * `tags.#.value` - Value of the tag.
     * @return A collection of values returned by getAmi.
     */
    public suspend fun getAmi(
        executableUsers: List<String>? = null,
        filters: List<GetAmiFilter>? = null,
        includeDeprecated: Boolean? = null,
        mostRecent: Boolean? = null,
        nameRegex: String? = null,
        owners: List<String>? = null,
        tags: Map<String, String>? = null,
    ): GetAmiResult {
        val argument = GetAmiPlainArgs(
            executableUsers = executableUsers,
            filters = filters,
            includeDeprecated = includeDeprecated,
            mostRecent = mostRecent,
            nameRegex = nameRegex,
            owners = owners,
            tags = tags,
        )
        return getAmiResultToKotlin(getAmiPlain(argument.toJava()).await())
    }

    /**
     * @see [getAmi].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetAmiPlainArgs].
     * @return A collection of values returned by getAmi.
     */
    public suspend fun getAmi(argument: suspend GetAmiPlainArgsBuilder.() -> Unit): GetAmiResult {
        val builder = GetAmiPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAmiResultToKotlin(getAmiPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get a list of AMI IDs matching the specified criteria.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetAmiIdsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ubuntu = Ec2Functions.getAmiIds(GetAmiIdsArgs.builder()
     *             .filters(GetAmiIdsFilterArgs.builder()
     *                 .name("name")
     *                 .values("ubuntu/images/ubuntu-*-*-amd64-server-*")
     *                 .build())
     *             .owners("099720109477")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getAmiIds.
     * @return A collection of values returned by getAmiIds.
     */
    public suspend fun getAmiIds(argument: GetAmiIdsPlainArgs): GetAmiIdsResult =
        getAmiIdsResultToKotlin(getAmiIdsPlain(argument.toJava()).await())

    /**
     * @see [getAmiIds].
     * @param executableUsers Limit search to users with *explicit* launch
     * permission on  the image. Valid items are the numeric account ID or `self`.
     * @param filters One or more name/value pairs to filter off of. There
     * are several valid keys, for a full reference, check out
     * [describe-images in the AWS CLI reference][1].
     * @param includeDeprecated If true, all deprecated AMIs are included in the response.
     * If false, no deprecated AMIs are included in the response. If no value is specified, the default value is `false`.
     * @param nameRegex Regex string to apply to the AMI list returned
     * by AWS. This allows more advanced filtering not supported from the AWS API.
     * This filtering is done locally on what AWS returns, and could have a performance
     * impact if the result is large. Combine this with other
     * options to narrow down the list AWS returns.
     * @param owners List of AMI owners to limit search. At least 1 value must be specified. Valid values: an AWS account ID, `self` (the current account), or an AWS owner alias (e.g., `amazon`, `aws-marketplace`, `microsoft`).
     * @param sortAscending Used to sort AMIs by creation time.
     * If no value is specified, the default value is `false`.
     * @return A collection of values returned by getAmiIds.
     */
    public suspend fun getAmiIds(
        executableUsers: List<String>? = null,
        filters: List<GetAmiIdsFilter>? = null,
        includeDeprecated: Boolean? = null,
        nameRegex: String? = null,
        owners: List<String>,
        sortAscending: Boolean? = null,
    ): GetAmiIdsResult {
        val argument = GetAmiIdsPlainArgs(
            executableUsers = executableUsers,
            filters = filters,
            includeDeprecated = includeDeprecated,
            nameRegex = nameRegex,
            owners = owners,
            sortAscending = sortAscending,
        )
        return getAmiIdsResultToKotlin(getAmiIdsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAmiIds].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetAmiIdsPlainArgs].
     * @return A collection of values returned by getAmiIds.
     */
    public suspend fun getAmiIds(argument: suspend GetAmiIdsPlainArgsBuilder.() -> Unit):
        GetAmiIdsResult {
        val builder = GetAmiIdsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAmiIdsResultToKotlin(getAmiIdsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific EC2 Customer-Owned IP Pool.
     * This data source can prove useful when a module accepts a coip pool id as
     * an input variable and needs to, for example, determine the CIDR block of that
     * COIP Pool.
     * ## Example Usage
     * The following example returns a specific coip pool ID
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetCoipPoolArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var coipPoolId = config.get("coipPoolId");
     *         final var selected = Ec2Functions.getCoipPool(GetCoipPoolArgs.builder()
     *             .id(coipPoolId)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCoipPool.
     * @return A collection of values returned by getCoipPool.
     */
    public suspend fun getCoipPool(argument: GetCoipPoolPlainArgs): GetCoipPoolResult =
        getCoipPoolResultToKotlin(getCoipPoolPlain(argument.toJava()).await())

    /**
     * @see [getCoipPool].
     * @param filters
     * @param localGatewayRouteTableId Local Gateway Route Table Id assigned to desired COIP Pool
     * @param poolId ID of the specific COIP Pool to retrieve.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired COIP Pool.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getCoipPool.
     */
    public suspend fun getCoipPool(
        filters: List<GetCoipPoolFilter>? = null,
        localGatewayRouteTableId: String? = null,
        poolId: String? = null,
        tags: Map<String, String>? = null,
    ): GetCoipPoolResult {
        val argument = GetCoipPoolPlainArgs(
            filters = filters,
            localGatewayRouteTableId = localGatewayRouteTableId,
            poolId = poolId,
            tags = tags,
        )
        return getCoipPoolResultToKotlin(getCoipPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getCoipPool].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetCoipPoolPlainArgs].
     * @return A collection of values returned by getCoipPool.
     */
    public suspend fun getCoipPool(argument: suspend GetCoipPoolPlainArgsBuilder.() -> Unit):
        GetCoipPoolResult {
        val builder = GetCoipPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCoipPoolResultToKotlin(getCoipPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information for multiple EC2 Customer-Owned IP Pools, such as their identifiers.
     * @param argument A collection of arguments for invoking getCoipPools.
     * @return A collection of values returned by getCoipPools.
     */
    public suspend fun getCoipPools(argument: GetCoipPoolsPlainArgs): GetCoipPoolsResult =
        getCoipPoolsResultToKotlin(getCoipPoolsPlain(argument.toJava()).await())

    /**
     * @see [getCoipPools].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired aws_ec2_coip_pools.
     * @return A collection of values returned by getCoipPools.
     */
    public suspend fun getCoipPools(
        filters: List<GetCoipPoolsFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetCoipPoolsResult {
        val argument = GetCoipPoolsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getCoipPoolsResultToKotlin(getCoipPoolsPlain(argument.toJava()).await())
    }

    /**
     * @see [getCoipPools].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetCoipPoolsPlainArgs].
     * @return A collection of values returned by getCoipPools.
     */
    public suspend fun getCoipPools(argument: suspend GetCoipPoolsPlainArgsBuilder.() -> Unit):
        GetCoipPoolsResult {
        val builder = GetCoipPoolsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCoipPoolsResultToKotlin(getCoipPoolsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an existing AWS Customer Gateway.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetCustomerGatewayArgs;
     * import com.pulumi.aws.ec2.VpnGateway;
     * import com.pulumi.aws.ec2.VpnGatewayArgs;
     * import com.pulumi.aws.ec2.VpnConnection;
     * import com.pulumi.aws.ec2.VpnConnectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = Ec2Functions.getCustomerGateway(GetCustomerGatewayArgs.builder()
     *             .filters(GetCustomerGatewayFilterArgs.builder()
     *                 .name("tag:Name")
     *                 .values("foo-prod")
     *                 .build())
     *             .build());
     *         var main = new VpnGateway("main", VpnGatewayArgs.builder()
     *             .vpcId(aws_vpc.main().id())
     *             .amazonSideAsn(7224)
     *             .build());
     *         var transit = new VpnConnection("transit", VpnConnectionArgs.builder()
     *             .vpnGatewayId(main.id())
     *             .customerGatewayId(foo.applyValue(getCustomerGatewayResult -> getCustomerGatewayResult.id()))
     *             .type(foo.applyValue(getCustomerGatewayResult -> getCustomerGatewayResult.type()))
     *             .staticRoutesOnly(false)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCustomerGateway.
     * @return A collection of values returned by getCustomerGateway.
     */
    public suspend fun getCustomerGateway(argument: GetCustomerGatewayPlainArgs):
        GetCustomerGatewayResult =
        getCustomerGatewayResultToKotlin(getCustomerGatewayPlain(argument.toJava()).await())

    /**
     * @see [getCustomerGateway].
     * @param filters One or more [name-value pairs][dcg-filters] to filter by.
     * [dcg-filters]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeCustomerGateways.html
     * @param id ID of the gateway.
     * @param tags Map of key-value pairs assigned to the gateway.
     * @return A collection of values returned by getCustomerGateway.
     */
    public suspend fun getCustomerGateway(
        filters: List<GetCustomerGatewayFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetCustomerGatewayResult {
        val argument = GetCustomerGatewayPlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getCustomerGatewayResultToKotlin(getCustomerGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomerGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetCustomerGatewayPlainArgs].
     * @return A collection of values returned by getCustomerGateway.
     */
    public suspend
    fun getCustomerGateway(argument: suspend GetCustomerGatewayPlainArgsBuilder.() -> Unit):
        GetCustomerGatewayResult {
        val builder = GetCustomerGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomerGatewayResultToKotlin(getCustomerGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about an EC2 Dedicated Host.
     * ## Example Usage
     * ### Filter Example
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetDedicatedHostArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getDedicatedHost(GetDedicatedHostArgs.builder()
     *             .filters(GetDedicatedHostFilterArgs.builder()
     *                 .name("instance-type")
     *                 .values("c5.18xlarge")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDedicatedHost.
     * @return A collection of values returned by getDedicatedHost.
     */
    public suspend fun getDedicatedHost(argument: GetDedicatedHostPlainArgs): GetDedicatedHostResult =
        getDedicatedHostResultToKotlin(getDedicatedHostPlain(argument.toJava()).await())

    /**
     * @see [getDedicatedHost].
     * @param filters Configuration block. Detailed below.
     * @param hostId ID of the Dedicated Host.
     * @param tags
     * @return A collection of values returned by getDedicatedHost.
     */
    public suspend fun getDedicatedHost(
        filters: List<GetDedicatedHostFilter>? = null,
        hostId: String? = null,
        tags: Map<String, String>? = null,
    ): GetDedicatedHostResult {
        val argument = GetDedicatedHostPlainArgs(
            filters = filters,
            hostId = hostId,
            tags = tags,
        )
        return getDedicatedHostResultToKotlin(getDedicatedHostPlain(argument.toJava()).await())
    }

    /**
     * @see [getDedicatedHost].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetDedicatedHostPlainArgs].
     * @return A collection of values returned by getDedicatedHost.
     */
    public suspend
    fun getDedicatedHost(argument: suspend GetDedicatedHostPlainArgsBuilder.() -> Unit):
        GetDedicatedHostResult {
        val builder = GetDedicatedHostPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDedicatedHostResultToKotlin(getDedicatedHostPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides a list of Elastic IPs in a region.
     * ## Example Usage
     * The following shows outputting all Elastic IPs with the a specific tag value.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetEipsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getEips(GetEipsArgs.builder()
     *             .tags(Map.of("Env", "dev"))
     *             .build());
     *         ctx.export("allocationIds", example.applyValue(getEipsResult -> getEipsResult.allocationIds()));
     *         ctx.export("publicIps", example.applyValue(getEipsResult -> getEipsResult.publicIps()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getEips.
     * @return A collection of values returned by getEips.
     */
    public suspend fun getEips(argument: GetEipsPlainArgs): GetEipsResult =
        getEipsResultToKotlin(getEipsPlain(argument.toJava()).await())

    /**
     * @see [getEips].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired Elastic IPs.
     * @return A collection of values returned by getEips.
     */
    public suspend fun getEips(
        filters: List<GetEipsFilter>? = null,
        tags: Map<String, String>? =
            null,
    ): GetEipsResult {
        val argument = GetEipsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getEipsResultToKotlin(getEipsPlain(argument.toJava()).await())
    }

    /**
     * @see [getEips].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetEipsPlainArgs].
     * @return A collection of values returned by getEips.
     */
    public suspend fun getEips(argument: suspend GetEipsPlainArgsBuilder.() -> Unit): GetEipsResult {
        val builder = GetEipsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEipsResultToKotlin(getEipsPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.Eip` provides details about a specific Elastic IP.
     * ## Example Usage
     * ### Search By Allocation ID (VPC only)
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetElasticIpArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var byAllocationId = Ec2Functions.getElasticIp(GetElasticIpArgs.builder()
     *             .id("eipalloc-12345678")
     *             .build());
     *     }
     * }
     * ```
     * ### Search By Filters (EC2-Classic or VPC)
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetElasticIpArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var byFilter = Ec2Functions.getElasticIp(GetElasticIpArgs.builder()
     *             .filters(GetElasticIpFilterArgs.builder()
     *                 .name("tag:Name")
     *                 .values("exampleNameTagValue")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### Search By Public IP (EC2-Classic or VPC)
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetElasticIpArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var byPublicIp = Ec2Functions.getElasticIp(GetElasticIpArgs.builder()
     *             .publicIp("1.2.3.4")
     *             .build());
     *     }
     * }
     * ```
     * ### Search By Tags (EC2-Classic or VPC)
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetElasticIpArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var byTags = Ec2Functions.getElasticIp(GetElasticIpArgs.builder()
     *             .tags(Map.of("Name", "exampleNameTagValue"))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getElasticIp.
     * @return A collection of values returned by getElasticIp.
     */
    public suspend fun getElasticIp(argument: GetElasticIpPlainArgs): GetElasticIpResult =
        getElasticIpResultToKotlin(getElasticIpPlain(argument.toJava()).await())

    /**
     * @see [getElasticIp].
     * @param filters One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html).
     * @param id Allocation ID of the specific VPC EIP to retrieve. If a classic EIP is required, do NOT set `id`, only set `public_ip`
     * @param publicIp Public IP of the specific EIP to retrieve.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired Elastic IP
     * @return A collection of values returned by getElasticIp.
     */
    public suspend fun getElasticIp(
        filters: List<GetElasticIpFilter>? = null,
        id: String? = null,
        publicIp: String? = null,
        tags: Map<String, String>? = null,
    ): GetElasticIpResult {
        val argument = GetElasticIpPlainArgs(
            filters = filters,
            id = id,
            publicIp = publicIp,
            tags = tags,
        )
        return getElasticIpResultToKotlin(getElasticIpPlain(argument.toJava()).await())
    }

    /**
     * @see [getElasticIp].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetElasticIpPlainArgs].
     * @return A collection of values returned by getElasticIp.
     */
    public suspend fun getElasticIp(argument: suspend GetElasticIpPlainArgsBuilder.() -> Unit):
        GetElasticIpResult {
        val builder = GetElasticIpPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getElasticIpResultToKotlin(getElasticIpPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ID of an Amazon EC2 Instance for use in other resources.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetInstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = Ec2Functions.getInstance(GetInstanceArgs.builder()
     *             .filters(
     *                 GetInstanceFilterArgs.builder()
     *                     .name("image-id")
     *                     .values("ami-xxxxxxxx")
     *                     .build(),
     *                 GetInstanceFilterArgs.builder()
     *                     .name("tag:Name")
     *                     .values("instance-name-tag")
     *                     .build())
     *             .instanceId("i-instanceid")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstance.
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(argument: GetInstancePlainArgs): GetInstanceResult =
        getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())

    /**
     * @see [getInstance].
     * @param filters One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [describe-instances in the AWS CLI reference][1].
     * @param getPasswordData If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     * @param getUserData Retrieve Base64 encoded User Data contents into the `user_data_base64` attribute. A SHA-1 hash of the User Data contents will always be present in the `user_data` attribute. Defaults to `false`.
     * > **NOTE:** At least one of `filter`, `instance_tags`, or `instance_id` must be specified.
     * > **NOTE:** If anything other than a single match is returned by the search,
     * this call will fail. Ensure that your search is specific enough to return
     * a single Instance ID only.
     * @param instanceId Specify the exact Instance ID with which to populate the data source.
     * @param instanceTags Map of tags, each pair of which must
     * exactly match a pair on the desired Instance.
     * @param tags Map of tags assigned to the Instance.
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(
        filters: List<GetInstanceFilter>? = null,
        getPasswordData: Boolean? = null,
        getUserData: Boolean? = null,
        instanceId: String? = null,
        instanceTags: Map<String, String>? = null,
        tags: Map<String, String>? = null,
    ): GetInstanceResult {
        val argument = GetInstancePlainArgs(
            filters = filters,
            getPasswordData = getPasswordData,
            getUserData = getUserData,
            instanceId = instanceId,
            instanceTags = instanceTags,
            tags = tags,
        )
        return getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getInstance].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetInstancePlainArgs].
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(argument: suspend GetInstancePlainArgsBuilder.() -> Unit):
        GetInstanceResult {
        val builder = GetInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceResultToKotlin(getInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Get characteristics for a single EC2 Instance Type.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetInstanceTypeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getInstanceType(GetInstanceTypeArgs.builder()
     *             .instanceType("t2.micro")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstanceType.
     * @return A collection of values returned by getInstanceType.
     */
    public suspend fun getInstanceType(argument: GetInstanceTypePlainArgs): GetInstanceTypeResult =
        getInstanceTypeResultToKotlin(getInstanceTypePlain(argument.toJava()).await())

    /**
     * @see [getInstanceType].
     * @param instanceType Instance
     * @return A collection of values returned by getInstanceType.
     */
    public suspend fun getInstanceType(instanceType: String): GetInstanceTypeResult {
        val argument = GetInstanceTypePlainArgs(
            instanceType = instanceType,
        )
        return getInstanceTypeResultToKotlin(getInstanceTypePlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceType].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetInstanceTypePlainArgs].
     * @return A collection of values returned by getInstanceType.
     */
    public suspend fun getInstanceType(argument: suspend GetInstanceTypePlainArgsBuilder.() -> Unit):
        GetInstanceTypeResult {
        val builder = GetInstanceTypePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceTypeResultToKotlin(getInstanceTypePlain(builtArgument.toJava()).await())
    }

    /**
     * Information about single EC2 Instance Type Offering.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetInstanceTypeOfferingArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getInstanceTypeOffering(GetInstanceTypeOfferingArgs.builder()
     *             .filters(GetInstanceTypeOfferingFilterArgs.builder()
     *                 .name("instance-type")
     *                 .values(
     *                     "t2.micro",
     *                     "t3.micro")
     *                 .build())
     *             .preferredInstanceTypes(
     *                 "t3.micro",
     *                 "t2.micro")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstanceTypeOffering.
     * @return A collection of values returned by getInstanceTypeOffering.
     */
    public suspend fun getInstanceTypeOffering(argument: GetInstanceTypeOfferingPlainArgs):
        GetInstanceTypeOfferingResult =
        getInstanceTypeOfferingResultToKotlin(getInstanceTypeOfferingPlain(argument.toJava()).await())

    /**
     * @see [getInstanceTypeOffering].
     * @param filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
     * @param locationType Location type. Defaults to `region`. Valid values: `availability-zone`, `availability-zone-id`, and `region`.
     * @param preferredInstanceTypes Ordered list of preferred EC2 Instance Types. The first match in this list will be returned. If no preferred matches are found and the original search returned more than one result, an error is returned.
     * @return A collection of values returned by getInstanceTypeOffering.
     */
    public suspend fun getInstanceTypeOffering(
        filters: List<GetInstanceTypeOfferingFilter>? = null,
        locationType: String? = null,
        preferredInstanceTypes: List<String>? = null,
    ): GetInstanceTypeOfferingResult {
        val argument = GetInstanceTypeOfferingPlainArgs(
            filters = filters,
            locationType = locationType,
            preferredInstanceTypes = preferredInstanceTypes,
        )
        return getInstanceTypeOfferingResultToKotlin(getInstanceTypeOfferingPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceTypeOffering].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetInstanceTypeOfferingPlainArgs].
     * @return A collection of values returned by getInstanceTypeOffering.
     */
    public suspend
    fun getInstanceTypeOffering(argument: suspend GetInstanceTypeOfferingPlainArgsBuilder.() -> Unit):
        GetInstanceTypeOfferingResult {
        val builder = GetInstanceTypeOfferingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceTypeOfferingResultToKotlin(getInstanceTypeOfferingPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about EC2 Instance Type Offerings.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetInstanceTypeOfferingsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getInstanceTypeOfferings(GetInstanceTypeOfferingsArgs.builder()
     *             .filters(
     *                 GetInstanceTypeOfferingsFilterArgs.builder()
     *                     .name("instance-type")
     *                     .values(
     *                         "t2.micro",
     *                         "t3.micro")
     *                     .build(),
     *                 GetInstanceTypeOfferingsFilterArgs.builder()
     *                     .name("location")
     *                     .values("usw2-az4")
     *                     .build())
     *             .locationType("availability-zone-id")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstanceTypeOfferings.
     * @return A collection of values returned by getInstanceTypeOfferings.
     */
    public suspend fun getInstanceTypeOfferings(argument: GetInstanceTypeOfferingsPlainArgs):
        GetInstanceTypeOfferingsResult =
        getInstanceTypeOfferingsResultToKotlin(getInstanceTypeOfferingsPlain(argument.toJava()).await())

    /**
     * @see [getInstanceTypeOfferings].
     * @param filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypeOfferings.html) for supported filters. Detailed below.
     * @param locationType Location type. Defaults to `region`. Valid values: `availability-zone`, `availability-zone-id`, and `region`.
     * @return A collection of values returned by getInstanceTypeOfferings.
     */
    public suspend fun getInstanceTypeOfferings(
        filters: List<GetInstanceTypeOfferingsFilter>? = null,
        locationType: String? = null,
    ): GetInstanceTypeOfferingsResult {
        val argument = GetInstanceTypeOfferingsPlainArgs(
            filters = filters,
            locationType = locationType,
        )
        return getInstanceTypeOfferingsResultToKotlin(getInstanceTypeOfferingsPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceTypeOfferings].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetInstanceTypeOfferingsPlainArgs].
     * @return A collection of values returned by getInstanceTypeOfferings.
     */
    public suspend
    fun getInstanceTypeOfferings(argument: suspend GetInstanceTypeOfferingsPlainArgsBuilder.() -> Unit):
        GetInstanceTypeOfferingsResult {
        val builder = GetInstanceTypeOfferingsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceTypeOfferingsResultToKotlin(getInstanceTypeOfferingsPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about EC2 Instance Types.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetInstanceTypesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getInstanceTypes(GetInstanceTypesArgs.builder()
     *             .filters(
     *                 GetInstanceTypesFilterArgs.builder()
     *                     .name("auto-recovery-supported")
     *                     .values("true")
     *                     .build(),
     *                 GetInstanceTypesFilterArgs.builder()
     *                     .name("network-info.encryption-in-transit-supported")
     *                     .values("true")
     *                     .build(),
     *                 GetInstanceTypesFilterArgs.builder()
     *                     .name("instance-storage-supported")
     *                     .values("true")
     *                     .build(),
     *                 GetInstanceTypesFilterArgs.builder()
     *                     .name("instance-type")
     *                     .values(
     *                         "g5.2xlarge",
     *                         "g5.4xlarge")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstanceTypes.
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend fun getInstanceTypes(argument: GetInstanceTypesPlainArgs): GetInstanceTypesResult =
        getInstanceTypesResultToKotlin(getInstanceTypesPlain(argument.toJava()).await())

    /**
     * @see [getInstanceTypes].
     * @param filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstanceTypes.html) for supported filters. Detailed below.
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend fun getInstanceTypes(filters: List<GetInstanceTypesFilter>? = null):
        GetInstanceTypesResult {
        val argument = GetInstanceTypesPlainArgs(
            filters = filters,
        )
        return getInstanceTypesResultToKotlin(getInstanceTypesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceTypes].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetInstanceTypesPlainArgs].
     * @return A collection of values returned by getInstanceTypes.
     */
    public suspend
    fun getInstanceTypes(argument: suspend GetInstanceTypesPlainArgsBuilder.() -> Unit):
        GetInstanceTypesResult {
        val builder = GetInstanceTypesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceTypesResultToKotlin(getInstanceTypesPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get IDs or IPs of Amazon EC2 instances to be referenced elsewhere,
     * e.g., to allow easier migration from another management solution
     * or to make it easier for an operator to connect through bastion host(s).
     * > **Note:** It's strongly discouraged to use this data source for querying ephemeral
     * instances (e.g., managed via autoscaling group), as the output may change at any time
     * and you'd need to re-run `apply` every time an instance comes up or dies.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetInstancesArgs;
     * import com.pulumi.aws.ec2.Eip;
     * import com.pulumi.aws.ec2.EipArgs;
     * import com.pulumi.codegen.internal.KeyedValue;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var testInstances = Ec2Functions.getInstances(GetInstancesArgs.builder()
     *             .instanceTags(Map.of("Role", "HardWorker"))
     *             .filters(GetInstancesFilterArgs.builder()
     *                 .name("instance.group-id")
     *                 .values("sg-12345678")
     *                 .build())
     *             .instanceStateNames(
     *                 "running",
     *                 "stopped")
     *             .build());
     *         for (var i = 0; i < testInstances.applyValue(getInstancesResult -> getInstancesResult.ids()).length(); i++) {
     *             new Eip("testEip-" + i, EipArgs.builder()
     *                 .instance(testInstances.applyValue(getInstancesResult -> getInstancesResult.ids())[range.value()])
     *                 .build());
     * }
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param filters One or more name/value pairs to use as filters. There are
     * several valid keys, for a full reference, check out
     * [describe-instances in the AWS CLI reference][1].
     * @param instanceStateNames List of instance states that should be applicable to the desired instances. The permitted values are: `pending, running, shutting-down, stopped, stopping, terminated`. The default value is `running`.
     * @param instanceTags Map of tags, each pair of which must
     * exactly match a pair on desired instances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        filters: List<GetInstancesFilter>? = null,
        instanceStateNames: List<String>? = null,
        instanceTags: Map<String, String>? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            filters = filters,
            instanceStateNames = instanceStateNames,
            instanceTags = instanceTags,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit):
        GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.InternetGateway` provides details about a specific Internet Gateway.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetInternetGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var vpcId = config.get("vpcId");
     *         final var default = Ec2Functions.getInternetGateway(GetInternetGatewayArgs.builder()
     *             .filters(GetInternetGatewayFilterArgs.builder()
     *                 .name("attachment.vpc-id")
     *                 .values(vpcId)
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getInternetGateway.
     * @return A collection of values returned by getInternetGateway.
     */
    public suspend fun getInternetGateway(argument: GetInternetGatewayPlainArgs):
        GetInternetGatewayResult =
        getInternetGatewayResultToKotlin(getInternetGatewayPlain(argument.toJava()).await())

    /**
     * @see [getInternetGateway].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param internetGatewayId ID of the specific Internet Gateway to retrieve.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired Internet Gateway.
     * @return A collection of values returned by getInternetGateway.
     */
    public suspend fun getInternetGateway(
        filters: List<GetInternetGatewayFilter>? = null,
        internetGatewayId: String? = null,
        tags: Map<String, String>? = null,
    ): GetInternetGatewayResult {
        val argument = GetInternetGatewayPlainArgs(
            filters = filters,
            internetGatewayId = internetGatewayId,
            tags = tags,
        )
        return getInternetGatewayResultToKotlin(getInternetGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getInternetGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetInternetGatewayPlainArgs].
     * @return A collection of values returned by getInternetGateway.
     */
    public suspend
    fun getInternetGateway(argument: suspend GetInternetGatewayPlainArgsBuilder.() -> Unit):
        GetInternetGatewayResult {
        val builder = GetInternetGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInternetGatewayResultToKotlin(getInternetGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Previews a CIDR from an IPAM address pool. Only works for private IPv4.
     * > **NOTE:** This functionality is also encapsulated in a resource sharing the same name. The data source can be used when you need to use the cidr in a calculation of the same Root module, `count` for example. However, once a cidr range has been allocated that was previewed, the next refresh will find a **new** cidr and may force new resources downstream. Make sure to use `ignore_changes` if this is undesirable.
     * ## Example Usage
     * Basic usage:
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetIpamPreviewNextCidrArgs;
     * import com.pulumi.aws.ec2.VpcIpamPoolCidrAllocation;
     * import com.pulumi.aws.ec2.VpcIpamPoolCidrAllocationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var testIpamPreviewNextCidr = Ec2Functions.getIpamPreviewNextCidr(GetIpamPreviewNextCidrArgs.builder()
     *             .ipamPoolId(aws_vpc_ipam_pool.test().id())
     *             .netmaskLength(28)
     *             .build());
     *         var testVpcIpamPoolCidrAllocation = new VpcIpamPoolCidrAllocation("testVpcIpamPoolCidrAllocation", VpcIpamPoolCidrAllocationArgs.builder()
     *             .ipamPoolId(aws_vpc_ipam_pool.test().id())
     *             .cidr(testIpamPreviewNextCidr.applyValue(getIpamPreviewNextCidrResult -> getIpamPreviewNextCidrResult.cidr()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getIpamPreviewNextCidr.
     * @return A collection of values returned by getIpamPreviewNextCidr.
     */
    public suspend fun getIpamPreviewNextCidr(argument: GetIpamPreviewNextCidrPlainArgs):
        GetIpamPreviewNextCidrResult =
        getIpamPreviewNextCidrResultToKotlin(getIpamPreviewNextCidrPlain(argument.toJava()).await())

    /**
     * @see [getIpamPreviewNextCidr].
     * @param disallowedCidrs Exclude a particular CIDR range from being returned by the pool.
     * @param ipamPoolId ID of the pool to which you want to assign a CIDR.
     * @param netmaskLength Netmask length of the CIDR you would like to preview from the IPAM pool.
     * @return A collection of values returned by getIpamPreviewNextCidr.
     */
    public suspend fun getIpamPreviewNextCidr(
        disallowedCidrs: List<String>? = null,
        ipamPoolId: String,
        netmaskLength: Int? = null,
    ): GetIpamPreviewNextCidrResult {
        val argument = GetIpamPreviewNextCidrPlainArgs(
            disallowedCidrs = disallowedCidrs,
            ipamPoolId = ipamPoolId,
            netmaskLength = netmaskLength,
        )
        return getIpamPreviewNextCidrResultToKotlin(getIpamPreviewNextCidrPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpamPreviewNextCidr].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetIpamPreviewNextCidrPlainArgs].
     * @return A collection of values returned by getIpamPreviewNextCidr.
     */
    public suspend
    fun getIpamPreviewNextCidr(argument: suspend GetIpamPreviewNextCidrPlainArgsBuilder.() -> Unit):
        GetIpamPreviewNextCidrResult {
        val builder = GetIpamPreviewNextCidrPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpamPreviewNextCidrResultToKotlin(getIpamPreviewNextCidrPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a specific EC2 Key Pair.
     * ## Example Usage
     * The following example shows how to get a EC2 Key Pair including the public key material from its name.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetKeyPairArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getKeyPair(GetKeyPairArgs.builder()
     *             .keyName("test")
     *             .includePublicKey(true)
     *             .filters(GetKeyPairFilterArgs.builder()
     *                 .name("tag:Component")
     *                 .values("web")
     *                 .build())
     *             .build());
     *         ctx.export("fingerprint", example.applyValue(getKeyPairResult -> getKeyPairResult.fingerprint()));
     *         ctx.export("name", example.applyValue(getKeyPairResult -> getKeyPairResult.keyName()));
     *         ctx.export("id", example.applyValue(getKeyPairResult -> getKeyPairResult.id()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getKeyPair.
     * @return A collection of values returned by getKeyPair.
     */
    public suspend fun getKeyPair(argument: GetKeyPairPlainArgs): GetKeyPairResult =
        getKeyPairResultToKotlin(getKeyPairPlain(argument.toJava()).await())

    /**
     * @see [getKeyPair].
     * @param filters Custom filter block as described below.
     * @param includePublicKey Whether to include the public key material in the response.
     * @param keyName Key Pair name.
     * @param keyPairId Key Pair ID.
     * @param tags Any tags assigned to the Key Pair.
     * @return A collection of values returned by getKeyPair.
     */
    public suspend fun getKeyPair(
        filters: List<GetKeyPairFilter>? = null,
        includePublicKey: Boolean? = null,
        keyName: String? = null,
        keyPairId: String? = null,
        tags: Map<String, String>? = null,
    ): GetKeyPairResult {
        val argument = GetKeyPairPlainArgs(
            filters = filters,
            includePublicKey = includePublicKey,
            keyName = keyName,
            keyPairId = keyPairId,
            tags = tags,
        )
        return getKeyPairResultToKotlin(getKeyPairPlain(argument.toJava()).await())
    }

    /**
     * @see [getKeyPair].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetKeyPairPlainArgs].
     * @return A collection of values returned by getKeyPair.
     */
    public suspend fun getKeyPair(argument: suspend GetKeyPairPlainArgsBuilder.() -> Unit):
        GetKeyPairResult {
        val builder = GetKeyPairPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKeyPairResultToKotlin(getKeyPairPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a Launch Configuration.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLaunchConfigurationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ubuntu = Ec2Functions.getLaunchConfiguration(GetLaunchConfigurationArgs.builder()
     *             .name("test-launch-config")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLaunchConfiguration.
     * @return A collection of values returned by getLaunchConfiguration.
     */
    public suspend fun getLaunchConfiguration(argument: GetLaunchConfigurationPlainArgs):
        GetLaunchConfigurationResult =
        getLaunchConfigurationResultToKotlin(getLaunchConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getLaunchConfiguration].
     * @param name Name of the launch configuration.
     * @return A collection of values returned by getLaunchConfiguration.
     */
    public suspend fun getLaunchConfiguration(name: String): GetLaunchConfigurationResult {
        val argument = GetLaunchConfigurationPlainArgs(
            name = name,
        )
        return getLaunchConfigurationResultToKotlin(getLaunchConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getLaunchConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLaunchConfigurationPlainArgs].
     * @return A collection of values returned by getLaunchConfiguration.
     */
    public suspend
    fun getLaunchConfiguration(argument: suspend GetLaunchConfigurationPlainArgsBuilder.() -> Unit):
        GetLaunchConfigurationResult {
        val builder = GetLaunchConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLaunchConfigurationResultToKotlin(getLaunchConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a Launch Template.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLaunchTemplateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = Ec2Functions.getLaunchTemplate(GetLaunchTemplateArgs.builder()
     *             .name("my-launch-template")
     *             .build());
     *     }
     * }
     * ```
     * ### Filter
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLaunchTemplateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getLaunchTemplate(GetLaunchTemplateArgs.builder()
     *             .filters(GetLaunchTemplateFilterArgs.builder()
     *                 .name("launch-template-name")
     *                 .values("some-template")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLaunchTemplate.
     * @return A collection of values returned by getLaunchTemplate.
     */
    public suspend fun getLaunchTemplate(argument: GetLaunchTemplatePlainArgs):
        GetLaunchTemplateResult =
        getLaunchTemplateResultToKotlin(getLaunchTemplatePlain(argument.toJava()).await())

    /**
     * @see [getLaunchTemplate].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param id ID of the specific launch template to retrieve.
     * @param name Name of the launch template.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired Launch Template.
     * @return A collection of values returned by getLaunchTemplate.
     */
    public suspend fun getLaunchTemplate(
        filters: List<GetLaunchTemplateFilter>? = null,
        id: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetLaunchTemplateResult {
        val argument = GetLaunchTemplatePlainArgs(
            filters = filters,
            id = id,
            name = name,
            tags = tags,
        )
        return getLaunchTemplateResultToKotlin(getLaunchTemplatePlain(argument.toJava()).await())
    }

    /**
     * @see [getLaunchTemplate].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLaunchTemplatePlainArgs].
     * @return A collection of values returned by getLaunchTemplate.
     */
    public suspend
    fun getLaunchTemplate(argument: suspend GetLaunchTemplatePlainArgsBuilder.() -> Unit):
        GetLaunchTemplateResult {
        val builder = GetLaunchTemplatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLaunchTemplateResultToKotlin(getLaunchTemplatePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an EC2 Local Gateway.
     * ## Example Usage
     * The following example shows how one might accept a local gateway id as a variable.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLocalGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var localGatewayId = config.get("localGatewayId");
     *         final var selected = Ec2Functions.getLocalGateway(GetLocalGatewayArgs.builder()
     *             .id(localGatewayId)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLocalGateway.
     * @return A collection of values returned by getLocalGateway.
     */
    public suspend fun getLocalGateway(argument: GetLocalGatewayPlainArgs): GetLocalGatewayResult =
        getLocalGatewayResultToKotlin(getLocalGatewayPlain(argument.toJava()).await())

    /**
     * @see [getLocalGateway].
     * @param filters Custom filter block as described below.
     * @param id Id of the specific Local Gateway to retrieve.
     * @param state Current state of the desired Local Gateway.
     * Can be either `"pending"` or `"available"`.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired Local Gateway.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getLocalGateway.
     */
    public suspend fun getLocalGateway(
        filters: List<GetLocalGatewayFilter>? = null,
        id: String? = null,
        state: String? = null,
        tags: Map<String, String>? = null,
    ): GetLocalGatewayResult {
        val argument = GetLocalGatewayPlainArgs(
            filters = filters,
            id = id,
            state = state,
            tags = tags,
        )
        return getLocalGatewayResultToKotlin(getLocalGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLocalGatewayPlainArgs].
     * @return A collection of values returned by getLocalGateway.
     */
    public suspend fun getLocalGateway(argument: suspend GetLocalGatewayPlainArgsBuilder.() -> Unit):
        GetLocalGatewayResult {
        val builder = GetLocalGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalGatewayResultToKotlin(getLocalGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an EC2 Local Gateway Route Table.
     * This data source can prove useful when a module accepts a local gateway route table id as
     * an input variable and needs to, for example, find the associated Outpost or Local Gateway.
     * ## Example Usage
     * The following example returns a specific local gateway route table ID
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLocalGatewayRouteTableArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var awsEc2LocalGatewayRouteTable = config.get("awsEc2LocalGatewayRouteTable");
     *         final var selected = Ec2Functions.getLocalGatewayRouteTable(GetLocalGatewayRouteTableArgs.builder()
     *             .localGatewayRouteTableId(awsEc2LocalGatewayRouteTable)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLocalGatewayRouteTable.
     * @return A collection of values returned by getLocalGatewayRouteTable.
     */
    public suspend fun getLocalGatewayRouteTable(argument: GetLocalGatewayRouteTablePlainArgs):
        GetLocalGatewayRouteTableResult =
        getLocalGatewayRouteTableResultToKotlin(getLocalGatewayRouteTablePlain(argument.toJava()).await())

    /**
     * @see [getLocalGatewayRouteTable].
     * @param filters
     * @param localGatewayId ID of the specific local gateway route table to retrieve.
     * @param localGatewayRouteTableId Local Gateway Route Table Id assigned to desired local gateway route table
     * @param outpostArn ARN of the Outpost the local gateway route table is associated with.
     * @param state State of the local gateway route table.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired local gateway route table.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getLocalGatewayRouteTable.
     */
    public suspend fun getLocalGatewayRouteTable(
        filters: List<GetLocalGatewayRouteTableFilter>? = null,
        localGatewayId: String? = null,
        localGatewayRouteTableId: String? = null,
        outpostArn: String? = null,
        state: String? = null,
        tags: Map<String, String>? = null,
    ): GetLocalGatewayRouteTableResult {
        val argument = GetLocalGatewayRouteTablePlainArgs(
            filters = filters,
            localGatewayId = localGatewayId,
            localGatewayRouteTableId = localGatewayRouteTableId,
            outpostArn = outpostArn,
            state = state,
            tags = tags,
        )
        return getLocalGatewayRouteTableResultToKotlin(getLocalGatewayRouteTablePlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalGatewayRouteTable].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLocalGatewayRouteTablePlainArgs].
     * @return A collection of values returned by getLocalGatewayRouteTable.
     */
    public suspend
    fun getLocalGatewayRouteTable(argument: suspend GetLocalGatewayRouteTablePlainArgsBuilder.() -> Unit):
        GetLocalGatewayRouteTableResult {
        val builder = GetLocalGatewayRouteTablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalGatewayRouteTableResultToKotlin(getLocalGatewayRouteTablePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information for multiple EC2 Local Gateway Route Tables, such as their identifiers.
     * ## Example Usage
     * The following shows outputting all Local Gateway Route Table Ids.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLocalGatewayRouteTablesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var fooLocalGatewayRouteTables = Ec2Functions.getLocalGatewayRouteTables();
     *         ctx.export("foo", fooLocalGatewayRouteTables.applyValue(getLocalGatewayRouteTablesResult -> getLocalGatewayRouteTablesResult.ids()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLocalGatewayRouteTables.
     * @return A collection of values returned by getLocalGatewayRouteTables.
     */
    public suspend fun getLocalGatewayRouteTables(argument: GetLocalGatewayRouteTablesPlainArgs):
        GetLocalGatewayRouteTablesResult =
        getLocalGatewayRouteTablesResultToKotlin(getLocalGatewayRouteTablesPlain(argument.toJava()).await())

    /**
     * @see [getLocalGatewayRouteTables].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired local gateway route table.
     * @return A collection of values returned by getLocalGatewayRouteTables.
     */
    public suspend fun getLocalGatewayRouteTables(
        filters: List<GetLocalGatewayRouteTablesFilter>? =
            null,
        tags: Map<String, String>? = null,
    ): GetLocalGatewayRouteTablesResult {
        val argument = GetLocalGatewayRouteTablesPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getLocalGatewayRouteTablesResultToKotlin(getLocalGatewayRouteTablesPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalGatewayRouteTables].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLocalGatewayRouteTablesPlainArgs].
     * @return A collection of values returned by getLocalGatewayRouteTables.
     */
    public suspend
    fun getLocalGatewayRouteTables(argument: suspend GetLocalGatewayRouteTablesPlainArgsBuilder.() -> Unit):
        GetLocalGatewayRouteTablesResult {
        val builder = GetLocalGatewayRouteTablesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalGatewayRouteTablesResultToKotlin(getLocalGatewayRouteTablesPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an EC2 Local Gateway Virtual Interface. More information can be found in the [Outposts User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#routing).
     * ## Example Usage
     * No Java example available.
     * @param argument A collection of arguments for invoking getLocalGatewayVirtualInterface.
     * @return A collection of values returned by getLocalGatewayVirtualInterface.
     */
    public suspend
    fun getLocalGatewayVirtualInterface(argument: GetLocalGatewayVirtualInterfacePlainArgs):
        GetLocalGatewayVirtualInterfaceResult =
        getLocalGatewayVirtualInterfaceResultToKotlin(getLocalGatewayVirtualInterfacePlain(argument.toJava()).await())

    /**
     * @see [getLocalGatewayVirtualInterface].
     * @param filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaces.html) for supported filters. Detailed below.
     * @param id Identifier of EC2 Local Gateway Virtual Interface.
     * @param tags Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
     * @return A collection of values returned by getLocalGatewayVirtualInterface.
     */
    public suspend fun getLocalGatewayVirtualInterface(
        filters: List<GetLocalGatewayVirtualInterfaceFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetLocalGatewayVirtualInterfaceResult {
        val argument = GetLocalGatewayVirtualInterfacePlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getLocalGatewayVirtualInterfaceResultToKotlin(getLocalGatewayVirtualInterfacePlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalGatewayVirtualInterface].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLocalGatewayVirtualInterfacePlainArgs].
     * @return A collection of values returned by getLocalGatewayVirtualInterface.
     */
    public suspend
    fun getLocalGatewayVirtualInterface(argument: suspend GetLocalGatewayVirtualInterfacePlainArgsBuilder.() -> Unit):
        GetLocalGatewayVirtualInterfaceResult {
        val builder = GetLocalGatewayVirtualInterfacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalGatewayVirtualInterfaceResultToKotlin(getLocalGatewayVirtualInterfacePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about an EC2 Local Gateway Virtual Interface Group. More information can be found in the [Outposts User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#routing).
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getLocalGatewayVirtualInterfaceGroup(GetLocalGatewayVirtualInterfaceGroupArgs.builder()
     *             .localGatewayId(data.aws_ec2_local_gateway().example().id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLocalGatewayVirtualInterfaceGroup.
     * @return A collection of values returned by getLocalGatewayVirtualInterfaceGroup.
     */
    public suspend
    fun getLocalGatewayVirtualInterfaceGroup(argument: GetLocalGatewayVirtualInterfaceGroupPlainArgs):
        GetLocalGatewayVirtualInterfaceGroupResult =
        getLocalGatewayVirtualInterfaceGroupResultToKotlin(getLocalGatewayVirtualInterfaceGroupPlain(argument.toJava()).await())

    /**
     * @see [getLocalGatewayVirtualInterfaceGroup].
     * @param filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
     * @param id Identifier of EC2 Local Gateway Virtual Interface Group.
     * @param localGatewayId Identifier of EC2 Local Gateway.
     * @param tags Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
     * @return A collection of values returned by getLocalGatewayVirtualInterfaceGroup.
     */
    public suspend fun getLocalGatewayVirtualInterfaceGroup(
        filters: List<GetLocalGatewayVirtualInterfaceGroupFilter>? = null,
        id: String? = null,
        localGatewayId: String? = null,
        tags: Map<String, String>? = null,
    ): GetLocalGatewayVirtualInterfaceGroupResult {
        val argument = GetLocalGatewayVirtualInterfaceGroupPlainArgs(
            filters = filters,
            id = id,
            localGatewayId = localGatewayId,
            tags = tags,
        )
        return getLocalGatewayVirtualInterfaceGroupResultToKotlin(getLocalGatewayVirtualInterfaceGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalGatewayVirtualInterfaceGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLocalGatewayVirtualInterfaceGroupPlainArgs].
     * @return A collection of values returned by getLocalGatewayVirtualInterfaceGroup.
     */
    public suspend
    fun getLocalGatewayVirtualInterfaceGroup(argument: suspend GetLocalGatewayVirtualInterfaceGroupPlainArgsBuilder.() -> Unit):
        GetLocalGatewayVirtualInterfaceGroupResult {
        val builder = GetLocalGatewayVirtualInterfaceGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalGatewayVirtualInterfaceGroupResultToKotlin(getLocalGatewayVirtualInterfaceGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about multiple EC2 Local Gateway Virtual Interface Groups, such as identifiers. More information can be found in the [Outposts User Guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#routing).
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLocalGatewayVirtualInterfaceGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var all = Ec2Functions.getLocalGatewayVirtualInterfaceGroups();
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLocalGatewayVirtualInterfaceGroups.
     * @return A collection of values returned by getLocalGatewayVirtualInterfaceGroups.
     */
    public suspend
    fun getLocalGatewayVirtualInterfaceGroups(argument: GetLocalGatewayVirtualInterfaceGroupsPlainArgs):
        GetLocalGatewayVirtualInterfaceGroupsResult =
        getLocalGatewayVirtualInterfaceGroupsResultToKotlin(getLocalGatewayVirtualInterfaceGroupsPlain(argument.toJava()).await())

    /**
     * @see [getLocalGatewayVirtualInterfaceGroups].
     * @param filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLocalGatewayVirtualInterfaceGroups.html) for supported filters. Detailed below.
     * @param tags Key-value map of resource tags, each pair of which must exactly match a pair on the desired local gateway route table.
     * @return A collection of values returned by getLocalGatewayVirtualInterfaceGroups.
     */
    public suspend
    fun getLocalGatewayVirtualInterfaceGroups(
        filters: List<GetLocalGatewayVirtualInterfaceGroupsFilter>? =
            null,
        tags: Map<String, String>? = null,
    ): GetLocalGatewayVirtualInterfaceGroupsResult {
        val argument = GetLocalGatewayVirtualInterfaceGroupsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getLocalGatewayVirtualInterfaceGroupsResultToKotlin(getLocalGatewayVirtualInterfaceGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalGatewayVirtualInterfaceGroups].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLocalGatewayVirtualInterfaceGroupsPlainArgs].
     * @return A collection of values returned by getLocalGatewayVirtualInterfaceGroups.
     */
    public suspend
    fun getLocalGatewayVirtualInterfaceGroups(argument: suspend GetLocalGatewayVirtualInterfaceGroupsPlainArgsBuilder.() -> Unit):
        GetLocalGatewayVirtualInterfaceGroupsResult {
        val builder = GetLocalGatewayVirtualInterfaceGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalGatewayVirtualInterfaceGroupsResultToKotlin(getLocalGatewayVirtualInterfaceGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information for multiple EC2 Local Gateways, such as their identifiers.
     * ## Example Usage
     * The following example retrieves Local Gateways with a resource tag of `service` set to `production`.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetLocalGatewaysArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var fooLocalGateways = Ec2Functions.getLocalGateways(GetLocalGatewaysArgs.builder()
     *             .tags(Map.of("service", "production"))
     *             .build());
     *         ctx.export("foo", fooLocalGateways.applyValue(getLocalGatewaysResult -> getLocalGatewaysResult.ids()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLocalGateways.
     * @return A collection of values returned by getLocalGateways.
     */
    public suspend fun getLocalGateways(argument: GetLocalGatewaysPlainArgs): GetLocalGatewaysResult =
        getLocalGatewaysResultToKotlin(getLocalGatewaysPlain(argument.toJava()).await())

    /**
     * @see [getLocalGateways].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired local_gateways.
     * @return A collection of values returned by getLocalGateways.
     */
    public suspend fun getLocalGateways(
        filters: List<GetLocalGatewaysFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetLocalGatewaysResult {
        val argument = GetLocalGatewaysPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getLocalGatewaysResultToKotlin(getLocalGatewaysPlain(argument.toJava()).await())
    }

    /**
     * @see [getLocalGateways].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetLocalGatewaysPlainArgs].
     * @return A collection of values returned by getLocalGateways.
     */
    public suspend
    fun getLocalGateways(argument: suspend GetLocalGatewaysPlainArgsBuilder.() -> Unit):
        GetLocalGatewaysResult {
        val builder = GetLocalGatewaysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLocalGatewaysResultToKotlin(getLocalGatewaysPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.ManagedPrefixList` provides details about a specific AWS prefix list or
     * customer-managed prefix list in the current region.
     * ## Example Usage
     * ### Find the regional DynamoDB prefix list
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.AwsFunctions;
     * import com.pulumi.aws.inputs.GetRegionArgs;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetManagedPrefixListArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = AwsFunctions.getRegion();
     *         final var example = Ec2Functions.getManagedPrefixList(GetManagedPrefixListArgs.builder()
     *             .name(String.format("com.amazonaws.%s.dynamodb", current.applyValue(getRegionResult -> getRegionResult.name())))
     *             .build());
     *     }
     * }
     * ```
     * ### Find a managed prefix list using filters
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetManagedPrefixListArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getManagedPrefixList(GetManagedPrefixListArgs.builder()
     *             .filters(GetManagedPrefixListFilterArgs.builder()
     *                 .name("prefix-list-name")
     *                 .values("my-prefix-list")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getManagedPrefixList.
     * @return A collection of values returned by getManagedPrefixList.
     */
    public suspend fun getManagedPrefixList(argument: GetManagedPrefixListPlainArgs):
        GetManagedPrefixListResult =
        getManagedPrefixListResultToKotlin(getManagedPrefixListPlain(argument.toJava()).await())

    /**
     * @see [getManagedPrefixList].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param id ID of the prefix list to select.
     * @param name Name of the prefix list to select.
     * @param tags Map of tags assigned to the resource.
     * @return A collection of values returned by getManagedPrefixList.
     */
    public suspend fun getManagedPrefixList(
        filters: List<GetManagedPrefixListFilter>? = null,
        id: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetManagedPrefixListResult {
        val argument = GetManagedPrefixListPlainArgs(
            filters = filters,
            id = id,
            name = name,
            tags = tags,
        )
        return getManagedPrefixListResultToKotlin(getManagedPrefixListPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedPrefixList].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetManagedPrefixListPlainArgs].
     * @return A collection of values returned by getManagedPrefixList.
     */
    public suspend
    fun getManagedPrefixList(argument: suspend GetManagedPrefixListPlainArgsBuilder.() -> Unit):
        GetManagedPrefixListResult {
        val builder = GetManagedPrefixListPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedPrefixListResultToKotlin(getManagedPrefixListPlain(builtArgument.toJava()).await())
    }

    /**
     * This resource can be useful for getting back a list of managed prefix list ids to be referenced elsewhere.
     * @param argument A collection of arguments for invoking getManagedPrefixLists.
     * @return A collection of values returned by getManagedPrefixLists.
     */
    public suspend fun getManagedPrefixLists(argument: GetManagedPrefixListsPlainArgs):
        GetManagedPrefixListsResult =
        getManagedPrefixListsResultToKotlin(getManagedPrefixListsPlain(argument.toJava()).await())

    /**
     * @see [getManagedPrefixLists].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired .
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getManagedPrefixLists.
     */
    public suspend fun getManagedPrefixLists(
        filters: List<GetManagedPrefixListsFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetManagedPrefixListsResult {
        val argument = GetManagedPrefixListsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getManagedPrefixListsResultToKotlin(getManagedPrefixListsPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedPrefixLists].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetManagedPrefixListsPlainArgs].
     * @return A collection of values returned by getManagedPrefixLists.
     */
    public suspend
    fun getManagedPrefixLists(argument: suspend GetManagedPrefixListsPlainArgsBuilder.() -> Unit):
        GetManagedPrefixListsResult {
        val builder = GetManagedPrefixListsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedPrefixListsResultToKotlin(getManagedPrefixListsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific VPC NAT Gateway.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNatGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = Ec2Functions.getNatGateway(GetNatGatewayArgs.builder()
     *             .subnetId(aws_subnet.public().id())
     *             .build());
     *     }
     * }
     * ```
     * ### With tags
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNatGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = Ec2Functions.getNatGateway(GetNatGatewayArgs.builder()
     *             .subnetId(aws_subnet.public().id())
     *             .tags(Map.of("Name", "gw NAT"))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getNatGateway.
     * @return A collection of values returned by getNatGateway.
     */
    public suspend fun getNatGateway(argument: GetNatGatewayPlainArgs): GetNatGatewayResult =
        getNatGatewayResultToKotlin(getNatGatewayPlain(argument.toJava()).await())

    /**
     * @see [getNatGateway].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param id ID of the specific NAT Gateway to retrieve.
     * @param state State of the NAT Gateway (pending | failed | available | deleting | deleted ).
     * @param subnetId ID of subnet that the NAT Gateway resides in.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired NAT Gateway.
     * @param vpcId ID of the VPC that the NAT Gateway resides in.
     * @return A collection of values returned by getNatGateway.
     */
    public suspend fun getNatGateway(
        filters: List<GetNatGatewayFilter>? = null,
        id: String? = null,
        state: String? = null,
        subnetId: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetNatGatewayResult {
        val argument = GetNatGatewayPlainArgs(
            filters = filters,
            id = id,
            state = state,
            subnetId = subnetId,
            tags = tags,
            vpcId = vpcId,
        )
        return getNatGatewayResultToKotlin(getNatGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getNatGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetNatGatewayPlainArgs].
     * @return A collection of values returned by getNatGateway.
     */
    public suspend fun getNatGateway(argument: suspend GetNatGatewayPlainArgsBuilder.() -> Unit):
        GetNatGatewayResult {
        val builder = GetNatGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNatGatewayResultToKotlin(getNatGatewayPlain(builtArgument.toJava()).await())
    }

    /**
     * This resource can be useful for getting back a list of NAT gateway ids to be referenced elsewhere.
     * @param argument A collection of arguments for invoking getNatGateways.
     * @return A collection of values returned by getNatGateways.
     */
    public suspend fun getNatGateways(argument: GetNatGatewaysPlainArgs): GetNatGatewaysResult =
        getNatGatewaysResultToKotlin(getNatGatewaysPlain(argument.toJava()).await())

    /**
     * @see [getNatGateways].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired NAT Gateways.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param vpcId VPC ID that you want to filter from.
     * @return A collection of values returned by getNatGateways.
     */
    public suspend fun getNatGateways(
        filters: List<GetNatGatewaysFilter>? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetNatGatewaysResult {
        val argument = GetNatGatewaysPlainArgs(
            filters = filters,
            tags = tags,
            vpcId = vpcId,
        )
        return getNatGatewaysResultToKotlin(getNatGatewaysPlain(argument.toJava()).await())
    }

    /**
     * @see [getNatGateways].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetNatGatewaysPlainArgs].
     * @return A collection of values returned by getNatGateways.
     */
    public suspend fun getNatGateways(argument: suspend GetNatGatewaysPlainArgsBuilder.() -> Unit):
        GetNatGatewaysResult {
        val builder = GetNatGatewaysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNatGatewaysResultToKotlin(getNatGatewaysPlain(builtArgument.toJava()).await())
    }

    /**
     * ## Example Usage
     * The following shows outputting all network ACL ids in a vpc.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNetworkAclsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var exampleNetworkAcls = Ec2Functions.getNetworkAcls(GetNetworkAclsArgs.builder()
     *             .vpcId(var_.vpc_id())
     *             .build());
     *         ctx.export("example", exampleNetworkAcls.applyValue(getNetworkAclsResult -> getNetworkAclsResult.ids()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getNetworkAcls.
     * @return A collection of values returned by getNetworkAcls.
     */
    public suspend fun getNetworkAcls(argument: GetNetworkAclsPlainArgs): GetNetworkAclsResult =
        getNetworkAclsResultToKotlin(getNetworkAclsPlain(argument.toJava()).await())

    /**
     * @see [getNetworkAcls].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired network ACLs.
     * @param vpcId VPC ID that you want to filter from.
     * @return A collection of values returned by getNetworkAcls.
     */
    public suspend fun getNetworkAcls(
        filters: List<GetNetworkAclsFilter>? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetNetworkAclsResult {
        val argument = GetNetworkAclsPlainArgs(
            filters = filters,
            tags = tags,
            vpcId = vpcId,
        )
        return getNetworkAclsResultToKotlin(getNetworkAclsPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkAcls].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetNetworkAclsPlainArgs].
     * @return A collection of values returned by getNetworkAcls.
     */
    public suspend fun getNetworkAcls(argument: suspend GetNetworkAclsPlainArgsBuilder.() -> Unit):
        GetNetworkAclsResult {
        val builder = GetNetworkAclsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkAclsResultToKotlin(getNetworkAclsPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.NetworkInsightsAnalysis` provides details about a specific Network Insights Analysis.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNetworkInsightsAnalysisArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getNetworkInsightsAnalysis(GetNetworkInsightsAnalysisArgs.builder()
     *             .networkInsightsAnalysisId(aws_ec2_network_insights_analysis.example().id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getNetworkInsightsAnalysis.
     * @return A collection of values returned by getNetworkInsightsAnalysis.
     */
    public suspend fun getNetworkInsightsAnalysis(argument: GetNetworkInsightsAnalysisPlainArgs):
        GetNetworkInsightsAnalysisResult =
        getNetworkInsightsAnalysisResultToKotlin(getNetworkInsightsAnalysisPlain(argument.toJava()).await())

    /**
     * @see [getNetworkInsightsAnalysis].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param networkInsightsAnalysisId ID of the Network Insights Analysis to select.
     * @param tags
     * @return A collection of values returned by getNetworkInsightsAnalysis.
     */
    public suspend fun getNetworkInsightsAnalysis(
        filters: List<GetNetworkInsightsAnalysisFilter>? = null,
        networkInsightsAnalysisId: String? = null,
        tags: Map<String, String>? = null,
    ): GetNetworkInsightsAnalysisResult {
        val argument = GetNetworkInsightsAnalysisPlainArgs(
            filters = filters,
            networkInsightsAnalysisId = networkInsightsAnalysisId,
            tags = tags,
        )
        return getNetworkInsightsAnalysisResultToKotlin(getNetworkInsightsAnalysisPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkInsightsAnalysis].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetNetworkInsightsAnalysisPlainArgs].
     * @return A collection of values returned by getNetworkInsightsAnalysis.
     */
    public suspend
    fun getNetworkInsightsAnalysis(argument: suspend GetNetworkInsightsAnalysisPlainArgsBuilder.() -> Unit):
        GetNetworkInsightsAnalysisResult {
        val builder = GetNetworkInsightsAnalysisPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkInsightsAnalysisResultToKotlin(getNetworkInsightsAnalysisPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.NetworkInsightsPath` provides details about a specific Network Insights Path.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNetworkInsightsPathArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getNetworkInsightsPath(GetNetworkInsightsPathArgs.builder()
     *             .networkInsightsPathId(aws_ec2_network_insights_path.example().id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getNetworkInsightsPath.
     * @return A collection of values returned by getNetworkInsightsPath.
     */
    public suspend fun getNetworkInsightsPath(argument: GetNetworkInsightsPathPlainArgs):
        GetNetworkInsightsPathResult =
        getNetworkInsightsPathResultToKotlin(getNetworkInsightsPathPlain(argument.toJava()).await())

    /**
     * @see [getNetworkInsightsPath].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param networkInsightsPathId ID of the Network Insights Path to select.
     * @param tags Map of tags assigned to the resource.
     * @return A collection of values returned by getNetworkInsightsPath.
     */
    public suspend fun getNetworkInsightsPath(
        filters: List<GetNetworkInsightsPathFilter>? = null,
        networkInsightsPathId: String? = null,
        tags: Map<String, String>? = null,
    ): GetNetworkInsightsPathResult {
        val argument = GetNetworkInsightsPathPlainArgs(
            filters = filters,
            networkInsightsPathId = networkInsightsPathId,
            tags = tags,
        )
        return getNetworkInsightsPathResultToKotlin(getNetworkInsightsPathPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkInsightsPath].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetNetworkInsightsPathPlainArgs].
     * @return A collection of values returned by getNetworkInsightsPath.
     */
    public suspend
    fun getNetworkInsightsPath(argument: suspend GetNetworkInsightsPathPlainArgsBuilder.() -> Unit):
        GetNetworkInsightsPathResult {
        val builder = GetNetworkInsightsPathPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkInsightsPathResultToKotlin(getNetworkInsightsPathPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a Network Interface.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNetworkInterfaceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var bar = Ec2Functions.getNetworkInterface(GetNetworkInterfaceArgs.builder()
     *             .id("eni-01234567")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getNetworkInterface.
     * @return A collection of values returned by getNetworkInterface.
     */
    public suspend fun getNetworkInterface(argument: GetNetworkInterfacePlainArgs):
        GetNetworkInterfaceResult =
        getNetworkInterfaceResultToKotlin(getNetworkInterfacePlain(argument.toJava()).await())

    /**
     * @see [getNetworkInterface].
     * @param filters One or more name/value pairs to filter off of. There are several valid keys, for a full reference, check out [describe-network-interfaces](https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-network-interfaces.html) in the AWS CLI reference.
     * @param id Identifier for the network interface.
     * @param tags Any tags assigned to the network interface.
     * @return A collection of values returned by getNetworkInterface.
     */
    public suspend fun getNetworkInterface(
        filters: List<GetNetworkInterfaceFilter>? = null,
        id: String? = null,
        tags: Map<String, String>? = null,
    ): GetNetworkInterfaceResult {
        val argument = GetNetworkInterfacePlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
        return getNetworkInterfaceResultToKotlin(getNetworkInterfacePlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkInterface].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetNetworkInterfacePlainArgs].
     * @return A collection of values returned by getNetworkInterface.
     */
    public suspend
    fun getNetworkInterface(argument: suspend GetNetworkInterfacePlainArgsBuilder.() -> Unit):
        GetNetworkInterfaceResult {
        val builder = GetNetworkInterfacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkInterfaceResultToKotlin(getNetworkInterfacePlain(builtArgument.toJava()).await())
    }

    /**
     * ## Example Usage
     * The following shows outputting all network interface ids in a region.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetNetworkInterfacesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var exampleNetworkInterfaces = Ec2Functions.getNetworkInterfaces();
     *         ctx.export("example", exampleNetworkInterfaces.applyValue(getNetworkInterfacesResult -> getNetworkInterfacesResult.ids()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getNetworkInterfaces.
     * @return A collection of values returned by getNetworkInterfaces.
     */
    public suspend fun getNetworkInterfaces(argument: GetNetworkInterfacesPlainArgs):
        GetNetworkInterfacesResult =
        getNetworkInterfacesResultToKotlin(getNetworkInterfacesPlain(argument.toJava()).await())

    /**
     * @see [getNetworkInterfaces].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired network interfaces.
     * @return A collection of values returned by getNetworkInterfaces.
     */
    public suspend fun getNetworkInterfaces(
        filters: List<GetNetworkInterfacesFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetNetworkInterfacesResult {
        val argument = GetNetworkInterfacesPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getNetworkInterfacesResultToKotlin(getNetworkInterfacesPlain(argument.toJava()).await())
    }

    /**
     * @see [getNetworkInterfaces].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetNetworkInterfacesPlainArgs].
     * @return A collection of values returned by getNetworkInterfaces.
     */
    public suspend
    fun getNetworkInterfaces(argument: suspend GetNetworkInterfacesPlainArgsBuilder.() -> Unit):
        GetNetworkInterfacesResult {
        val builder = GetNetworkInterfacesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNetworkInterfacesResultToKotlin(getNetworkInterfacesPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.getPrefixList` provides details about a specific AWS prefix list (PL)
     * in the current region.
     * This can be used both to validate a prefix list given in a variable
     * and to obtain the CIDR blocks (IP address ranges) for the associated
     * AWS service. The latter may be useful e.g., for adding network ACL
     * rules.
     * The aws.ec2.ManagedPrefixList data source is normally more appropriate to use given it can return customer-managed prefix list info, as well as additional attributes.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.VpcEndpoint;
     * import com.pulumi.aws.ec2.VpcEndpointArgs;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetPrefixListArgs;
     * import com.pulumi.aws.ec2.NetworkAcl;
     * import com.pulumi.aws.ec2.NetworkAclArgs;
     * import com.pulumi.aws.ec2.NetworkAclRule;
     * import com.pulumi.aws.ec2.NetworkAclRuleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var privateS3VpcEndpoint = new VpcEndpoint("privateS3VpcEndpoint", VpcEndpointArgs.builder()
     *             .vpcId(aws_vpc.foo().id())
     *             .serviceName("com.amazonaws.us-west-2.s3")
     *             .build());
     *         final var privateS3PrefixList = Ec2Functions.getPrefixList(GetPrefixListArgs.builder()
     *             .prefixListId(privateS3VpcEndpoint.prefixListId())
     *             .build());
     *         var bar = new NetworkAcl("bar", NetworkAclArgs.builder()
     *             .vpcId(aws_vpc.foo().id())
     *             .build());
     *         var privateS3NetworkAclRule = new NetworkAclRule("privateS3NetworkAclRule", NetworkAclRuleArgs.builder()
     *             .networkAclId(bar.id())
     *             .ruleNumber(200)
     *             .egress(false)
     *             .protocol("tcp")
     *             .ruleAction("allow")
     *             .cidrBlock(privateS3PrefixList.applyValue(getPrefixListResult -> getPrefixListResult).applyValue(privateS3PrefixList -> privateS3PrefixList.applyValue(getPrefixListResult -> getPrefixListResult.cidrBlocks()[0])))
     *             .fromPort(443)
     *             .toPort(443)
     *             .build());
     *     }
     * }
     * ```
     * ### Filter
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetPrefixListArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getPrefixList(GetPrefixListArgs.builder()
     *             .filters(GetPrefixListFilterArgs.builder()
     *                 .name("prefix-list-id")
     *                 .values("pl-68a54001")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPrefixList.
     * @return A collection of values returned by getPrefixList.
     */
    public suspend fun getPrefixList(argument: GetPrefixListPlainArgs): GetPrefixListResult =
        getPrefixListResultToKotlin(getPrefixListPlain(argument.toJava()).await())

    /**
     * @see [getPrefixList].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param name Name of the prefix list to select.
     * @param prefixListId ID of the prefix list to select.
     * @return A collection of values returned by getPrefixList.
     */
    public suspend fun getPrefixList(
        filters: List<GetPrefixListFilter>? = null,
        name: String? = null,
        prefixListId: String? = null,
    ): GetPrefixListResult {
        val argument = GetPrefixListPlainArgs(
            filters = filters,
            name = name,
            prefixListId = prefixListId,
        )
        return getPrefixListResultToKotlin(getPrefixListPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrefixList].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetPrefixListPlainArgs].
     * @return A collection of values returned by getPrefixList.
     */
    public suspend fun getPrefixList(argument: suspend GetPrefixListPlainArgsBuilder.() -> Unit):
        GetPrefixListResult {
        val builder = GetPrefixListPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrefixListResultToKotlin(getPrefixListPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides details about a specific AWS EC2 Public IPv4 Pool.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetPublicIpv4PoolArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getPublicIpv4Pool(GetPublicIpv4PoolArgs.builder()
     *             .poolId("ipv4pool-ec2-000df99cff0c1ec10")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPublicIpv4Pool.
     * @return A collection of values returned by getPublicIpv4Pool.
     */
    public suspend fun getPublicIpv4Pool(argument: GetPublicIpv4PoolPlainArgs):
        GetPublicIpv4PoolResult =
        getPublicIpv4PoolResultToKotlin(getPublicIpv4PoolPlain(argument.toJava()).await())

    /**
     * @see [getPublicIpv4Pool].
     * @param poolId AWS resource IDs of a public IPv4 pool (as a string) for which this data source will fetch detailed information.
     * @param tags Any tags for the address pool.
     * @return A collection of values returned by getPublicIpv4Pool.
     */
    public suspend fun getPublicIpv4Pool(poolId: String, tags: Map<String, String>? = null):
        GetPublicIpv4PoolResult {
        val argument = GetPublicIpv4PoolPlainArgs(
            poolId = poolId,
            tags = tags,
        )
        return getPublicIpv4PoolResultToKotlin(getPublicIpv4PoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getPublicIpv4Pool].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetPublicIpv4PoolPlainArgs].
     * @return A collection of values returned by getPublicIpv4Pool.
     */
    public suspend
    fun getPublicIpv4Pool(argument: suspend GetPublicIpv4PoolPlainArgsBuilder.() -> Unit):
        GetPublicIpv4PoolResult {
        val builder = GetPublicIpv4PoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPublicIpv4PoolResultToKotlin(getPublicIpv4PoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for getting information about AWS EC2 Public IPv4 Pools.
     * ## Example Usage
     * ### Basic Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetPublicIpv4PoolsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getPublicIpv4Pools();
     *     }
     * }
     * ```
     * ### Usage with Filter
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetPublicIpv4PoolsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getPublicIpv4Pools(GetPublicIpv4PoolsArgs.builder()
     *             .filters(GetPublicIpv4PoolsFilterArgs.builder()
     *                 .name("tag-key")
     *                 .values("ExampleTagKey")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getPublicIpv4Pools.
     * @return A collection of values returned by getPublicIpv4Pools.
     */
    public suspend fun getPublicIpv4Pools(argument: GetPublicIpv4PoolsPlainArgs):
        GetPublicIpv4PoolsResult =
        getPublicIpv4PoolsResultToKotlin(getPublicIpv4PoolsPlain(argument.toJava()).await())

    /**
     * @see [getPublicIpv4Pools].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired pools.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getPublicIpv4Pools.
     */
    public suspend fun getPublicIpv4Pools(
        filters: List<GetPublicIpv4PoolsFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetPublicIpv4PoolsResult {
        val argument = GetPublicIpv4PoolsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getPublicIpv4PoolsResultToKotlin(getPublicIpv4PoolsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPublicIpv4Pools].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetPublicIpv4PoolsPlainArgs].
     * @return A collection of values returned by getPublicIpv4Pools.
     */
    public suspend
    fun getPublicIpv4Pools(argument: suspend GetPublicIpv4PoolsPlainArgsBuilder.() -> Unit):
        GetPublicIpv4PoolsResult {
        val builder = GetPublicIpv4PoolsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPublicIpv4PoolsResultToKotlin(getPublicIpv4PoolsPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.Route` provides details about a specific Route.
     * This resource can prove useful when finding the resource associated with a CIDR. For example, finding the peering connection associated with a CIDR value.
     * ## Example Usage
     * The following example shows how one might use a CIDR value to find a network interface id and use this to create a data source of that network interface.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetRouteTableArgs;
     * import com.pulumi.aws.ec2.inputs.GetRouteArgs;
     * import com.pulumi.aws.ec2.inputs.GetNetworkInterfaceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var subnetId = config.get("subnetId");
     *         final var selected = Ec2Functions.getRouteTable(GetRouteTableArgs.builder()
     *             .subnetId(subnetId)
     *             .build());
     *         final var route = Ec2Functions.getRoute(GetRouteArgs.builder()
     *             .routeTableId(aws_route_table.selected().id())
     *             .destinationCidrBlock("10.0.1.0/24")
     *             .build());
     *         final var interface = Ec2Functions.getNetworkInterface(GetNetworkInterfaceArgs.builder()
     *             .id(route.applyValue(getRouteResult -> getRouteResult.networkInterfaceId()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRoute.
     * @return A collection of values returned by getRoute.
     */
    public suspend fun getRoute(argument: GetRoutePlainArgs): GetRouteResult =
        getRouteResultToKotlin(getRoutePlain(argument.toJava()).await())

    /**
     * @see [getRoute].
     * @param carrierGatewayId EC2 Carrier Gateway ID of the Route belonging to the Route Table.
     * @param coreNetworkArn Core network ARN of the Route belonging to the Route Table.
     * @param destinationCidrBlock CIDR block of the Route belonging to the Route Table.
     * @param destinationIpv6CidrBlock IPv6 CIDR block of the Route belonging to the Route Table.
     * @param destinationPrefixListId ID of a managed prefix list destination of the Route belonging to the Route Table.
     * @param egressOnlyGatewayId Egress Only Gateway ID of the Route belonging to the Route Table.
     * @param gatewayId Gateway ID of the Route belonging to the Route Table.
     * @param instanceId Instance ID of the Route belonging to the Route Table.
     * @param localGatewayId Local Gateway ID of the Route belonging to the Route Table.
     * @param natGatewayId NAT Gateway ID of the Route belonging to the Route Table.
     * @param networkInterfaceId Network Interface ID of the Route belonging to the Route Table.
     * @param routeTableId ID of the specific Route Table containing the Route entry.
     * The following arguments are optional:
     * @param transitGatewayId EC2 Transit Gateway ID of the Route belonging to the Route Table.
     * @param vpcPeeringConnectionId VPC Peering Connection ID of the Route belonging to the Route Table.
     * @return A collection of values returned by getRoute.
     */
    public suspend fun getRoute(
        carrierGatewayId: String? = null,
        coreNetworkArn: String? = null,
        destinationCidrBlock: String? = null,
        destinationIpv6CidrBlock: String? = null,
        destinationPrefixListId: String? = null,
        egressOnlyGatewayId: String? = null,
        gatewayId: String? = null,
        instanceId: String? = null,
        localGatewayId: String? = null,
        natGatewayId: String? = null,
        networkInterfaceId: String? = null,
        routeTableId: String,
        transitGatewayId: String? = null,
        vpcPeeringConnectionId: String? = null,
    ): GetRouteResult {
        val argument = GetRoutePlainArgs(
            carrierGatewayId = carrierGatewayId,
            coreNetworkArn = coreNetworkArn,
            destinationCidrBlock = destinationCidrBlock,
            destinationIpv6CidrBlock = destinationIpv6CidrBlock,
            destinationPrefixListId = destinationPrefixListId,
            egressOnlyGatewayId = egressOnlyGatewayId,
            gatewayId = gatewayId,
            instanceId = instanceId,
            localGatewayId = localGatewayId,
            natGatewayId = natGatewayId,
            networkInterfaceId = networkInterfaceId,
            routeTableId = routeTableId,
            transitGatewayId = transitGatewayId,
            vpcPeeringConnectionId = vpcPeeringConnectionId,
        )
        return getRouteResultToKotlin(getRoutePlain(argument.toJava()).await())
    }

    /**
     * @see [getRoute].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetRoutePlainArgs].
     * @return A collection of values returned by getRoute.
     */
    public suspend fun getRoute(argument: suspend GetRoutePlainArgsBuilder.() -> Unit):
        GetRouteResult {
        val builder = GetRoutePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteResultToKotlin(getRoutePlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.RouteTable` provides details about a specific Route Table.
     * This resource can prove useful when a module accepts a Subnet ID as an input variable and needs to, for example, add a route in the Route Table.
     * ## Example Usage
     * The following example shows how one might accept a Route Table ID as a variable and use this data source to obtain the data necessary to create a route.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetRouteTableArgs;
     * import com.pulumi.aws.ec2.Route;
     * import com.pulumi.aws.ec2.RouteArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var subnetId = config.get("subnetId");
     *         final var selected = Ec2Functions.getRouteTable(GetRouteTableArgs.builder()
     *             .subnetId(subnetId)
     *             .build());
     *         var route = new Route("route", RouteArgs.builder()
     *             .routeTableId(selected.applyValue(getRouteTableResult -> getRouteTableResult.id()))
     *             .destinationCidrBlock("10.0.1.0/22")
     *             .vpcPeeringConnectionId("pcx-45ff3dc1")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getRouteTable.
     * @return A collection of values returned by getRouteTable.
     */
    public suspend fun getRouteTable(argument: GetRouteTablePlainArgs): GetRouteTableResult =
        getRouteTableResultToKotlin(getRouteTablePlain(argument.toJava()).await())

    /**
     * @see [getRouteTable].
     * @param filters Configuration block. Detailed below.
     * @param gatewayId ID of an Internet Gateway or Virtual Private Gateway which is connected to the Route Table (not exported if not passed as a parameter).
     * @param routeTableId ID of the specific Route Table to retrieve.
     * @param subnetId ID of a Subnet which is connected to the Route Table (not exported if not passed as a parameter).
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired Route Table.
     * @param vpcId ID of the VPC that the desired Route Table belongs to.
     * @return A collection of values returned by getRouteTable.
     */
    public suspend fun getRouteTable(
        filters: List<GetRouteTableFilter>? = null,
        gatewayId: String? = null,
        routeTableId: String? = null,
        subnetId: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetRouteTableResult {
        val argument = GetRouteTablePlainArgs(
            filters = filters,
            gatewayId = gatewayId,
            routeTableId = routeTableId,
            subnetId = subnetId,
            tags = tags,
            vpcId = vpcId,
        )
        return getRouteTableResultToKotlin(getRouteTablePlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteTable].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetRouteTablePlainArgs].
     * @return A collection of values returned by getRouteTable.
     */
    public suspend fun getRouteTable(argument: suspend GetRouteTablePlainArgsBuilder.() -> Unit):
        GetRouteTableResult {
        val builder = GetRouteTablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteTableResultToKotlin(getRouteTablePlain(builtArgument.toJava()).await())
    }

    /**
     * This resource can be useful for getting back a list of route table ids to be referenced elsewhere.
     * @param argument A collection of arguments for invoking getRouteTables.
     * @return A collection of values returned by getRouteTables.
     */
    public suspend fun getRouteTables(argument: GetRouteTablesPlainArgs): GetRouteTablesResult =
        getRouteTablesResultToKotlin(getRouteTablesPlain(argument.toJava()).await())

    /**
     * @see [getRouteTables].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired route tables.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param vpcId VPC ID that you want to filter from.
     * @return A collection of values returned by getRouteTables.
     */
    public suspend fun getRouteTables(
        filters: List<GetRouteTablesFilter>? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetRouteTablesResult {
        val argument = GetRouteTablesPlainArgs(
            filters = filters,
            tags = tags,
            vpcId = vpcId,
        )
        return getRouteTablesResultToKotlin(getRouteTablesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRouteTables].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetRouteTablesPlainArgs].
     * @return A collection of values returned by getRouteTables.
     */
    public suspend fun getRouteTables(argument: suspend GetRouteTablesPlainArgsBuilder.() -> Unit):
        GetRouteTablesResult {
        val builder = GetRouteTablesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRouteTablesResultToKotlin(getRouteTablesPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.SecurityGroup` provides details about a specific Security Group.
     * This resource can prove useful when a module accepts a Security Group id as
     * an input variable and needs to, for example, determine the id of the
     * VPC that the security group belongs to.
     * ## Example Usage
     * The following example shows how one might accept a Security Group id as a variable
     * and use this data source to obtain the data necessary to create a subnet.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetSecurityGroupArgs;
     * import com.pulumi.aws.ec2.Subnet;
     * import com.pulumi.aws.ec2.SubnetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var securityGroupId = config.get("securityGroupId");
     *         final var selected = Ec2Functions.getSecurityGroup(GetSecurityGroupArgs.builder()
     *             .id(securityGroupId)
     *             .build());
     *         var subnet = new Subnet("subnet", SubnetArgs.builder()
     *             .vpcId(selected.applyValue(getSecurityGroupResult -> getSecurityGroupResult.vpcId()))
     *             .cidrBlock("10.0.1.0/24")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSecurityGroup.
     * @return A collection of values returned by getSecurityGroup.
     */
    public suspend fun getSecurityGroup(argument: GetSecurityGroupPlainArgs): GetSecurityGroupResult =
        getSecurityGroupResultToKotlin(getSecurityGroupPlain(argument.toJava()).await())

    /**
     * @see [getSecurityGroup].
     * @param filters Custom filter block as described below.
     * @param id Id of the specific security group to retrieve.
     * @param name Name of the field to filter by, as defined by
     * [the underlying AWS API](http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSecurityGroups.html).
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired security group.
     * @param vpcId Id of the VPC that the desired security group belongs to.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getSecurityGroup.
     */
    public suspend fun getSecurityGroup(
        filters: List<GetSecurityGroupFilter>? = null,
        id: String? = null,
        name: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetSecurityGroupResult {
        val argument = GetSecurityGroupPlainArgs(
            filters = filters,
            id = id,
            name = name,
            tags = tags,
            vpcId = vpcId,
        )
        return getSecurityGroupResultToKotlin(getSecurityGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetSecurityGroupPlainArgs].
     * @return A collection of values returned by getSecurityGroup.
     */
    public suspend
    fun getSecurityGroup(argument: suspend GetSecurityGroupPlainArgsBuilder.() -> Unit):
        GetSecurityGroupResult {
        val builder = GetSecurityGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityGroupResultToKotlin(getSecurityGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get IDs and VPC membership of Security Groups that are created outside this provider.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetSecurityGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getSecurityGroups(GetSecurityGroupsArgs.builder()
     *             .tags(Map.ofEntries(
     *                 Map.entry("Application", "k8s"),
     *                 Map.entry("Environment", "dev")
     *             ))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSecurityGroups.
     * @return A collection of values returned by getSecurityGroups.
     */
    public suspend fun getSecurityGroups(argument: GetSecurityGroupsPlainArgs):
        GetSecurityGroupsResult =
        getSecurityGroupsResultToKotlin(getSecurityGroupsPlain(argument.toJava()).await())

    /**
     * @see [getSecurityGroups].
     * @param filters One or more name/value pairs to use as filters. There are several valid keys, for a full reference, check out [describe-security-groups in the AWS CLI reference][1].
     * @param tags Map of tags, each pair of which must exactly match for desired security groups.
     * @return A collection of values returned by getSecurityGroups.
     */
    public suspend fun getSecurityGroups(
        filters: List<GetSecurityGroupsFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetSecurityGroupsResult {
        val argument = GetSecurityGroupsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getSecurityGroupsResultToKotlin(getSecurityGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecurityGroups].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetSecurityGroupsPlainArgs].
     * @return A collection of values returned by getSecurityGroups.
     */
    public suspend
    fun getSecurityGroups(argument: suspend GetSecurityGroupsPlainArgsBuilder.() -> Unit):
        GetSecurityGroupsResult {
        val builder = GetSecurityGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecurityGroupsResultToKotlin(getSecurityGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides a way to check whether serial console access is enabled for your AWS account in the current AWS region.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = Ec2Functions.getSerialConsoleAccess();
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = Ec2Functions.getSerialConsoleAccess();
     *     }
     * }
     * ```
     * @param argument Provides a way to check whether serial console access is enabled for your AWS account in the current AWS region.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = Ec2Functions.getSerialConsoleAccess();
     *     }
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = Ec2Functions.getSerialConsoleAccess();
     *     }
     * }
     * ```
     * @return A collection of values returned by getSerialConsoleAccess.
     */
    public suspend fun getSerialConsoleAccess(): GetSerialConsoleAccessResult =
        getSerialConsoleAccessResultToKotlin(getSerialConsoleAccessPlain().await())

    /**
     * Information about most recent Spot Price for a given EC2 instance.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetSpotPriceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getSpotPrice(GetSpotPriceArgs.builder()
     *             .availabilityZone("us-west-2a")
     *             .filters(GetSpotPriceFilterArgs.builder()
     *                 .name("product-description")
     *                 .values("Linux/UNIX")
     *                 .build())
     *             .instanceType("t3.medium")
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSpotPrice.
     * @return A collection of values returned by getSpotPrice.
     */
    public suspend fun getSpotPrice(argument: GetSpotPricePlainArgs): GetSpotPriceResult =
        getSpotPriceResultToKotlin(getSpotPricePlain(argument.toJava()).await())

    /**
     * @see [getSpotPrice].
     * @param availabilityZone Availability zone in which to query Spot price information.
     * @param filters One or more configuration blocks containing name-values filters. See the [EC2 API Reference](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeSpotPriceHistory.html) for supported filters. Detailed below.
     * @param instanceType Type of instance for which to query Spot Price information.
     * @return A collection of values returned by getSpotPrice.
     */
    public suspend fun getSpotPrice(
        availabilityZone: String? = null,
        filters: List<GetSpotPriceFilter>? = null,
        instanceType: String? = null,
    ): GetSpotPriceResult {
        val argument = GetSpotPricePlainArgs(
            availabilityZone = availabilityZone,
            filters = filters,
            instanceType = instanceType,
        )
        return getSpotPriceResultToKotlin(getSpotPricePlain(argument.toJava()).await())
    }

    /**
     * @see [getSpotPrice].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetSpotPricePlainArgs].
     * @return A collection of values returned by getSpotPrice.
     */
    public suspend fun getSpotPrice(argument: suspend GetSpotPricePlainArgsBuilder.() -> Unit):
        GetSpotPriceResult {
        val builder = GetSpotPricePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSpotPriceResultToKotlin(getSpotPricePlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.Subnet` provides details about a specific VPC subnet.
     * This resource can prove useful when a module accepts a subnet ID as an input variable and needs to, for example, determine the ID of the VPC that the subnet belongs to.
     * ## Example Usage
     * The following example shows how one might accept a subnet ID as a variable and use this data source to obtain the data necessary to create a security group that allows connections from hosts in that subnet.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetSubnetArgs;
     * import com.pulumi.aws.ec2.SecurityGroup;
     * import com.pulumi.aws.ec2.SecurityGroupArgs;
     * import com.pulumi.aws.ec2.inputs.SecurityGroupIngressArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var config = ctx.config();
     *         final var subnetId = config.get("subnetId");
     *         final var selected = Ec2Functions.getSubnet(GetSubnetArgs.builder()
     *             .id(subnetId)
     *             .build());
     *         var subnet = new SecurityGroup("subnet", SecurityGroupArgs.builder()
     *             .vpcId(selected.applyValue(getSubnetResult -> getSubnetResult.vpcId()))
     *             .ingress(SecurityGroupIngressArgs.builder()
     *                 .cidrBlocks(selected.applyValue(getSubnetResult -> getSubnetResult.cidrBlock()))
     *                 .fromPort(80)
     *                 .toPort(80)
     *                 .protocol("tcp")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ### Filter Example
     * If you want to match against tag `Name`, use:
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetSubnetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var selected = Ec2Functions.getSubnet(GetSubnetArgs.builder()
     *             .filters(GetSubnetFilterArgs.builder()
     *                 .name("tag:Name")
     *                 .values("yakdriver")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSubnet.
     * @return A collection of values returned by getSubnet.
     */
    public suspend fun getSubnet(argument: GetSubnetPlainArgs): GetSubnetResult =
        getSubnetResultToKotlin(getSubnetPlain(argument.toJava()).await())

    /**
     * @see [getSubnet].
     * @param availabilityZone Availability zone where the subnet must reside.
     * @param availabilityZoneId ID of the Availability Zone for the subnet. This argument is not supported in all regions or partitions. If necessary, use `availability_zone` instead.
     * @param cidrBlock CIDR block of the desired subnet.
     * @param defaultForAz Whether the desired subnet must be the default subnet for its associated availability zone.
     * @param filters Configuration block. Detailed below.
     * @param id ID of the specific subnet to retrieve.
     * @param ipv6CidrBlock IPv6 CIDR block of the desired subnet.
     * @param state State that the desired subnet must have.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired subnet.
     * @param vpcId ID of the VPC that the desired subnet belongs to.
     * @return A collection of values returned by getSubnet.
     */
    public suspend fun getSubnet(
        availabilityZone: String? = null,
        availabilityZoneId: String? = null,
        cidrBlock: String? = null,
        defaultForAz: Boolean? = null,
        filters: List<GetSubnetFilter>? = null,
        id: String? = null,
        ipv6CidrBlock: String? = null,
        state: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetSubnetResult {
        val argument = GetSubnetPlainArgs(
            availabilityZone = availabilityZone,
            availabilityZoneId = availabilityZoneId,
            cidrBlock = cidrBlock,
            defaultForAz = defaultForAz,
            filters = filters,
            id = id,
            ipv6CidrBlock = ipv6CidrBlock,
            state = state,
            tags = tags,
            vpcId = vpcId,
        )
        return getSubnetResultToKotlin(getSubnetPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubnet].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetSubnetPlainArgs].
     * @return A collection of values returned by getSubnet.
     */
    public suspend fun getSubnet(argument: suspend GetSubnetPlainArgsBuilder.() -> Unit):
        GetSubnetResult {
        val builder = GetSubnetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubnetResultToKotlin(getSubnetPlain(builtArgument.toJava()).await())
    }

    /**
     * This resource can be useful for getting back a set of subnet IDs.
     * @param argument A collection of arguments for invoking getSubnets.
     * @return A collection of values returned by getSubnets.
     */
    public suspend fun getSubnets(argument: GetSubnetsPlainArgs): GetSubnetsResult =
        getSubnetsResultToKotlin(getSubnetsPlain(argument.toJava()).await())

    /**
     * @see [getSubnets].
     * @param filters Custom filter block as described below.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired subnets.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getSubnets.
     */
    public suspend fun getSubnets(
        filters: List<GetSubnetsFilter>? = null,
        tags: Map<String, String>? =
            null,
    ): GetSubnetsResult {
        val argument = GetSubnetsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getSubnetsResultToKotlin(getSubnetsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubnets].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetSubnetsPlainArgs].
     * @return A collection of values returned by getSubnets.
     */
    public suspend fun getSubnets(argument: suspend GetSubnetsPlainArgsBuilder.() -> Unit):
        GetSubnetsResult {
        val builder = GetSubnetsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubnetsResultToKotlin(getSubnetsPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information for multiple EC2 Transit Gateway Route Tables, such as their identifiers.
     * ## Example Usage
     * The following shows outputting all Transit Gateway Route Table Ids.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetTransitGatewayRouteTablesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var exampleTransitGatewayRouteTables = Ec2Functions.getTransitGatewayRouteTables();
     *         ctx.export("example", exampleTransitGatewayRouteTables.applyValue(getTransitGatewayRouteTablesResult -> getTransitGatewayRouteTablesResult.ids()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getTransitGatewayRouteTables.
     * @return A collection of values returned by getTransitGatewayRouteTables.
     */
    public suspend fun getTransitGatewayRouteTables(argument: GetTransitGatewayRouteTablesPlainArgs):
        GetTransitGatewayRouteTablesResult =
        getTransitGatewayRouteTablesResultToKotlin(getTransitGatewayRouteTablesPlain(argument.toJava()).await())

    /**
     * @see [getTransitGatewayRouteTables].
     * @param filters Custom filter block as described below.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired transit gateway route table.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getTransitGatewayRouteTables.
     */
    public suspend fun getTransitGatewayRouteTables(
        filters: List<GetTransitGatewayRouteTablesFilter>? =
            null,
        tags: Map<String, String>? = null,
    ): GetTransitGatewayRouteTablesResult {
        val argument = GetTransitGatewayRouteTablesPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getTransitGatewayRouteTablesResultToKotlin(getTransitGatewayRouteTablesPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransitGatewayRouteTables].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetTransitGatewayRouteTablesPlainArgs].
     * @return A collection of values returned by getTransitGatewayRouteTables.
     */
    public suspend
    fun getTransitGatewayRouteTables(argument: suspend GetTransitGatewayRouteTablesPlainArgsBuilder.() -> Unit):
        GetTransitGatewayRouteTablesResult {
        val builder = GetTransitGatewayRouteTablesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransitGatewayRouteTablesResultToKotlin(getTransitGatewayRouteTablesPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.Vpc` provides details about a specific VPC.
     * This resource can prove useful when a module accepts a vpc id as
     * an input variable and needs to, for example, determine the CIDR block of that
     * VPC.
     * @param argument A collection of arguments for invoking getVpc.
     * @return A collection of values returned by getVpc.
     */
    public suspend fun getVpc(argument: GetVpcPlainArgs): GetVpcResult =
        getVpcResultToKotlin(getVpcPlain(argument.toJava()).await())

    /**
     * @see [getVpc].
     * @param cidrBlock Cidr block of the desired VPC.
     * @param default Boolean constraint on whether the desired VPC is
     * the default VPC for the region.
     * @param dhcpOptionsId DHCP options id of the desired VPC.
     * @param filters Custom filter block as described below.
     * @param id ID of the specific VPC to retrieve.
     * @param state Current state of the desired VPC.
     * Can be either `"pending"` or `"available"`.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired VPC.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getVpc.
     */
    public suspend fun getVpc(
        cidrBlock: String? = null,
        default: Boolean? = null,
        dhcpOptionsId: String? = null,
        filters: List<GetVpcFilter>? = null,
        id: String? = null,
        state: String? = null,
        tags: Map<String, String>? = null,
    ): GetVpcResult {
        val argument = GetVpcPlainArgs(
            cidrBlock = cidrBlock,
            default = default,
            dhcpOptionsId = dhcpOptionsId,
            filters = filters,
            id = id,
            state = state,
            tags = tags,
        )
        return getVpcResultToKotlin(getVpcPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpc].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcPlainArgs].
     * @return A collection of values returned by getVpc.
     */
    public suspend fun getVpc(argument: suspend GetVpcPlainArgsBuilder.() -> Unit): GetVpcResult {
        val builder = GetVpcPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcResultToKotlin(getVpcPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about an EC2 DHCP Options configuration.
     * ## Example Usage
     * ### Lookup by DHCP Options ID
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcDhcpOptionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getVpcDhcpOptions(GetVpcDhcpOptionsArgs.builder()
     *             .dhcpOptionsId("dopts-12345678")
     *             .build());
     *     }
     * }
     * ```
     * ### Lookup by Filter
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcDhcpOptionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = Ec2Functions.getVpcDhcpOptions(GetVpcDhcpOptionsArgs.builder()
     *             .filters(
     *                 GetVpcDhcpOptionsFilterArgs.builder()
     *                     .name("key")
     *                     .values("domain-name")
     *                     .build(),
     *                 GetVpcDhcpOptionsFilterArgs.builder()
     *                     .name("value")
     *                     .values("example.com")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVpcDhcpOptions.
     * @return A collection of values returned by getVpcDhcpOptions.
     */
    public suspend fun getVpcDhcpOptions(argument: GetVpcDhcpOptionsPlainArgs):
        GetVpcDhcpOptionsResult =
        getVpcDhcpOptionsResultToKotlin(getVpcDhcpOptionsPlain(argument.toJava()).await())

    /**
     * @see [getVpcDhcpOptions].
     * @param dhcpOptionsId EC2 DHCP Options ID.
     * @param filters List of custom filters as described below.
     * @param tags Map of tags assigned to the resource.
     * @return A collection of values returned by getVpcDhcpOptions.
     */
    public suspend fun getVpcDhcpOptions(
        dhcpOptionsId: String? = null,
        filters: List<GetVpcDhcpOptionsFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetVpcDhcpOptionsResult {
        val argument = GetVpcDhcpOptionsPlainArgs(
            dhcpOptionsId = dhcpOptionsId,
            filters = filters,
            tags = tags,
        )
        return getVpcDhcpOptionsResultToKotlin(getVpcDhcpOptionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcDhcpOptions].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcDhcpOptionsPlainArgs].
     * @return A collection of values returned by getVpcDhcpOptions.
     */
    public suspend
    fun getVpcDhcpOptions(argument: suspend GetVpcDhcpOptionsPlainArgsBuilder.() -> Unit):
        GetVpcDhcpOptionsResult {
        val builder = GetVpcDhcpOptionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcDhcpOptionsResultToKotlin(getVpcDhcpOptionsPlain(builtArgument.toJava()).await())
    }

    /**
     * The VPC Endpoint data source provides details about
     * a specific VPC endpoint.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcEndpointArgs;
     * import com.pulumi.aws.ec2.VpcEndpointRouteTableAssociation;
     * import com.pulumi.aws.ec2.VpcEndpointRouteTableAssociationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var s3 = Ec2Functions.getVpcEndpoint(GetVpcEndpointArgs.builder()
     *             .vpcId(aws_vpc.foo().id())
     *             .serviceName("com.amazonaws.us-west-2.s3")
     *             .build());
     *         var privateS3 = new VpcEndpointRouteTableAssociation("privateS3", VpcEndpointRouteTableAssociationArgs.builder()
     *             .vpcEndpointId(s3.applyValue(getVpcEndpointResult -> getVpcEndpointResult.id()))
     *             .routeTableId(aws_route_table.private().id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVpcEndpoint.
     * @return A collection of values returned by getVpcEndpoint.
     */
    public suspend fun getVpcEndpoint(argument: GetVpcEndpointPlainArgs): GetVpcEndpointResult =
        getVpcEndpointResultToKotlin(getVpcEndpointPlain(argument.toJava()).await())

    /**
     * @see [getVpcEndpoint].
     * @param filters Custom filter block as described below.
     * @param id ID of the specific VPC Endpoint to retrieve.
     * @param serviceName Service name of the specific VPC Endpoint to retrieve. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
     * @param state State of the specific VPC Endpoint to retrieve.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the specific VPC Endpoint to retrieve.
     * @param vpcId ID of the VPC in which the specific VPC Endpoint is used.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getVpcEndpoint.
     */
    public suspend fun getVpcEndpoint(
        filters: List<GetVpcEndpointFilter>? = null,
        id: String? = null,
        serviceName: String? = null,
        state: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetVpcEndpointResult {
        val argument = GetVpcEndpointPlainArgs(
            filters = filters,
            id = id,
            serviceName = serviceName,
            state = state,
            tags = tags,
            vpcId = vpcId,
        )
        return getVpcEndpointResultToKotlin(getVpcEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcEndpointPlainArgs].
     * @return A collection of values returned by getVpcEndpoint.
     */
    public suspend fun getVpcEndpoint(argument: suspend GetVpcEndpointPlainArgsBuilder.() -> Unit):
        GetVpcEndpointResult {
        val builder = GetVpcEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcEndpointResultToKotlin(getVpcEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * The VPC Endpoint Service data source details about a specific service that
     * can be specified when creating a VPC endpoint within the region configured in the provider.
     * ## Example Usage
     * ### AWS Service
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcEndpointServiceArgs;
     * import com.pulumi.aws.ec2.Vpc;
     * import com.pulumi.aws.ec2.VpcArgs;
     * import com.pulumi.aws.ec2.VpcEndpoint;
     * import com.pulumi.aws.ec2.VpcEndpointArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var s3 = Ec2Functions.getVpcEndpointService(GetVpcEndpointServiceArgs.builder()
     *             .service("s3")
     *             .serviceType("Gateway")
     *             .build());
     *         var foo = new Vpc("foo", VpcArgs.builder()
     *             .cidrBlock("10.0.0.0/16")
     *             .build());
     *         var ep = new VpcEndpoint("ep", VpcEndpointArgs.builder()
     *             .vpcId(foo.id())
     *             .serviceName(s3.applyValue(getVpcEndpointServiceResult -> getVpcEndpointServiceResult.serviceName()))
     *             .build());
     *     }
     * }
     * ```
     * ### Non-AWS Service
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcEndpointServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var custome = Ec2Functions.getVpcEndpointService(GetVpcEndpointServiceArgs.builder()
     *             .serviceName("com.amazonaws.vpce.us-west-2.vpce-svc-0e87519c997c63cd8")
     *             .build());
     *     }
     * }
     * ```
     * ### Filter
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcEndpointServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getVpcEndpointService(GetVpcEndpointServiceArgs.builder()
     *             .filters(GetVpcEndpointServiceFilterArgs.builder()
     *                 .name("service-name")
     *                 .values("some-service")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVpcEndpointService.
     * @return A collection of values returned by getVpcEndpointService.
     */
    public suspend fun getVpcEndpointService(argument: GetVpcEndpointServicePlainArgs):
        GetVpcEndpointServiceResult =
        getVpcEndpointServiceResultToKotlin(getVpcEndpointServicePlain(argument.toJava()).await())

    /**
     * @see [getVpcEndpointService].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @param service Common name of an AWS service (e.g., `s3`).
     * @param serviceName Service name that is specified when creating a VPC endpoint. For AWS services the service name is usually in the form `com.amazonaws.<region>.<service>` (the SageMaker Notebook service is an exception to this rule, the service name is in the form `aws.sagemaker.<region>.notebook`).
     * @param serviceType Service type, `Gateway` or `Interface`.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired VPC Endpoint Service.
     * > **NOTE:** Specifying `service` will not work for non-AWS services or AWS services that don't follow the standard `service_name` pattern of `com.amazonaws.<region>.<service>`.
     * @return A collection of values returned by getVpcEndpointService.
     */
    public suspend fun getVpcEndpointService(
        filters: List<GetVpcEndpointServiceFilter>? = null,
        service: String? = null,
        serviceName: String? = null,
        serviceType: String? = null,
        tags: Map<String, String>? = null,
    ): GetVpcEndpointServiceResult {
        val argument = GetVpcEndpointServicePlainArgs(
            filters = filters,
            service = service,
            serviceName = serviceName,
            serviceType = serviceType,
            tags = tags,
        )
        return getVpcEndpointServiceResultToKotlin(getVpcEndpointServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcEndpointService].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcEndpointServicePlainArgs].
     * @return A collection of values returned by getVpcEndpointService.
     */
    public suspend
    fun getVpcEndpointService(argument: suspend GetVpcEndpointServicePlainArgsBuilder.() -> Unit):
        GetVpcEndpointServiceResult {
        val builder = GetVpcEndpointServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcEndpointServiceResultToKotlin(getVpcEndpointServicePlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.VpcIpamPool` provides details about an IPAM pool.
     * This resource can prove useful when an ipam pool was created in another root
     * module and you need the pool's id as an input variable. For example, pools
     * can be shared via RAM and used to create vpcs with CIDRs from that pool.
     * ## Example Usage
     * The following example shows an account that has only 1 pool, perhaps shared
     * via RAM, and using that pool id to create a VPC with a CIDR derived from
     * AWS IPAM.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolArgs;
     * import com.pulumi.aws.ec2.Vpc;
     * import com.pulumi.aws.ec2.VpcArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var testVpcIpamPool = Ec2Functions.getVpcIpamPool(GetVpcIpamPoolArgs.builder()
     *             .filters(
     *                 GetVpcIpamPoolFilterArgs.builder()
     *                     .name("description")
     *                     .values("*test*")
     *                     .build(),
     *                 GetVpcIpamPoolFilterArgs.builder()
     *                     .name("address-family")
     *                     .values("ipv4")
     *                     .build())
     *             .build());
     *         var testVpc = new Vpc("testVpc", VpcArgs.builder()
     *             .ipv4IpamPoolId(testVpcIpamPool.applyValue(getVpcIpamPoolResult -> getVpcIpamPoolResult.id()))
     *             .ipv4NetmaskLength(28)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVpcIamPool.
     * @return A collection of values returned by getVpcIamPool.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampool.getVpcIamPool has been deprecated in favor of
      aws.ec2/getvpcipampool.getVpcIpamPool
  """,
    )
    public suspend fun getVpcIamPool(argument: GetVpcIamPoolPlainArgs): GetVpcIamPoolResult =
        getVpcIamPoolResultToKotlin(getVpcIamPoolPlain(argument.toJava()).await())

    /**
     * @see [getVpcIamPool].
     * @param allocationResourceTags Tags that are required to create resources in using this pool.
     * @param filters Custom filter block as described below.
     * @param id ID of the IPAM pool.
     * @param ipamPoolId ID of the IPAM pool you would like information on.
     * @param tags Map of tags to assigned to the resource.
     * @return A collection of values returned by getVpcIamPool.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampool.getVpcIamPool has been deprecated in favor of
      aws.ec2/getvpcipampool.getVpcIpamPool
  """,
    )
    public suspend fun getVpcIamPool(
        allocationResourceTags: Map<String, String>? = null,
        filters: List<GetVpcIamPoolFilter>? = null,
        id: String? = null,
        ipamPoolId: String? = null,
        tags: Map<String, String>? = null,
    ): GetVpcIamPoolResult {
        val argument = GetVpcIamPoolPlainArgs(
            allocationResourceTags = allocationResourceTags,
            filters = filters,
            id = id,
            ipamPoolId = ipamPoolId,
            tags = tags,
        )
        return getVpcIamPoolResultToKotlin(getVpcIamPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcIamPool].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcIamPoolPlainArgs].
     * @return A collection of values returned by getVpcIamPool.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampool.getVpcIamPool has been deprecated in favor of
      aws.ec2/getvpcipampool.getVpcIpamPool
  """,
    )
    public suspend fun getVpcIamPool(argument: suspend GetVpcIamPoolPlainArgsBuilder.() -> Unit):
        GetVpcIamPoolResult {
        val builder = GetVpcIamPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcIamPoolResultToKotlin(getVpcIamPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.getVpcIpamPoolCidrs` provides details about an IPAM pool.
     * This resource can prove useful when an ipam pool was shared to your account and you want to know all (or a filtered list) of the CIDRs that are provisioned into the pool.
     * @param argument A collection of arguments for invoking getVpcIamPoolCidrs.
     * @return A collection of values returned by getVpcIamPoolCidrs.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampoolcidrs.getVpcIamPoolCidrs has been deprecated in favor of
      aws.ec2/getvpcipampoolcidrs.getVpcIpamPoolCidrs
  """,
    )
    public suspend fun getVpcIamPoolCidrs(argument: GetVpcIamPoolCidrsPlainArgs):
        GetVpcIamPoolCidrsResult =
        getVpcIamPoolCidrsResultToKotlin(getVpcIamPoolCidrsPlain(argument.toJava()).await())

    /**
     * @see [getVpcIamPoolCidrs].
     * @param filters Custom filter block as described below.
     * @param ipamPoolId ID of the IPAM pool you would like the list of provisioned CIDRs.
     * @return A collection of values returned by getVpcIamPoolCidrs.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampoolcidrs.getVpcIamPoolCidrs has been deprecated in favor of
      aws.ec2/getvpcipampoolcidrs.getVpcIpamPoolCidrs
  """,
    )
    public suspend fun getVpcIamPoolCidrs(
        filters: List<GetVpcIamPoolCidrsFilter>? = null,
        ipamPoolId: String,
    ): GetVpcIamPoolCidrsResult {
        val argument = GetVpcIamPoolCidrsPlainArgs(
            filters = filters,
            ipamPoolId = ipamPoolId,
        )
        return getVpcIamPoolCidrsResultToKotlin(getVpcIamPoolCidrsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcIamPoolCidrs].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcIamPoolCidrsPlainArgs].
     * @return A collection of values returned by getVpcIamPoolCidrs.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampoolcidrs.getVpcIamPoolCidrs has been deprecated in favor of
      aws.ec2/getvpcipampoolcidrs.getVpcIpamPoolCidrs
  """,
    )
    public suspend
    fun getVpcIamPoolCidrs(argument: suspend GetVpcIamPoolCidrsPlainArgsBuilder.() -> Unit):
        GetVpcIamPoolCidrsResult {
        val builder = GetVpcIamPoolCidrsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcIamPoolCidrsResultToKotlin(getVpcIamPoolCidrsPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.getVpcIpamPools` provides details about IPAM pools.
     * This resource can prove useful when IPAM pools are created in another root
     * module and you need the pool ids as input variables. For example, pools
     * can be shared via RAM and used to create vpcs with CIDRs from that pool.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getVpcIpamPools(GetVpcIpamPoolsArgs.builder()
     *             .filters(
     *                 GetVpcIpamPoolsFilterArgs.builder()
     *                     .name("description")
     *                     .values("*test*")
     *                     .build(),
     *                 GetVpcIpamPoolsFilterArgs.builder()
     *                     .name("address-family")
     *                     .values("ipv4")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVpcIamPools.
     * @return A collection of values returned by getVpcIamPools.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampools.getVpcIamPools has been deprecated in favor of
      aws.ec2/getvpcipampools.getVpcIpamPools
  """,
    )
    public suspend fun getVpcIamPools(argument: GetVpcIamPoolsPlainArgs): GetVpcIamPoolsResult =
        getVpcIamPoolsResultToKotlin(getVpcIamPoolsPlain(argument.toJava()).await())

    /**
     * @see [getVpcIamPools].
     * @param filters Custom filter block as described below.
     * @return A collection of values returned by getVpcIamPools.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampools.getVpcIamPools has been deprecated in favor of
      aws.ec2/getvpcipampools.getVpcIpamPools
  """,
    )
    public suspend fun getVpcIamPools(filters: List<GetVpcIamPoolsFilter>? = null):
        GetVpcIamPoolsResult {
        val argument = GetVpcIamPoolsPlainArgs(
            filters = filters,
        )
        return getVpcIamPoolsResultToKotlin(getVpcIamPoolsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcIamPools].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcIamPoolsPlainArgs].
     * @return A collection of values returned by getVpcIamPools.
     */
    @Deprecated(
        message = """
  aws.ec2/getvpciampools.getVpcIamPools has been deprecated in favor of
      aws.ec2/getvpcipampools.getVpcIpamPools
  """,
    )
    public suspend fun getVpcIamPools(argument: suspend GetVpcIamPoolsPlainArgsBuilder.() -> Unit):
        GetVpcIamPoolsResult {
        val builder = GetVpcIamPoolsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcIamPoolsResultToKotlin(getVpcIamPoolsPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.VpcIpamPool` provides details about an IPAM pool.
     * This resource can prove useful when an ipam pool was created in another root
     * module and you need the pool's id as an input variable. For example, pools
     * can be shared via RAM and used to create vpcs with CIDRs from that pool.
     * ## Example Usage
     * The following example shows an account that has only 1 pool, perhaps shared
     * via RAM, and using that pool id to create a VPC with a CIDR derived from
     * AWS IPAM.
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolArgs;
     * import com.pulumi.aws.ec2.Vpc;
     * import com.pulumi.aws.ec2.VpcArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var testVpcIpamPool = Ec2Functions.getVpcIpamPool(GetVpcIpamPoolArgs.builder()
     *             .filters(
     *                 GetVpcIpamPoolFilterArgs.builder()
     *                     .name("description")
     *                     .values("*test*")
     *                     .build(),
     *                 GetVpcIpamPoolFilterArgs.builder()
     *                     .name("address-family")
     *                     .values("ipv4")
     *                     .build())
     *             .build());
     *         var testVpc = new Vpc("testVpc", VpcArgs.builder()
     *             .ipv4IpamPoolId(testVpcIpamPool.applyValue(getVpcIpamPoolResult -> getVpcIpamPoolResult.id()))
     *             .ipv4NetmaskLength(28)
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVpcIpamPool.
     * @return A collection of values returned by getVpcIpamPool.
     */
    public suspend fun getVpcIpamPool(argument: GetVpcIpamPoolPlainArgs): GetVpcIpamPoolResult =
        getVpcIpamPoolResultToKotlin(getVpcIpamPoolPlain(argument.toJava()).await())

    /**
     * @see [getVpcIpamPool].
     * @param allocationResourceTags Tags that are required to create resources in using this pool.
     * @param filters Custom filter block as described below.
     * @param id ID of the IPAM pool.
     * @param ipamPoolId ID of the IPAM pool you would like information on.
     * @param tags Map of tags to assigned to the resource.
     * @return A collection of values returned by getVpcIpamPool.
     */
    public suspend fun getVpcIpamPool(
        allocationResourceTags: Map<String, String>? = null,
        filters: List<GetVpcIpamPoolFilter>? = null,
        id: String? = null,
        ipamPoolId: String? = null,
        tags: Map<String, String>? = null,
    ): GetVpcIpamPoolResult {
        val argument = GetVpcIpamPoolPlainArgs(
            allocationResourceTags = allocationResourceTags,
            filters = filters,
            id = id,
            ipamPoolId = ipamPoolId,
            tags = tags,
        )
        return getVpcIpamPoolResultToKotlin(getVpcIpamPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcIpamPool].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcIpamPoolPlainArgs].
     * @return A collection of values returned by getVpcIpamPool.
     */
    public suspend fun getVpcIpamPool(argument: suspend GetVpcIpamPoolPlainArgsBuilder.() -> Unit):
        GetVpcIpamPoolResult {
        val builder = GetVpcIpamPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcIpamPoolResultToKotlin(getVpcIpamPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.getVpcIpamPoolCidrs` provides details about an IPAM pool.
     * This resource can prove useful when an ipam pool was shared to your account and you want to know all (or a filtered list) of the CIDRs that are provisioned into the pool.
     * @param argument A collection of arguments for invoking getVpcIpamPoolCidrs.
     * @return A collection of values returned by getVpcIpamPoolCidrs.
     */
    public suspend fun getVpcIpamPoolCidrs(argument: GetVpcIpamPoolCidrsPlainArgs):
        GetVpcIpamPoolCidrsResult =
        getVpcIpamPoolCidrsResultToKotlin(getVpcIpamPoolCidrsPlain(argument.toJava()).await())

    /**
     * @see [getVpcIpamPoolCidrs].
     * @param filters Custom filter block as described below.
     * @param ipamPoolId ID of the IPAM pool you would like the list of provisioned CIDRs.
     * @return A collection of values returned by getVpcIpamPoolCidrs.
     */
    public suspend fun getVpcIpamPoolCidrs(
        filters: List<GetVpcIpamPoolCidrsFilter>? = null,
        ipamPoolId: String,
    ): GetVpcIpamPoolCidrsResult {
        val argument = GetVpcIpamPoolCidrsPlainArgs(
            filters = filters,
            ipamPoolId = ipamPoolId,
        )
        return getVpcIpamPoolCidrsResultToKotlin(getVpcIpamPoolCidrsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcIpamPoolCidrs].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcIpamPoolCidrsPlainArgs].
     * @return A collection of values returned by getVpcIpamPoolCidrs.
     */
    public suspend
    fun getVpcIpamPoolCidrs(argument: suspend GetVpcIpamPoolCidrsPlainArgsBuilder.() -> Unit):
        GetVpcIpamPoolCidrsResult {
        val builder = GetVpcIpamPoolCidrsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcIpamPoolCidrsResultToKotlin(getVpcIpamPoolCidrsPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.ec2.getVpcIpamPools` provides details about IPAM pools.
     * This resource can prove useful when IPAM pools are created in another root
     * module and you need the pool ids as input variables. For example, pools
     * can be shared via RAM and used to create vpcs with CIDRs from that pool.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcIpamPoolsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = Ec2Functions.getVpcIpamPools(GetVpcIpamPoolsArgs.builder()
     *             .filters(
     *                 GetVpcIpamPoolsFilterArgs.builder()
     *                     .name("description")
     *                     .values("*test*")
     *                     .build(),
     *                 GetVpcIpamPoolsFilterArgs.builder()
     *                     .name("address-family")
     *                     .values("ipv4")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVpcIpamPools.
     * @return A collection of values returned by getVpcIpamPools.
     */
    public suspend fun getVpcIpamPools(argument: GetVpcIpamPoolsPlainArgs): GetVpcIpamPoolsResult =
        getVpcIpamPoolsResultToKotlin(getVpcIpamPoolsPlain(argument.toJava()).await())

    /**
     * @see [getVpcIpamPools].
     * @param filters Custom filter block as described below.
     * @return A collection of values returned by getVpcIpamPools.
     */
    public suspend fun getVpcIpamPools(filters: List<GetVpcIpamPoolsFilter>? = null):
        GetVpcIpamPoolsResult {
        val argument = GetVpcIpamPoolsPlainArgs(
            filters = filters,
        )
        return getVpcIpamPoolsResultToKotlin(getVpcIpamPoolsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcIpamPools].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcIpamPoolsPlainArgs].
     * @return A collection of values returned by getVpcIpamPools.
     */
    public suspend fun getVpcIpamPools(argument: suspend GetVpcIpamPoolsPlainArgsBuilder.() -> Unit):
        GetVpcIpamPoolsResult {
        val builder = GetVpcIpamPoolsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcIpamPoolsResultToKotlin(getVpcIpamPoolsPlain(builtArgument.toJava()).await())
    }

    /**
     * The VPC Peering Connection data source provides details about
     * a specific VPC peering connection.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpcPeeringConnectionArgs;
     * import com.pulumi.aws.ec2.RouteTable;
     * import com.pulumi.aws.ec2.RouteTableArgs;
     * import com.pulumi.aws.ec2.Route;
     * import com.pulumi.aws.ec2.RouteArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var pc = Ec2Functions.getVpcPeeringConnection(GetVpcPeeringConnectionArgs.builder()
     *             .vpcId(aws_vpc.foo().id())
     *             .peerCidrBlock("10.0.1.0/22")
     *             .build());
     *         var rt = new RouteTable("rt", RouteTableArgs.builder()
     *             .vpcId(aws_vpc.foo().id())
     *             .build());
     *         var route = new Route("route", RouteArgs.builder()
     *             .routeTableId(rt.id())
     *             .destinationCidrBlock(pc.applyValue(getVpcPeeringConnectionResult -> getVpcPeeringConnectionResult.peerCidrBlock()))
     *             .vpcPeeringConnectionId(pc.applyValue(getVpcPeeringConnectionResult -> getVpcPeeringConnectionResult.id()))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVpcPeeringConnection.
     * @return A collection of values returned by getVpcPeeringConnection.
     */
    public suspend fun getVpcPeeringConnection(argument: GetVpcPeeringConnectionPlainArgs):
        GetVpcPeeringConnectionResult =
        getVpcPeeringConnectionResultToKotlin(getVpcPeeringConnectionPlain(argument.toJava()).await())

    /**
     * @see [getVpcPeeringConnection].
     * @param cidrBlock Primary CIDR block of the requester VPC of the specific VPC Peering Connection to retrieve.
     * @param filters Custom filter block as described below.
     * @param id ID of the specific VPC Peering Connection to retrieve.
     * @param ownerId AWS account ID of the owner of the requester VPC of the specific VPC Peering Connection to retrieve.
     * @param peerCidrBlock Primary CIDR block of the accepter VPC of the specific VPC Peering Connection to retrieve.
     * @param peerOwnerId AWS account ID of the owner of the accepter VPC of the specific VPC Peering Connection to retrieve.
     * @param peerRegion Region of the accepter VPC of the specific VPC Peering Connection to retrieve.
     * @param peerVpcId ID of the accepter VPC of the specific VPC Peering Connection to retrieve.
     * @param region Region of the requester VPC of the specific VPC Peering Connection to retrieve.
     * @param status Status of the specific VPC Peering Connection to retrieve.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired VPC Peering Connection.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param vpcId ID of the requester VPC of the specific VPC Peering Connection to retrieve.
     * @return A collection of values returned by getVpcPeeringConnection.
     */
    public suspend fun getVpcPeeringConnection(
        cidrBlock: String? = null,
        filters: List<GetVpcPeeringConnectionFilter>? = null,
        id: String? = null,
        ownerId: String? = null,
        peerCidrBlock: String? = null,
        peerOwnerId: String? = null,
        peerRegion: String? = null,
        peerVpcId: String? = null,
        region: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        vpcId: String? = null,
    ): GetVpcPeeringConnectionResult {
        val argument = GetVpcPeeringConnectionPlainArgs(
            cidrBlock = cidrBlock,
            filters = filters,
            id = id,
            ownerId = ownerId,
            peerCidrBlock = peerCidrBlock,
            peerOwnerId = peerOwnerId,
            peerRegion = peerRegion,
            peerVpcId = peerVpcId,
            region = region,
            status = status,
            tags = tags,
            vpcId = vpcId,
        )
        return getVpcPeeringConnectionResultToKotlin(getVpcPeeringConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcPeeringConnection].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcPeeringConnectionPlainArgs].
     * @return A collection of values returned by getVpcPeeringConnection.
     */
    public suspend
    fun getVpcPeeringConnection(argument: suspend GetVpcPeeringConnectionPlainArgsBuilder.() -> Unit):
        GetVpcPeeringConnectionResult {
        val builder = GetVpcPeeringConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcPeeringConnectionResultToKotlin(getVpcPeeringConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get IDs of Amazon VPC peering connections
     * To get more details on each connection, use the data resource aws.ec2.VpcPeeringConnection
     * Note: To use this data source in a count, the resources should exist before trying to access
     * the data source.
     * ## Example Usage
     * No Java example available.
     * @param argument A collection of arguments for invoking getVpcPeeringConnections.
     * @return A collection of values returned by getVpcPeeringConnections.
     */
    public suspend fun getVpcPeeringConnections(argument: GetVpcPeeringConnectionsPlainArgs):
        GetVpcPeeringConnectionsResult =
        getVpcPeeringConnectionsResultToKotlin(getVpcPeeringConnectionsPlain(argument.toJava()).await())

    /**
     * @see [getVpcPeeringConnections].
     * @param filters Custom filter block as described below.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired VPC Peering Connection.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @return A collection of values returned by getVpcPeeringConnections.
     */
    public suspend fun getVpcPeeringConnections(
        filters: List<GetVpcPeeringConnectionsFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetVpcPeeringConnectionsResult {
        val argument = GetVpcPeeringConnectionsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getVpcPeeringConnectionsResultToKotlin(getVpcPeeringConnectionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcPeeringConnections].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcPeeringConnectionsPlainArgs].
     * @return A collection of values returned by getVpcPeeringConnections.
     */
    public suspend
    fun getVpcPeeringConnections(argument: suspend GetVpcPeeringConnectionsPlainArgsBuilder.() -> Unit):
        GetVpcPeeringConnectionsResult {
        val builder = GetVpcPeeringConnectionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcPeeringConnectionsResultToKotlin(getVpcPeeringConnectionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This resource can be useful for getting back a list of VPC Ids for a region.
     * The following example retrieves a list of VPC Ids with a custom tag of `service` set to a value of "production".
     * @param argument A collection of arguments for invoking getVpcs.
     * @return A collection of values returned by getVpcs.
     */
    public suspend fun getVpcs(argument: GetVpcsPlainArgs): GetVpcsResult =
        getVpcsResultToKotlin(getVpcsPlain(argument.toJava()).await())

    /**
     * @see [getVpcs].
     * @param filters Custom filter block as described below.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired vpcs.
     * @return A collection of values returned by getVpcs.
     */
    public suspend fun getVpcs(
        filters: List<GetVpcsFilter>? = null,
        tags: Map<String, String>? =
            null,
    ): GetVpcsResult {
        val argument = GetVpcsPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getVpcsResultToKotlin(getVpcsPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpcs].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpcsPlainArgs].
     * @return A collection of values returned by getVpcs.
     */
    public suspend fun getVpcs(argument: suspend GetVpcsPlainArgsBuilder.() -> Unit): GetVpcsResult {
        val builder = GetVpcsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpcsResultToKotlin(getVpcsPlain(builtArgument.toJava()).await())
    }

    /**
     * The VPN Gateway data source provides details about
     * a specific VPN gateway.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.Ec2Functions;
     * import com.pulumi.aws.ec2.inputs.GetVpnGatewayArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var selected = Ec2Functions.getVpnGateway(GetVpnGatewayArgs.builder()
     *             .filters(GetVpnGatewayFilterArgs.builder()
     *                 .name("tag:Name")
     *                 .values("vpn-gw")
     *                 .build())
     *             .build());
     *         ctx.export("vpnGatewayId", selected.applyValue(getVpnGatewayResult -> getVpnGatewayResult.id()));
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getVpnGateway.
     * @return A collection of values returned by getVpnGateway.
     */
    public suspend fun getVpnGateway(argument: GetVpnGatewayPlainArgs): GetVpnGatewayResult =
        getVpnGatewayResultToKotlin(getVpnGatewayPlain(argument.toJava()).await())

    /**
     * @see [getVpnGateway].
     * @param amazonSideAsn Autonomous System Number (ASN) for the Amazon side of the specific VPN Gateway to retrieve.
     * More complex filters can be expressed using one or more `filter` sub-blocks,
     * which take the following arguments:
     * @param attachedVpcId ID of a VPC attached to the specific VPN Gateway to retrieve.
     * @param availabilityZone Availability Zone of the specific VPN Gateway to retrieve.
     * @param filters Custom filter block as described below.
     * @param id ID of the specific VPN Gateway to retrieve.
     * @param state State of the specific VPN Gateway to retrieve.
     * @param tags Map of tags, each pair of which must exactly match
     * a pair on the desired VPN Gateway.
     * @return A collection of values returned by getVpnGateway.
     */
    public suspend fun getVpnGateway(
        amazonSideAsn: String? = null,
        attachedVpcId: String? = null,
        availabilityZone: String? = null,
        filters: List<GetVpnGatewayFilter>? = null,
        id: String? = null,
        state: String? = null,
        tags: Map<String, String>? = null,
    ): GetVpnGatewayResult {
        val argument = GetVpnGatewayPlainArgs(
            amazonSideAsn = amazonSideAsn,
            attachedVpcId = attachedVpcId,
            availabilityZone = availabilityZone,
            filters = filters,
            id = id,
            state = state,
            tags = tags,
        )
        return getVpnGatewayResultToKotlin(getVpnGatewayPlain(argument.toJava()).await())
    }

    /**
     * @see [getVpnGateway].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ec2&#46;kotlin&#46;inputs&#46;GetVpnGatewayPlainArgs].
     * @return A collection of values returned by getVpnGateway.
     */
    public suspend fun getVpnGateway(argument: suspend GetVpnGatewayPlainArgsBuilder.() -> Unit):
        GetVpnGatewayResult {
        val builder = GetVpnGatewayPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVpnGatewayResultToKotlin(getVpnGatewayPlain(builtArgument.toJava()).await())
    }
}
