@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [EgressOnlyInternetGateway].
 */
@PulumiTagMarker
public class EgressOnlyInternetGatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EgressOnlyInternetGatewayArgs = EgressOnlyInternetGatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EgressOnlyInternetGatewayArgsBuilder.() -> Unit) {
        val builder = EgressOnlyInternetGatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EgressOnlyInternetGateway {
        val builtJavaResource = com.pulumi.aws.ec2.EgressOnlyInternetGateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EgressOnlyInternetGateway(builtJavaResource)
    }
}

/**
 * [IPv6 only] Creates an egress-only Internet gateway for your VPC.
 * An egress-only Internet gateway is used to enable outbound communication
 * over IPv6 from instances in your VPC to the Internet, and prevents hosts
 * outside of your VPC from initiating an IPv6 connection with your instance.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.EgressOnlyInternetGateway;
 * import com.pulumi.aws.ec2.EgressOnlyInternetGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.1.0.0/16")
 *             .assignGeneratedIpv6CidrBlock(true)
 *             .build());
 *         var exampleEgressOnlyInternetGateway = new EgressOnlyInternetGateway("exampleEgressOnlyInternetGateway", EgressOnlyInternetGatewayArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .tags(Map.of("Name", "main"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Egress-only Internet gateways using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/egressOnlyInternetGateway:EgressOnlyInternetGateway example eigw-015e0e244e24dfe8a
 * ```
 *
 */
public class EgressOnlyInternetGateway internal constructor(
    override val javaResource: com.pulumi.aws.ec2.EgressOnlyInternetGateway,
) : KotlinCustomResource(javaResource, EgressOnlyInternetGatewayMapper) {
    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The VPC ID to create in.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object EgressOnlyInternetGatewayMapper : ResourceMapper<EgressOnlyInternetGateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.EgressOnlyInternetGateway::class == javaResource::class

    override fun map(javaResource: Resource): EgressOnlyInternetGateway =
        EgressOnlyInternetGateway(javaResource as com.pulumi.aws.ec2.EgressOnlyInternetGateway)
}

/**
 * @see [EgressOnlyInternetGateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EgressOnlyInternetGateway].
 */
public suspend fun egressOnlyInternetGateway(
    name: String,
    block: suspend EgressOnlyInternetGatewayResourceBuilder.() -> Unit,
): EgressOnlyInternetGateway {
    val builder = EgressOnlyInternetGatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EgressOnlyInternetGateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun egressOnlyInternetGateway(name: String): EgressOnlyInternetGateway {
    val builder = EgressOnlyInternetGatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
