@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Eip].
 */
@PulumiTagMarker
public class EipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EipArgs = EipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EipArgsBuilder.() -> Unit) {
        val builder = EipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Eip {
        val builtJavaResource = com.pulumi.aws.ec2.Eip(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Eip(builtJavaResource)
    }
}

/**
 * Provides an Elastic IP resource.
 * > **Note:** EIP may require IGW to exist prior to association. Use `depends_on` to set an explicit dependency on the IGW.
 * > **Note:** Do not use `network_interface` to associate the EIP to `aws.lb.LoadBalancer` or `aws.ec2.NatGateway` resources. Instead use the `allocation_id` available in those resources to allow AWS to manage the association, otherwise you will see `AuthFailure` errors.
 * ## Example Usage
 * ### Single EIP associated with an instance
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lb = new Eip("lb", EipArgs.builder()
 *             .instance(aws_instance.web().id())
 *             .domain("vpc")
 *             .build());
 *     }
 * }
 * ```
 * ### Multiple EIPs associated with a single network interface
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkInterface;
 * import com.pulumi.aws.ec2.NetworkInterfaceArgs;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var multi_ip = new NetworkInterface("multi-ip", NetworkInterfaceArgs.builder()
 *             .subnetId(aws_subnet.main().id())
 *             .privateIps(
 *                 "10.0.0.10",
 *                 "10.0.0.11")
 *             .build());
 *         var one = new Eip("one", EipArgs.builder()
 *             .domain("vpc")
 *             .networkInterface(multi_ip.id())
 *             .associateWithPrivateIp("10.0.0.10")
 *             .build());
 *         var two = new Eip("two", EipArgs.builder()
 *             .domain("vpc")
 *             .networkInterface(multi_ip.id())
 *             .associateWithPrivateIp("10.0.0.11")
 *             .build());
 *     }
 * }
 * ```
 * ### Attaching an EIP to an Instance with a pre-assigned private ip (VPC Only)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.InternetGateway;
 * import com.pulumi.aws.ec2.InternetGatewayArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Vpc("default", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .enableDnsHostnames(true)
 *             .build());
 *         var gw = new InternetGateway("gw", InternetGatewayArgs.builder()
 *             .vpcId(default_.id())
 *             .build());
 *         var myTestSubnet = new Subnet("myTestSubnet", SubnetArgs.builder()
 *             .vpcId(default_.id())
 *             .cidrBlock("10.0.0.0/24")
 *             .mapPublicIpOnLaunch(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(gw)
 *                 .build());
 *         var foo = new Instance("foo", InstanceArgs.builder()
 *             .ami("ami-5189a661")
 *             .instanceType("t2.micro")
 *             .privateIp("10.0.0.12")
 *             .subnetId(myTestSubnet.id())
 *             .build());
 *         var bar = new Eip("bar", EipArgs.builder()
 *             .domain("vpc")
 *             .instance(foo.id())
 *             .associateWithPrivateIp("10.0.0.12")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(gw)
 *                 .build());
 *     }
 * }
 * ```
 * ### Allocating EIP from the BYOIP pool
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var byoip_ip = new Eip("byoip-ip", EipArgs.builder()
 *             .domain("vpc")
 *             .publicIpv4Pool("ipv4pool-ec2-012345")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EIPs in a VPC using their Allocation ID. For example:
 * ```sh
 *  $ pulumi import aws:ec2/eip:Eip bar eipalloc-00a10e96
 * ```
 *
 */
public class Eip internal constructor(
    override val javaResource: com.pulumi.aws.ec2.Eip,
) : KotlinCustomResource(javaResource, EipMapper) {
    /**
     * IP address from an EC2 BYOIP pool. This option is only available for VPC EIPs.
     */
    public val address: Output<String>?
        get() = javaResource.address().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * ID that AWS assigns to represent the allocation of the Elastic IP address for use with instances in a VPC.
     */
    public val allocationId: Output<String>
        get() = javaResource.allocationId().applyValue({ args0 -> args0 })

    /**
     * User-specified primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
     */
    public val associateWithPrivateIp: Output<String>?
        get() = javaResource.associateWithPrivateIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ID representing the association of the address with an instance in a VPC.
     */
    public val associationId: Output<String>
        get() = javaResource.associationId().applyValue({ args0 -> args0 })

    /**
     * Carrier IP address.
     */
    public val carrierIp: Output<String>
        get() = javaResource.carrierIp().applyValue({ args0 -> args0 })

    /**
     * Customer owned IP.
     */
    public val customerOwnedIp: Output<String>
        get() = javaResource.customerOwnedIp().applyValue({ args0 -> args0 })

    /**
     * ID  of a customer-owned address pool. For more on customer owned IP addressed check out [Customer-owned IP addresses guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing).
     */
    public val customerOwnedIpv4Pool: Output<String>?
        get() = javaResource.customerOwnedIpv4Pool().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates if this EIP is for use in VPC (`vpc`).
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * EC2 instance ID.
     */
    public val instance: Output<String>
        get() = javaResource.instance().applyValue({ args0 -> args0 })

    /**
     * Location from which the IP address is advertised. Use this parameter to limit the address to this location.
     */
    public val networkBorderGroup: Output<String>
        get() = javaResource.networkBorderGroup().applyValue({ args0 -> args0 })

    /**
     * Network interface ID to associate with.
     */
    public val networkInterface: Output<String>
        get() = javaResource.networkInterface().applyValue({ args0 -> args0 })

    /**
     * The Private DNS associated with the Elastic IP address (if in VPC).
     */
    public val privateDns: Output<String>
        get() = javaResource.privateDns().applyValue({ args0 -> args0 })

    /**
     * Contains the private IP address (if in VPC).
     */
    public val privateIp: Output<String>
        get() = javaResource.privateIp().applyValue({ args0 -> args0 })

    /**
     * Public DNS associated with the Elastic IP address.
     */
    public val publicDns: Output<String>
        get() = javaResource.publicDns().applyValue({ args0 -> args0 })

    /**
     * Contains the public IP address.
     */
    public val publicIp: Output<String>
        get() = javaResource.publicIp().applyValue({ args0 -> args0 })

    /**
     * EC2 IPv4 address pool identifier or `amazon`.
     * This option is only available for VPC EIPs.
     */
    public val publicIpv4Pool: Output<String>
        get() = javaResource.publicIpv4Pool().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the resource. Tags can only be applied to EIPs in a VPC. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Boolean if the EIP is in a VPC or not. Use `domain` instead.
     * Defaults to `true` unless the region supports EC2-Classic.
     * > **NOTE:** You can specify either the `instance` ID or the `network_interface` ID, but not both. Including both will **not** return an error from the AWS API, but will have undefined behavior. See the relevant [AssociateAddress API Call][1] for more information.
     * > **NOTE:** Specifying both `public_ipv4_pool` and `address` won't cause an error but `address` will be used in the
     * case both options are defined as the api only requires one or the other.
     */
    @Deprecated(
        message = """
  use domain attribute instead
  """,
    )
    public val vpc: Output<Boolean>
        get() = javaResource.vpc().applyValue({ args0 -> args0 })
}

public object EipMapper : ResourceMapper<Eip> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.Eip::class == javaResource::class

    override fun map(javaResource: Resource): Eip = Eip(javaResource as com.pulumi.aws.ec2.Eip)
}

/**
 * @see [Eip].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Eip].
 */
public suspend fun eip(name: String, block: suspend EipResourceBuilder.() -> Unit): Eip {
    val builder = EipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Eip].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eip(name: String): Eip {
    val builder = EipResourceBuilder()
    builder.name(name)
    return builder.build()
}
