@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.EipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic IP resource.
 * > **Note:** EIP may require IGW to exist prior to association. Use `depends_on` to set an explicit dependency on the IGW.
 * > **Note:** Do not use `network_interface` to associate the EIP to `aws.lb.LoadBalancer` or `aws.ec2.NatGateway` resources. Instead use the `allocation_id` available in those resources to allow AWS to manage the association, otherwise you will see `AuthFailure` errors.
 * ## Example Usage
 * ### Single EIP associated with an instance
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lb = new Eip("lb", EipArgs.builder()
 *             .instance(aws_instance.web().id())
 *             .domain("vpc")
 *             .build());
 *     }
 * }
 * ```
 * ### Multiple EIPs associated with a single network interface
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.NetworkInterface;
 * import com.pulumi.aws.ec2.NetworkInterfaceArgs;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var multi_ip = new NetworkInterface("multi-ip", NetworkInterfaceArgs.builder()
 *             .subnetId(aws_subnet.main().id())
 *             .privateIps(
 *                 "10.0.0.10",
 *                 "10.0.0.11")
 *             .build());
 *         var one = new Eip("one", EipArgs.builder()
 *             .domain("vpc")
 *             .networkInterface(multi_ip.id())
 *             .associateWithPrivateIp("10.0.0.10")
 *             .build());
 *         var two = new Eip("two", EipArgs.builder()
 *             .domain("vpc")
 *             .networkInterface(multi_ip.id())
 *             .associateWithPrivateIp("10.0.0.11")
 *             .build());
 *     }
 * }
 * ```
 * ### Attaching an EIP to an Instance with a pre-assigned private ip (VPC Only)
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.InternetGateway;
 * import com.pulumi.aws.ec2.InternetGatewayArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Vpc("default", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .enableDnsHostnames(true)
 *             .build());
 *         var gw = new InternetGateway("gw", InternetGatewayArgs.builder()
 *             .vpcId(default_.id())
 *             .build());
 *         var myTestSubnet = new Subnet("myTestSubnet", SubnetArgs.builder()
 *             .vpcId(default_.id())
 *             .cidrBlock("10.0.0.0/24")
 *             .mapPublicIpOnLaunch(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(gw)
 *                 .build());
 *         var foo = new Instance("foo", InstanceArgs.builder()
 *             .ami("ami-5189a661")
 *             .instanceType("t2.micro")
 *             .privateIp("10.0.0.12")
 *             .subnetId(myTestSubnet.id())
 *             .build());
 *         var bar = new Eip("bar", EipArgs.builder()
 *             .domain("vpc")
 *             .instance(foo.id())
 *             .associateWithPrivateIp("10.0.0.12")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(gw)
 *                 .build());
 *     }
 * }
 * ```
 * ### Allocating EIP from the BYOIP pool
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var byoip_ip = new Eip("byoip-ip", EipArgs.builder()
 *             .domain("vpc")
 *             .publicIpv4Pool("ipv4pool-ec2-012345")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EIPs in a VPC using their Allocation ID. For example:
 * ```sh
 *  $ pulumi import aws:ec2/eip:Eip bar eipalloc-00a10e96
 * ```
 * @property address IP address from an EC2 BYOIP pool. This option is only available for VPC EIPs.
 * @property associateWithPrivateIp User-specified primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
 * @property customerOwnedIpv4Pool ID  of a customer-owned address pool. For more on customer owned IP addressed check out [Customer-owned IP addresses guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing).
 * @property domain Indicates if this EIP is for use in VPC (`vpc`).
 * @property instance EC2 instance ID.
 * @property networkBorderGroup Location from which the IP address is advertised. Use this parameter to limit the address to this location.
 * @property networkInterface Network interface ID to associate with.
 * @property publicIpv4Pool EC2 IPv4 address pool identifier or `amazon`.
 * This option is only available for VPC EIPs.
 * @property tags Map of tags to assign to the resource. Tags can only be applied to EIPs in a VPC. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpc Boolean if the EIP is in a VPC or not. Use `domain` instead.
 * Defaults to `true` unless the region supports EC2-Classic.
 * > **NOTE:** You can specify either the `instance` ID or the `network_interface` ID, but not both. Including both will **not** return an error from the AWS API, but will have undefined behavior. See the relevant [AssociateAddress API Call][1] for more information.
 * > **NOTE:** Specifying both `public_ipv4_pool` and `address` won't cause an error but `address` will be used in the
 * case both options are defined as the api only requires one or the other.
 */
public data class EipArgs(
    public val address: Output<String>? = null,
    public val associateWithPrivateIp: Output<String>? = null,
    public val customerOwnedIpv4Pool: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val instance: Output<String>? = null,
    public val networkBorderGroup: Output<String>? = null,
    public val networkInterface: Output<String>? = null,
    public val publicIpv4Pool: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    @Deprecated(
        message = """
  use domain attribute instead
  """,
    )
    public val vpc: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.EipArgs> {
    override fun toJava(): com.pulumi.aws.ec2.EipArgs = com.pulumi.aws.ec2.EipArgs.builder()
        .address(address?.applyValue({ args0 -> args0 }))
        .associateWithPrivateIp(associateWithPrivateIp?.applyValue({ args0 -> args0 }))
        .customerOwnedIpv4Pool(customerOwnedIpv4Pool?.applyValue({ args0 -> args0 }))
        .domain(domain?.applyValue({ args0 -> args0 }))
        .instance(instance?.applyValue({ args0 -> args0 }))
        .networkBorderGroup(networkBorderGroup?.applyValue({ args0 -> args0 }))
        .networkInterface(networkInterface?.applyValue({ args0 -> args0 }))
        .publicIpv4Pool(publicIpv4Pool?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .vpc(vpc?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EipArgs].
 */
@PulumiTagMarker
public class EipArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var associateWithPrivateIp: Output<String>? = null

    private var customerOwnedIpv4Pool: Output<String>? = null

    private var domain: Output<String>? = null

    private var instance: Output<String>? = null

    private var networkBorderGroup: Output<String>? = null

    private var networkInterface: Output<String>? = null

    private var publicIpv4Pool: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpc: Output<Boolean>? = null

    /**
     * @param value IP address from an EC2 BYOIP pool. This option is only available for VPC EIPs.
     */
    @JvmName("ehwunuslgfrcipma")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value User-specified primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
     */
    @JvmName("rmkatsqfohhpulca")
    public suspend fun associateWithPrivateIp(`value`: Output<String>) {
        this.associateWithPrivateIp = value
    }

    /**
     * @param value ID  of a customer-owned address pool. For more on customer owned IP addressed check out [Customer-owned IP addresses guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing).
     */
    @JvmName("nkphycagylutdhea")
    public suspend fun customerOwnedIpv4Pool(`value`: Output<String>) {
        this.customerOwnedIpv4Pool = value
    }

    /**
     * @param value Indicates if this EIP is for use in VPC (`vpc`).
     */
    @JvmName("vtduwynmvhtxdtcs")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value EC2 instance ID.
     */
    @JvmName("hpbfrbivtalnqxqq")
    public suspend fun instance(`value`: Output<String>) {
        this.instance = value
    }

    /**
     * @param value Location from which the IP address is advertised. Use this parameter to limit the address to this location.
     */
    @JvmName("xcgpxeovxvdrhabb")
    public suspend fun networkBorderGroup(`value`: Output<String>) {
        this.networkBorderGroup = value
    }

    /**
     * @param value Network interface ID to associate with.
     */
    @JvmName("bnioaioitdmwwush")
    public suspend fun networkInterface(`value`: Output<String>) {
        this.networkInterface = value
    }

    /**
     * @param value EC2 IPv4 address pool identifier or `amazon`.
     * This option is only available for VPC EIPs.
     */
    @JvmName("ykduxnsteypgahps")
    public suspend fun publicIpv4Pool(`value`: Output<String>) {
        this.publicIpv4Pool = value
    }

    /**
     * @param value Map of tags to assign to the resource. Tags can only be applied to EIPs in a VPC. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kshilycjulsiaogx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Boolean if the EIP is in a VPC or not. Use `domain` instead.
     * Defaults to `true` unless the region supports EC2-Classic.
     * > **NOTE:** You can specify either the `instance` ID or the `network_interface` ID, but not both. Including both will **not** return an error from the AWS API, but will have undefined behavior. See the relevant [AssociateAddress API Call][1] for more information.
     * > **NOTE:** Specifying both `public_ipv4_pool` and `address` won't cause an error but `address` will be used in the
     * case both options are defined as the api only requires one or the other.
     */
    @Deprecated(
        message = """
  use domain attribute instead
  """,
    )
    @JvmName("vftxmshthprpbgvl")
    public suspend fun vpc(`value`: Output<Boolean>) {
        this.vpc = value
    }

    /**
     * @param value IP address from an EC2 BYOIP pool. This option is only available for VPC EIPs.
     */
    @JvmName("vaornvwrpnnspeqc")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value User-specified primary or secondary private IP address to associate with the Elastic IP address. If no private IP address is specified, the Elastic IP address is associated with the primary private IP address.
     */
    @JvmName("rjosaignmhjuhpsh")
    public suspend fun associateWithPrivateIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associateWithPrivateIp = mapped
    }

    /**
     * @param value ID  of a customer-owned address pool. For more on customer owned IP addressed check out [Customer-owned IP addresses guide](https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing).
     */
    @JvmName("tuhjpxtvxhcankju")
    public suspend fun customerOwnedIpv4Pool(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerOwnedIpv4Pool = mapped
    }

    /**
     * @param value Indicates if this EIP is for use in VPC (`vpc`).
     */
    @JvmName("mcydvvqhnbxhqjyb")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value EC2 instance ID.
     */
    @JvmName("wqidmgpftfecskrs")
    public suspend fun instance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instance = mapped
    }

    /**
     * @param value Location from which the IP address is advertised. Use this parameter to limit the address to this location.
     */
    @JvmName("maphgswcccpmyfka")
    public suspend fun networkBorderGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkBorderGroup = mapped
    }

    /**
     * @param value Network interface ID to associate with.
     */
    @JvmName("dpdxnmfxhkidfjqq")
    public suspend fun networkInterface(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterface = mapped
    }

    /**
     * @param value EC2 IPv4 address pool identifier or `amazon`.
     * This option is only available for VPC EIPs.
     */
    @JvmName("fqratudffuqiavhi")
    public suspend fun publicIpv4Pool(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIpv4Pool = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. Tags can only be applied to EIPs in a VPC. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mvxdgbarmigtbuan")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. Tags can only be applied to EIPs in a VPC. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bbnpfjkypjvjueic")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Boolean if the EIP is in a VPC or not. Use `domain` instead.
     * Defaults to `true` unless the region supports EC2-Classic.
     * > **NOTE:** You can specify either the `instance` ID or the `network_interface` ID, but not both. Including both will **not** return an error from the AWS API, but will have undefined behavior. See the relevant [AssociateAddress API Call][1] for more information.
     * > **NOTE:** Specifying both `public_ipv4_pool` and `address` won't cause an error but `address` will be used in the
     * case both options are defined as the api only requires one or the other.
     */
    @Deprecated(
        message = """
  use domain attribute instead
  """,
    )
    @JvmName("xsghxqhmuhvfrywd")
    public suspend fun vpc(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpc = mapped
    }

    internal fun build(): EipArgs = EipArgs(
        address = address,
        associateWithPrivateIp = associateWithPrivateIp,
        customerOwnedIpv4Pool = customerOwnedIpv4Pool,
        domain = domain,
        instance = instance,
        networkBorderGroup = networkBorderGroup,
        networkInterface = networkInterface,
        publicIpv4Pool = publicIpv4Pool,
        tags = tags,
        vpc = vpc,
    )
}
