@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [EipAssociation].
 */
@PulumiTagMarker
public class EipAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EipAssociationArgs = EipAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EipAssociationArgsBuilder.() -> Unit) {
        val builder = EipAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EipAssociation {
        val builtJavaResource = com.pulumi.aws.ec2.EipAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EipAssociation(builtJavaResource)
    }
}

/**
 * Provides an AWS EIP Association as a top level resource, to associate and
 * disassociate Elastic IPs from AWS Instances and Network Interfaces.
 * > **NOTE:** Do not use this resource to associate an EIP to `aws.lb.LoadBalancer` or `aws.ec2.NatGateway` resources. Instead use the `allocation_id` available in those resources to allow AWS to manage the association, otherwise you will see `AuthFailure` errors.
 * > **NOTE:** `aws.ec2.EipAssociation` is useful in scenarios where EIPs are either
 * pre-existing or distributed to customers or users and therefore cannot be changed.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import com.pulumi.aws.ec2.EipAssociation;
 * import com.pulumi.aws.ec2.EipAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var web = new Instance("web", InstanceArgs.builder()
 *             .ami("ami-21f78e11")
 *             .availabilityZone("us-west-2a")
 *             .instanceType("t2.micro")
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *         var example = new Eip("example", EipArgs.builder()
 *             .domain("vpc")
 *             .build());
 *         var eipAssoc = new EipAssociation("eipAssoc", EipAssociationArgs.builder()
 *             .instanceId(web.id())
 *             .allocationId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EIP Assocations using their association IDs. For example:
 * ```sh
 *  $ pulumi import aws:ec2/eipAssociation:EipAssociation test eipassoc-ab12c345
 * ```
 *
 */
public class EipAssociation internal constructor(
    override val javaResource: com.pulumi.aws.ec2.EipAssociation,
) : KotlinCustomResource(javaResource, EipAssociationMapper) {
    /**
     * The allocation ID. This is required for EC2-VPC.
     */
    public val allocationId: Output<String>
        get() = javaResource.allocationId().applyValue({ args0 -> args0 })

    /**
     * Whether to allow an Elastic IP to
     * be re-associated. Defaults to `true` in VPC.
     */
    public val allowReassociation: Output<Boolean>?
        get() = javaResource.allowReassociation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the instance. This is required for
     * EC2-Classic. For EC2-VPC, you can specify either the instance ID or the
     * network interface ID, but not both. The operation fails if you specify an
     * instance ID unless exactly one network interface is attached.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * The ID of the network interface. If the
     * instance has more than one network interface, you must specify a network
     * interface ID.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The primary or secondary private IP address
     * to associate with the Elastic IP address. If no private IP address is
     * specified, the Elastic IP address is associated with the primary private IP
     * address.
     */
    public val privateIpAddress: Output<String>
        get() = javaResource.privateIpAddress().applyValue({ args0 -> args0 })

    /**
     * The Elastic IP address. This is required for EC2-Classic.
     */
    public val publicIp: Output<String>
        get() = javaResource.publicIp().applyValue({ args0 -> args0 })
}

public object EipAssociationMapper : ResourceMapper<EipAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.EipAssociation::class == javaResource::class

    override fun map(javaResource: Resource): EipAssociation = EipAssociation(
        javaResource as
            com.pulumi.aws.ec2.EipAssociation,
    )
}

/**
 * @see [EipAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EipAssociation].
 */
public suspend fun eipAssociation(
    name: String,
    block: suspend EipAssociationResourceBuilder.() -> Unit,
): EipAssociation {
    val builder = EipAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EipAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eipAssociation(name: String): EipAssociation {
    val builder = EipAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
