@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.EipAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AWS EIP Association as a top level resource, to associate and
 * disassociate Elastic IPs from AWS Instances and Network Interfaces.
 * > **NOTE:** Do not use this resource to associate an EIP to `aws.lb.LoadBalancer` or `aws.ec2.NatGateway` resources. Instead use the `allocation_id` available in those resources to allow AWS to manage the association, otherwise you will see `AuthFailure` errors.
 * > **NOTE:** `aws.ec2.EipAssociation` is useful in scenarios where EIPs are either
 * pre-existing or distributed to customers or users and therefore cannot be changed.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.Eip;
 * import com.pulumi.aws.ec2.EipArgs;
 * import com.pulumi.aws.ec2.EipAssociation;
 * import com.pulumi.aws.ec2.EipAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var web = new Instance("web", InstanceArgs.builder()
 *             .ami("ami-21f78e11")
 *             .availabilityZone("us-west-2a")
 *             .instanceType("t2.micro")
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *         var example = new Eip("example", EipArgs.builder()
 *             .domain("vpc")
 *             .build());
 *         var eipAssoc = new EipAssociation("eipAssoc", EipAssociationArgs.builder()
 *             .instanceId(web.id())
 *             .allocationId(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import EIP Assocations using their association IDs. For example:
 * ```sh
 *  $ pulumi import aws:ec2/eipAssociation:EipAssociation test eipassoc-ab12c345
 * ```
 * @property allocationId The allocation ID. This is required for EC2-VPC.
 * @property allowReassociation Whether to allow an Elastic IP to
 * be re-associated. Defaults to `true` in VPC.
 * @property instanceId The ID of the instance. This is required for
 * EC2-Classic. For EC2-VPC, you can specify either the instance ID or the
 * network interface ID, but not both. The operation fails if you specify an
 * instance ID unless exactly one network interface is attached.
 * @property networkInterfaceId The ID of the network interface. If the
 * instance has more than one network interface, you must specify a network
 * interface ID.
 * @property privateIpAddress The primary or secondary private IP address
 * to associate with the Elastic IP address. If no private IP address is
 * specified, the Elastic IP address is associated with the primary private IP
 * address.
 * @property publicIp The Elastic IP address. This is required for EC2-Classic.
 */
public data class EipAssociationArgs(
    public val allocationId: Output<String>? = null,
    public val allowReassociation: Output<Boolean>? = null,
    public val instanceId: Output<String>? = null,
    public val networkInterfaceId: Output<String>? = null,
    public val privateIpAddress: Output<String>? = null,
    public val publicIp: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.EipAssociationArgs> {
    override fun toJava(): com.pulumi.aws.ec2.EipAssociationArgs =
        com.pulumi.aws.ec2.EipAssociationArgs.builder()
            .allocationId(allocationId?.applyValue({ args0 -> args0 }))
            .allowReassociation(allowReassociation?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .networkInterfaceId(networkInterfaceId?.applyValue({ args0 -> args0 }))
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 }))
            .publicIp(publicIp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EipAssociationArgs].
 */
@PulumiTagMarker
public class EipAssociationArgsBuilder internal constructor() {
    private var allocationId: Output<String>? = null

    private var allowReassociation: Output<Boolean>? = null

    private var instanceId: Output<String>? = null

    private var networkInterfaceId: Output<String>? = null

    private var privateIpAddress: Output<String>? = null

    private var publicIp: Output<String>? = null

    /**
     * @param value The allocation ID. This is required for EC2-VPC.
     */
    @JvmName("bngxeevafslasghy")
    public suspend fun allocationId(`value`: Output<String>) {
        this.allocationId = value
    }

    /**
     * @param value Whether to allow an Elastic IP to
     * be re-associated. Defaults to `true` in VPC.
     */
    @JvmName("lisewoboeiblqtml")
    public suspend fun allowReassociation(`value`: Output<Boolean>) {
        this.allowReassociation = value
    }

    /**
     * @param value The ID of the instance. This is required for
     * EC2-Classic. For EC2-VPC, you can specify either the instance ID or the
     * network interface ID, but not both. The operation fails if you specify an
     * instance ID unless exactly one network interface is attached.
     */
    @JvmName("idcphjwmtwkvffpo")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The ID of the network interface. If the
     * instance has more than one network interface, you must specify a network
     * interface ID.
     */
    @JvmName("rwdeyelbdpcrsfpl")
    public suspend fun networkInterfaceId(`value`: Output<String>) {
        this.networkInterfaceId = value
    }

    /**
     * @param value The primary or secondary private IP address
     * to associate with the Elastic IP address. If no private IP address is
     * specified, the Elastic IP address is associated with the primary private IP
     * address.
     */
    @JvmName("cfegxdxiedwwpuin")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value The Elastic IP address. This is required for EC2-Classic.
     */
    @JvmName("wfveelovuxkedbro")
    public suspend fun publicIp(`value`: Output<String>) {
        this.publicIp = value
    }

    /**
     * @param value The allocation ID. This is required for EC2-VPC.
     */
    @JvmName("orklbohryqyprvls")
    public suspend fun allocationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationId = mapped
    }

    /**
     * @param value Whether to allow an Elastic IP to
     * be re-associated. Defaults to `true` in VPC.
     */
    @JvmName("xuisvhpndiddbcjv")
    public suspend fun allowReassociation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowReassociation = mapped
    }

    /**
     * @param value The ID of the instance. This is required for
     * EC2-Classic. For EC2-VPC, you can specify either the instance ID or the
     * network interface ID, but not both. The operation fails if you specify an
     * instance ID unless exactly one network interface is attached.
     */
    @JvmName("exyhhbrcouxpuake")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The ID of the network interface. If the
     * instance has more than one network interface, you must specify a network
     * interface ID.
     */
    @JvmName("mgafehjqkvwvddlx")
    public suspend fun networkInterfaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceId = mapped
    }

    /**
     * @param value The primary or secondary private IP address
     * to associate with the Elastic IP address. If no private IP address is
     * specified, the Elastic IP address is associated with the primary private IP
     * address.
     */
    @JvmName("tfyncuwoexaqyvss")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param value The Elastic IP address. This is required for EC2-Classic.
     */
    @JvmName("vubyewtxhfalodll")
    public suspend fun publicIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicIp = mapped
    }

    internal fun build(): EipAssociationArgs = EipAssociationArgs(
        allocationId = allocationId,
        allowReassociation = allowReassociation,
        instanceId = instanceId,
        networkInterfaceId = networkInterfaceId,
        privateIpAddress = privateIpAddress,
        publicIp = publicIp,
    )
}
