@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.kotlin.outputs.FleetFleetInstanceSet
import com.pulumi.aws.ec2.kotlin.outputs.FleetLaunchTemplateConfig
import com.pulumi.aws.ec2.kotlin.outputs.FleetOnDemandOptions
import com.pulumi.aws.ec2.kotlin.outputs.FleetSpotOptions
import com.pulumi.aws.ec2.kotlin.outputs.FleetTargetCapacitySpecification
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ec2.kotlin.outputs.FleetFleetInstanceSet.Companion.toKotlin as fleetFleetInstanceSetToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.FleetLaunchTemplateConfig.Companion.toKotlin as fleetLaunchTemplateConfigToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.FleetOnDemandOptions.Companion.toKotlin as fleetOnDemandOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.FleetSpotOptions.Companion.toKotlin as fleetSpotOptionsToKotlin
import com.pulumi.aws.ec2.kotlin.outputs.FleetTargetCapacitySpecification.Companion.toKotlin as fleetTargetCapacitySpecificationToKotlin

/**
 * Builder for [Fleet].
 */
@PulumiTagMarker
public class FleetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FleetArgs = FleetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FleetArgsBuilder.() -> Unit) {
        val builder = FleetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Fleet {
        val builtJavaResource = com.pulumi.aws.ec2.Fleet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Fleet(builtJavaResource)
    }
}

/**
 * Provides a resource to manage EC2 Fleets.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Fleet;
 * import com.pulumi.aws.ec2.FleetArgs;
 * import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigArgs;
 * import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs;
 * import com.pulumi.aws.ec2.inputs.FleetTargetCapacitySpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Fleet("example", FleetArgs.builder()
 *             .launchTemplateConfigs(FleetLaunchTemplateConfigArgs.builder()
 *                 .launchTemplateSpecification(FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs.builder()
 *                     .launchTemplateId(aws_launch_template.example().id())
 *                     .version(aws_launch_template.example().latest_version())
 *                     .build())
 *                 .build())
 *             .targetCapacitySpecification(FleetTargetCapacitySpecificationArgs.builder()
 *                 .defaultTargetCapacityType("spot")
 *                 .totalTargetCapacity(5)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_fleet` using the Fleet identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2/fleet:Fleet example fleet-b9b55d27-c5fc-41ac-a6f3-48fcc91f080c
 * ```
 *
 */
public class Fleet internal constructor(
    override val javaResource: com.pulumi.aws.ec2.Fleet,
) : KotlinCustomResource(javaResource, FleetMapper) {
    /**
     * The ARN of the fleet
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Reserved.
     */
    public val context: Output<String>?
        get() = javaResource.context().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2. Valid values: `no-termination`, `termination`. Defaults to `termination`. Supported only for fleets of type `maintain`.
     */
    public val excessCapacityTerminationPolicy: Output<String>?
        get() = javaResource.excessCapacityTerminationPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    public val fleetInstanceSets: Output<List<FleetFleetInstanceSet>>
        get() = javaResource.fleetInstanceSets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> fleetFleetInstanceSetToKotlin(args0) })
            })
        })

    /**
     * The state of the EC2 Fleet.
     */
    public val fleetState: Output<String>
        get() = javaResource.fleetState().applyValue({ args0 -> args0 })

    /**
     * The number of units fulfilled by this request compared to the set target capacity.
     */
    public val fulfilledCapacity: Output<Double>
        get() = javaResource.fulfilledCapacity().applyValue({ args0 -> args0 })

    /**
     * The number of units fulfilled by this request compared to the set target On-Demand capacity.
     */
    public val fulfilledOnDemandCapacity: Output<Double>
        get() = javaResource.fulfilledOnDemandCapacity().applyValue({ args0 -> args0 })

    /**
     * Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    public val launchTemplateConfigs: Output<List<FleetLaunchTemplateConfig>>
        get() = javaResource.launchTemplateConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> fleetLaunchTemplateConfigToKotlin(args0) })
            })
        })

    /**
     * Nested argument containing On-Demand configurations. Defined below.
     */
    public val onDemandOptions: Output<FleetOnDemandOptions>?
        get() = javaResource.onDemandOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> fleetOnDemandOptionsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Whether EC2 Fleet should replace unhealthy instances. Defaults to `false`. Supported only for fleets of type `maintain`.
     */
    public val replaceUnhealthyInstances: Output<Boolean>?
        get() = javaResource.replaceUnhealthyInstances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Nested argument containing Spot configurations. Defined below.
     */
    public val spotOptions: Output<FleetSpotOptions>?
        get() = javaResource.spotOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    fleetSpotOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Nested argument containing target capacity configurations. Defined below.
     */
    public val targetCapacitySpecification: Output<FleetTargetCapacitySpecification>
        get() = javaResource.targetCapacitySpecification().applyValue({ args0 ->
            args0.let({ args0 ->
                fleetTargetCapacitySpecificationToKotlin(args0)
            })
        })

    /**
     * Whether to terminate instances for an EC2 Fleet if it is deleted successfully. Defaults to `false`.
     */
    public val terminateInstances: Output<Boolean>?
        get() = javaResource.terminateInstances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether running instances should be terminated when the EC2 Fleet expires. Defaults to `false`.
     */
    public val terminateInstancesWithExpiration: Output<Boolean>?
        get() = javaResource.terminateInstancesWithExpiration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of request. Indicates whether the EC2 Fleet only requests the target capacity, or also attempts to maintain it. Valid values: `maintain`, `request`, `instant`. Defaults to `maintain`.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     */
    public val validFrom: Output<String>?
        get() = javaResource.validFrom().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
     */
    public val validUntil: Output<String>?
        get() = javaResource.validUntil().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object FleetMapper : ResourceMapper<Fleet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.Fleet::class == javaResource::class

    override fun map(javaResource: Resource): Fleet = Fleet(javaResource as com.pulumi.aws.ec2.Fleet)
}

/**
 * @see [Fleet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Fleet].
 */
public suspend fun fleet(name: String, block: suspend FleetResourceBuilder.() -> Unit): Fleet {
    val builder = FleetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Fleet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fleet(name: String): Fleet {
    val builder = FleetResourceBuilder()
    builder.name(name)
    return builder.build()
}
