@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.FleetArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.FleetFleetInstanceSetArgs
import com.pulumi.aws.ec2.kotlin.inputs.FleetFleetInstanceSetArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.FleetLaunchTemplateConfigArgs
import com.pulumi.aws.ec2.kotlin.inputs.FleetLaunchTemplateConfigArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.FleetOnDemandOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.FleetOnDemandOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.FleetSpotOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.FleetSpotOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.FleetTargetCapacitySpecificationArgs
import com.pulumi.aws.ec2.kotlin.inputs.FleetTargetCapacitySpecificationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage EC2 Fleets.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Fleet;
 * import com.pulumi.aws.ec2.FleetArgs;
 * import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigArgs;
 * import com.pulumi.aws.ec2.inputs.FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs;
 * import com.pulumi.aws.ec2.inputs.FleetTargetCapacitySpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Fleet("example", FleetArgs.builder()
 *             .launchTemplateConfigs(FleetLaunchTemplateConfigArgs.builder()
 *                 .launchTemplateSpecification(FleetLaunchTemplateConfigLaunchTemplateSpecificationArgs.builder()
 *                     .launchTemplateId(aws_launch_template.example().id())
 *                     .version(aws_launch_template.example().latest_version())
 *                     .build())
 *                 .build())
 *             .targetCapacitySpecification(FleetTargetCapacitySpecificationArgs.builder()
 *                 .defaultTargetCapacityType("spot")
 *                 .totalTargetCapacity(5)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_ec2_fleet` using the Fleet identifier. For example:
 * ```sh
 *  $ pulumi import aws:ec2/fleet:Fleet example fleet-b9b55d27-c5fc-41ac-a6f3-48fcc91f080c
 * ```
 * @property context Reserved.
 * @property excessCapacityTerminationPolicy Whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2. Valid values: `no-termination`, `termination`. Defaults to `termination`. Supported only for fleets of type `maintain`.
 * @property fleetInstanceSets Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
 * @property fleetState The state of the EC2 Fleet.
 * @property fulfilledCapacity The number of units fulfilled by this request compared to the set target capacity.
 * @property fulfilledOnDemandCapacity The number of units fulfilled by this request compared to the set target On-Demand capacity.
 * @property launchTemplateConfigs Nested argument containing EC2 Launch Template configurations. Defined below.
 * @property onDemandOptions Nested argument containing On-Demand configurations. Defined below.
 * @property replaceUnhealthyInstances Whether EC2 Fleet should replace unhealthy instances. Defaults to `false`. Supported only for fleets of type `maintain`.
 * @property spotOptions Nested argument containing Spot configurations. Defined below.
 * @property tags Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetCapacitySpecification Nested argument containing target capacity configurations. Defined below.
 * @property terminateInstances Whether to terminate instances for an EC2 Fleet if it is deleted successfully. Defaults to `false`.
 * @property terminateInstancesWithExpiration Whether running instances should be terminated when the EC2 Fleet expires. Defaults to `false`.
 * @property type The type of request. Indicates whether the EC2 Fleet only requests the target capacity, or also attempts to maintain it. Valid values: `maintain`, `request`, `instant`. Defaults to `maintain`.
 * @property validFrom The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
 * @property validUntil The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
 */
public data class FleetArgs(
    public val context: Output<String>? = null,
    public val excessCapacityTerminationPolicy: Output<String>? = null,
    public val fleetInstanceSets: Output<List<FleetFleetInstanceSetArgs>>? = null,
    public val fleetState: Output<String>? = null,
    public val fulfilledCapacity: Output<Double>? = null,
    public val fulfilledOnDemandCapacity: Output<Double>? = null,
    public val launchTemplateConfigs: Output<List<FleetLaunchTemplateConfigArgs>>? = null,
    public val onDemandOptions: Output<FleetOnDemandOptionsArgs>? = null,
    public val replaceUnhealthyInstances: Output<Boolean>? = null,
    public val spotOptions: Output<FleetSpotOptionsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetCapacitySpecification: Output<FleetTargetCapacitySpecificationArgs>? = null,
    public val terminateInstances: Output<Boolean>? = null,
    public val terminateInstancesWithExpiration: Output<Boolean>? = null,
    public val type: Output<String>? = null,
    public val validFrom: Output<String>? = null,
    public val validUntil: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.FleetArgs> {
    override fun toJava(): com.pulumi.aws.ec2.FleetArgs = com.pulumi.aws.ec2.FleetArgs.builder()
        .context(context?.applyValue({ args0 -> args0 }))
        .excessCapacityTerminationPolicy(excessCapacityTerminationPolicy?.applyValue({ args0 -> args0 }))
        .fleetInstanceSets(
            fleetInstanceSets?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .fleetState(fleetState?.applyValue({ args0 -> args0 }))
        .fulfilledCapacity(fulfilledCapacity?.applyValue({ args0 -> args0 }))
        .fulfilledOnDemandCapacity(fulfilledOnDemandCapacity?.applyValue({ args0 -> args0 }))
        .launchTemplateConfigs(
            launchTemplateConfigs?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .onDemandOptions(onDemandOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .replaceUnhealthyInstances(replaceUnhealthyInstances?.applyValue({ args0 -> args0 }))
        .spotOptions(spotOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .targetCapacitySpecification(
            targetCapacitySpecification?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .terminateInstances(terminateInstances?.applyValue({ args0 -> args0 }))
        .terminateInstancesWithExpiration(terminateInstancesWithExpiration?.applyValue({ args0 -> args0 }))
        .type(type?.applyValue({ args0 -> args0 }))
        .validFrom(validFrom?.applyValue({ args0 -> args0 }))
        .validUntil(validUntil?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetArgs].
 */
@PulumiTagMarker
public class FleetArgsBuilder internal constructor() {
    private var context: Output<String>? = null

    private var excessCapacityTerminationPolicy: Output<String>? = null

    private var fleetInstanceSets: Output<List<FleetFleetInstanceSetArgs>>? = null

    private var fleetState: Output<String>? = null

    private var fulfilledCapacity: Output<Double>? = null

    private var fulfilledOnDemandCapacity: Output<Double>? = null

    private var launchTemplateConfigs: Output<List<FleetLaunchTemplateConfigArgs>>? = null

    private var onDemandOptions: Output<FleetOnDemandOptionsArgs>? = null

    private var replaceUnhealthyInstances: Output<Boolean>? = null

    private var spotOptions: Output<FleetSpotOptionsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetCapacitySpecification: Output<FleetTargetCapacitySpecificationArgs>? = null

    private var terminateInstances: Output<Boolean>? = null

    private var terminateInstancesWithExpiration: Output<Boolean>? = null

    private var type: Output<String>? = null

    private var validFrom: Output<String>? = null

    private var validUntil: Output<String>? = null

    /**
     * @param value Reserved.
     */
    @JvmName("wkgjkhjhkthxhvpm")
    public suspend fun context(`value`: Output<String>) {
        this.context = value
    }

    /**
     * @param value Whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2. Valid values: `no-termination`, `termination`. Defaults to `termination`. Supported only for fleets of type `maintain`.
     */
    @JvmName("okgtwvxegfmukiit")
    public suspend fun excessCapacityTerminationPolicy(`value`: Output<String>) {
        this.excessCapacityTerminationPolicy = value
    }

    /**
     * @param value Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    @JvmName("oknptborqhrtprgo")
    public suspend fun fleetInstanceSets(`value`: Output<List<FleetFleetInstanceSetArgs>>) {
        this.fleetInstanceSets = value
    }

    @JvmName("vhyjwiuduohujkln")
    public suspend fun fleetInstanceSets(vararg values: Output<FleetFleetInstanceSetArgs>) {
        this.fleetInstanceSets = Output.all(values.asList())
    }

    /**
     * @param values Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    @JvmName("iupeeqcbctfbbuvq")
    public suspend fun fleetInstanceSets(values: List<Output<FleetFleetInstanceSetArgs>>) {
        this.fleetInstanceSets = Output.all(values)
    }

    /**
     * @param value The state of the EC2 Fleet.
     */
    @JvmName("oxlglwtxqsnldksd")
    public suspend fun fleetState(`value`: Output<String>) {
        this.fleetState = value
    }

    /**
     * @param value The number of units fulfilled by this request compared to the set target capacity.
     */
    @JvmName("jikcanprfbjfrtwf")
    public suspend fun fulfilledCapacity(`value`: Output<Double>) {
        this.fulfilledCapacity = value
    }

    /**
     * @param value The number of units fulfilled by this request compared to the set target On-Demand capacity.
     */
    @JvmName("inuugnxpuxcnkhgu")
    public suspend fun fulfilledOnDemandCapacity(`value`: Output<Double>) {
        this.fulfilledOnDemandCapacity = value
    }

    /**
     * @param value Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    @JvmName("ahdngoswbajaigix")
    public suspend fun launchTemplateConfigs(`value`: Output<List<FleetLaunchTemplateConfigArgs>>) {
        this.launchTemplateConfigs = value
    }

    @JvmName("unsxcnrtcvgyntuq")
    public suspend fun launchTemplateConfigs(vararg values: Output<FleetLaunchTemplateConfigArgs>) {
        this.launchTemplateConfigs = Output.all(values.asList())
    }

    /**
     * @param values Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    @JvmName("jkmuhtcqsmltmcxd")
    public suspend fun launchTemplateConfigs(values: List<Output<FleetLaunchTemplateConfigArgs>>) {
        this.launchTemplateConfigs = Output.all(values)
    }

    /**
     * @param value Nested argument containing On-Demand configurations. Defined below.
     */
    @JvmName("edmfuenqprklnlov")
    public suspend fun onDemandOptions(`value`: Output<FleetOnDemandOptionsArgs>) {
        this.onDemandOptions = value
    }

    /**
     * @param value Whether EC2 Fleet should replace unhealthy instances. Defaults to `false`. Supported only for fleets of type `maintain`.
     */
    @JvmName("heksyfttehddcphh")
    public suspend fun replaceUnhealthyInstances(`value`: Output<Boolean>) {
        this.replaceUnhealthyInstances = value
    }

    /**
     * @param value Nested argument containing Spot configurations. Defined below.
     */
    @JvmName("uoabqfklwmdgcxch")
    public suspend fun spotOptions(`value`: Output<FleetSpotOptionsArgs>) {
        this.spotOptions = value
    }

    /**
     * @param value Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vlqutdrupbnuqemc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Nested argument containing target capacity configurations. Defined below.
     */
    @JvmName("kdbkhypdgnxqvnql")
    public suspend
    fun targetCapacitySpecification(`value`: Output<FleetTargetCapacitySpecificationArgs>) {
        this.targetCapacitySpecification = value
    }

    /**
     * @param value Whether to terminate instances for an EC2 Fleet if it is deleted successfully. Defaults to `false`.
     */
    @JvmName("kpxemrfjavpaeequ")
    public suspend fun terminateInstances(`value`: Output<Boolean>) {
        this.terminateInstances = value
    }

    /**
     * @param value Whether running instances should be terminated when the EC2 Fleet expires. Defaults to `false`.
     */
    @JvmName("gfparodfmklycoel")
    public suspend fun terminateInstancesWithExpiration(`value`: Output<Boolean>) {
        this.terminateInstancesWithExpiration = value
    }

    /**
     * @param value The type of request. Indicates whether the EC2 Fleet only requests the target capacity, or also attempts to maintain it. Valid values: `maintain`, `request`, `instant`. Defaults to `maintain`.
     */
    @JvmName("blaoeswmsnndgihi")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     */
    @JvmName("rpsmplnlsohbtorc")
    public suspend fun validFrom(`value`: Output<String>) {
        this.validFrom = value
    }

    /**
     * @param value The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
     */
    @JvmName("bbwylxpipknfdqaj")
    public suspend fun validUntil(`value`: Output<String>) {
        this.validUntil = value
    }

    /**
     * @param value Reserved.
     */
    @JvmName("frriciydclrbevpy")
    public suspend fun context(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.context = mapped
    }

    /**
     * @param value Whether running instances should be terminated if the total target capacity of the EC2 Fleet is decreased below the current size of the EC2. Valid values: `no-termination`, `termination`. Defaults to `termination`. Supported only for fleets of type `maintain`.
     */
    @JvmName("djbqitfuubfaqvwp")
    public suspend fun excessCapacityTerminationPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excessCapacityTerminationPolicy = mapped
    }

    /**
     * @param value Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    @JvmName("puxnevbrplktahja")
    public suspend fun fleetInstanceSets(`value`: List<FleetFleetInstanceSetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetInstanceSets = mapped
    }

    /**
     * @param argument Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    @JvmName("prntmctiejwjddag")
    public suspend
    fun fleetInstanceSets(argument: List<suspend FleetFleetInstanceSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FleetFleetInstanceSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fleetInstanceSets = mapped
    }

    /**
     * @param argument Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    @JvmName("tksbnsogvfkjqqro")
    public suspend fun fleetInstanceSets(
        vararg
        argument: suspend FleetFleetInstanceSetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FleetFleetInstanceSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fleetInstanceSets = mapped
    }

    /**
     * @param argument Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    @JvmName("ocskcsxtoinrmpko")
    public suspend
    fun fleetInstanceSets(argument: suspend FleetFleetInstanceSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FleetFleetInstanceSetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.fleetInstanceSets = mapped
    }

    /**
     * @param values Information about the instances that were launched by the fleet. Available only when `type` is set to `instant`.
     */
    @JvmName("iapjdemurlevyuhf")
    public suspend fun fleetInstanceSets(vararg values: FleetFleetInstanceSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fleetInstanceSets = mapped
    }

    /**
     * @param value The state of the EC2 Fleet.
     */
    @JvmName("pueaiassaxrvroxv")
    public suspend fun fleetState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetState = mapped
    }

    /**
     * @param value The number of units fulfilled by this request compared to the set target capacity.
     */
    @JvmName("jhbkwvyfpuftejau")
    public suspend fun fulfilledCapacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fulfilledCapacity = mapped
    }

    /**
     * @param value The number of units fulfilled by this request compared to the set target On-Demand capacity.
     */
    @JvmName("ydkagkfsykvnssss")
    public suspend fun fulfilledOnDemandCapacity(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fulfilledOnDemandCapacity = mapped
    }

    /**
     * @param value Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    @JvmName("phoacjpcwhjbuhfl")
    public suspend fun launchTemplateConfigs(`value`: List<FleetLaunchTemplateConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param argument Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    @JvmName("jrhnolsljijuropf")
    public suspend
    fun launchTemplateConfigs(argument: List<suspend FleetLaunchTemplateConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FleetLaunchTemplateConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param argument Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    @JvmName("ejxatoqclwqtfaig")
    public suspend fun launchTemplateConfigs(
        vararg
        argument: suspend FleetLaunchTemplateConfigArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FleetLaunchTemplateConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param argument Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    @JvmName("eujglynsbakauwmq")
    public suspend
    fun launchTemplateConfigs(argument: suspend FleetLaunchTemplateConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FleetLaunchTemplateConfigArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param values Nested argument containing EC2 Launch Template configurations. Defined below.
     */
    @JvmName("vedpleumqoyjotws")
    public suspend fun launchTemplateConfigs(vararg values: FleetLaunchTemplateConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.launchTemplateConfigs = mapped
    }

    /**
     * @param value Nested argument containing On-Demand configurations. Defined below.
     */
    @JvmName("rsbnxigitiorqqjn")
    public suspend fun onDemandOptions(`value`: FleetOnDemandOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandOptions = mapped
    }

    /**
     * @param argument Nested argument containing On-Demand configurations. Defined below.
     */
    @JvmName("pkcvvfdrfghrxxmf")
    public suspend fun onDemandOptions(argument: suspend FleetOnDemandOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = FleetOnDemandOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.onDemandOptions = mapped
    }

    /**
     * @param value Whether EC2 Fleet should replace unhealthy instances. Defaults to `false`. Supported only for fleets of type `maintain`.
     */
    @JvmName("mtlmyvrneciccmxt")
    public suspend fun replaceUnhealthyInstances(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replaceUnhealthyInstances = mapped
    }

    /**
     * @param value Nested argument containing Spot configurations. Defined below.
     */
    @JvmName("fqbfkbvyirydelym")
    public suspend fun spotOptions(`value`: FleetSpotOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotOptions = mapped
    }

    /**
     * @param argument Nested argument containing Spot configurations. Defined below.
     */
    @JvmName("dqqqkvtmlhmudfdx")
    public suspend fun spotOptions(argument: suspend FleetSpotOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = FleetSpotOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spotOptions = mapped
    }

    /**
     * @param value Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ilojpjkvqkpfdpuu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of Fleet tags. To tag instances at launch, specify the tags in the Launch Template. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("liqbuchkdcpmwjlf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Nested argument containing target capacity configurations. Defined below.
     */
    @JvmName("edaqvoltdwcgkcuk")
    public suspend fun targetCapacitySpecification(`value`: FleetTargetCapacitySpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetCapacitySpecification = mapped
    }

    /**
     * @param argument Nested argument containing target capacity configurations. Defined below.
     */
    @JvmName("ucajoscjlafbdhqs")
    public suspend
    fun targetCapacitySpecification(argument: suspend FleetTargetCapacitySpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = FleetTargetCapacitySpecificationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.targetCapacitySpecification = mapped
    }

    /**
     * @param value Whether to terminate instances for an EC2 Fleet if it is deleted successfully. Defaults to `false`.
     */
    @JvmName("lqqtddcciubnaykk")
    public suspend fun terminateInstances(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminateInstances = mapped
    }

    /**
     * @param value Whether running instances should be terminated when the EC2 Fleet expires. Defaults to `false`.
     */
    @JvmName("gdqwhhjfblxaelkj")
    public suspend fun terminateInstancesWithExpiration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminateInstancesWithExpiration = mapped
    }

    /**
     * @param value The type of request. Indicates whether the EC2 Fleet only requests the target capacity, or also attempts to maintain it. Valid values: `maintain`, `request`, `instant`. Defaults to `maintain`.
     */
    @JvmName("stavhdlwpwoaofof")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The start date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
     */
    @JvmName("pxinmtrjaklhtlrs")
    public suspend fun validFrom(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validFrom = mapped
    }

    /**
     * @param value The end date and time of the request, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to fulfill the request. If no value is specified, the request remains until you cancel it.
     */
    @JvmName("pyqikijgmpaebdbl")
    public suspend fun validUntil(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validUntil = mapped
    }

    internal fun build(): FleetArgs = FleetArgs(
        context = context,
        excessCapacityTerminationPolicy = excessCapacityTerminationPolicy,
        fleetInstanceSets = fleetInstanceSets,
        fleetState = fleetState,
        fulfilledCapacity = fulfilledCapacity,
        fulfilledOnDemandCapacity = fulfilledOnDemandCapacity,
        launchTemplateConfigs = launchTemplateConfigs,
        onDemandOptions = onDemandOptions,
        replaceUnhealthyInstances = replaceUnhealthyInstances,
        spotOptions = spotOptions,
        tags = tags,
        targetCapacitySpecification = targetCapacitySpecification,
        terminateInstances = terminateInstances,
        terminateInstancesWithExpiration = terminateInstancesWithExpiration,
        type = type,
        validFrom = validFrom,
        validUntil = validUntil,
    )
}
