@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.FlowLogArgs.builder
import com.pulumi.aws.ec2.kotlin.inputs.FlowLogDestinationOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.FlowLogDestinationOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a VPC/Subnet/ENI/Transit Gateway/Transit Gateway Attachment Flow Log to capture IP traffic for a specific network
 * interface, subnet, or VPC. Logs are sent to a CloudWatch Log Group, a S3 Bucket, or Amazon Kinesis Data Firehose
 * ## Example Usage
 * ### CloudWatch Logging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.cloudwatch.LogGroup;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.ec2.FlowLog;
 * import com.pulumi.aws.ec2.FlowLogArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleLogGroup = new LogGroup("exampleLogGroup");
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("vpc-flow-logs.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleFlowLog = new FlowLog("exampleFlowLog", FlowLogArgs.builder()
 *             .iamRoleArn(exampleRole.arn())
 *             .logDestination(exampleLogGroup.arn())
 *             .trafficType("ALL")
 *             .vpcId(aws_vpc.example().id())
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .actions(
 *                     "logs:CreateLogGroup",
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents",
 *                     "logs:DescribeLogGroups",
 *                     "logs:DescribeLogStreams")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.id())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ### Amazon Kinesis Data Firehose logging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStream;
 * import com.pulumi.aws.kinesis.FirehoseDeliveryStreamArgs;
 * import com.pulumi.aws.kinesis.inputs.FirehoseDeliveryStreamExtendedS3ConfigurationArgs;
 * import com.pulumi.aws.ec2.FlowLog;
 * import com.pulumi.aws.ec2.FlowLogArgs;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("firehose.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleFirehoseDeliveryStream = new FirehoseDeliveryStream("exampleFirehoseDeliveryStream", FirehoseDeliveryStreamArgs.builder()
 *             .destination("extended_s3")
 *             .extendedS3Configuration(FirehoseDeliveryStreamExtendedS3ConfigurationArgs.builder()
 *                 .roleArn(exampleRole.arn())
 *                 .bucketArn(exampleBucketV2.arn())
 *                 .build())
 *             .tags(Map.of("LogDeliveryEnabled", "true"))
 *             .build());
 *         var exampleFlowLog = new FlowLog("exampleFlowLog", FlowLogArgs.builder()
 *             .logDestination(exampleFirehoseDeliveryStream.arn())
 *             .logDestinationType("kinesis-data-firehose")
 *             .trafficType("ALL")
 *             .vpcId(aws_vpc.example().id())
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         final var examplePolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .effect("Allow")
 *             .actions(
 *                 "logs:CreateLogDelivery",
 *                 "logs:DeleteLogDelivery",
 *                 "logs:ListLogDeliveries",
 *                 "logs:GetLogDelivery",
 *                 "firehose:TagDeliveryStream")
 *             .resources("*")
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.id())
 *             .policy(examplePolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *     }
 * }
 * ```
 * ### S3 Logging
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.ec2.FlowLog;
 * import com.pulumi.aws.ec2.FlowLogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleFlowLog = new FlowLog("exampleFlowLog", FlowLogArgs.builder()
 *             .logDestination(exampleBucketV2.arn())
 *             .logDestinationType("s3")
 *             .trafficType("ALL")
 *             .vpcId(aws_vpc.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### S3 Logging in Apache Parquet format with per-hour partitions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.ec2.FlowLog;
 * import com.pulumi.aws.ec2.FlowLogArgs;
 * import com.pulumi.aws.ec2.inputs.FlowLogDestinationOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2");
 *         var exampleFlowLog = new FlowLog("exampleFlowLog", FlowLogArgs.builder()
 *             .logDestination(exampleBucketV2.arn())
 *             .logDestinationType("s3")
 *             .trafficType("ALL")
 *             .vpcId(aws_vpc.example().id())
 *             .destinationOptions(FlowLogDestinationOptionsArgs.builder()
 *                 .fileFormat("parquet")
 *                 .perHourPartition(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Flow Logs using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/flowLog:FlowLog test_flow_log fl-1a2b3c4d
 * ```
 * @property deliverCrossAccountRole ARN of the IAM role that allows Amazon EC2 to publish flow logs across accounts.
 * @property destinationOptions Describes the destination options for a flow log. More details below.
 * @property eniId Elastic Network Interface ID to attach to
 * @property iamRoleArn The ARN for the IAM role that's used to post flow logs to a CloudWatch Logs log group
 * @property logDestination The ARN of the logging destination. Either `log_destination` or `log_group_name` must be set.
 * @property logDestinationType The type of the logging destination. Valid values: `cloud-watch-logs`, `s3`, `kinesis-data-firehose`. Default: `cloud-watch-logs`.
 * @property logFormat The fields to include in the flow log record, in the order in which they should appear.
 * @property logGroupName **Deprecated:** Use `log_destination` instead. The name of the CloudWatch log group. Either `log_group_name` or `log_destination` must be set.
 * @property maxAggregationInterval The maximum interval of time
 * during which a flow of packets is captured and aggregated into a flow
 * log record. Valid Values: `60` seconds (1 minute) or `600` seconds (10
 * minutes). Default: `600`. When `transit_gateway_id` or `transit_gateway_attachment_id` is specified, `max_aggregation_interval` *must* be 60 seconds (1 minute).
 * @property subnetId Subnet ID to attach to
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property trafficType The type of traffic to capture. Valid values: `ACCEPT`,`REJECT`, `ALL`.
 * @property transitGatewayAttachmentId Transit Gateway Attachment ID to attach to
 * @property transitGatewayId Transit Gateway ID to attach to
 * @property vpcId VPC ID to attach to
 */
public data class FlowLogArgs(
    public val deliverCrossAccountRole: Output<String>? = null,
    public val destinationOptions: Output<FlowLogDestinationOptionsArgs>? = null,
    public val eniId: Output<String>? = null,
    public val iamRoleArn: Output<String>? = null,
    public val logDestination: Output<String>? = null,
    public val logDestinationType: Output<String>? = null,
    public val logFormat: Output<String>? = null,
    @Deprecated(
        message = """
  use 'log_destination' argument instead
  """,
    )
    public val logGroupName: Output<String>? = null,
    public val maxAggregationInterval: Output<Int>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trafficType: Output<String>? = null,
    public val transitGatewayAttachmentId: Output<String>? = null,
    public val transitGatewayId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.FlowLogArgs> {
    override fun toJava(): com.pulumi.aws.ec2.FlowLogArgs = com.pulumi.aws.ec2.FlowLogArgs.builder()
        .deliverCrossAccountRole(deliverCrossAccountRole?.applyValue({ args0 -> args0 }))
        .destinationOptions(
            destinationOptions?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .eniId(eniId?.applyValue({ args0 -> args0 }))
        .iamRoleArn(iamRoleArn?.applyValue({ args0 -> args0 }))
        .logDestination(logDestination?.applyValue({ args0 -> args0 }))
        .logDestinationType(logDestinationType?.applyValue({ args0 -> args0 }))
        .logFormat(logFormat?.applyValue({ args0 -> args0 }))
        .logGroupName(logGroupName?.applyValue({ args0 -> args0 }))
        .maxAggregationInterval(maxAggregationInterval?.applyValue({ args0 -> args0 }))
        .subnetId(subnetId?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .trafficType(trafficType?.applyValue({ args0 -> args0 }))
        .transitGatewayAttachmentId(transitGatewayAttachmentId?.applyValue({ args0 -> args0 }))
        .transitGatewayId(transitGatewayId?.applyValue({ args0 -> args0 }))
        .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowLogArgs].
 */
@PulumiTagMarker
public class FlowLogArgsBuilder internal constructor() {
    private var deliverCrossAccountRole: Output<String>? = null

    private var destinationOptions: Output<FlowLogDestinationOptionsArgs>? = null

    private var eniId: Output<String>? = null

    private var iamRoleArn: Output<String>? = null

    private var logDestination: Output<String>? = null

    private var logDestinationType: Output<String>? = null

    private var logFormat: Output<String>? = null

    private var logGroupName: Output<String>? = null

    private var maxAggregationInterval: Output<Int>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trafficType: Output<String>? = null

    private var transitGatewayAttachmentId: Output<String>? = null

    private var transitGatewayId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value ARN of the IAM role that allows Amazon EC2 to publish flow logs across accounts.
     */
    @JvmName("rkaxibwljqpdudaj")
    public suspend fun deliverCrossAccountRole(`value`: Output<String>) {
        this.deliverCrossAccountRole = value
    }

    /**
     * @param value Describes the destination options for a flow log. More details below.
     */
    @JvmName("wmfjlbnyemdcotim")
    public suspend fun destinationOptions(`value`: Output<FlowLogDestinationOptionsArgs>) {
        this.destinationOptions = value
    }

    /**
     * @param value Elastic Network Interface ID to attach to
     */
    @JvmName("jugqxkvrwicwgrag")
    public suspend fun eniId(`value`: Output<String>) {
        this.eniId = value
    }

    /**
     * @param value The ARN for the IAM role that's used to post flow logs to a CloudWatch Logs log group
     */
    @JvmName("libgjsddacbmtbgi")
    public suspend fun iamRoleArn(`value`: Output<String>) {
        this.iamRoleArn = value
    }

    /**
     * @param value The ARN of the logging destination. Either `log_destination` or `log_group_name` must be set.
     */
    @JvmName("ttstvgidjhorqwth")
    public suspend fun logDestination(`value`: Output<String>) {
        this.logDestination = value
    }

    /**
     * @param value The type of the logging destination. Valid values: `cloud-watch-logs`, `s3`, `kinesis-data-firehose`. Default: `cloud-watch-logs`.
     */
    @JvmName("ltrdadkosfcvcusu")
    public suspend fun logDestinationType(`value`: Output<String>) {
        this.logDestinationType = value
    }

    /**
     * @param value The fields to include in the flow log record, in the order in which they should appear.
     */
    @JvmName("lwefxmdaiaighwxa")
    public suspend fun logFormat(`value`: Output<String>) {
        this.logFormat = value
    }

    /**
     * @param value **Deprecated:** Use `log_destination` instead. The name of the CloudWatch log group. Either `log_group_name` or `log_destination` must be set.
     */
    @Deprecated(
        message = """
  use 'log_destination' argument instead
  """,
    )
    @JvmName("mwwnyjsxaqpqumgy")
    public suspend fun logGroupName(`value`: Output<String>) {
        this.logGroupName = value
    }

    /**
     * @param value The maximum interval of time
     * during which a flow of packets is captured and aggregated into a flow
     * log record. Valid Values: `60` seconds (1 minute) or `600` seconds (10
     * minutes). Default: `600`. When `transit_gateway_id` or `transit_gateway_attachment_id` is specified, `max_aggregation_interval` *must* be 60 seconds (1 minute).
     */
    @JvmName("dgkvyadpiwgaveku")
    public suspend fun maxAggregationInterval(`value`: Output<Int>) {
        this.maxAggregationInterval = value
    }

    /**
     * @param value Subnet ID to attach to
     */
    @JvmName("irrwtfwomrpdqegm")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mkxlfqyffadpgkyd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of traffic to capture. Valid values: `ACCEPT`,`REJECT`, `ALL`.
     */
    @JvmName("cfvywmuspgymtoix")
    public suspend fun trafficType(`value`: Output<String>) {
        this.trafficType = value
    }

    /**
     * @param value Transit Gateway Attachment ID to attach to
     */
    @JvmName("mrxmdshujaowjnkq")
    public suspend fun transitGatewayAttachmentId(`value`: Output<String>) {
        this.transitGatewayAttachmentId = value
    }

    /**
     * @param value Transit Gateway ID to attach to
     */
    @JvmName("aiolclbhajyiheqv")
    public suspend fun transitGatewayId(`value`: Output<String>) {
        this.transitGatewayId = value
    }

    /**
     * @param value VPC ID to attach to
     */
    @JvmName("qjrchmmsvusbtchh")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value ARN of the IAM role that allows Amazon EC2 to publish flow logs across accounts.
     */
    @JvmName("pqsmjhsgywsblcyb")
    public suspend fun deliverCrossAccountRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliverCrossAccountRole = mapped
    }

    /**
     * @param value Describes the destination options for a flow log. More details below.
     */
    @JvmName("iiicqsjxebjmrreh")
    public suspend fun destinationOptions(`value`: FlowLogDestinationOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationOptions = mapped
    }

    /**
     * @param argument Describes the destination options for a flow log. More details below.
     */
    @JvmName("bdiixqfxaryetikk")
    public suspend
    fun destinationOptions(argument: suspend FlowLogDestinationOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = FlowLogDestinationOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destinationOptions = mapped
    }

    /**
     * @param value Elastic Network Interface ID to attach to
     */
    @JvmName("afahvfcybgbqubrp")
    public suspend fun eniId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eniId = mapped
    }

    /**
     * @param value The ARN for the IAM role that's used to post flow logs to a CloudWatch Logs log group
     */
    @JvmName("inrrosvhuivtkrhq")
    public suspend fun iamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoleArn = mapped
    }

    /**
     * @param value The ARN of the logging destination. Either `log_destination` or `log_group_name` must be set.
     */
    @JvmName("nqnagholslrtmoci")
    public suspend fun logDestination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logDestination = mapped
    }

    /**
     * @param value The type of the logging destination. Valid values: `cloud-watch-logs`, `s3`, `kinesis-data-firehose`. Default: `cloud-watch-logs`.
     */
    @JvmName("mjteqcfcreklldxf")
    public suspend fun logDestinationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logDestinationType = mapped
    }

    /**
     * @param value The fields to include in the flow log record, in the order in which they should appear.
     */
    @JvmName("padwdpqbilbhfoou")
    public suspend fun logFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logFormat = mapped
    }

    /**
     * @param value **Deprecated:** Use `log_destination` instead. The name of the CloudWatch log group. Either `log_group_name` or `log_destination` must be set.
     */
    @Deprecated(
        message = """
  use 'log_destination' argument instead
  """,
    )
    @JvmName("qrremydjuuhgnxbc")
    public suspend fun logGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logGroupName = mapped
    }

    /**
     * @param value The maximum interval of time
     * during which a flow of packets is captured and aggregated into a flow
     * log record. Valid Values: `60` seconds (1 minute) or `600` seconds (10
     * minutes). Default: `600`. When `transit_gateway_id` or `transit_gateway_attachment_id` is specified, `max_aggregation_interval` *must* be 60 seconds (1 minute).
     */
    @JvmName("xlnduogrypbgtuqe")
    public suspend fun maxAggregationInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAggregationInterval = mapped
    }

    /**
     * @param value Subnet ID to attach to
     */
    @JvmName("xkrwtpdpbvmnnbfm")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mpywjariubpdphgt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tiivoppndxuetmow")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of traffic to capture. Valid values: `ACCEPT`,`REJECT`, `ALL`.
     */
    @JvmName("qnruwjxtbftfvmip")
    public suspend fun trafficType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trafficType = mapped
    }

    /**
     * @param value Transit Gateway Attachment ID to attach to
     */
    @JvmName("byxgohdapysweimr")
    public suspend fun transitGatewayAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayAttachmentId = mapped
    }

    /**
     * @param value Transit Gateway ID to attach to
     */
    @JvmName("kmwcrtsvuivtjlct")
    public suspend fun transitGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayId = mapped
    }

    /**
     * @param value VPC ID to attach to
     */
    @JvmName("vufuypstbfpcryai")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): FlowLogArgs = FlowLogArgs(
        deliverCrossAccountRole = deliverCrossAccountRole,
        destinationOptions = destinationOptions,
        eniId = eniId,
        iamRoleArn = iamRoleArn,
        logDestination = logDestination,
        logDestinationType = logDestinationType,
        logFormat = logFormat,
        logGroupName = logGroupName,
        maxAggregationInterval = maxAggregationInterval,
        subnetId = subnetId,
        tags = tags,
        trafficType = trafficType,
        transitGatewayAttachmentId = transitGatewayAttachmentId,
        transitGatewayId = transitGatewayId,
        vpcId = vpcId,
    )
}
