@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ImageBlockPublicAccess].
 */
@PulumiTagMarker
public class ImageBlockPublicAccessResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImageBlockPublicAccessArgs = ImageBlockPublicAccessArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImageBlockPublicAccessArgsBuilder.() -> Unit) {
        val builder = ImageBlockPublicAccessArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ImageBlockPublicAccess {
        val builtJavaResource = com.pulumi.aws.ec2.ImageBlockPublicAccess(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ImageBlockPublicAccess(builtJavaResource)
    }
}

/**
 * Provides a regional public access block for AMIs. This prevents AMIs from being made publicly accessible.
 * If you already have public AMIs, they will remain publicly available.
 * > **NOTE:** Deleting this resource does not change the block public access value, the resource in simply removed from state instead.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.ImageBlockPublicAccess;
 * import com.pulumi.aws.ec2.ImageBlockPublicAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ImageBlockPublicAccess("test", ImageBlockPublicAccessArgs.builder()
 *             .state("block-new-sharing")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * You cannot import this resource.
 */
public class ImageBlockPublicAccess internal constructor(
    override val javaResource: com.pulumi.aws.ec2.ImageBlockPublicAccess,
) : KotlinCustomResource(javaResource, ImageBlockPublicAccessMapper) {
    /**
     * The state of block public access for AMIs at the account level in the configured AWS Region. Valid values: `unblocked` and `block-new-sharing`.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })
}

public object ImageBlockPublicAccessMapper : ResourceMapper<ImageBlockPublicAccess> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ec2.ImageBlockPublicAccess::class == javaResource::class

    override fun map(javaResource: Resource): ImageBlockPublicAccess =
        ImageBlockPublicAccess(javaResource as com.pulumi.aws.ec2.ImageBlockPublicAccess)
}

/**
 * @see [ImageBlockPublicAccess].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ImageBlockPublicAccess].
 */
public suspend fun imageBlockPublicAccess(
    name: String,
    block: suspend ImageBlockPublicAccessResourceBuilder.() -> Unit,
): ImageBlockPublicAccess {
    val builder = ImageBlockPublicAccessResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ImageBlockPublicAccess].
 * @param name The _unique_ name of the resulting resource.
 */
public fun imageBlockPublicAccess(name: String): ImageBlockPublicAccess {
    val builder = ImageBlockPublicAccessResourceBuilder()
    builder.name(name)
    return builder.build()
}
