@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.ImageBlockPublicAccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a regional public access block for AMIs. This prevents AMIs from being made publicly accessible.
 * If you already have public AMIs, they will remain publicly available.
 * > **NOTE:** Deleting this resource does not change the block public access value, the resource in simply removed from state instead.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.ImageBlockPublicAccess;
 * import com.pulumi.aws.ec2.ImageBlockPublicAccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new ImageBlockPublicAccess("test", ImageBlockPublicAccessArgs.builder()
 *             .state("block-new-sharing")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * You cannot import this resource.
 * @property state The state of block public access for AMIs at the account level in the configured AWS Region. Valid values: `unblocked` and `block-new-sharing`.
 */
public data class ImageBlockPublicAccessArgs(
    public val state: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.ImageBlockPublicAccessArgs> {
    override fun toJava(): com.pulumi.aws.ec2.ImageBlockPublicAccessArgs =
        com.pulumi.aws.ec2.ImageBlockPublicAccessArgs.builder()
            .state(state?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageBlockPublicAccessArgs].
 */
@PulumiTagMarker
public class ImageBlockPublicAccessArgsBuilder internal constructor() {
    private var state: Output<String>? = null

    /**
     * @param value The state of block public access for AMIs at the account level in the configured AWS Region. Valid values: `unblocked` and `block-new-sharing`.
     */
    @JvmName("vxirtpwdnkhwdmxa")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The state of block public access for AMIs at the account level in the configured AWS Region. Valid values: `unblocked` and `block-new-sharing`.
     */
    @JvmName("myiwhvnglkvdkydq")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): ImageBlockPublicAccessArgs = ImageBlockPublicAccessArgs(
        state = state,
    )
}
