@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.InstanceArgs.builder
import com.pulumi.aws.ec2.kotlin.enums.InstanceType
import com.pulumi.aws.ec2.kotlin.enums.Tenancy
import com.pulumi.aws.ec2.kotlin.inputs.InstanceCapacityReservationSpecificationArgs
import com.pulumi.aws.ec2.kotlin.inputs.InstanceCapacityReservationSpecificationArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.InstanceCpuOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.InstanceCpuOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.InstanceCreditSpecificationArgs
import com.pulumi.aws.ec2.kotlin.inputs.InstanceCreditSpecificationArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.InstanceEbsBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.InstanceEbsBlockDeviceArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.InstanceEnclaveOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.InstanceEnclaveOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.InstanceEphemeralBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.InstanceEphemeralBlockDeviceArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.InstanceInstanceMarketOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.InstanceInstanceMarketOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.InstanceLaunchTemplateArgs
import com.pulumi.aws.ec2.kotlin.inputs.InstanceLaunchTemplateArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.InstanceMaintenanceOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.InstanceMaintenanceOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.InstanceMetadataOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.InstanceMetadataOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.InstanceNetworkInterfaceArgs
import com.pulumi.aws.ec2.kotlin.inputs.InstanceNetworkInterfaceArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.InstancePrivateDnsNameOptionsArgs
import com.pulumi.aws.ec2.kotlin.inputs.InstancePrivateDnsNameOptionsArgsBuilder
import com.pulumi.aws.ec2.kotlin.inputs.InstanceRootBlockDeviceArgs
import com.pulumi.aws.ec2.kotlin.inputs.InstanceRootBlockDeviceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an EC2 instance resource. This allows instances to be created, updated, and deleted.
 * ## Example Usage
 * ### Basic example using AMI lookup
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var ubuntu = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .filters(
 *                 GetAmiFilterArgs.builder()
 *                     .name("name")
 *                     .values("ubuntu/images/hvm-ssd/ubuntu-focal-20.04-amd64-server-*")
 *                     .build(),
 *                 GetAmiFilterArgs.builder()
 *                     .name("virtualization-type")
 *                     .values("hvm")
 *                     .build())
 *             .owners("099720109477")
 *             .build());
 *         var web = new Instance("web", InstanceArgs.builder()
 *             .ami(ubuntu.applyValue(getAmiResult -> getAmiResult.id()))
 *             .instanceType("t3.micro")
 *             .tags(Map.of("Name", "HelloWorld"))
 *             .build());
 *     }
 * }
 * ```
 * ### Spot instance example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceInstanceMarketOptionsArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceInstanceMarketOptionsSpotOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var thisAmi = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .owners("amazon")
 *             .filters(
 *                 GetAmiFilterArgs.builder()
 *                     .name("architecture")
 *                     .values("arm64")
 *                     .build(),
 *                 GetAmiFilterArgs.builder()
 *                     .name("name")
 *                     .values("al2023-ami-2023*")
 *                     .build())
 *             .build());
 *         var thisInstance = new Instance("thisInstance", InstanceArgs.builder()
 *             .ami(thisAmi.applyValue(getAmiResult -> getAmiResult.id()))
 *             .instanceMarketOptions(InstanceInstanceMarketOptionsArgs.builder()
 *                 .spotOptions(InstanceInstanceMarketOptionsSpotOptionsArgs.builder()
 *                     .maxPrice(0.0031)
 *                     .build())
 *                 .build())
 *             .instanceType("t4g.nano")
 *             .tags(Map.of("Name", "test-spot"))
 *             .build());
 *     }
 * }
 * ```
 * ### Network and credit specification example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.ec2.NetworkInterface;
 * import com.pulumi.aws.ec2.NetworkInterfaceArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceNetworkInterfaceArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceCreditSpecificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var myVpc = new Vpc("myVpc", VpcArgs.builder()
 *             .cidrBlock("172.16.0.0/16")
 *             .tags(Map.of("Name", "tf-example"))
 *             .build());
 *         var mySubnet = new Subnet("mySubnet", SubnetArgs.builder()
 *             .vpcId(myVpc.id())
 *             .cidrBlock("172.16.10.0/24")
 *             .availabilityZone("us-west-2a")
 *             .tags(Map.of("Name", "tf-example"))
 *             .build());
 *         var fooNetworkInterface = new NetworkInterface("fooNetworkInterface", NetworkInterfaceArgs.builder()
 *             .subnetId(mySubnet.id())
 *             .privateIps("172.16.10.100")
 *             .tags(Map.of("Name", "primary_network_interface"))
 *             .build());
 *         var fooInstance = new Instance("fooInstance", InstanceArgs.builder()
 *             .ami("ami-005e54dee72cc1d00")
 *             .instanceType("t2.micro")
 *             .networkInterfaces(InstanceNetworkInterfaceArgs.builder()
 *                 .networkInterfaceId(fooNetworkInterface.id())
 *                 .deviceIndex(0)
 *                 .build())
 *             .creditSpecification(InstanceCreditSpecificationArgs.builder()
 *                 .cpuCredits("unlimited")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### CPU options example
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.ec2.Ec2Functions;
 * import com.pulumi.aws.ec2.inputs.GetAmiArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.aws.ec2.inputs.InstanceCpuOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("172.16.0.0/16")
 *             .tags(Map.of("Name", "tf-example"))
 *             .build());
 *         var exampleSubnet = new Subnet("exampleSubnet", SubnetArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .cidrBlock("172.16.10.0/24")
 *             .availabilityZone("us-east-2a")
 *             .tags(Map.of("Name", "tf-example"))
 *             .build());
 *         final var amzn-linux-2023-ami = Ec2Functions.getAmi(GetAmiArgs.builder()
 *             .mostRecent(true)
 *             .owners("amazon")
 *             .filters(GetAmiFilterArgs.builder()
 *                 .name("name")
 *                 .values("al2023-ami-2023.*-x86_64")
 *                 .build())
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .ami(amzn_linux_2023_ami.id())
 *             .instanceType("c6a.2xlarge")
 *             .subnetId(exampleSubnet.id())
 *             .cpuOptions(InstanceCpuOptionsArgs.builder()
 *                 .coreCount(2)
 *                 .threadsPerCore(2)
 *                 .build())
 *             .tags(Map.of("Name", "tf-example"))
 *             .build());
 *     }
 * }
 * ```
 * ### Host resource group or Licence Manager registered AMI example
 * A host resource group is a collection of Dedicated Hosts that you can manage as a single entity. As you launch instances, License Manager allocates the hosts and launches instances on them based on the settings that you configured. You can add existing Dedicated Hosts to a host resource group and take advantage of automated host management through License Manager.
 * > **NOTE:** A dedicated host is automatically associated with a License Manager host resource group if **Allocate hosts automatically** is enabled. Otherwise, use the `host_resource_group_arn` argument to explicitly associate the instance with the host resource group.
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var this_ = new Instance("this", InstanceArgs.builder()
 *             .ami("ami-0dcc1e21636832c5d")
 *             .hostResourceGroupArn("arn:aws:resource-groups:us-west-2:012345678901:group/win-testhost")
 *             .instanceType("m5.large")
 *             .tenancy("host")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import instances using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/instance:Instance web i-12345678
 * ```
 * @property ami AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
 * @property associatePublicIpAddress Whether to associate a public IP address with an instance in a VPC.
 * @property availabilityZone AZ to start the instance in.
 * @property capacityReservationSpecification Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
 * > **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
 * @property cpuCoreCount Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
 * @property cpuOptions The CPU options for the instance. See CPU Options below for more details.
 * @property cpuThreadsPerCore If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
 * @property creditSpecification Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
 * @property disableApiStop If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
 * @property disableApiTermination If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
 * @property ebsBlockDevices One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
 * @property ebsOptimized If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
 * @property enclaveOptions Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
 * @property ephemeralBlockDevices One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
 * @property getPasswordData If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
 * @property hibernation If true, the launched EC2 instance will support hibernation.
 * @property hostId ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
 * @property hostResourceGroupArn ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
 * @property iamInstanceProfile IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
 * @property instanceInitiatedShutdownBehavior Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
 * @property instanceMarketOptions Describes the market (purchasing) option for the instances. See Market Options below for details on attributes.
 * @property instanceType Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
 * @property ipv6AddressCount Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
 * @property ipv6Addresses Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
 * @property keyName Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
 * @property launchTemplate Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
 * @property maintenanceOptions Maintenance and recovery options for the instance. See Maintenance Options below for more details.
 * @property metadataOptions Customize the metadata options of the instance. See Metadata Options below for more details.
 * @property monitoring If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
 * @property networkInterfaces Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
 * @property placementGroup Placement Group to start the instance in.
 * @property placementPartitionNumber Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
 * @property privateDnsNameOptions Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
 * @property privateIp Private IP address to associate with the instance in a VPC.
 * @property rootBlockDevice Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
 * @property secondaryPrivateIps List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
 * @property securityGroups List of security group names to associate with.
 * > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
 * @property sourceDestCheck Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
 * @property subnetId VPC Subnet ID to launch in.
 * @property tags Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tenancy Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
 * @property userData User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
 * @property userDataBase64 Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
 * @property userDataReplaceOnChange When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
 * @property volumeTags Map of tags to assign, at instance-creation time, to root and EBS volumes.
 * > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
 * @property vpcSecurityGroupIds List of security group IDs to associate with.
 */
public data class InstanceArgs(
    public val ami: Output<String>? = null,
    public val associatePublicIpAddress: Output<Boolean>? = null,
    public val availabilityZone: Output<String>? = null,
    public val capacityReservationSpecification: Output<InstanceCapacityReservationSpecificationArgs>? =
        null,
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    public val cpuCoreCount: Output<Int>? = null,
    public val cpuOptions: Output<InstanceCpuOptionsArgs>? = null,
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    public val cpuThreadsPerCore: Output<Int>? = null,
    public val creditSpecification: Output<InstanceCreditSpecificationArgs>? = null,
    public val disableApiStop: Output<Boolean>? = null,
    public val disableApiTermination: Output<Boolean>? = null,
    public val ebsBlockDevices: Output<List<InstanceEbsBlockDeviceArgs>>? = null,
    public val ebsOptimized: Output<Boolean>? = null,
    public val enclaveOptions: Output<InstanceEnclaveOptionsArgs>? = null,
    public val ephemeralBlockDevices: Output<List<InstanceEphemeralBlockDeviceArgs>>? = null,
    public val getPasswordData: Output<Boolean>? = null,
    public val hibernation: Output<Boolean>? = null,
    public val hostId: Output<String>? = null,
    public val hostResourceGroupArn: Output<String>? = null,
    public val iamInstanceProfile: Output<String>? = null,
    public val instanceInitiatedShutdownBehavior: Output<String>? = null,
    public val instanceMarketOptions: Output<InstanceInstanceMarketOptionsArgs>? = null,
    public val instanceType: Output<Either<String, InstanceType>>? = null,
    public val ipv6AddressCount: Output<Int>? = null,
    public val ipv6Addresses: Output<List<String>>? = null,
    public val keyName: Output<String>? = null,
    public val launchTemplate: Output<InstanceLaunchTemplateArgs>? = null,
    public val maintenanceOptions: Output<InstanceMaintenanceOptionsArgs>? = null,
    public val metadataOptions: Output<InstanceMetadataOptionsArgs>? = null,
    public val monitoring: Output<Boolean>? = null,
    public val networkInterfaces: Output<List<InstanceNetworkInterfaceArgs>>? = null,
    public val placementGroup: Output<String>? = null,
    public val placementPartitionNumber: Output<Int>? = null,
    public val privateDnsNameOptions: Output<InstancePrivateDnsNameOptionsArgs>? = null,
    public val privateIp: Output<String>? = null,
    public val rootBlockDevice: Output<InstanceRootBlockDeviceArgs>? = null,
    public val secondaryPrivateIps: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Use of `securityGroups` is discouraged as it does not allow for changes and will force your
      instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which
      allows for updates.
  """,
    )
    public val securityGroups: Output<List<String>>? = null,
    public val sourceDestCheck: Output<Boolean>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tenancy: Output<Either<String, Tenancy>>? = null,
    public val userData: Output<String>? = null,
    public val userDataBase64: Output<String>? = null,
    public val userDataReplaceOnChange: Output<Boolean>? = null,
    public val volumeTags: Output<Map<String, String>>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.InstanceArgs> {
    override fun toJava(): com.pulumi.aws.ec2.InstanceArgs = com.pulumi.aws.ec2.InstanceArgs.builder()
        .ami(ami?.applyValue({ args0 -> args0 }))
        .associatePublicIpAddress(associatePublicIpAddress?.applyValue({ args0 -> args0 }))
        .availabilityZone(availabilityZone?.applyValue({ args0 -> args0 }))
        .capacityReservationSpecification(
            capacityReservationSpecification?.applyValue({ args0 ->
                args0.let({ args0 -> args0.toJava() })
            }),
        )
        .cpuCoreCount(cpuCoreCount?.applyValue({ args0 -> args0 }))
        .cpuOptions(cpuOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .cpuThreadsPerCore(cpuThreadsPerCore?.applyValue({ args0 -> args0 }))
        .creditSpecification(
            creditSpecification?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .disableApiStop(disableApiStop?.applyValue({ args0 -> args0 }))
        .disableApiTermination(disableApiTermination?.applyValue({ args0 -> args0 }))
        .ebsBlockDevices(
            ebsBlockDevices?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .ebsOptimized(ebsOptimized?.applyValue({ args0 -> args0 }))
        .enclaveOptions(enclaveOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .ephemeralBlockDevices(
            ephemeralBlockDevices?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .getPasswordData(getPasswordData?.applyValue({ args0 -> args0 }))
        .hibernation(hibernation?.applyValue({ args0 -> args0 }))
        .hostId(hostId?.applyValue({ args0 -> args0 }))
        .hostResourceGroupArn(hostResourceGroupArn?.applyValue({ args0 -> args0 }))
        .iamInstanceProfile(iamInstanceProfile?.applyValue({ args0 -> args0 }))
        .instanceInitiatedShutdownBehavior(
            instanceInitiatedShutdownBehavior?.applyValue({ args0 ->
                args0
            }),
        )
        .instanceMarketOptions(
            instanceMarketOptions?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .instanceType(
            instanceType?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .ipv6AddressCount(ipv6AddressCount?.applyValue({ args0 -> args0 }))
        .ipv6Addresses(ipv6Addresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .keyName(keyName?.applyValue({ args0 -> args0 }))
        .launchTemplate(launchTemplate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .maintenanceOptions(
            maintenanceOptions?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .metadataOptions(metadataOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .monitoring(monitoring?.applyValue({ args0 -> args0 }))
        .networkInterfaces(
            networkInterfaces?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .placementGroup(placementGroup?.applyValue({ args0 -> args0 }))
        .placementPartitionNumber(placementPartitionNumber?.applyValue({ args0 -> args0 }))
        .privateDnsNameOptions(
            privateDnsNameOptions?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .privateIp(privateIp?.applyValue({ args0 -> args0 }))
        .rootBlockDevice(rootBlockDevice?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .secondaryPrivateIps(secondaryPrivateIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .sourceDestCheck(sourceDestCheck?.applyValue({ args0 -> args0 }))
        .subnetId(subnetId?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .tenancy(
            tenancy?.applyValue({ args0 ->
                args0.transform({ args0 -> args0 }, { args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .userData(userData?.applyValue({ args0 -> args0 }))
        .userDataBase64(userDataBase64?.applyValue({ args0 -> args0 }))
        .userDataReplaceOnChange(userDataReplaceOnChange?.applyValue({ args0 -> args0 }))
        .volumeTags(
            volumeTags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .vpcSecurityGroupIds(
            vpcSecurityGroupIds?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }),
        ).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var ami: Output<String>? = null

    private var associatePublicIpAddress: Output<Boolean>? = null

    private var availabilityZone: Output<String>? = null

    private var capacityReservationSpecification:
        Output<InstanceCapacityReservationSpecificationArgs>? = null

    private var cpuCoreCount: Output<Int>? = null

    private var cpuOptions: Output<InstanceCpuOptionsArgs>? = null

    private var cpuThreadsPerCore: Output<Int>? = null

    private var creditSpecification: Output<InstanceCreditSpecificationArgs>? = null

    private var disableApiStop: Output<Boolean>? = null

    private var disableApiTermination: Output<Boolean>? = null

    private var ebsBlockDevices: Output<List<InstanceEbsBlockDeviceArgs>>? = null

    private var ebsOptimized: Output<Boolean>? = null

    private var enclaveOptions: Output<InstanceEnclaveOptionsArgs>? = null

    private var ephemeralBlockDevices: Output<List<InstanceEphemeralBlockDeviceArgs>>? = null

    private var getPasswordData: Output<Boolean>? = null

    private var hibernation: Output<Boolean>? = null

    private var hostId: Output<String>? = null

    private var hostResourceGroupArn: Output<String>? = null

    private var iamInstanceProfile: Output<String>? = null

    private var instanceInitiatedShutdownBehavior: Output<String>? = null

    private var instanceMarketOptions: Output<InstanceInstanceMarketOptionsArgs>? = null

    private var instanceType: Output<Either<String, InstanceType>>? = null

    private var ipv6AddressCount: Output<Int>? = null

    private var ipv6Addresses: Output<List<String>>? = null

    private var keyName: Output<String>? = null

    private var launchTemplate: Output<InstanceLaunchTemplateArgs>? = null

    private var maintenanceOptions: Output<InstanceMaintenanceOptionsArgs>? = null

    private var metadataOptions: Output<InstanceMetadataOptionsArgs>? = null

    private var monitoring: Output<Boolean>? = null

    private var networkInterfaces: Output<List<InstanceNetworkInterfaceArgs>>? = null

    private var placementGroup: Output<String>? = null

    private var placementPartitionNumber: Output<Int>? = null

    private var privateDnsNameOptions: Output<InstancePrivateDnsNameOptionsArgs>? = null

    private var privateIp: Output<String>? = null

    private var rootBlockDevice: Output<InstanceRootBlockDeviceArgs>? = null

    private var secondaryPrivateIps: Output<List<String>>? = null

    private var securityGroups: Output<List<String>>? = null

    private var sourceDestCheck: Output<Boolean>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tenancy: Output<Either<String, Tenancy>>? = null

    private var userData: Output<String>? = null

    private var userDataBase64: Output<String>? = null

    private var userDataReplaceOnChange: Output<Boolean>? = null

    private var volumeTags: Output<Map<String, String>>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    /**
     * @param value AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
     */
    @JvmName("mytvwnlpgjtylndk")
    public suspend fun ami(`value`: Output<String>) {
        this.ami = value
    }

    /**
     * @param value Whether to associate a public IP address with an instance in a VPC.
     */
    @JvmName("jakljlefgsxmgndu")
    public suspend fun associatePublicIpAddress(`value`: Output<Boolean>) {
        this.associatePublicIpAddress = value
    }

    /**
     * @param value AZ to start the instance in.
     */
    @JvmName("yjmwhredabwpnpij")
    public suspend fun availabilityZone(`value`: Output<String>) {
        this.availabilityZone = value
    }

    /**
     * @param value Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
     * > **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
     */
    @JvmName("shttuncdltvnoike")
    public suspend
    fun capacityReservationSpecification(`value`: Output<InstanceCapacityReservationSpecificationArgs>) {
        this.capacityReservationSpecification = value
    }

    /**
     * @param value Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
     */
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    @JvmName("pupfkrteefgswkba")
    public suspend fun cpuCoreCount(`value`: Output<Int>) {
        this.cpuCoreCount = value
    }

    /**
     * @param value The CPU options for the instance. See CPU Options below for more details.
     */
    @JvmName("qsjjrqbeslldqfpj")
    public suspend fun cpuOptions(`value`: Output<InstanceCpuOptionsArgs>) {
        this.cpuOptions = value
    }

    /**
     * @param value If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
     */
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    @JvmName("lgkkkudamesdgqvn")
    public suspend fun cpuThreadsPerCore(`value`: Output<Int>) {
        this.cpuThreadsPerCore = value
    }

    /**
     * @param value Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
     */
    @JvmName("kqklrheyhqenmebh")
    public suspend fun creditSpecification(`value`: Output<InstanceCreditSpecificationArgs>) {
        this.creditSpecification = value
    }

    /**
     * @param value If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     */
    @JvmName("agxcijftetvrware")
    public suspend fun disableApiStop(`value`: Output<Boolean>) {
        this.disableApiStop = value
    }

    /**
     * @param value If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
     */
    @JvmName("wdohypmaninsoagf")
    public suspend fun disableApiTermination(`value`: Output<Boolean>) {
        this.disableApiTermination = value
    }

    /**
     * @param value One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("sovnmyudvxwqeodf")
    public suspend fun ebsBlockDevices(`value`: Output<List<InstanceEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = value
    }

    @JvmName("ojjvaakxalacwnkj")
    public suspend fun ebsBlockDevices(vararg values: Output<InstanceEbsBlockDeviceArgs>) {
        this.ebsBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("hwpvoseyvqcifodh")
    public suspend fun ebsBlockDevices(values: List<Output<InstanceEbsBlockDeviceArgs>>) {
        this.ebsBlockDevices = Output.all(values)
    }

    /**
     * @param value If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
     */
    @JvmName("bqgxmekslreihesq")
    public suspend fun ebsOptimized(`value`: Output<Boolean>) {
        this.ebsOptimized = value
    }

    /**
     * @param value Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     */
    @JvmName("winwpxylqpysjdjn")
    public suspend fun enclaveOptions(`value`: Output<InstanceEnclaveOptionsArgs>) {
        this.enclaveOptions = value
    }

    /**
     * @param value One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("bojrcyarrsbsjwgy")
    public suspend
    fun ephemeralBlockDevices(`value`: Output<List<InstanceEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = value
    }

    @JvmName("hfebufvavahqgcin")
    public suspend fun ephemeralBlockDevices(
        vararg
        values: Output<InstanceEphemeralBlockDeviceArgs>,
    ) {
        this.ephemeralBlockDevices = Output.all(values.asList())
    }

    /**
     * @param values One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("fyodqahmqahfhxia")
    public suspend fun ephemeralBlockDevices(values: List<Output<InstanceEphemeralBlockDeviceArgs>>) {
        this.ephemeralBlockDevices = Output.all(values)
    }

    /**
     * @param value If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     */
    @JvmName("umixprldibkxtofy")
    public suspend fun getPasswordData(`value`: Output<Boolean>) {
        this.getPasswordData = value
    }

    /**
     * @param value If true, the launched EC2 instance will support hibernation.
     */
    @JvmName("wjutfuyuamjjamno")
    public suspend fun hibernation(`value`: Output<Boolean>) {
        this.hibernation = value
    }

    /**
     * @param value ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
     */
    @JvmName("suxyoxrqxktbiqte")
    public suspend fun hostId(`value`: Output<String>) {
        this.hostId = value
    }

    /**
     * @param value ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
     */
    @JvmName("dlikfjkhkbbvsiio")
    public suspend fun hostResourceGroupArn(`value`: Output<String>) {
        this.hostResourceGroupArn = value
    }

    /**
     * @param value IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
     */
    @JvmName("vstwryfgbsowawah")
    public suspend fun iamInstanceProfile(`value`: Output<String>) {
        this.iamInstanceProfile = value
    }

    /**
     * @param value Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
     */
    @JvmName("mvlxsekaqgpravlf")
    public suspend fun instanceInitiatedShutdownBehavior(`value`: Output<String>) {
        this.instanceInitiatedShutdownBehavior = value
    }

    /**
     * @param value Describes the market (purchasing) option for the instances. See Market Options below for details on attributes.
     */
    @JvmName("jnluclwdfqfrxdrb")
    public suspend fun instanceMarketOptions(`value`: Output<InstanceInstanceMarketOptionsArgs>) {
        this.instanceMarketOptions = value
    }

    /**
     * @param value Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
     */
    @JvmName("nmrnagejxgyvpluu")
    public suspend fun instanceType(`value`: Output<Either<String, InstanceType>>) {
        this.instanceType = value
    }

    /**
     * @param value Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
     */
    @JvmName("qsejnyfkotplakcf")
    public suspend fun ipv6AddressCount(`value`: Output<Int>) {
        this.ipv6AddressCount = value
    }

    /**
     * @param value Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     */
    @JvmName("rfawmowghvrlxfdk")
    public suspend fun ipv6Addresses(`value`: Output<List<String>>) {
        this.ipv6Addresses = value
    }

    @JvmName("etfopsfhliqpdrxp")
    public suspend fun ipv6Addresses(vararg values: Output<String>) {
        this.ipv6Addresses = Output.all(values.asList())
    }

    /**
     * @param values Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     */
    @JvmName("buealydecltcoipv")
    public suspend fun ipv6Addresses(values: List<Output<String>>) {
        this.ipv6Addresses = Output.all(values)
    }

    /**
     * @param value Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
     */
    @JvmName("ucmyvylgwgdcjgno")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
     */
    @JvmName("xqalhxapksaoqocv")
    public suspend fun launchTemplate(`value`: Output<InstanceLaunchTemplateArgs>) {
        this.launchTemplate = value
    }

    /**
     * @param value Maintenance and recovery options for the instance. See Maintenance Options below for more details.
     */
    @JvmName("brfiqnushscumlyl")
    public suspend fun maintenanceOptions(`value`: Output<InstanceMaintenanceOptionsArgs>) {
        this.maintenanceOptions = value
    }

    /**
     * @param value Customize the metadata options of the instance. See Metadata Options below for more details.
     */
    @JvmName("rubwprwcjwroprnq")
    public suspend fun metadataOptions(`value`: Output<InstanceMetadataOptionsArgs>) {
        this.metadataOptions = value
    }

    /**
     * @param value If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
     */
    @JvmName("ajrmggbrwmunouvk")
    public suspend fun monitoring(`value`: Output<Boolean>) {
        this.monitoring = value
    }

    /**
     * @param value Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    @JvmName("prylpywxvcnmusvy")
    public suspend fun networkInterfaces(`value`: Output<List<InstanceNetworkInterfaceArgs>>) {
        this.networkInterfaces = value
    }

    @JvmName("yvvnkjuwdgfgjrug")
    public suspend fun networkInterfaces(vararg values: Output<InstanceNetworkInterfaceArgs>) {
        this.networkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    @JvmName("ayviexmcswhywnah")
    public suspend fun networkInterfaces(values: List<Output<InstanceNetworkInterfaceArgs>>) {
        this.networkInterfaces = Output.all(values)
    }

    /**
     * @param value Placement Group to start the instance in.
     */
    @JvmName("jomqivhrywunjspr")
    public suspend fun placementGroup(`value`: Output<String>) {
        this.placementGroup = value
    }

    /**
     * @param value Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
     */
    @JvmName("kxidkndtkcwxqiax")
    public suspend fun placementPartitionNumber(`value`: Output<Int>) {
        this.placementPartitionNumber = value
    }

    /**
     * @param value Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     */
    @JvmName("xbbsesliriqakyil")
    public suspend fun privateDnsNameOptions(`value`: Output<InstancePrivateDnsNameOptionsArgs>) {
        this.privateDnsNameOptions = value
    }

    /**
     * @param value Private IP address to associate with the instance in a VPC.
     */
    @JvmName("oggslnftodqbdnqt")
    public suspend fun privateIp(`value`: Output<String>) {
        this.privateIp = value
    }

    /**
     * @param value Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
     */
    @JvmName("lgboqylwllatnaqu")
    public suspend fun rootBlockDevice(`value`: Output<InstanceRootBlockDeviceArgs>) {
        this.rootBlockDevice = value
    }

    /**
     * @param value List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     */
    @JvmName("lhsqosqddehltfju")
    public suspend fun secondaryPrivateIps(`value`: Output<List<String>>) {
        this.secondaryPrivateIps = value
    }

    @JvmName("rukvdnnsigacyxxx")
    public suspend fun secondaryPrivateIps(vararg values: Output<String>) {
        this.secondaryPrivateIps = Output.all(values.asList())
    }

    /**
     * @param values List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     */
    @JvmName("bipsrrhktavfmtyu")
    public suspend fun secondaryPrivateIps(values: List<Output<String>>) {
        this.secondaryPrivateIps = Output.all(values)
    }

    /**
     * @param value List of security group names to associate with.
     * > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     */
    @Deprecated(
        message = """
  Use of `securityGroups` is discouraged as it does not allow for changes and will force your
      instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which
      allows for updates.
  """,
    )
    @JvmName("uomeehpcaucejevm")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("axbshhsvfmxueavt")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values List of security group names to associate with.
     * > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     */
    @Deprecated(
        message = """
  Use of `securityGroups` is discouraged as it does not allow for changes and will force your
      instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which
      allows for updates.
  """,
    )
    @JvmName("owckljavclrjtorf")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
     */
    @JvmName("sqkltjoyhpsdalvf")
    public suspend fun sourceDestCheck(`value`: Output<Boolean>) {
        this.sourceDestCheck = value
    }

    /**
     * @param value VPC Subnet ID to launch in.
     */
    @JvmName("gybkbicvcdcsyutm")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hhbigbyycpadwimi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
     */
    @JvmName("jbpfdshkhumxcrqa")
    public suspend fun tenancy(`value`: Output<Either<String, Tenancy>>) {
        this.tenancy = value
    }

    /**
     * @param value User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     */
    @JvmName("grcbvwlksujpmovp")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     */
    @JvmName("obykmnhgpphmdtrt")
    public suspend fun userDataBase64(`value`: Output<String>) {
        this.userDataBase64 = value
    }

    /**
     * @param value When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
     */
    @JvmName("phcmulxlnnpqydsk")
    public suspend fun userDataReplaceOnChange(`value`: Output<Boolean>) {
        this.userDataReplaceOnChange = value
    }

    /**
     * @param value Map of tags to assign, at instance-creation time, to root and EBS volumes.
     * > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
     */
    @JvmName("jshiorpqqohfawrv")
    public suspend fun volumeTags(`value`: Output<Map<String, String>>) {
        this.volumeTags = value
    }

    /**
     * @param value List of security group IDs to associate with.
     */
    @JvmName("rvbvptmpdlqiynoa")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("qlynmyslfdmxvgns")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of security group IDs to associate with.
     */
    @JvmName("sykyrtceywyqnoho")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value AMI to use for the instance. Required unless `launch_template` is specified and the Launch Template specifes an AMI. If an AMI is specified in the Launch Template, setting `ami` will override the AMI specified in the Launch Template.
     */
    @JvmName("toaavqwidmswsbah")
    public suspend fun ami(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ami = mapped
    }

    /**
     * @param value Whether to associate a public IP address with an instance in a VPC.
     */
    @JvmName("hvnrloidubgcwixx")
    public suspend fun associatePublicIpAddress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatePublicIpAddress = mapped
    }

    /**
     * @param value AZ to start the instance in.
     */
    @JvmName("cwhvumemqtcjajtd")
    public suspend fun availabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZone = mapped
    }

    /**
     * @param value Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
     * > **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
     */
    @JvmName("mcofujldimdjwdbg")
    public suspend
    fun capacityReservationSpecification(`value`: InstanceCapacityReservationSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationSpecification = mapped
    }

    /**
     * @param argument Describes an instance's Capacity Reservation targeting option. See Capacity Reservation Specification below for more details.
     * > **NOTE:** Changing `cpu_core_count` and/or `cpu_threads_per_core` will cause the resource to be destroyed and re-created.
     */
    @JvmName("wjxmysenjoqvnsqh")
    public suspend
    fun capacityReservationSpecification(argument: suspend InstanceCapacityReservationSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceCapacityReservationSpecificationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.capacityReservationSpecification = mapped
    }

    /**
     * @param value Sets the number of CPU cores for an instance. This option is only supported on creation of instance type that support CPU Options [CPU Cores and Threads Per CPU Core Per Instance Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html#cpu-options-supported-instances-values) - specifying this option for unsupported instance types will return an error from the EC2 API.
     */
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    @JvmName("duldajkgocogakxc")
    public suspend fun cpuCoreCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuCoreCount = mapped
    }

    /**
     * @param value The CPU options for the instance. See CPU Options below for more details.
     */
    @JvmName("fceuvfsdjnymwfex")
    public suspend fun cpuOptions(`value`: InstanceCpuOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuOptions = mapped
    }

    /**
     * @param argument The CPU options for the instance. See CPU Options below for more details.
     */
    @JvmName("xabamwrogyovbftx")
    public suspend fun cpuOptions(argument: suspend InstanceCpuOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceCpuOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cpuOptions = mapped
    }

    /**
     * @param value If set to 1, hyperthreading is disabled on the launched instance. Defaults to 2 if not set. See [Optimizing CPU Options](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html) for more information.
     */
    @Deprecated(
        message = """
  use 'cpu_options' argument instead
  """,
    )
    @JvmName("licpsyoorlivwugd")
    public suspend fun cpuThreadsPerCore(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuThreadsPerCore = mapped
    }

    /**
     * @param value Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
     */
    @JvmName("ohavjvohrecigcfq")
    public suspend fun creditSpecification(`value`: InstanceCreditSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creditSpecification = mapped
    }

    /**
     * @param argument Configuration block for customizing the credit specification of the instance. See Credit Specification below for more details. This provider will only perform drift detection of its value when present in a configuration. Removing this configuration on existing instances will only stop managing it. It will not change the configuration back to the default for the instance type.
     */
    @JvmName("tedxcnkastwhvfhe")
    public suspend
    fun creditSpecification(argument: suspend InstanceCreditSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceCreditSpecificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.creditSpecification = mapped
    }

    /**
     * @param value If true, enables [EC2 Instance Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     */
    @JvmName("gnwixpckcdwaaowh")
    public suspend fun disableApiStop(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableApiStop = mapped
    }

    /**
     * @param value If true, enables [EC2 Instance Termination Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingDisableAPITermination).
     */
    @JvmName("xmhrpukidtnwyycy")
    public suspend fun disableApiTermination(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableApiTermination = mapped
    }

    /**
     * @param value One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("xjbasaxpdsaypywe")
    public suspend fun ebsBlockDevices(`value`: List<InstanceEbsBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("ghjctetdblwmjdgt")
    public suspend
    fun ebsBlockDevices(argument: List<suspend InstanceEbsBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceEbsBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("uffobilylyfnkada")
    public suspend fun ebsBlockDevices(
        vararg
        argument: suspend InstanceEbsBlockDeviceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InstanceEbsBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param argument One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("bmaoglpuxxrxalko")
    public suspend
    fun ebsBlockDevices(argument: suspend InstanceEbsBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceEbsBlockDeviceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ebsBlockDevices = mapped
    }

    /**
     * @param values One or more configuration blocks with additional EBS block devices to attach to the instance. Block device configurations only apply on resource creation. See Block Devices below for details on attributes and drift detection. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("nbhdxvtfybvkogix")
    public suspend fun ebsBlockDevices(vararg values: InstanceEbsBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ebsBlockDevices = mapped
    }

    /**
     * @param value If true, the launched EC2 instance will be EBS-optimized. Note that if this is not set on an instance type that is optimized by default then this will show as disabled but if the instance type is optimized by default then there is no need to set this and there is no effect to disabling it. See the [EBS Optimized section](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) of the AWS User Guide for more information.
     */
    @JvmName("dsccatcwdfkmejil")
    public suspend fun ebsOptimized(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebsOptimized = mapped
    }

    /**
     * @param value Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     */
    @JvmName("hxxjcxdbbheyqnvu")
    public suspend fun enclaveOptions(`value`: InstanceEnclaveOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enclaveOptions = mapped
    }

    /**
     * @param argument Enable Nitro Enclaves on launched instances. See Enclave Options below for more details.
     */
    @JvmName("gwmyxqfcqyyhtaeb")
    public suspend
    fun enclaveOptions(argument: suspend InstanceEnclaveOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceEnclaveOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.enclaveOptions = mapped
    }

    /**
     * @param value One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("sqwarjrxgwmsttoy")
    public suspend fun ephemeralBlockDevices(`value`: List<InstanceEphemeralBlockDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("oxxostqifjfmchmb")
    public suspend
    fun ephemeralBlockDevices(argument: List<suspend InstanceEphemeralBlockDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceEphemeralBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("dxsextsusgwokbdn")
    public suspend fun ephemeralBlockDevices(
        vararg
        argument: suspend InstanceEphemeralBlockDeviceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InstanceEphemeralBlockDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param argument One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("wsabusdvsaqqsgxh")
    public suspend
    fun ephemeralBlockDevices(argument: suspend InstanceEphemeralBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstanceEphemeralBlockDeviceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param values One or more configuration blocks to customize Ephemeral (also known as "Instance Store") volumes on the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a set of objects.
     */
    @JvmName("dxjvpcbhojirejid")
    public suspend fun ephemeralBlockDevices(vararg values: InstanceEphemeralBlockDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ephemeralBlockDevices = mapped
    }

    /**
     * @param value If true, wait for password data to become available and retrieve it. Useful for getting the administrator password for instances running Microsoft Windows. The password data is exported to the `password_data` attribute. See [GetPasswordData](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_GetPasswordData.html) for more information.
     */
    @JvmName("ylkfvqnuklupukov")
    public suspend fun getPasswordData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.getPasswordData = mapped
    }

    /**
     * @param value If true, the launched EC2 instance will support hibernation.
     */
    @JvmName("wdecevdmcqjglqiv")
    public suspend fun hibernation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hibernation = mapped
    }

    /**
     * @param value ID of a dedicated host that the instance will be assigned to. Use when an instance is to be launched on a specific dedicated host.
     */
    @JvmName("aidrrwkpjgppygav")
    public suspend fun hostId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostId = mapped
    }

    /**
     * @param value ARN of the host resource group in which to launch the instances. If you specify an ARN, omit the `tenancy` parameter or set it to `host`.
     */
    @JvmName("jdbjbepobprglskn")
    public suspend fun hostResourceGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostResourceGroupArn = mapped
    }

    /**
     * @param value IAM Instance Profile to launch the instance with. Specified as the name of the Instance Profile. Ensure your credentials have the correct permission to assign the instance profile according to the [EC2 documentation](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html#roles-usingrole-ec2instance-permissions), notably `iam:PassRole`.
     */
    @JvmName("wcnilqphlcfopdac")
    public suspend fun iamInstanceProfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamInstanceProfile = mapped
    }

    /**
     * @param value Shutdown behavior for the instance. Amazon defaults this to `stop` for EBS-backed instances and `terminate` for instance-store instances. Cannot be set on instance-store instances. See [Shutdown Behavior](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior) for more information.
     */
    @JvmName("ydmpckpukudqiigu")
    public suspend fun instanceInitiatedShutdownBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceInitiatedShutdownBehavior = mapped
    }

    /**
     * @param value Describes the market (purchasing) option for the instances. See Market Options below for details on attributes.
     */
    @JvmName("qxnqnhfwlekgjauc")
    public suspend fun instanceMarketOptions(`value`: InstanceInstanceMarketOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceMarketOptions = mapped
    }

    /**
     * @param argument Describes the market (purchasing) option for the instances. See Market Options below for details on attributes.
     */
    @JvmName("dltxnpiwtbqesmom")
    public suspend
    fun instanceMarketOptions(argument: suspend InstanceInstanceMarketOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceInstanceMarketOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.instanceMarketOptions = mapped
    }

    /**
     * @param value Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
     */
    @JvmName("gjhwvoxdegdtksyx")
    public suspend fun instanceType(`value`: Either<String, InstanceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
     */
    @JvmName("etcuvllnoojcaxbk")
    public fun instanceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InstanceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Instance type to use for the instance. Required unless `launch_template` is specified and the Launch Template specifies an instance type. If an instance type is specified in the Launch Template, setting `instance_type` will override the instance type specified in the Launch Template. Updates to this field will trigger a stop/start of the EC2 instance.
     */
    @JvmName("jvxohdrnpdaapmqf")
    public fun instanceType(`value`: InstanceType) {
        val toBeMapped = Either.ofRight<String, InstanceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Number of IPv6 addresses to associate with the primary network interface. Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
     */
    @JvmName("shhttryegpaxedyg")
    public suspend fun ipv6AddressCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6AddressCount = mapped
    }

    /**
     * @param value Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     */
    @JvmName("mngmoagislejxudm")
    public suspend fun ipv6Addresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param values Specify one or more IPv6 addresses from the range of the subnet to associate with the primary network interface
     */
    @JvmName("tshqsmaoiogmadof")
    public suspend fun ipv6Addresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipv6Addresses = mapped
    }

    /**
     * @param value Key name of the Key Pair to use for the instance; which can be managed using the `aws.ec2.KeyPair` resource.
     */
    @JvmName("rnmgcrwruxbhoypd")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
     */
    @JvmName("dfjgvfkxqdofomkm")
    public suspend fun launchTemplate(`value`: InstanceLaunchTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplate = mapped
    }

    /**
     * @param argument Specifies a Launch Template to configure the instance. Parameters configured on this resource will override the corresponding parameters in the Launch Template. See Launch Template Specification below for more details.
     */
    @JvmName("fvrikowghuybkxfp")
    public suspend
    fun launchTemplate(argument: suspend InstanceLaunchTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceLaunchTemplateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.launchTemplate = mapped
    }

    /**
     * @param value Maintenance and recovery options for the instance. See Maintenance Options below for more details.
     */
    @JvmName("nnascjadksqpbakt")
    public suspend fun maintenanceOptions(`value`: InstanceMaintenanceOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceOptions = mapped
    }

    /**
     * @param argument Maintenance and recovery options for the instance. See Maintenance Options below for more details.
     */
    @JvmName("tifbjaripkscnujt")
    public suspend
    fun maintenanceOptions(argument: suspend InstanceMaintenanceOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceMaintenanceOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.maintenanceOptions = mapped
    }

    /**
     * @param value Customize the metadata options of the instance. See Metadata Options below for more details.
     */
    @JvmName("subwmhoyipirojen")
    public suspend fun metadataOptions(`value`: InstanceMetadataOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataOptions = mapped
    }

    /**
     * @param argument Customize the metadata options of the instance. See Metadata Options below for more details.
     */
    @JvmName("vlgawvbavbwqsqbc")
    public suspend
    fun metadataOptions(argument: suspend InstanceMetadataOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceMetadataOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.metadataOptions = mapped
    }

    /**
     * @param value If true, the launched EC2 instance will have detailed monitoring enabled. (Available since v0.6.0)
     */
    @JvmName("uxnccovpebrpfrxe")
    public suspend fun monitoring(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoring = mapped
    }

    /**
     * @param value Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    @JvmName("ixrmmyboayxxisth")
    public suspend fun networkInterfaces(`value`: List<InstanceNetworkInterfaceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    @JvmName("wloiglkduohhdnau")
    public suspend
    fun networkInterfaces(argument: List<suspend InstanceNetworkInterfaceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceNetworkInterfaceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    @JvmName("fldylncbswmrwsls")
    public suspend fun networkInterfaces(
        vararg
        argument: suspend InstanceNetworkInterfaceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InstanceNetworkInterfaceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    @JvmName("hitycqpqdcknfyvf")
    public suspend
    fun networkInterfaces(argument: suspend InstanceNetworkInterfaceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstanceNetworkInterfaceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param values Customize network interfaces to be attached at instance boot time. See Network Interfaces below for more details.
     */
    @JvmName("hhiuoumiccmtpsrq")
    public suspend fun networkInterfaces(vararg values: InstanceNetworkInterfaceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param value Placement Group to start the instance in.
     */
    @JvmName("easchfxhqhtqrorb")
    public suspend fun placementGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementGroup = mapped
    }

    /**
     * @param value Number of the partition the instance is in. Valid only if the `aws.ec2.PlacementGroup` resource's `strategy` argument is set to `"partition"`.
     */
    @JvmName("pbrpoigesrtaksbx")
    public suspend fun placementPartitionNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementPartitionNumber = mapped
    }

    /**
     * @param value Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     */
    @JvmName("pdkwcaiwmwagmoby")
    public suspend fun privateDnsNameOptions(`value`: InstancePrivateDnsNameOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateDnsNameOptions = mapped
    }

    /**
     * @param argument Options for the instance hostname. The default values are inherited from the subnet. See Private DNS Name Options below for more details.
     */
    @JvmName("dxbspatpoabrscit")
    public suspend
    fun privateDnsNameOptions(argument: suspend InstancePrivateDnsNameOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = InstancePrivateDnsNameOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateDnsNameOptions = mapped
    }

    /**
     * @param value Private IP address to associate with the instance in a VPC.
     */
    @JvmName("oleepkqnwdfgavcp")
    public suspend fun privateIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIp = mapped
    }

    /**
     * @param value Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
     */
    @JvmName("gyhlritbwkmiowkx")
    public suspend fun rootBlockDevice(`value`: InstanceRootBlockDeviceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootBlockDevice = mapped
    }

    /**
     * @param argument Configuration block to customize details about the root block device of the instance. See Block Devices below for details. When accessing this as an attribute reference, it is a list containing one object.
     */
    @JvmName("ajwtxwbygcqiuikp")
    public suspend
    fun rootBlockDevice(argument: suspend InstanceRootBlockDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceRootBlockDeviceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.rootBlockDevice = mapped
    }

    /**
     * @param value List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     */
    @JvmName("ypckecjpgtbkeadf")
    public suspend fun secondaryPrivateIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryPrivateIps = mapped
    }

    /**
     * @param values List of secondary private IPv4 addresses to assign to the instance's primary network interface (eth0) in a VPC. Can only be assigned to the primary network interface (eth0) attached at instance creation, not a pre-existing network interface i.e., referenced in a `network_interface` block. Refer to the [Elastic network interfaces documentation](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI) to see the maximum number of private IP addresses allowed per instance type.
     */
    @JvmName("jyguyrkactjjathg")
    public suspend fun secondaryPrivateIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryPrivateIps = mapped
    }

    /**
     * @param value List of security group names to associate with.
     * > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     */
    @Deprecated(
        message = """
  Use of `securityGroups` is discouraged as it does not allow for changes and will force your
      instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which
      allows for updates.
  """,
    )
    @JvmName("srvxlrjdxxnwtqfu")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values List of security group names to associate with.
     * > **NOTE:** If you are creating Instances in a VPC, use `vpc_security_group_ids` instead.
     */
    @Deprecated(
        message = """
  Use of `securityGroups` is discouraged as it does not allow for changes and will force your
      instance to be replaced if changes are made. To avoid this, use `vpcSecurityGroupIds` which
      allows for updates.
  """,
    )
    @JvmName("nmifnoqypgsmbfkv")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value Controls if traffic is routed to the instance when the destination address does not match the instance. Used for NAT or VPNs. Defaults true.
     */
    @JvmName("iosiwevrfvjcqheb")
    public suspend fun sourceDestCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDestCheck = mapped
    }

    /**
     * @param value VPC Subnet ID to launch in.
     */
    @JvmName("xpaupxmpepyhjskh")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xeidccdblmsmetvy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. Note that these tags apply to the instance and not block storage devices. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tnkllwdwwktripaj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
     */
    @JvmName("xnhbhicxwwmggacv")
    public suspend fun tenancy(`value`: Either<String, Tenancy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenancy = mapped
    }

    /**
     * @param value Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
     */
    @JvmName("ibfaqogfckrbyuvy")
    public fun tenancy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Tenancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenancy = mapped
    }

    /**
     * @param value Tenancy of the instance (if the instance is running in a VPC). An instance with a tenancy of `dedicated` runs on single-tenant hardware. The `host` tenancy is not supported for the import-instance command. Valid values are `default`, `dedicated`, and `host`.
     */
    @JvmName("cmfdbcikqwoevllg")
    public fun tenancy(`value`: Tenancy) {
        val toBeMapped = Either.ofRight<String, Tenancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tenancy = mapped
    }

    /**
     * @param value User data to provide when launching the instance. Do not pass gzip-compressed data via this argument; see `user_data_base64` instead. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     */
    @JvmName("hexqddqckklfvske")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value Can be used instead of `user_data` to pass base64-encoded binary data directly. Use this instead of `user_data` whenever the value is not a valid UTF-8 string. For example, gzip-encoded user data must be base64-encoded and passed via this argument to avoid corruption. Updates to this field will trigger a stop/start of the EC2 instance by default. If the `user_data_replace_on_change` is set then updates to this field will trigger a destroy and recreate.
     */
    @JvmName("iadkibvonlpvlntw")
    public suspend fun userDataBase64(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDataBase64 = mapped
    }

    /**
     * @param value When used in combination with `user_data` or `user_data_base64` will trigger a destroy and recreate when set to `true`. Defaults to `false` if not set.
     */
    @JvmName("dqffwnemakpuiqsm")
    public suspend fun userDataReplaceOnChange(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDataReplaceOnChange = mapped
    }

    /**
     * @param value Map of tags to assign, at instance-creation time, to root and EBS volumes.
     * > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
     */
    @JvmName("uefmopxtaxaeanvd")
    public suspend fun volumeTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeTags = mapped
    }

    /**
     * @param values Map of tags to assign, at instance-creation time, to root and EBS volumes.
     * > **NOTE:** Do not use `volume_tags` if you plan to manage block device tags outside the `aws.ec2.Instance` configuration, such as using `tags` in an `aws.ebs.Volume` resource attached via `aws.ec2.VolumeAttachment`. Doing so will result in resource cycling and inconsistent behavior.
     */
    @JvmName("ssydnexeqyivnksq")
    public fun volumeTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeTags = mapped
    }

    /**
     * @param value List of security group IDs to associate with.
     */
    @JvmName("wjkkidduylsctmty")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values List of security group IDs to associate with.
     */
    @JvmName("lxkrieqsvytrngli")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        ami = ami,
        associatePublicIpAddress = associatePublicIpAddress,
        availabilityZone = availabilityZone,
        capacityReservationSpecification = capacityReservationSpecification,
        cpuCoreCount = cpuCoreCount,
        cpuOptions = cpuOptions,
        cpuThreadsPerCore = cpuThreadsPerCore,
        creditSpecification = creditSpecification,
        disableApiStop = disableApiStop,
        disableApiTermination = disableApiTermination,
        ebsBlockDevices = ebsBlockDevices,
        ebsOptimized = ebsOptimized,
        enclaveOptions = enclaveOptions,
        ephemeralBlockDevices = ephemeralBlockDevices,
        getPasswordData = getPasswordData,
        hibernation = hibernation,
        hostId = hostId,
        hostResourceGroupArn = hostResourceGroupArn,
        iamInstanceProfile = iamInstanceProfile,
        instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior,
        instanceMarketOptions = instanceMarketOptions,
        instanceType = instanceType,
        ipv6AddressCount = ipv6AddressCount,
        ipv6Addresses = ipv6Addresses,
        keyName = keyName,
        launchTemplate = launchTemplate,
        maintenanceOptions = maintenanceOptions,
        metadataOptions = metadataOptions,
        monitoring = monitoring,
        networkInterfaces = networkInterfaces,
        placementGroup = placementGroup,
        placementPartitionNumber = placementPartitionNumber,
        privateDnsNameOptions = privateDnsNameOptions,
        privateIp = privateIp,
        rootBlockDevice = rootBlockDevice,
        secondaryPrivateIps = secondaryPrivateIps,
        securityGroups = securityGroups,
        sourceDestCheck = sourceDestCheck,
        subnetId = subnetId,
        tags = tags,
        tenancy = tenancy,
        userData = userData,
        userDataBase64 = userDataBase64,
        userDataReplaceOnChange = userDataReplaceOnChange,
        volumeTags = volumeTags,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
    )
}
