@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ec2.kotlin

import com.pulumi.aws.ec2.InternetGatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to create a VPC Internet Gateway.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.InternetGateway;
 * import com.pulumi.aws.ec2.InternetGatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gw = new InternetGateway("gw", InternetGatewayArgs.builder()
 *             .vpcId(aws_vpc.main().id())
 *             .tags(Map.of("Name", "main"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Internet Gateways using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:ec2/internetGateway:InternetGateway gw igw-c0a643a9
 * ```
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * > **Note:** It's recommended to denote that the AWS Instance or Elastic IP depends on the Internet Gateway. For example:
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const gw = new aws.ec2.InternetGateway("gw", {vpcId: aws_vpc.main.id});
 * // ... other arguments ...
 * const foo = new aws.ec2.Instance("foo", {}, {
 *     dependsOn: [gw],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * gw = aws.ec2.InternetGateway("gw", vpc_id=aws_vpc["main"]["id"])
 * # ... other arguments ...
 * foo = aws.ec2.Instance("foo", opts=pulumi.ResourceOptions(depends_on=[gw]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gw = new Aws.Ec2.InternetGateway("gw", new()
 *     {
 *         VpcId = aws_vpc.Main.Id,
 *     });
 *     // ... other arguments ...
 *     var foo = new Aws.Ec2.Instance("foo", new()
 *     {
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn = new[]
 *         {
 *             gw,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		gw, err := ec2.NewInternetGateway(ctx, "gw", &ec2.InternetGatewayArgs{
 * 			VpcId: pulumi.Any(aws_vpc.Main.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ec2.NewInstance(ctx, "foo", nil, pulumi.DependsOn([]pulumi.Resource{
 * 			gw,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.InternetGateway;
 * import com.pulumi.aws.ec2.InternetGatewayArgs;
 * import com.pulumi.aws.ec2.Instance;
 * import com.pulumi.aws.ec2.InstanceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gw = new InternetGateway("gw", InternetGatewayArgs.builder()
 *             .vpcId(aws_vpc.main().id())
 *             .build());
 *         var foo = new Instance("foo", InstanceArgs.Empty, CustomResourceOptions.builder()
 *             .dependsOn(gw)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   gw:
 *     type: aws:ec2:InternetGateway
 *     properties:
 *       vpcId: ${aws_vpc.main.id}
 *   foo:
 *     type: aws:ec2:Instance
 *     options:
 *       dependson:
 *         - ${gw}
 * ```
 * @property vpcId The VPC ID to create in.  See the aws.ec2.InternetGatewayAttachment resource for an alternate way to attach an Internet Gateway to a VPC.
 */
public data class InternetGatewayArgs(
    public val tags: Output<Map<String, String>>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ec2.InternetGatewayArgs> {
    override fun toJava(): com.pulumi.aws.ec2.InternetGatewayArgs =
        com.pulumi.aws.ec2.InternetGatewayArgs.builder()
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InternetGatewayArgs].
 */
@PulumiTagMarker
public class InternetGatewayArgsBuilder internal constructor() {
    private var tags: Output<Map<String, String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **Note:** It's recommended to denote that the AWS Instance or Elastic IP depends on the Internet Gateway. For example:
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const gw = new aws.ec2.InternetGateway("gw", {vpcId: aws_vpc.main.id});
     * // ... other arguments ...
     * const foo = new aws.ec2.Instance("foo", {}, {
     *     dependsOn: [gw],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * gw = aws.ec2.InternetGateway("gw", vpc_id=aws_vpc["main"]["id"])
     * # ... other arguments ...
     * foo = aws.ec2.Instance("foo", opts=pulumi.ResourceOptions(depends_on=[gw]))
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var gw = new Aws.Ec2.InternetGateway("gw", new()
     *     {
     *         VpcId = aws_vpc.Main.Id,
     *     });
     *     // ... other arguments ...
     *     var foo = new Aws.Ec2.Instance("foo", new()
     *     {
     *     }, new CustomResourceOptions
     *     {
     *         DependsOn = new[]
     *         {
     *             gw,
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		gw, err := ec2.NewInternetGateway(ctx, "gw", &ec2.InternetGatewayArgs{
     * 			VpcId: pulumi.Any(aws_vpc.Main.Id),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewInstance(ctx, "foo", nil, pulumi.DependsOn([]pulumi.Resource{
     * 			gw,
     * 		}))
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.InternetGateway;
     * import com.pulumi.aws.ec2.InternetGatewayArgs;
     * import com.pulumi.aws.ec2.Instance;
     * import com.pulumi.aws.ec2.InstanceArgs;
     * import com.pulumi.resources.CustomResourceOptions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var gw = new InternetGateway("gw", InternetGatewayArgs.builder()
     *             .vpcId(aws_vpc.main().id())
     *             .build());
     *         var foo = new Instance("foo", InstanceArgs.Empty, CustomResourceOptions.builder()
     *             .dependsOn(gw)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   gw:
     *     type: aws:ec2:InternetGateway
     *     properties:
     *       vpcId: ${aws_vpc.main.id}
     *   foo:
     *     type: aws:ec2:Instance
     *     options:
     *       dependson:
     *         - ${gw}
     * ```
     */
    @JvmName("gvhxgybgtjuglkyj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VPC ID to create in.  See the aws.ec2.InternetGatewayAttachment resource for an alternate way to attach an Internet Gateway to a VPC.
     */
    @JvmName("fvhudxjmqxvtookq")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **Note:** It's recommended to denote that the AWS Instance or Elastic IP depends on the Internet Gateway. For example:
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const gw = new aws.ec2.InternetGateway("gw", {vpcId: aws_vpc.main.id});
     * // ... other arguments ...
     * const foo = new aws.ec2.Instance("foo", {}, {
     *     dependsOn: [gw],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * gw = aws.ec2.InternetGateway("gw", vpc_id=aws_vpc["main"]["id"])
     * # ... other arguments ...
     * foo = aws.ec2.Instance("foo", opts=pulumi.ResourceOptions(depends_on=[gw]))
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var gw = new Aws.Ec2.InternetGateway("gw", new()
     *     {
     *         VpcId = aws_vpc.Main.Id,
     *     });
     *     // ... other arguments ...
     *     var foo = new Aws.Ec2.Instance("foo", new()
     *     {
     *     }, new CustomResourceOptions
     *     {
     *         DependsOn = new[]
     *         {
     *             gw,
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		gw, err := ec2.NewInternetGateway(ctx, "gw", &ec2.InternetGatewayArgs{
     * 			VpcId: pulumi.Any(aws_vpc.Main.Id),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewInstance(ctx, "foo", nil, pulumi.DependsOn([]pulumi.Resource{
     * 			gw,
     * 		}))
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.InternetGateway;
     * import com.pulumi.aws.ec2.InternetGatewayArgs;
     * import com.pulumi.aws.ec2.Instance;
     * import com.pulumi.aws.ec2.InstanceArgs;
     * import com.pulumi.resources.CustomResourceOptions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var gw = new InternetGateway("gw", InternetGatewayArgs.builder()
     *             .vpcId(aws_vpc.main().id())
     *             .build());
     *         var foo = new Instance("foo", InstanceArgs.Empty, CustomResourceOptions.builder()
     *             .dependsOn(gw)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   gw:
     *     type: aws:ec2:InternetGateway
     *     properties:
     *       vpcId: ${aws_vpc.main.id}
     *   foo:
     *     type: aws:ec2:Instance
     *     options:
     *       dependson:
     *         - ${gw}
     * ```
     */
    @JvmName("jyvsjrkyeahqwhqd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     * > **Note:** It's recommended to denote that the AWS Instance or Elastic IP depends on the Internet Gateway. For example:
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const gw = new aws.ec2.InternetGateway("gw", {vpcId: aws_vpc.main.id});
     * // ... other arguments ...
     * const foo = new aws.ec2.Instance("foo", {}, {
     *     dependsOn: [gw],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * gw = aws.ec2.InternetGateway("gw", vpc_id=aws_vpc["main"]["id"])
     * # ... other arguments ...
     * foo = aws.ec2.Instance("foo", opts=pulumi.ResourceOptions(depends_on=[gw]))
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var gw = new Aws.Ec2.InternetGateway("gw", new()
     *     {
     *         VpcId = aws_vpc.Main.Id,
     *     });
     *     // ... other arguments ...
     *     var foo = new Aws.Ec2.Instance("foo", new()
     *     {
     *     }, new CustomResourceOptions
     *     {
     *         DependsOn = new[]
     *         {
     *             gw,
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		gw, err := ec2.NewInternetGateway(ctx, "gw", &ec2.InternetGatewayArgs{
     * 			VpcId: pulumi.Any(aws_vpc.Main.Id),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = ec2.NewInstance(ctx, "foo", nil, pulumi.DependsOn([]pulumi.Resource{
     * 			gw,
     * 		}))
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ec2.InternetGateway;
     * import com.pulumi.aws.ec2.InternetGatewayArgs;
     * import com.pulumi.aws.ec2.Instance;
     * import com.pulumi.aws.ec2.InstanceArgs;
     * import com.pulumi.resources.CustomResourceOptions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var gw = new InternetGateway("gw", InternetGatewayArgs.builder()
     *             .vpcId(aws_vpc.main().id())
     *             .build());
     *         var foo = new Instance("foo", InstanceArgs.Empty, CustomResourceOptions.builder()
     *             .dependsOn(gw)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   gw:
     *     type: aws:ec2:InternetGateway
     *     properties:
     *       vpcId: ${aws_vpc.main.id}
     *   foo:
     *     type: aws:ec2:Instance
     *     options:
     *       dependson:
     *         - ${gw}
     * ```
     */
    @JvmName("csfmmnhlkmhcnasn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VPC ID to create in.  See the aws.ec2.InternetGatewayAttachment resource for an alternate way to attach an Internet Gateway to a VPC.
     */
    @JvmName("mbcmcuvyiggufplt")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): InternetGatewayArgs = InternetGatewayArgs(
        tags = tags,
        vpcId = vpcId,
    )
}
